<?php

// INCLUDE THIS BEFORE you load your ReduxFramework object config file.


// You may replace $redux_opt_name with a string if you wish. If you do so, change loader.php
// as well as all the instances below.
$redux_opt_name = "ghostpool_huber";

if ( !function_exists( "ghostpool_add_metaboxes" ) ):
    function ghostpool_add_metaboxes($metaboxes) {

    $metaboxes = array();
             
                
	/*--------------------------------------------------------------
	Post Options
	--------------------------------------------------------------*/	

	// Audio Post Format Options
    $audio_format_options = array();
    $audio_format_options[] = array(
		'fields' => array(
						        
			array(
				'id'        => 'audio_mp3_url',
				'type'      => 'media',
				'title'     => esc_html__( 'MP3 Audio File', 'huber' ),
				'mode'      => false,
				'desc'      => esc_html__( 'Upload a MP3 audio file.', 'huber' ),
			),

			array(
				'id'        => 'audio_ogg_url',
				'type'      => 'media',
				'title'     => esc_html__( 'OGG Audio File', 'huber' ),
				'mode'      => false,
				'desc'      => esc_html__( 'Upload a OGG audio file.', 'huber' ),
			),
					
		),
	);	
    $metaboxes[] = array(
        'id' => 'audio-format-options',
        'title' => esc_html__( 'Audio Options', 'huber' ),
        'post_types' => array( 'post' ),
        'post_format' => array( 'audio' ),
        'position' => 'normal',
        'priority' => 'high',
        'sections' => $audio_format_options,
    );
    	
	// Gallery Post Format Options
    $gallery_format_options = array();
    $gallery_format_options[] = array(
        'fields' => array(
						        
			array(
				'id'        => 'gallery_slider',
				'type'      => 'gallery',
				'title'     => esc_html__( 'Gallery Slider', 'huber' ),
				 'subtitle'  => esc_html__( 'Create a new gallery slider by selecting an existing image or uploading new ones using the WordPress native uploader.', 'huber' ),
				 'desc'  => esc_html__( 'Add a gallery slider.', 'huber' ),
			),
 
		),
	);		
    $metaboxes[] = array(
        'id' => 'gallery-format-options',
        'title' => esc_html__( 'Gallery Options', 'huber' ),
        'post_types' => array( 'post' ),
        'post_format' => array( 'gallery' ),
        'position' => 'normal',
        'priority' => 'high',
        'sections' => $gallery_format_options,
    );
    
    // Link Format Options   
    $link_format_options = array();
    $link_format_options[] = array(
        'fields' => array(
						        
			array(
				'id'       => 'link',
				'type'     => 'text',
				'title'    => esc_html__( 'Link', 'huber' ),
				'desc'     => esc_html__( 'The link which your post goes to.', 'huber' ),
				'validate' => 'url',
			),
			
			array( 
				'id' => 'link_target',
				'title' => esc_html__( 'Link Target', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'The target for the link.', 'huber' ),
				'options' => array(
					'_blank' => esc_html__( 'New Window', 'huber' ),
					'_self' => esc_html__( 'Same Window', 'huber' ),
				),
				'default' => '_blank',
			),
					 
		),
	);		
    $metaboxes[] = array(
        'id' => 'link-format-options',
        'title' => esc_html__( 'Link Options', 'huber' ),
        'post_types' => array( 'post' ),
        'post_format' => array( 'link' ),
        'position' => 'normal',
        'priority' => 'high',
        'sections' => $link_format_options,
    );
        
    // Quote Format Options  
    $quote_format_options = array();
    $quote_format_options[] = array(
        'fields' => array(
						        
			array(
				'id'       => 'quote_source',
				'type'     => 'text',
				'title'    => esc_html__( 'Quote Source', 'huber' ),
				'desc'     => esc_html__( 'The source of the quote.', 'huber' ),
			),
					 
		),
	);
    $metaboxes[] = array(
        'id' => 'quote-format-options',
        'title' => esc_html__( 'Quote Options', 'huber' ),
        'post_types' => array( 'post' ),
        'post_format' => array( 'quote' ),
        'position' => 'normal',
        'priority' => 'high',
        'sections' => $quote_format_options,
    );
            
    // Video Format Options   
    $video_format_options = array();
    $video_format_options[] = array(
        'fields' => array(
			
			array(
				'id'        => 'video_embed_url',
				'type'      => 'text',
				'title'     => esc_html__( 'Video URL', 'huber' ),
				'desc'      => esc_html__( 'Video URL uploaded to one of the major video sites e.g. YouTube, Vimeo, blip.tv, etc.', 'huber' ),
				'validate'  => 'url',
				'default' => '',
			),
			        
			array(
				'id'        => 'video_m4v_url',
				'type'      => 'media',
				'title'     => esc_html__( 'M4V Video', 'huber' ),
				'desc'      => esc_html__( 'Upload a M4V video.', 'huber' ),
				'mode'      => false,
				'default' => '',
			),

			array(
				'id'        => 'video_mp4_url',
				'type'      => 'media',
				'title'     => esc_html__( 'MP4 Video', 'huber' ),
				'desc'      => esc_html__( 'Upload a MP4 video.', 'huber' ),
				'mode'      => false,
				'default' => '',
			),

			array(
				'id'        => 'video_webm_url',
				'type'      => 'media',
				'title'     => esc_html__( 'WebM Video', 'huber' ),
				'desc'      => esc_html__( 'Upload a WebM video.', 'huber' ),
				'mode'      => false,
				'default' => '',
			),
			
			array(
				'id'        => 'video_ogv_url',
				'type'      => 'media',
				'title'     => esc_html__( 'OGV Video', 'huber' ),
				'desc'      => esc_html__( 'Upload a OGV video.', 'huber' ),
				'mode'      => false,
				'default' => '',
			),

			array(
				'id'       => 'video_description',
				'type' 	   => 'textarea',
				'title'    => esc_html__( 'Video Description', 'huber' ),
				'desc'     => esc_html__( 'A description which is added next to your video.', 'huber' ),
			),
					
		),
	);	
    $metaboxes[] = array(
        'id' => 'video-format-options',
        'title' => esc_html__( 'Video Options', 'huber' ),
        'post_types' => array( 'post' ),
        'post_format' => array( 'video' ),
        'position' => 'normal',
        'priority' => 'high',
        'sections' => $video_format_options,
    ); 


	/*--------------------------------------------------------------
	Blog Page Template Options
	--------------------------------------------------------------*/	

    $blog_options = array();
    $blog_options[] = array(
		//'title' => esc_html__( 'Blog', 'huber' ),
		'fields' => array(
					        
			array(
				'id'       => 'blog_cats',
				'type'     => 'select',
				'multi'    => true,
				'title'    => esc_html__( 'Categories', 'huber' ),
				'data' => 'terms',
				'args' => array( 'taxonomies' => 'category', 'hide_empty' => false ),
				'desc' => esc_html__( 'Select the categories you want to display.', 'huber' ),
				'default' => '',
			),
			
			array( 
				'id' => 'blog_post_types',
				'title' => esc_html__( 'Post Types', 'huber' ),
				'desc' => esc_html__( 'Select the post types you want to display.', 'huber' ),
				'type' => 'select',
				'multi' => true,				
				'options' => array(
					'post' => esc_html__( 'Post', 'huber' ),
					'page' => esc_html__( 'Page', 'huber' ),
				),
				'default' => array( 'post' ),
			),
													
			array( 
				'id' => 'blog_format',
				'title' => esc_html__( 'Format', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The format to display the items in.', 'huber' ),
				'options' => array(
					'gp-blog-list' => esc_html__( 'List', 'huber' ),
					'gp-blog-columns-1' => esc_html__( '1 Column', 'huber' ),
					'gp-blog-columns-2' => esc_html__( '2 Columns', 'huber' ),
					'gp-blog-columns-3' => esc_html__( '3 Columns', 'huber' ),
					'gp-blog-columns-4' => esc_html__( '4 Columns', 'huber' ),
					'gp-blog-columns-5' => esc_html__( '5 Columns', 'huber' ),
					'gp-blog-columns-6' => esc_html__( '6 Columns', 'huber' ),
					'gp-blog-masonry' => esc_html__( 'Masonry', 'huber' ),
				),
				'default' => 'gp-blog-list',
			),

			array(  
				'id' => 'blog_orderby',
				'title' => esc_html__( 'Order By', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The criteria which the items are ordered by.', 'huber' ),
				'options' => array(
					'newest' => esc_html__( 'Newest', 'huber' ),
					'oldest' => esc_html__( 'Oldest', 'huber' ),
					'title_az' => esc_html__( 'Title (A-Z)', 'huber' ),
					'title_za' => esc_html__( 'Title (Z-A)', 'huber' ),
					'comment_count' => esc_html__( 'Most Comments', 'huber' ),
					'views' => esc_html__( 'Most Views', 'huber' ),
					'likes' => esc_html__( 'Most Likes', 'huber' ),
					'menu_order' => esc_html__( 'Menu Order', 'huber' ),
					'rand' => esc_html__( 'Random', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default' => 'newest',
			),
			                    										
			array(
				'id'       => 'blog_per_page',
				'type'     => 'spinner',
				'title'    => esc_html__( 'Items Per Page', 'huber' ),
				'desc' => esc_html__( 'The number of items on each page.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 8,
			),

			array(
				'id'       => 'blog_standard_post_image_size',
				'title'    => esc_html__( 'Standard Post Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'blog_hub_image_size',
				'title'    => esc_html__( 'Hub Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'blog_review_image_size',
				'title'    => esc_html__( 'Review Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'blog_preview_image_size',
				'title'    => esc_html__( 'Preview Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
												
			array( 
				'id' => 'blog_content_display',
				'title' => esc_html__( 'Content Display', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'The amount of content displayed.', 'huber' ),
				'options' => array(
					'excerpt' => esc_html__( 'Excerpt', 'huber' ),
					'full_content' => esc_html__( 'Full Content', 'huber' ),
				),
				'default' => 'excerpt',
			),
		
			array( 
				'id' => 'blog_excerpt_length',
				'title' => esc_html__( 'Excerpt Length', 'huber' ),
				'required'  => array( 'blog_content_display', '=', 'excerpt' ),
				'type' => 'spinner',
				'desc' => esc_html__( 'The number of characters in excerpts.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => '0',
			),

			array(
				'id'        => 'blog_meta',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'huber' ),
				'desc' => esc_html__( 'Select the meta data you want to display.', 'huber' ), 
				'options'   => array(
					'release_date' => esc_html__( 'Release Date', 'huber' ),
					'author' => esc_html__( 'Author Name', 'huber' ),
					'date' => esc_html__( 'Post Date', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
                    'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'followers' => esc_html__( 'Followers', 'huber' ),
					'cats' => esc_html__( 'Categories', 'huber' ),
					'tags' => esc_html__( 'Post Tags', 'huber' ),
					'hub_fields' => esc_html__( 'Hub Fields', 'huber' ),
					'site_rating' => esc_html__( 'Site Rating', 'huber' ),
					'user_rating' => esc_html__( 'User Rating', 'huber' ),
				),
				'default'   => array(
					'release_date' => '0',
					'author' => '1',
					'date' => '1', 
					'comment_count' => '1',
					'views' => '0',
					'likes' => '0',
					'followers' => '0',
					'cats' => '0',
					'tags' => '0',
					'hub_fields' => '0',
					'site_rating' => '1',
					'user_rating' => '0',
				),
			),

			array(
				'id'        => 'blog_filters',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Filters (Sorting)', 'huber' ),
				'desc' => esc_html__( 'Choose what options to display in the frontend dropdown filter menu (disabled if load more button enabled).', 'huber' ), 
				'options'   => array(
					'date' => esc_html__( 'Date', 'huber' ),
					'title' => esc_html__( 'Title', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default'   => array(
					'cats' => '0',
					'date' => '1',
					'title' => '1',
					'comment_count' => '1',
					'views' => '1',
					'likes' => '1',
					'release_date' => '1',
					'release_date_asc' => '1',
					'site_rating' => '1',
					'user_rating' => '1',
				)
			),

			array(
				'id'       => 'blog_filter_cat_id',
				'type'     => 'select',
				'required'  => array( 'blog_filter', '=', 'enabled' ),
				'title'    => esc_html__( 'Filter (Categories)', 'huber' ),
				'data' => 'terms',
				'args' => array( 'taxonomies' => 'category', 'hide_empty' => false ),
				'desc' => esc_html__( 'Select the category you want to filter by, leave blank to display all categories.', 'huber' ),
				'subtitle' => esc_html__( 'The sub categories of this category will also be displayed.', 'huber' ),
				'default' => '',
			),
									
			array(  
				'id' => 'blog_read_more_link',
				'title' => esc_html__( 'Read More Link', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a read more link below the content.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),
														
		),
	);
    $metaboxes[] = array(
        'id' => 'blog-template-options',
        'title' => esc_html__( 'Blog Options', 'huber' ),
        'post_types' => array( 'page' ),
        'page_template' => array( 'blog-template.php' ),
        'position' => 'normal',
        'priority' => 'high',
        'sections' => $blog_options,
    );
    

	/*--------------------------------------------------------------
	Homepage Options
	--------------------------------------------------------------*/	

	$homepage_options = array();
    $homepage_options[] = array(
		'title' => esc_html__( 'Featured Box', 'huber' ),
		'desc' => esc_html__( 'The area at the top of the page that contains one, two or three posts.', 'huber' ),
		'icon' => 'el-icon-screen',
		'fields' => array(

			array( 
				'id' => 'home_presets',
				'title' => esc_html__( 'Demos', 'huber' ),					
				'type' => 'select',
				'desc' => esc_html__( 'Select one of the theme demos.', 'huber' ),
				'options' => array(
					'default' => esc_html__( 'None', 'huber' ),
					'homepage-1' => esc_html__( 'Homepage 1', 'huber' ),
					'homepage-2' => esc_html__( 'Homepage 2', 'huber' ),
					'homepage-3' => esc_html__( 'Homepage 3', 'huber' ),
					'homepage-4' => esc_html__( 'Homepage 4', 'huber' ),
					'homepage-5' => esc_html__( 'Homepage 5', 'huber' ),
					'homepage-6' => esc_html__( 'Homepage 6', 'huber' ),
				),	
				'default' => 'default',
			),
			
			array( 
				'id' => 'featured_box',
				'title' => esc_html__( 'Featured Box', 'huber' ),					
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to enable or disable the featured box.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),	
				'default' => 'enabled',
			),
			
			array(
				'id'       => 'featured_box_cats',
				'required' => array( 'featured_box', '=', 'enabled' ),
				'type'     => 'select',
				'title'    => esc_html__( 'Categories', 'huber' ),
				'data' => 'terms',
				'multi' => true,
				'args' => array( 'taxonomies' => 'category', 'hide_empty' => false ),
				'desc' => esc_html__( 'Select the categories you want to display in the featured box.', 'huber' ),
				'default' => '',
			),

			array(
				'id'       => 'featured_box_page_ids',
				'required' => array( 'featured_box', '=', 'enabled' ),
				'type'     => 'select',
				'title'    => esc_html__( 'Pages', 'huber' ),
				'data' => 'page',
				'multi' => true,
				'args' => array( 'post_status' => array( 'publish', 'future' ), 'sort_column' => 'menu_order' ),
				'desc' => esc_html__( 'Select the pages you want to display in the featured box.', 'huber' ),
				'default' => '',
			),	

			array(
				'id'       => 'featured_box_post_types',
				'required' => array( 'featured_box', '=', 'enabled' ),
				'type'     => 'select',
				'title'    => esc_html__( 'Post Types', 'huber' ),
				'data' => 'post_types',
				'multi' => true,
				'desc' => esc_html__( 'Select the post types you want to display in the featured box.', 'huber' ),
				'default' => array( 'post' ),
			),				

			array( 
				'id' => 'featured_box_format',
				'required' => array( 'featured_box', '=', 'enabled' ),
				'title' => esc_html__( 'Format', 'huber' ),					
				'type' => 'select',
				'desc' => esc_html__( 'The format of the featured box.', 'huber' ),
				'options' => array(
					'gp-featured-box-1' => esc_html__( '1 Item', 'huber' ),
					'gp-featured-box-2' => esc_html__( '2 Items', 'huber' ),
					'gp-featured-box-3' => esc_html__( '3 Items ', 'huber' ),
				),	
				'default' => 'gp-featured-box-3',
			),
						
			array(  
				'id' => 'featured_box_orderby',
				'required' => array( 'featured_box', '=', 'enabled' ),
				'title' => esc_html__( 'Order By', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The criteria which the items are ordered by.', 'huber' ),
				'options' => array(
					'newest' => esc_html__( 'Newest', 'huber' ),
					'oldest' => esc_html__( 'Oldest', 'huber' ),
					'title_az' => esc_html__( 'Title (A-Z)', 'huber' ),
					'title_za' => esc_html__( 'Title (Z-A)', 'huber' ),
					'comment_count' => esc_html__( 'Most Comments', 'huber' ),
					'views' => esc_html__( 'Most Views', 'huber' ),
					'likes' => esc_html__( 'Most Likes', 'huber' ),
					'menu_order' => esc_html__( 'Menu Order', 'huber' ),
					'rand' => esc_html__( 'Random', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default' => 'newest',
			),
			
			array(
				'id'       => 'featured_box_offset',
				'required' => array( 'featured_box', '=', 'enabled' ),
				'type'     => 'spinner',
				'title'    => esc_html__( 'Offset', 'huber' ),
				'desc' => esc_html__( 'The number of items to offset by e.g. set to 3 to exclude the first 3 posts.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => 0,
			),
			
			array( 
				'id' => 'featured_box_size',
				'required' => array( 'featured_box', '=', 'enabled' ),
				'title' => esc_html__( 'Size', 'huber' ),					
				'type' => 'button_set',
				'desc' => esc_html__( 'The size of the featured box.', 'huber' ),
				'options' => array(
					'gp-featured-box-fullwidth' => esc_html__( 'Full Width', 'huber' ),
					'gp-featured-box-boxed' => esc_html__( 'Boxed', 'huber' ),
				),	
				'default' => 'gp-featured-box-fullwidth',
			),

			array(
				'id' => 'featured_box_bg', 
				'required' => array( 'featured_box', '=', 'enabled' ),
				'title' => esc_html__( 'Background', 'huber' ),
				'type'      => 'media',	
				'mode'      => false,		
				'desc' => esc_html__( 'The background of the featured box which can be seen on wider screens.', 'huber' ),
				'default' => '',
			),
			
			array( 
				'id' => 'featured_box_caption_title',
				'required' => array( 'featured_box', '=', 'enabled' ),
				'title' => esc_html__( 'Caption Title', 'huber' ),					
				'type' => 'button_set',
				'desc' => esc_html__( 'Display the caption title.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),	
				'default' => 'enabled',
			),

			array( 
				'id' => 'featured_box_caption_title_length',
				'title' => esc_html__( 'Caption Title Length', 'huber' ),
				'required' => array( 'featured_box', '=', 'enabled' ),
				'type' => 'spinner',
				'desc' => esc_html__( 'The number of characters in the caption title.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => '50',
			),
			
			array( 
				'id' => 'featured_box_caption_text',
				'required' => array( 'featured_box', '=', 'enabled' ),
				'title' => esc_html__( 'Caption Text', 'huber' ),					
				'type' => 'button_set',
				'desc' => esc_html__( 'Display the caption text (only displays in main slide).', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),	
				'default' => 'enabled',
			),

			array( 
				'id' => 'featured_box_caption_text_length',
				'title' => esc_html__( 'Caption Text Length', 'huber' ),
				'required' => array( 'featured_box', '=', 'enabled' ),
				'type' => 'spinner',
				'desc' => esc_html__( 'The number of characters in the caption text.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => '160',
			),

			array( 
				'id' => 'featured_box_site_rating',
				'required' => array( 'featured_box', '=', 'enabled' ),
				'title' => esc_html__( 'Site Rating', 'huber' ),					
				'type' => 'button_set',
				'desc' => esc_html__( 'Display the site rating for this item.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),	
				'default' => 'enabled',
			),

			array( 
				'id' => 'featured_box_user_rating',
				'required' => array( 'featured_box', '=', 'enabled' ),
				'title' => esc_html__( 'User Rating', 'huber' ),					
				'type' => 'button_set',
				'desc' => esc_html__( 'Display the user rating for this item.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),	
				'default' => 'disabled',
			),
			
			array(  
				'id' => 'featured_box_image_position',
				'required' => array( 'featured_box', '=', 'enabled' ),
				'title' => esc_html__( 'Image Position', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'Choose what position the images are shown from.', 'huber' ),
				'options' => array(
					'top-left' => esc_html__( 'Top Left', 'huber' ),
					'top-center' => esc_html__( 'Top Center', 'huber' ),
					'top-right' => esc_html__( 'Top Right', 'huber' ),
					'center-center' => esc_html__( 'Center', 'huber' ),
				),
				'default' => 'center-center',
			),
	
			array(
				'id'       => 'homepage_content_header',
				'type'     => 'editor',
				'title'    => esc_html__( 'Content Header', 'huber' ),
				'desc' => esc_html__( 'Add content directly above the page content and sidebar.', 'huber' ),
				'default' => '',
			),

			array(
				'id' => 'homepage_content_header_format',
				'title' => esc_html__( 'Content Header Format', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether the content area stretches across the entire page.', 'huber' ),
				'options' => array(
					'fixed' => esc_html__( 'Fixed', 'huber' ),
					'fullwidth' => esc_html__( 'Full Width', 'huber' ),
				),
				'default' => 'fixed',
			),
																																							
		),			
	);

    $homepage_options[] = array(
		'title' => esc_html__( 'Featured Posts', 'huber' ),
		'desc' => esc_html__( 'A row of posts below the main featured box.', 'huber' ),
		'icon' => 'el-icon-th-large',
		'fields' => array(
				
			array( 
				'id' => 'featured_posts',
				'title' => esc_html__( 'Featured Posts', 'huber' ),					
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to enable or disable the featured posts.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),	
				'default' => 'enabled',
			),
		
			array(
				'id' => 'featured_posts_title', 
				'required' => array( 'featured_posts', '=', 'enabled' ),
				'title' => esc_html__( 'Featured Posts Title', 'huber' ),
				'type'      => 'text',	
				'desc' => esc_html__( 'The title for the featured posts.', 'huber' ),
				'default' => esc_html__( 'Featured Reviews', 'huber' ),
			),
			
			array(
				'id'       => 'featured_posts_cats',
				'required' => array( 'featured_posts', '=', 'enabled' ),
				'type'     => 'select',
				'title'    => esc_html__( 'Categories', 'huber' ),
				'data' => 'terms',
				'multi' => true,
				'args' => array( 'taxonomies' => 'category', 'hide_empty' => false ),
				'desc' => esc_html__( 'Select the categories you want to display.', 'huber' ),
				'default' => '',
			),

			array(
				'id'       => 'featured_posts_page_ids',
				'required' => array( 'featured_posts', '=', 'enabled' ),
				'type'     => 'select',
				'title'    => esc_html__( 'Pages', 'huber' ),
				'data' => 'page',
				'multi' => true,
				'args' => array( 'post_status' => array( 'publish', 'future' ), 'sort_column' => 'menu_order' ),
				'desc' => esc_html__( 'Select the pages you want to display in the slider.', 'huber' ),
				'default' => '',
			),	

			array(
				'id'       => 'featured_posts_post_types',
				'required' => array( 'featured_posts', '=', 'enabled' ),
				'type'     => 'select',
				'title'    => esc_html__( 'Post Types', 'huber' ),
				'data' => 'post_types',
				'multi' => true,
				'desc' => esc_html__( 'Select the post types you want to display in the slider.', 'huber' ),
				'default' => array( 'post' ),
			),
						
			array( 
				'id' => 'featured_posts_format',
				'required' => array( 'featured_posts', '=', 'enabled' ),
				'title' => esc_html__( 'Format', 'huber' ),
				'desc' => esc_html__( 'The format of the featured posts.', 'huber' ),
				'type' => 'select',
				'options' => array(
					'gp-blog-columns-1' => esc_html__( '1 Column', 'huber' ),
					'gp-blog-columns-2' => esc_html__( '2 Columns', 'huber' ),
					'gp-blog-columns-3' => esc_html__( '3 Columns', 'huber' ),
					'gp-blog-columns-4' => esc_html__( '4 Columns', 'huber' ),
					'gp-blog-columns-5' => esc_html__( '5 Columns', 'huber' ),
					'gp-blog-columns-6' => esc_html__( '6 Columns', 'huber' ),
				),
				'default' => 'gp-blog-columns-4',
			),
			
			array(  
				'id' => 'featured_posts_orderby',
				'required' => array( 'featured_posts', '=', 'enabled' ),
				'title' => esc_html__( 'Order By', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The criteria which the items are ordered by.', 'huber' ),
				'options' => array(
					'newest' => esc_html__( 'Newest', 'huber' ),
					'oldest' => esc_html__( 'Oldest', 'huber' ),
					'title_az' => esc_html__( 'Title (A-Z)', 'huber' ),
					'title_za' => esc_html__( 'Title (Z-A)', 'huber' ),
					'comment_count' => esc_html__( 'Most Comments', 'huber' ),
					'views' => esc_html__( 'Most Views', 'huber' ),
					'likes' => esc_html__( 'Most Likes', 'huber' ),
					'menu_order' => esc_html__( 'Menu Order', 'huber' ),
					'rand' => esc_html__( 'Random', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default' => 'newest',
			),
			
			array(
				'id'       => 'featured_posts_per_page',
				'required' => array( 'featured_posts', '=', 'enabled' ),
				'type'     => 'spinner',
				'title'    => esc_html__( 'Items', 'huber' ),
				'desc' => esc_html__( 'The number of items to display.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 4,
			),	
			
			array(
				'id'       => 'featured_posts_offset',
				'required' => array( 'featured_posts', '=', 'enabled' ),
				'type'     => 'spinner',
				'title'    => esc_html__( 'Offset', 'huber' ),
				'desc' => esc_html__( 'The number of items to offset by e.g. set to 3 to exclude the first 3 posts.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => 0,
			),

			array( 
				'id' => 'featured_posts_site_rating',
				'required' => array( 'featured_posts', '=', 'enabled' ),
				'title' => esc_html__( 'Site Rating', 'huber' ),					
				'type' => 'button_set',
				'desc' => esc_html__( 'Display the site rating for this item.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),	
				'default' => 'enabled',
			),

			array( 
				'id' => 'featured_posts_user_rating',
				'required' => array( 'featured_posts', '=', 'enabled' ),
				'title' => esc_html__( 'User Rating', 'huber' ),					
				'type' => 'button_set',
				'desc' => esc_html__( 'Display the user rating for this item.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),	
				'default' => 'disabled',
			),
								
		),			
	);
	
    $homepage_options[] = array(
		'title' => esc_html__( 'Latest News', 'huber' ),
		'desc' => esc_html__( 'A list or grid of posts below the featured box and featured rows in the main content area.', 'huber' ),
		'icon' => 'el-icon-pencil',
		'fields' => array(
				
			array( 
				'id' => 'latest_news',
				'title' => esc_html__( 'Latest News', 'huber' ),					
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to enable or disable the latest news.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),	
				'default' => 'enabled',
			),
		
			array(
				'id' => 'latest_news_title', 
				'required' => array( 'latest_news', '=', 'enabled' ),
				'title' => esc_html__( 'Latest News Title', 'huber' ),
				'type'      => 'text',	
				'desc' => esc_html__( 'The title for the latest news.', 'huber' ),
				'default' => esc_html__( 'Latest News', 'huber' ),
			),
			
			array(
				'id'       => 'latest_news_cats',
				'required' => array( 'latest_news', '=', 'enabled' ),
				'type'     => 'select',
				'title'    => esc_html__( 'Categories', 'huber' ),
				'data' => 'terms',
				'multi' => true,
				'args' => array( 'taxonomies' => 'category', 'hide_empty' => false ),
				'desc' => esc_html__( 'Select the categories you want to display.', 'huber' ),
				'default' => '',
			),

			array(
				'id'       => 'latest_news_page_ids',
				'required' => array( 'latest_news', '=', 'enabled' ),
				'type'     => 'select',
				'title'    => esc_html__( 'Pages', 'huber' ),
				'data' => 'page',
				'multi' => true,
				'args' => array( 'post_status' => array( 'publish', 'future' ), 'sort_column' => 'menu_order' ),
				'desc' => esc_html__( 'Select the pages you want to display in the slider.', 'huber' ),
				'default' => '',
			),	

			array(
				'id'       => 'latest_news_post_types',
				'required' => array( 'latest_news', '=', 'enabled' ),
				'type'     => 'select',
				'title'    => esc_html__( 'Post Types', 'huber' ),
				'data' => 'post_types',
				'multi' => true,
				'desc' => esc_html__( 'Select the post types you want to display in the slider.', 'huber' ),
				'default' => array( 'post' ),
			),
						
			array( 
				'id' => 'latest_news_format',
				'required' => array( 'latest_news', '=', 'enabled' ),
				'title' => esc_html__( 'Format', 'huber' ),
				'desc' => esc_html__( 'The format of the featured posts.', 'huber' ),
				'type' => 'select',
				'options' => array(
					'gp-blog-list'      => esc_html__( 'List', 'huber' ),
					'gp-blog-columns-1' => esc_html__( '1 Column', 'huber' ),
					'gp-blog-columns-2' => esc_html__( '2 Columns', 'huber' ),
					'gp-blog-columns-3' => esc_html__( '3 Columns', 'huber' ),
					'gp-blog-columns-4' => esc_html__( '4 Columns', 'huber' ),
					'gp-blog-columns-5' => esc_html__( '5 Columns', 'huber' ),
					'gp-blog-columns-6' => esc_html__( '6 Columns', 'huber' ),
					'gp-blog-masonry'   => esc_html__( 'Masonry', 'huber' ),
				),
				'default' => 'gp-blog-list',
			),
			
			array(  
				'id' => 'latest_news_orderby',
				'required' => array( 'latest_news', '=', 'enabled' ),
				'title' => esc_html__( 'Order By', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The criteria which the items are ordered by.', 'huber' ),
				'options' => array(
					'newest' => esc_html__( 'Newest', 'huber' ),
					'oldest' => esc_html__( 'Oldest', 'huber' ),
					'title_az' => esc_html__( 'Title (A-Z)', 'huber' ),
					'title_za' => esc_html__( 'Title (Z-A)', 'huber' ),
					'comment_count' => esc_html__( 'Most Comments', 'huber' ),
					'views' => esc_html__( 'Most Views', 'huber' ),
					'likes' => esc_html__( 'Most Likes', 'huber' ),
					'menu_order' => esc_html__( 'Menu Order', 'huber' ),
					'rand' => esc_html__( 'Random', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default' => 'newest',
			),
			
			array(
				'id'       => 'latest_news_per_page',
				'required' => array( 'latest_news', '=', 'enabled' ),
				'type'     => 'spinner',
				'title'    => esc_html__( 'Items Per Page', 'huber' ),
				'desc' => esc_html__( 'The number of items on each page.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 7,
			),

			array(
				'id'       => 'latest_news_standard_post_image_size',
				'required' => array( 'latest_news', '=', 'enabled' ),
				'title'    => esc_html__( 'Standard Post Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'latest_news_hub_image_size',
				'required' => array( 'latest_news', '=', 'enabled' ),
				'title'    => esc_html__( 'Hub Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'latest_news_review_image_size',
				'required' => array( 'latest_news', '=', 'enabled' ),
				'title'    => esc_html__( 'Review Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'latest_news_preview_image_size',
				'required' => array( 'latest_news', '=', 'enabled' ),
				'title'    => esc_html__( 'Preview Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
						
			array(
				'id'       => 'latest_news_offset',
				'required' => array( 'latest_news', '=', 'enabled' ),
				'type'     => 'spinner',
				'title'    => esc_html__( 'Offset', 'huber' ),
				'desc' => esc_html__( 'The number of items to offset by e.g. set to 3 to exclude the first 3 posts.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => 0,
			),
			
			array( 
				'id' => 'latest_news_excerpt_length',
				'title' => esc_html__( 'Excerpt Length', 'huber' ),
				'required' => array( 'latest_news', '=', 'enabled' ),
				'type' => 'spinner',
				'desc' => esc_html__( 'The number of characters in excerpts.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => '200',
			),
			
			array(  
				'id' => 'latest_news_pagination',
				'required' => array( 'latest_news', '=', 'enabled' ),
				'title' => esc_html__( 'Pagination', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'Add pagination numbers or load more button.', 'huber' ),
				'options' => array(
					'page-numbers' => esc_html__( 'Page Numbers', 'huber' ),
					'load-more' => esc_html__( 'Load More Button', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'load-more',
			),
								
		),			
	);	
    $metaboxes[] = array(
        'id' => 'homepage-template-options',
        'title' => esc_html__( 'Homepage Options', 'huber' ),
        'post_types' => array( 'page' ),
        'page_template' => array( 'homepage-template.php' ),
        'position' => 'normal',
        'priority' => 'high',
        'sections' => $homepage_options,
    );					
	
    
	/*--------------------------------------------------------------
	Link Page Template Options
	--------------------------------------------------------------*/	

    $link_template_options = array();
    $link_template_options[] = array(
        'fields' => array(
        
			array( 
				'id' => 'link_template_link',
				'title' => esc_html__( 'Link', 'huber' ),
				'type' => 'text',
				'desc' => esc_html__( 'The link which your page goes to.', 'huber' ),
				'default' => '',
				'validate' => 'url',
			),

			array( 
				'id' => 'link_template_link_target',
				'title' => esc_html__( 'Link Target', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'The target for the link.', 'huber' ),
				'options' => array(
					'_blank' => esc_html__( 'New Window', 'huber' ),
					'_self' => esc_html__( 'Same Window', 'huber' ),
				),
				'default' => '_self',
			),
															 
		),
	);	
    $metaboxes[] = array(
        'id' => 'link-template-options',
        'title' => esc_html__( 'Link Options', 'huber' ),
        'post_types' => array( 'page' ),
        'page_template' => array( 'link-template.php' ),
        'position' => 'normal',
        'priority' => 'high',
        'sections' => $link_template_options,
    );


	/*--------------------------------------------------------------
	Post/Page Options
	--------------------------------------------------------------*/	

    // General
	$page_options = array();			
    $page_options[] = array(
    	'title' => esc_html__( 'General', 'huber' ),	
		'desc' => esc_html__( 'By default most of these options are set from the Theme Options page to change all pages at once, but you can overwrite these options here so this page has different settings.', 'huber' ),
		'icon' => 'el-icon-cogs',
		'fields' => array(

			array( 
				'id' => 'template',
				'title' => esc_html__( 'Template', 'huber' ),
				'desc' => esc_html__( 'Choose whether this is a standard, hub or review post/page.', 'huber' ),
				'type' => 'button_set',
				'options' => array(
					'gp-standard-post' => esc_html__( 'Standard', 'huber' ),
					'gp-hub-post' => esc_html__( 'Hub', 'huber' ),
					'gp-review-post' => esc_html__( 'Review', 'huber' ),
					'gp-preview-post' => esc_html__( 'Preview', 'huber' ),
					'gp-user-review-post' => esc_html__( 'User Review', 'huber' ),
				),
				'default' => 'gp-standard-post',
			),
			
			// Load hub association option
			apply_filters( 'ghostpool_hub_association_option_type', '' ),

			array(
				'id'      => 'primary_hub',
				'type'    => 'select',
				'data'    => 'primary_hub',
				'title'   => esc_html__( 'Primary Hub', 'huber' ),
				'subtitle' => esc_html__( 'You will need to save the post/page before you will see the associated hubs in this list.', 'huber' ),
				'desc' => esc_html__( 'Select a primary hub which will be shown in the hub header, GP Rating Box and GP Affiliates widget for this post/page.', 'huber' ),
				'required' => array( 'hub_association_ids', '!=', '' ),
				'default' => '',
			),	
																									
			array( 
				'id' => 'page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The page header on the page.', 'huber' ),
				'options' => array(
					'default' => esc_html__( 'Default', 'huber' ),
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'default',
			),
				
			array(
				'id' => 'page_header_bg', 
				'title' => esc_html__( 'Page Header Image Background', 'huber' ),
				'type'      => 'media',		
				'mode'      => false,
				'desc' => esc_html__( 'The background of the page header.', 'huber' ),
				'default' => '',
			),	

			array( 
				'id' => 'page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '', 
				)		
			 ),

			array(
				'id' => 'page_header_video', 
				'title' => esc_html__( 'Page Header Video', 'huber' ),
				'subtitle' => esc_html__( 'Supports YouTube, Vimeo and HTML5 video. For multiple HTML5 formats, each video should have exactly the same filename but remove the extension (e.g. .mp4) from the filename in the text box.', 'huber' ),
				'type'      => 'text',	
				'validate'  => 'url',	
				'desc' => esc_html__( 'URL to the video that is displayed in the page header.', 'huber' ),
				'default' => '',
			),
			 								
			array(
				'id' => 'page_header_video_bg', 
				'title' => esc_html__( 'Page Header Video Background', 'huber' ),
				'subtitle' => esc_html__( 'Supports YouTube, Vimeo and HTML5 video. For multiple HTML5 formats, each video should have exactly the same filename but remove the extension (e.g. .mp4) from the filename in the text box.', 'huber' ),
				'type'      => 'text',	
				'validate'  => 'url',
				'desc' => esc_html__( 'URL of the video used as the background in the page header.', 'huber' ),
				'default' => '',
			),
						        
			array( 
				'id' => 'custom_title',
				'title' => esc_html__( 'Custom Title', 'huber' ),
				'type' => 'text',
				'desc' => esc_html__( 'A custom title that overwrites the default title.', 'huber' ),
				'default' => '',
			),
									
			array( 
				'id' => 'subtitle',
				'title' => esc_html__( 'Subtitle', 'huber' ),
				'type' => 'textarea',
				'desc' => esc_html__( 'Add a subtitle below the title header.', 'huber' ),
				'default' => '',
			),
		
			array( 
				'id' => 'layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),					
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'default' => array( 'title' => esc_html__( 'Default', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/default.png' ),
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'default',
			),
			
			array(
				'id'      => 'left_sidebar',
				'type'    => 'select',
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars_default',
				'default' => 'default',
			),

			array(
				'id'      => 'right_sidebar',
				'type'    => 'select',
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars_default',
				'default' => 'default',
			),		

			array(
				'id'      => 'comments_sidebar',
				'type'    => 'select',
				'title'   => esc_html__( 'Comments Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars_default',
				'default' => 'default',
			),

			array(  
				'id' => 'image',
				'title' => esc_html__( 'Featured Image', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether to display the featured image.', 'huber' ),
				'options' => array(
					'default' => esc_html__( 'Default', 'huber' ),
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'default',
			),

		),
	);

    // Hub Options
    $page_options[] = array(
    	'title' => esc_html__( 'Hub', 'huber' ),
		'desc' => esc_html__( 'Options relating to hubs.', 'huber' ),
		'icon' => 'el-icon-globe',
		'fields' => array(		
		
			array( 
				'id' => 'release_date',		
				'title' => esc_html__( 'Release Date', 'huber' ),
				'type' => 'date',
				'desc' => esc_html__( 'The release date of this item using the format yyyy/mm/dd e.g. 2017/03/31.', 'huber' ),
			),

			array(
				'id'       => 'synopsis',
				'type'     => 'editor',
				'title'    => esc_html__( 'Synopsis', 'huber' ),
				'subtitle' => esc_html__( 'Used in the GP Rating Box and replaces the default excerpt on category pages.', 'huber' ),
				'desc' => esc_html__( 'Add a synopsis for this page.', 'huber' ),
				'default' => '',
			),

			array( 
				'id' => 'affiliates',
				'title' => esc_html__( 'Affiliates', 'huber' ),
				'desc' => esc_html__( 'Add an affiliate.', 'huber' ),
				'subtitle' => esc_html__( 'Add the affiliate name, price and link in the following format e.g. Amazon | $75.99 | https://amazon.com/sub-page | Buy', 'huber' ),
				'type' => 'multi_text',
				'add_text' => esc_html__( 'Add New', 'huber' ),
				'default' => '',
			),

			array(  
				'id' => 'forum_topic',
				'title' => esc_html__( 'Forum/Topic', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether to display a forum or topic.', 'huber' ),
				'options' => array(
					'forum' => esc_html__( 'Forum', 'huber' ),
					'topic' => esc_html__( 'Topic', 'huber' ),
				),
				'default' => 'forum',
			),
									
			array(
				'id'        => 'forum_tab_id',
				'type'      => 'text',
				'title'     => esc_html__( 'Forum/Topic ID', 'huber' ),
				'desc'  => esc_html__( 'The ID of the forum or topic you want to show under the Forums tab.', 'huber' ),
				'default' => '',
			),

			array(
				'id'        => 'images_tab_gallery',
				'type'      => 'gallery',
				'title'     => esc_html__( 'Images Gallery', 'huber' ),
				'subtitle'  => esc_html__( 'Select or upload images using the WordPress native uploader.', 'huber' ),
				'desc'  => esc_html__( 'Uploaded images will automatically show up under the images tab page.', 'huber' ),
				'default' => '',
			),

			// Load hub association option
			apply_filters( 'ghostpool_custom_hub_tab_option_type', '' ),
						
			array(
				'id' => 'tab_title', 
				'title' => esc_html__( 'Custom Tab Title', 'huber' ),
				'type'      => 'text',
				'desc' => esc_html__( 'Add a custom title for the hub tab instead of the standard page title.', 'huber' ),
				'default' => '',
			),
															
		),
	);	
	
	// Review Options
    $page_options[] = array(
		'title' => esc_html__( 'Review', 'huber' ),
		'desc' => esc_html__( 'Give any post or page a review.', 'huber' ),
		'icon' => 'el-icon-star',
		'fields' => array(
			
			array( 
				'id' => 'site_rating',
				'title' => esc_html__( 'Site Rating', 'huber' ),
				'desc' => esc_html__( 'Add a rating for this review.', 'huber' ),
				'subtitle' => esc_html__( 'To add multiple ratings click the "Add Site Rating" button.', 'huber' ),
				'type' => 'multi_text',
				'add_text' => esc_html__( 'Add New', 'huber' ),
				'default' => '',
			),

			array( 
				'id' => 'rating_criteria',
				'title' => esc_html__( 'Rating Criteria', 'huber' ),
				'desc' => esc_html__( 'Add multiple rating criteria to your site rating.', 'huber' ),
				'subtitle' => esc_html__( 'To add multiple criteria click the "Add Rating Criteria" button. If you want to use your global rating criteria from the Theme Options page leave this empty.', 'huber' ),
				'type' => 'multi_text',
				'add_text' => esc_html__( 'Add New', 'huber' ),
				'default' => '',
				'test' => true
			),
									
			array( 
				'id' => 'good_points',
				'title' => esc_html__( 'Good Points', 'huber' ),
				'desc' => esc_html__( 'Add a good point for this review.', 'huber' ),
				'subtitle' => esc_html__( 'To add multiple good points click the "Add Good Point" button.', 'huber' ),
				'type' => 'multi_text',
				'add_text' => esc_html__( 'Add New', 'huber' ),
				'default' => '',
			),

			array( 
				'id' => 'bad_points',
				'title' => esc_html__( 'Bad Points', 'huber' ),
				'desc' => esc_html__( 'Add a bad point for this review.', 'huber' ),
				'subtitle' => esc_html__( 'To add multiple bad points click the "Add Bad Point" button.', 'huber' ),
				'type' => 'multi_text',
				'add_text' => esc_html__( 'Add New', 'huber' ),
				'default' => '',
			),
			
			array( 
				'id' => 'summary',
				'title' => esc_html__( 'Summary', 'huber' ),
				'type' => 'textarea',
				'desc' => esc_html__( 'Add a summary for you review or preview.', 'huber' ),
			),
			
			array(  
				'id' => 'results_position',
				'title' => esc_html__( 'Results Position', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose the position of the review results which contain the good/bad points and site rating.', 'huber' ),
				'options' => array(
					'default' => esc_html__( 'Default', 'huber' ),
					'top' => esc_html__( 'Top', 'huber' ),
					'bottom' => esc_html__( 'Bottom', 'huber' ),
				),
				'default' => 'default',
			),
						
			array(
				'id'        => 'reset_user_ratings',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Reset User Ratings & Votes', 'huber' ),
				'desc' => esc_html__( 'Reset the user ratings and votes for this page only.', 'huber' ),
				'default'  => '0',
			),
																		
		),
	);
		
    $metaboxes[] = array(
        'id' => 'page-options',
        'title' => esc_html__( 'Page Options', 'huber' ),
        'post_types' => array( 'post', 'page', 'product' ),
        'post_format' => array( '0', 'standard', 'audio', 'gallery', 'quote', 'video', 'link' ),
        'position' => 'normal',
        'priority' => 'high',
        'sections' => $page_options
    ); 
        
    // Kind of overkill, but ahh well.  ;)
    $metaboxes = apply_filters( 
    	'ghostpool_redux_metabox_options', 
    	$metaboxes,
    	$page_options,
    	$audio_format_options, 
    	$gallery_format_options, 
    	$link_format_options, 
    	$quote_format_options,
    	$video_format_options,
    	$blog_options,
    	$homepage_options,
    	$link_template_options
    );

    return $metaboxes;
  }
  add_action('redux/metaboxes/'.$redux_opt_name.'/boxes', 'ghostpool_add_metaboxes');
endif;