<?php
/**
 * Version 0.0.3
 *
 * This file is just an example you can copy it to your theme and modify it to fit your own needs.
 * Watch the paths though.
 */
 
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'GhostPool_Importer' ) && class_exists( 'GhostPool_Huber' ) ) {

	if ( file_exists( WP_PLUGIN_DIR . '/huber-plugin/importer/radium-importer.php' ) ) {			
		require_once( WP_PLUGIN_DIR . '/huber-plugin/importer/radium-importer.php' );
	}
	
	class GhostPool_Importer extends Radium_Theme_Importer {

		private static $instance;
		public $theme_options_framework = 'redux';
		public $theme_option_name       = 'ghostpool_huber';
		public $theme_options_file_name = 'theme_options.txt';
		public $widgets_file_name       = 'widgets.json';
		public $content_demo_file_name  = 'content.xml';
		public $widget_import_results;
		public $demo_files_path;

		public function __construct() {
			$this->demo_files_path = get_template_directory() . '/lib/framework/importer/demo-files/';
			self::$instance = $this;
			parent::__construct();
		}

		public static function getInstance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}
	
		public function set_demo_menus() {
			$locations = get_theme_mod( 'nav_menu_locations' );
			$menus = wp_get_nav_menus();
			if ( $menus ) {
				foreach( $menus as $menu ) { // assign menus to theme locations
					if ( $menu->name == 'Huber Desktop Menu' ) {
						$locations['gp-desktop-nav'] = $menu->term_id;				
					} elseif ( $menu->name == 'Huber Social Menu' ) {
						$locations['gp-social-nav'] = $menu->term_id;						
					} elseif ( $menu->name == 'Huber Profile Menu' ) {
						$locations['gp-profile-nav'] = $menu->term_id;						
					} elseif ( $menu->name == 'Huber Footer Menu' ) {
						$locations['gp-footer-nav'] = $menu->term_id;		
					}
				}
			}
			set_theme_mod( 'nav_menu_locations', $locations );	
		}

		public function ghostpool_custom_sidebars() {	
			if ( get_option( 'ghostpool_custom_sidebars_imported' ) !== '1' ) {
				$sidebars = array();
				$sidebars = get_option( 'cs_sidebars', FALSE );
				if ( $sidebars !== FALSE ) {
					$sidebars = $sidebars;
					$sidebars[] = array(
						'name' => '',
						'id' => '',
						'description' => '',
						'before_widget' => '<div id="%1$s" class="widget %2$s">',
						'after_widget'  => '</div>',
						'before_title'  => '<div class="element-title"><h3 class="widgettitle">',
						'after_title'   => '</h3></div>',
					);			
					update_option( 'cs_sidebars', $sidebars );
				}
				update_option( 'ghostpool_custom_sidebars_imported', '1' );
			}
			
			if ( ! empty( $sidebars ) ) {
				foreach( $sidebars as $sidebar ) {
					register_sidebar( $sidebar );
				}
			}
			
		}

		public function after_wp_importer() {
		
			// Set home page
			if ( get_page_by_path( 'home' ) ) {				
				update_option( 'page_on_front', get_page_by_path( 'home' )->ID );
			}	
			update_option( 'show_on_front', 'page' );
	
			// Set Following page in theme options
			if ( get_page_by_path( 'following' ) && ghostpool_option( 'following_page' ) == '' ) {
				$following_page_id = get_page_by_path( 'following' )->ID;
				Redux::setOption( 'ghostpool_huber', 'following_page', $following_page_id );
			}

			// Set Post Submission pages in theme options
			if ( get_page_by_path( 'my-posts' ) && ghostpool_option( 'post_submission_page' ) == '' ) {
				$my_posts_page_id = get_page_by_path( 'my-posts' )->ID;
				Redux::setOption( 'ghostpool_huber', 'post_submission_page', $my_posts_page_id );
			}		
	
			// Set featured box category
			if ( get_page_by_path( 'home' ) && get_category_by_slug( 'demo-featured' ) ) {
				$category = get_category_by_slug( 'demo-featured' );
				$category_id = $category->term_id;
				update_post_meta( get_page_by_path( 'home' )->ID, 'featured_box_cats', $category_id );	
			}
			if ( ( get_page_by_path( 'homepage-2' ) OR get_page_by_path( 'homepage-3' ) ) && get_category_by_slug( 'demo-games' ) ) {
				$category = get_category_by_slug( 'demo-games' );
				$category_id = $category->term_id;
				update_post_meta( get_page_by_path( 'homepage-2' )->ID, 'featured_box_cats', $category_id );	
				update_post_meta( get_page_by_path( 'homepage-3' )->ID, 'featured_box_cats', $category_id );	
			}

			// Set featured posts category
			if ( ( get_page_by_path( 'home' ) OR get_page_by_path( 'homepage-2' ) ) && get_category_by_slug( 'demo-featured-reviews' ) ) {
				$category = get_category_by_slug( 'demo-featured-reviews' );
				$category_id = $category->term_id;
				update_post_meta( get_page_by_path( 'home' )->ID, 'featured_posts_cats', $category_id );	
				update_post_meta( get_page_by_path( 'homepage-2' )->ID, 'featured_posts_cats', $category_id );	
			}
	
			// Set latest news category
			if ( ( get_page_by_path( 'home' ) OR get_page_by_path( 'homepage-2' ) ) && get_category_by_slug( 'demo-news' ) ) {
				$category = get_category_by_slug( 'demo-news' );
				$category_id = $category->term_id;
				update_post_meta( get_page_by_path( 'home' )->ID, 'latest_news_cats', $category_id );
				update_post_meta( get_page_by_path( 'homepage-2' )->ID, 'latest_news_cats', $category_id );	
			}
															
			// Import custom category options
			if ( get_category_by_slug( 'demo-games' ) ) {
				$category = get_category_by_slug( 'demo-games' );
				$category_id = $category->term_id;
				$category_options = get_option( "taxonomy_$category_id" );
				$category_options['page_header'] = 'gp-first-post-page-header';
				$category_options['color'] = '';
				$category_options['page_header_bg'] = '';
				update_option( "taxonomy_$category_id", $category_options );
			}

			if ( get_category_by_slug( 'demo-pc' ) ) {
				$category = get_category_by_slug( 'demo-pc' );
				$category_id = $category->term_id;
				$category_options = get_option( "taxonomy_$category_id" );
				$category_options['color'] = '#1b384c';
				$category_options['page_header_bg'] = '';
				update_option( "taxonomy_$category_id", $category_options );
			}
	
			if ( get_category_by_slug( 'demo-ps4' ) ) {			
				$category = get_category_by_slug( 'demo-ps4' );
				$category_id = $category->term_id;
				$category_options = get_option( "taxonomy_$category_id" );
				$category_options['page_header'] = 'gp-fullwidth-page-header';
				$category_options['color'] = '#003791';
				$category_options['page_header_bg'] = '';
				update_option( "taxonomy_$category_id", $category_options );
			}
	
			if ( get_category_by_slug( 'demo-xbox-one' ) ) {			
				$category = get_category_by_slug( 'demo-xbox-one' );
				$category_id = $category->term_id;
				$category_options = get_option( "taxonomy_$category_id" );
				$category_options['color'] = '#5dc21e';
				$category_options['page_header_bg'] = '';
				update_option( "taxonomy_$category_id", $category_options );
			}
					
			if ( get_category_by_slug( 'demo-videos' ) ) {
				$category = get_category_by_slug( 'demo-videos' );
				$category_id = $category->term_id;
				$category_options = get_option( "taxonomy_$category_id" );
				$category_options['format'] = 'gp-blog-columns-2';
				$category_options['color'] = '';
				$category_options['page_header_bg'] = '';
				update_option( "taxonomy_$category_id", $category_options );
			}
	
			// Delete "Hello World" post
			$default_post = get_posts( array( 'title' => 'Hello World!' ) );
			if ( $default_post ) {				
				wp_delete_post( $default_post[0]->ID );
			}
		
		}					
		
	}

	GhostPool_Importer::getInstance();

}