<?php 

// Theme version number
define( 'HUBER_THEME_VERSION', '2.33' );

// Fix for incorrect URL to Redux assets
function ghostpool_redux_url() {
	return get_theme_file_uri( '/lib/framework/redux/' );
}
add_filter( 'redux/url', 'ghostpool_redux_url' );

// Load database updates
require_once( get_template_directory() . '/lib/framework/database-updates.php' );

// Load metaboxes
require_once( get_template_directory() . '/lib/framework/metaboxes-config.php' );

// Load Redux theme options framework
require_once( get_template_directory() . '/lib/framework/redux/framework.php' );

// Load theme options
require_once( get_template_directory() . '/lib/framework/theme-config.php' );

// Load options function
if ( ! function_exists( 'ghostpool_option' ) ) {
	function ghostpool_option( $opt_1, $opt_2 = false, $opt_3 = false, $opt_4 = false ) {
		global $ghostpool_huber;
		if ( $opt_4 != false ) {
			return $opt_4;
		} else {		
			if ( $opt_2 ) {
				if ( isset( $ghostpool_huber[$opt_1][$opt_2] ) ) {
					return $ghostpool_huber[$opt_1][$opt_2];
				}
			} else {
				if ( isset( $ghostpool_huber[$opt_1] ) ) {
					return $ghostpool_huber[$opt_1];
				}
			}
		}	
	}
}

/**
 * Load Redux stylesheet
 *
 */
if ( ! function_exists( 'ghostpool_redux_enqueue' ) ) {
	function ghostpool_redux_enqueue() {

		wp_enqueue_style( 'custom-redux-theme-options', get_template_directory_uri() . '/lib/framework/css/redux-theme-options.css', array( 'redux-admin-css' ), time(), 'all' );
	
		wp_enqueue_style( 'custom-redux-metaboxes', get_template_directory_uri() . '/lib/framework/css/redux-metaboxes.css', array( 'redux-admin-css', 'redux-extension-metaboxes-css' ), time(), 'all' );
		
		// Load custom version of date picker
		wp_dequeue_script( 'redux-field-date-js' );
		wp_enqueue_script( 'custom-redux-field-date-js', get_template_directory_uri() . '/lib/framework/scripts/field_date.min.js', array( 'jquery', 'jquery-ui-core', 'jquery-ui-datepicker', 'redux-js' ), time(), true );

		// Deregister script so select2 is not loaded on WooCommerce product pages
		/*wp_deregister_script( 'redux-select2-sortable-js' );
		if ( get_post_type() != 'product' ) {
			wp_register_script( 'redux-select2-sortable-js', get_template_directory_uri() . '/lib/framework/redux/assets/js/vendor/redux.select2.sortable.min.js', array( 'jquery' ), '', true );
		}*/   
		
		// Load settings script
		wp_enqueue_script( 'ghostpool-settings', get_template_directory_uri() . '/lib/framework/scripts/settings.js', array( 'jquery' ), '', true );
		
	}
}
add_action( 'redux/page/ghostpool_huber/enqueue', 'ghostpool_redux_enqueue' );

/**
 * Generate hub association option type
 *
 */

if ( ! function_exists( 'ghostpool_change_hub_association_option_type' ) ) {
	function ghostpool_change_hub_association_option_type() {
		return array(
			'id'      => 'hub_association_ids',
			'type'    => 'select',
			'multi'   => true,
			'data'    => 'hubs',
			'title'   => esc_html__( 'Hub Association', 'huber' ),
			'desc' => esc_html__( 'Select the hubs you want to associate this post with. This post will then display under the Reviews, News or Videos tab on the selected hubs.', 'huber' ),
			'default' => '',
		);					
	}
}
add_filter( 'ghostpool_hub_association_option_type', 'ghostpool_change_hub_association_option_type' );

/**
 * Generate custom tab option type
 *
 */
if ( ! function_exists( 'ghostpool_change_custom_hub_tab_option_type' ) ) {
	function ghostpool_change_custom_hub_tab_option_type() {
		return array(
			'id'      => 'custom_hub_tab_ids',
			'type'    => 'select',
			'multi'   => true,
			'data'    => 'hubs',
			'title'   => esc_html__( 'Custom Tab', 'huber' ),
			'desc' => esc_html__( 'Make this page a hub tab by selecting the hubs you want to display it on.', 'huber' ),
			'default' => '',
		);					
	}
}
add_filter( 'ghostpool_custom_hub_tab_option_type', 'ghostpool_change_custom_hub_tab_option_type' );
			
/**
 * Add custom rating criteria field
 *
 */
if ( ! function_exists( 'ghostpool_redux_rating_criteria' ) ) {
	function ghostpool_redux_rating_criteria( $text ) {
		$criteria = ghostpool_option( 'site_rating_criteria' );
		if ( isset( $criteria[0] ) && '' !== $criteria[0] ) {
			return $text . '<div class="description field-desc gp-rating-criteria-1">' . esc_html__( 'You have created the following rating criteria:', 'huber' ) . ' ' . implode( ', ', ghostpool_option( 'site_rating_criteria' ) ) . '</div>' . '<div class="description field-desc gp-rating-criteria-2">' . esc_html__( 'You have created the following rating criteria, you can override them above:', 'huber' ) . ' ' . implode( ', ', $criteria ) . '</div>';			
		} else {
			return $text;
		}
	}
}	
add_filter( 'redux/field/ghostpool_huber/multi_text/render/after', 'ghostpool_redux_rating_criteria' );

/**
 * Add custom hub association field
 *
 */
if ( ! function_exists( 'ghostpool_redux_data_hubs' ) ) {
	function ghostpool_redux_data_hubs() {
		
		$data = array();
		
		$args = array(
			'post_type' => array( 'post', 'page' ),
			'post_status' => array( 'publish', 'future' ), 
			'meta_key' => 'template',
			'meta_value' => apply_filters( 'ghostpool_hub_association_meta_value', 'gp-hub-post' ),
			'posts_per_page' => apply_filters( 'ghostpool_hub_association_per_page', '-1' ), 
			'orderby' => 'date', 
			'order' => 'desc',
			'no_found_rows'  => true,
			'cache_results' => false,
			'update_post_meta_cache' => false,
			'update_post_term_cache' => false,
		);
		
		$posts = get_posts( $args );
		if ( ! empty ( $posts ) ) {
			foreach ( $posts as $post ) {
				$data[ $post->ID ] = $post->post_title;
			}
		}
		
		return $data;
		
	}
}	
add_filter( 'redux/options/ghostpool_huber/data/hubs', 'ghostpool_redux_data_hubs' );

/**
 * Add custom primary hub field
 *
 */
if ( ! function_exists( 'ghostpool_redux_data_primary_hub' ) ) {
	function ghostpool_redux_data_primary_hub() {
	
		$data = array();
		
		$associated_hub_ids = get_post_meta( get_the_ID(), 'hub_association_ids', true );		
	
		if ( ! empty( $associated_hub_ids ) ) { 

			$args = array(
				'post_type' => array( 'post', 'page' ),
				'post_status' => array( 'publish', 'future' ), 
				'include' => $associated_hub_ids,
				'posts_per_page' => -1, 
				'orderby' => 'date', 
				'order' => 'desc',
				'no_found_rows'  => true,
				'cache_results' => false,
				'update_post_meta_cache' => false,
				'update_post_term_cache' => false,
			);
		
			$posts = get_posts( $args );
			if ( ! empty ( $posts ) ) {
				foreach ( $posts as $post ) {
					$data[ $post->ID ] = $post->post_title;
				}
			}
		
		}
				
		return $data;
		
	}
}	
add_filter( 'redux/options/ghostpool_huber/data/primary_hub', 'ghostpool_redux_data_primary_hub' );

/**
 * Add custom sidebar field
 *
 */
if ( ! function_exists( 'ghostpool_redux_data_sidebars' ) ) {
	function ghostpool_redux_data_sidebars() {		         
		global $wp_registered_sidebars;
		$data = array();	
		foreach ( $wp_registered_sidebars as $key => $value ) {
			$data[ $key ] = $value['name'];
		}
		return $data;
	}
}	
add_filter( 'redux/options/ghostpool_huber/data/custom_sidebars', 'ghostpool_redux_data_sidebars' );

/**
 * Add custom sidebar field with default option
 *
 */
if ( ! function_exists( 'ghostpool_redux_data_sidebars_default' ) ) {
	function ghostpool_redux_data_sidebars_default() {		         
		global $wp_registered_sidebars;
		$data = array();
		$data['default'] = esc_html__( 'Default', 'huber' );		
		foreach ( $wp_registered_sidebars as $key => $value ) {
			$data[ $key ] = $value['name'];
		}
		return $data;
	}
}	
add_filter( 'redux/options/ghostpool_huber/data/custom_sidebars_default', 'ghostpool_redux_data_sidebars_default' );

/**
 * Add custom image size data field
 *
 */
if ( ! function_exists( 'ghostpool_redux_data_image_sizes' ) ) {
	function ghostpool_redux_data_image_sizes() {
		global $_wp_additional_image_sizes;
		$output = array();
		$sizes = array();
		foreach ( get_intermediate_image_sizes() as $_size ) {
			if ( in_array( $_size, array( 'thumbnail', 'medium', 'medium_large', 'large' ) ) ) {
				$sizes[ $_size ]['width']  = get_option( "{$_size}_size_w" );
				$sizes[ $_size ]['height'] = get_option( "{$_size}_size_h" );
			} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
				$sizes[ $_size ] = array(
					'width'  => $_wp_additional_image_sizes[ $_size ]['width'],
					'height' => $_wp_additional_image_sizes[ $_size ]['height'],
				);
			}
			$name = $_size . ' (' . $sizes[ $_size ]['width'] . ' x ' . $sizes[ $_size ]['height'] . ')';
			$output[ $_size ] = $name;
		}
		return array_merge( array( 'default' => esc_html__( 'Default', 'huber' ) ), $output );
	}
}	
add_filter( 'redux/options/ghostpool_huber/data/custom_image_size', 'ghostpool_redux_data_image_sizes' );

/**
 * Change import option description text
 *
 */	 
function ghostpool_import_file_description() {
	return esc_html__( 'Copy and paste the code from the back up file and click Save Changes to restore your sites options from a backup.', 'huber' );
}
add_filter( 'redux-import-file-description', 'ghostpool_import_file_description' );

/**
 * Change import option description text
 *
 */	 
function ghostpool_import_url_description() {
	return esc_html__( 'Input the export URL below and click Save Changes to to restore your sites options from a backup.', 'huber' );
}
add_filter( 'redux-import-link-description', 'ghostpool_import_url_description' );

/**
 * Change accepted format for date validation
 *
 */	
class Redux_Validation_date {

	function __construct( $parent, $field, $value, $current ) {

		$this->parent       = $parent;
		$this->field        = $field;
		$this->field['msg'] = ( isset( $this->field['msg'] ) ) ? $this->field['msg'] : esc_html__( 'This field must be a valid date.', 'huber' );
		$this->value        = $value;
		$this->current      = $current;

		$this->validate();
	}
	
	function validate() {

		$string = str_replace( '/', '', $this->value );

		if ( ! is_numeric( $string ) ) {
			$this->value = ( isset( $this->current ) ) ? $this->current : '';
			$this->error = $this->field;

			return;
		}

		if ( $this->value[4] != '/' ) {
			$this->value = ( isset( $this->current ) ) ? $this->current : '';
			$this->error = $this->field;

			return;
		}

		if ( $this->value[7] != '/' ) {
			$this->value = ( isset( $this->current ) ) ? $this->current : '';
			$this->error = $this->field;
		}
	}
}

/**
 * Filter admin posts by template
 *
 */	 
function ghostpool_admin_posts_filter( $query ) {
    global $pagenow;
    if ( is_admin() && $pagenow == 'edit.php' ) {
		if ( isset( $_GET['template'] ) && $_GET['template'] == 'gp-associated-post' ) {
			$query->query_vars['meta_key'] = 'hub_association_ids';
	   } elseif ( isset( $_GET['template'] ) && $_GET['template'] != '' ) {
			$query->query_vars['meta_query'] = array(
				array(
					  'key' => 'template',
					  'value' => $_GET['template'],
				),
				array(
					  'key' => 'hub_association_ids',
					  'compare' => 'NOT EXISTS',
				),
			);
		}
   }
}
add_filter( 'parse_query', 'ghostpool_admin_posts_filter' );

/**
 * Display template dropdown filter for admin posts
 *
 */	 
function ghostpool_admin_posts_filter_restrict_manage_posts() {

	$fields = array( 	
		'' => esc_html__( 'All Templates', 'huber' ), 
		'gp-standard-post' => esc_html__( 'Standard Posts', 'huber' ), 
		'gp-associated-post' => esc_html__( 'Posts Associated With Hubs', 'huber' ), 
		'gp-hub-post' => esc_html__( 'Hub Posts', 'huber' ), 
		'gp-review-post' => esc_html__( 'Review Posts', 'huber' ), 
		'gp-preview-post' => esc_html__( 'Preview Posts', 'huber' ), 
		'gp-user-review-post' => esc_html__( 'User Review Posts', 'huber' ), 
	); ?>

	<select name="template">
		<?php foreach ( $fields as $key => $field ) { ?>
			<option value="<?php echo $key; ?>"<?php if ( isset( $_GET['template'] ) && $_GET['template'] == $key ) { ?> selected="selected"<?php } ?>><?php echo $field; ?></option>	
		<?php } ?>
	</select> 

<?php }
add_action( 'restrict_manage_posts', 'ghostpool_admin_posts_filter_restrict_manage_posts' );

// Hide Redux notice
if ( 'hide' !== get_option( 'redux-framework_tracking_notice' ) ) {
	update_option( 'redux-framework_tracking_notice', 'hide' );
}