<?php if ( ! function_exists( 'ghostpool_huber_update_database' ) ) {
	function ghostpool_huber_update_database() {
	
		// If this is a new installation do not update the database 
		if ( ! get_option( 'ghostpool_huber_db_version' ) ) {
			update_option( 'ghostpool_huber_db_version', '2.12' ); // Update database version to latest version and then exit
			return;
		}

		/**
		 * Updating to v1.4
		 *
		 */	
		 if ( version_compare( get_option( 'ghostpool_huber_db_version' ), '1.4', '<' ) ) {
	
			global $wpdb;

			// Update featured box format option values
			//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'gp-featured-box-one-col', 'gp-featured-box-1' ) );
			//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'gp-featured-box-two-cols', 'gp-featured-box-3' ) );

			// Change user reviews rating meta_key name
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_site_rating', 'ghostpool_post_submission_user_rating' ) );

			// Change user reviews rating meta_key name
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_site_rating', 'ghostpool_post_submission_user_rating' ) );

			update_option( 'ghostpool_huber_db_version', '1.4' );

		}

		/**
		 * Updating to v1.5.1
		 *
		 */
		if ( version_compare( get_option( 'ghostpool_huber_db_version' ), '1.5.1', '<' ) ) {
		
			global $wpdb;

			// Update custom hub tab meta key name
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'custom_hub_tab_ids', 'ghostpool_hub_tab' ) );

			update_option( 'ghostpool_huber_db_version', '1.5.1' );

		}

		/**
		 * Updating to v2.0
		 *
		 */	
		if ( version_compare( get_option( 'ghostpool_huber_db_version' ), '2.0', '<' ) ) {

			global $wpdb;

			// Change sidebar option names
			 if ( get_option( 'cs_sidebars' ) ) { 
				add_option( 'ghostpool_sidebars', get_option( 'cs_sidebars' ) );
				delete_option( 'cs_sidebars' );
			}
			if ( get_option( 'cs_modifiable' ) ) { 
				add_option( 'ghostpool_modifiable', get_option( 'cs_modifiable' ) );
				delete_option( 'cs_modifiable' );
			}	
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", '_ghostpool_replacements', '_cs_replacements' ) );

			update_option( 'ghostpool_huber_db_version', '2.0' );

		}

		/**
		 * Updating to v2.3
		 *
		 */	
		if ( version_compare( get_option( 'ghostpool_huber_db_version' ), '2.3', '<' ) ) {

			// Get entire array
			$my_options = get_option( 'ghostpool_huber' );

			// Alter the options array appropriately
			if ( $my_options['fixed_header'] == 'gp-fixed-header' ) {
				$my_options['fixed_header'] = 'gp-fixed-header-desktop';
			}
			if ( $my_options['back_to_top'] == 'gp-back-to-top' ) {
				$my_options['back_to_top'] = 'gp-back-to-top-desktop';
			}

			// Update entire array
			update_option( 'ghostpool_huber', $my_options );
			
			update_option( 'ghostpool_huber_db_version', '2.3' );

		}
		
		/**
		 * Updating to v2.12
		 *
		 */	
		if ( version_compare( get_option( 'ghostpool_huber_db_version' ), '2.12', '<' ) ) {

			global $wpdb;

			// Add template type for standard and user review posts
			$args = array(
				'meta_query'      => array( 
					'relation'    => 'AND',
					array( 
						'key'     => 'template', 
						'compare' => 'NOT EXISTS',
					),
				),
				'posts_per_page' => -1,
				'paged'			 => 1,
				'no_found_rows'	 => true,
			);
			$gp_query = new WP_Query( $args );
			if ( $gp_query->have_posts() ) : while ( $gp_query->have_posts() ) : $gp_query->the_post();
				if ( ! get_post_meta( get_the_ID(), 'template', true ) && get_post_meta( get_the_ID(), 'ghostpool_hub_page_id', true ) ) {
					add_post_meta( get_the_ID(), 'template', 'gp-user-review-post' );
				}
				if ( ! get_post_meta( get_the_ID(), 'template', true ) && ! get_post_meta( get_the_ID(), 'ghostpool_hub_page_id', true ) ) {
					add_post_meta( get_the_ID(), 'template', 'gp-standard-post' );
				}
			endwhile; endif;

			// Update vote down custom field name
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_voting_down', '_ghostpool_voting_down' ) );

			update_option( 'ghostpool_huber_db_version', '2.12' ); // remember to add this version to the top of page as well

		}
		
		
	}	
}
add_action( 'init', 'ghostpool_huber_update_database' );		