<?php
/**
 * BuddyPress - Groups Home
 *
 * @package BuddyPress
 * @subpackage bp-legacy
 */

?>
<div id="buddypress">

	<?php if ( bp_has_groups() ) : while ( bp_groups() ) : bp_the_group(); ?>

		<?php do_action( 'bp_before_group_home_content' ); ?>
			
		<div id="gp-buddypress-column-left">

			<?php do_action( 'bp_before_group_header' ); ?>

			<div id="item-header-content">

				<h2 class="gp-group-name"><?php bp_group_name(); ?></h2>
				
				<?php do_action( 'bp_before_group_header_meta' ); ?>
	
				<?php bp_group_type_list(); ?>

				<div id="item-buttons"><?php do_action( 'bp_group_header_actions' ); ?></div>

				<div id="item-meta">
					<?php do_action( 'bp_group_header_meta' ); ?>
					<span class="highlight"><?php bp_group_type(); ?></span>
					<span class="activity"><?php printf( esc_html__( 'active %s', 'huber' ), bp_get_group_last_active() ); ?></span>
					<?php bp_group_description(); ?>
				</div>
			
			</div>

			<div id="item-actions">

				<?php if ( bp_group_is_visible() ) : ?>

					<h2><?php esc_html_e( 'Group Admins', 'huber' ); ?></h2>

					<?php bp_group_list_admins(); do_action( 'bp_after_group_menu_admins' );

					if ( bp_group_has_moderators() ) :

						do_action( 'bp_before_group_menu_mods' ); ?>

						<h2><?php esc_html_e( 'Group Mods' , 'huber' ); ?></h2>

						<?php bp_group_list_mods(); do_action( 'bp_after_group_menu_mods' );

					endif;

				endif; ?>

			</div>

			<?php do_action( 'bp_after_group_header' ); do_action( 'template_notices' ); ?>
		
		</div>
	
		<div id="gp-buddypress-column-right">	

			<div id="item-body">

				<div id="item-nav">
					<div class="item-list-tabs no-ajax" id="object-nav" aria-label="<?php esc_attr_e( 'Group primary navigation', 'huber' ); ?>" role="navigation">
						<ul>

							<?php bp_get_options_nav(); ?>

							<?php
							/**
							 * Fires after the display of group options navigation.
							 *
							 * @since 1.2.0
							 */
							do_action( 'bp_group_options_nav' ); ?>

						</ul>
					</div>
				</div><!-- #item-nav -->
	
				<?php

				/**
				 * Fires before the display of the group home body.
				 *
				 * @since 1.2.0
				 */
				do_action( 'bp_before_group_body' );

				/**
				 * Does this next bit look familiar? If not, go check out WordPress's
				 * /wp-includes/template-loader.php file.
				 *
				 * @todo A real template hierarchy? Gasp!
				 */

					// Looking at home location
					if ( bp_is_group_home() ) :

						if ( bp_group_is_visible() ) {

							// Load appropriate front template
							bp_groups_front_template_part();

						} else {

							/**
							 * Fires before the display of the group status message.
							 *
							 * @since 1.1.0
							 */
							do_action( 'bp_before_group_status_message' ); ?>

							<div id="message" class="info">
								<p><?php bp_group_status_message(); ?></p>
							</div>

							<?php

							/**
							 * Fires after the display of the group status message.
							 *
							 * @since 1.1.0
							 */
							do_action( 'bp_after_group_status_message' );

						}

					// Not looking at home
					else :

						// Group Admin
						if     ( bp_is_group_admin_page() ) : bp_get_template_part( 'groups/single/admin'        );

						// Group Activity
						elseif ( bp_is_group_activity()   ) : bp_get_template_part( 'groups/single/activity'     );

						// Group Members
						elseif ( bp_is_group_members()    ) : bp_groups_members_template_part();

						// Group Invitations
						elseif ( bp_is_group_invites()    ) : bp_get_template_part( 'groups/single/send-invites' );

						// Membership request
						elseif ( bp_is_group_membership_request() ) : bp_get_template_part( 'groups/single/request-membership' );

						// Anything else (plugins mostly)
						else                                : bp_get_template_part( 'groups/single/plugins'      );

						endif;

					endif;

				/**
				 * Fires after the display of the group home body.
				 *
				 * @since 1.2.0
				 */
				do_action( 'bp_after_group_body' ); ?>

			</div><!-- #item-body -->

			<?php

			/**
			 * Fires after the display of the group home content.
			 *
			 * @since 1.2.0
			 */
			do_action( 'bp_after_group_home_content' ); ?>
		
		</div>	
	
	<?php endwhile; endif; ?>
		
</div><!-- #buddypress -->