<?php
/*
Template Name: Blog
*/
get_header();

// Page options
$header = ghostpool_option( 'page_header' ) == 'default' ? ghostpool_option( 'page_page_header' ) : ghostpool_option( 'page_header' );
$format = ghostpool_option( 'blog_format' );
$cats = ghostpool_option( 'blog_cats' ) ? esc_attr( implode( ',', ghostpool_option( 'blog_cats' ) ) ) : '';
$post_types = ghostpool_option( 'blog_post_types' ) ? implode( ',', ghostpool_option( 'blog_post_types' ) ) : ghostpool_option( 'blog_post_types' );
$image_size_standard = ghostpool_option( 'blog_standard_post_image_size' );
$image_size_hub = ghostpool_option( 'blog_hub_image_size' );
$image_size_review = ghostpool_option( 'blog_review_image_size' );
$image_size_preview = ghostpool_option( 'blog_preview_image_size' );
$content_display = ghostpool_option( 'blog_content_display' );	
$excerpt_length = ghostpool_option( 'blog_excerpt_length' );	
$meta_release_date = ghostpool_option( 'blog_meta', 'release_date' );
$meta_author = ghostpool_option( 'blog_meta', 'author' );
$meta_date = ghostpool_option( 'blog_meta', 'date' );
$meta_comment_count = ghostpool_option( 'blog_meta', 'comment_count' );
$meta_views = ghostpool_option( 'blog_meta', 'views' );
$meta_likes = ghostpool_option( 'blog_meta', 'likes' );
$meta_followers = ghostpool_option( 'blog_meta', 'followers' );
$meta_cats = ghostpool_option( 'blog_meta', 'cats' );
$meta_tags = ghostpool_option( 'blog_meta', 'tags' );
$meta_hub_fields = ghostpool_option( 'blog_meta', 'hub_fields' );
$meta_site_rating = ghostpool_option( 'blog_meta', 'site_rating' );
$meta_user_rating = ghostpool_option( 'blog_meta', 'user_rating' );
$read_more_link = ghostpool_option( 'blog_read_more_link' );

?>
	
<?php ghostpool_page_title( '', $header ); ?>

<?php ghostpool_page_header( 
	$post_id = get_the_ID(), 
	$type = $header,  
	$bg = ghostpool_option( 'page_header_bg' ),
	$height = ghostpool_option( 'page_header_height', 'padding-bottom' ) != '' ? ghostpool_option( 'page_header_height', 'padding-bottom' ) : ghostpool_option( 'page_page_header_height', 'padding-bottom' )	
); ?>

<div id="gp-content-wrapper" class="gp-container">

	<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>
	
	<div id="gp-inner-container">

		<div id="gp-left-column">
	
			<div id="gp-content">
		
				<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

					<?php if ( $header == 'gp-fullwidth-page-header' OR $header == 'gp-full-page-page-header' ) { ?>	
						<?php ghostpool_breadcrumbs(); ?>
						<header class="gp-entry-header">
							<h1 class="gp-entry-title">
								<?php if ( ghostpool_option( 'custom_title' ) ) { esc_attr_e( ghostpool_option( 'custom_title' ) ); } else { the_title(); } ?>
							</h1>
							<?php if ( ghostpool_option( 'subtitle' ) ) { ?>
								<div class="gp-subtitle"><?php esc_attr_e( ghostpool_option( 'subtitle' ) ); ?></div>
							<?php } ?>
						</header>
					<?php } ?>
										
					<?php the_content(); ?>
		
				<?php endwhile; endif; rewind_posts(); ?>	

				<?php $args = array(
					'post_status' 	      => 'publish',
					'post_type'           => ghostpool_option( 'blog_post_types' ),
					ghostpool_cats( ghostpool_option( 'blog_cats' ), 'param' ) => ghostpool_cats( ghostpool_option( 'blog_cats' ), 'variables' ),
					'orderby'             => ghostpool_orderby( ghostpool_option( 'blog_orderby' ), 'orderby' ),
					'order'               => ghostpool_orderby( ghostpool_option( 'blog_orderby' ), 'order' ),
					'meta_key'            => ghostpool_orderby( ghostpool_option( 'blog_orderby' ), 'meta_key' ),
					'meta_query' 		  => ghostpool_orderby( ghostpool_option( 'blog_orderby' ), ghostpool_option( 'blog_release_date_from' ), ghostpool_option( 'blog_release_date_to' ), 'meta_query' ),
					'posts_per_page'      => ghostpool_option( 'blog_per_page' ),
					'paged'          	  => ghostpool_paged(),
				);

				$args = apply_filters( 'ghostpool_blog_query', $args );

				$gp_query = new WP_Query( $args );
		
				?>
			
				<div class="gp-blog-wrapper gp-archive-wrapper <?php echo sanitize_html_class( ghostpool_option( 'blog_format' ) ); ?>" data-type="blog-template" data-cats="<?php echo esc_attr( $cats ); ?>" data-posttypes="<?php echo esc_attr( $post_types ); ?>" data-format="<?php echo esc_attr( ghostpool_option( 'blog_format' ) ); ?>" data-orderby="<?php echo esc_attr( ghostpool_option( 'blog_orderby' ) ); ?>" data-perpage="<?php echo absint( ghostpool_option( 'blog_per_page' ) ); ?>" data-offset="<?php echo esc_attr( ghostpool_option( 'blog_offset' ) ); ?>" data-imagesizestandard="<?php echo esc_attr( $image_size_standard ); ?>" data-imagesizehub="<?php echo esc_attr( $image_size_hub ); ?>" data-imagesizereview="<?php echo esc_attr( $image_size_review ); ?>" data-imagesizepreview="<?php echo esc_attr( $image_size_preview ); ?>" data-contentdisplay="<?php echo esc_attr( ghostpool_option( 'blog_content_display' ) ); ?>" data-excerptlength="<?php echo absint( ghostpool_option( 'blog_excerpt_length' ) ); ?>" data-releasedate="<?php echo esc_attr( ghostpool_option( 'blog_meta', 'release_date' ) ); ?>" data-metaauthor="<?php echo esc_attr( ghostpool_option( 'blog_meta', 'author' ) ); ?>" data-metadate="<?php echo esc_attr( ghostpool_option( 'blog_meta', 'date' ) ); ?>" data-metacommentcount="<?php echo esc_attr( ghostpool_option( 'blog_meta', 'comment_count' ) ); ?>" data-metaviews="<?php echo esc_attr( ghostpool_option( 'blog_meta', 'views' ) ); ?>" data-metalikes="<?php echo esc_attr( ghostpool_option( 'blog_meta', 'likes' ) ); ?>" data-metafollowers="<?php echo esc_attr( ghostpool_option( 'blog_meta', 'followers' ) ); ?>" data-metacats="<?php echo esc_attr( ghostpool_option( 'blog_meta', 'cats' ) ); ?>" data-metatags="<?php echo esc_attr( ghostpool_option( 'blog_meta', 'tags' ) ); ?>" data-metahubfields="<?php echo esc_attr( ghostpool_option( 'blog_meta', 'hub_fields' ) ); ?>" data-metasiterating="<?php echo esc_attr( ghostpool_option( 'blog_meta', 'site_rating' ) ); ?>" data-metauserrating="<?php echo esc_attr( ghostpool_option( 'blog_meta', 'user_rating' ) ); ?>" data-readmorelink="<?php echo esc_attr( ghostpool_option( 'blog_read_more_link' ) ); ?>" data-pagination="page-numbers">
				
						<?php ghostpool_filter(
							ghostpool_option( 'blog_filters' ),
							ghostpool_option( 'blog_filter_cat_id' ),
							ghostpool_option( 'blog_orderby' ),
							'page-numbers'
						); ?>
														
						<div class="gp-section-loop <?php echo sanitize_html_class( ghostpool_option( 'ajax' ) ); ?>">
							
							<?php if ( $gp_query->have_posts() ) : ?>
							
								<div class="gp-section-loop-inner">								
									<?php if ( ghostpool_option( 'blog_format' ) == 'gp-blog-masonry' ) { ?><div class="gp-gutter-size"></div><?php } ?>					
									<?php while ( $gp_query->have_posts() ) : $gp_query->the_post(); ?>
										<?php if ( function_exists( 'ghostpool_post_loop' ) ) { ghostpool_post_loop( $format, $image_size_standard, $image_size_hub, $image_size_review, $image_size_preview, $content_display, $excerpt_length, $meta_release_date, $meta_author, $meta_date, $meta_comment_count, $meta_views, $meta_likes, $meta_followers, $meta_cats, $meta_tags, $meta_hub_fields, $meta_site_rating, $meta_user_rating, $read_more_link ); } ?>
									<?php endwhile; ?>
								</div>
							
								<?php echo ghostpool_pagination( $gp_query->max_num_pages, 'page-numbers' ); ?>
						
						<?php else : ?>

							<strong class="gp-no-items-found"><?php esc_html_e( 'No items found.', 'huber' ); ?></strong>

						<?php endif; wp_reset_postdata(); ?>
						
					</div>	
			
				</div>

			</div>

			<?php get_sidebar( 'left' ); ?>

		</div>
	
		<?php get_sidebar( 'right' ); ?>

	</div>

	<?php do_action( 'ghostpool_end_content_wrapper' ); ?>
			
	<div class="gp-clear"></div>

</div>

<?php get_footer(); ?>