<?php get_header();

// Page options
$format = ghostpool_option( 'search_format' );
$image_size_standard = ghostpool_option( 'search_standard_post_image_size' );
$image_size_hub = ghostpool_option( 'search_hub_image_size' );
$image_size_review = ghostpool_option( 'search_review_image_size' );
$image_size_preview = ghostpool_option( 'search_preview_image_size' );
$content_display = ghostpool_option( 'search_content_display' );
$excerpt_length = ghostpool_option( 'search_excerpt_length' );	
$meta_release_date = ghostpool_option( 'search_meta', 'release_date' );
$meta_author = ghostpool_option( 'search_meta', 'author' );
$meta_date = ghostpool_option( 'search_meta', 'date' );
$meta_comment_count = ghostpool_option( 'search_meta', 'comment_count' );
$meta_views = ghostpool_option( 'search_meta', 'views' );
$meta_likes = ghostpool_option( 'search_meta', 'likes' );
$meta_followers = ghostpool_option( 'search_meta', 'followers' );
$meta_cats = ghostpool_option( 'search_meta', 'cats' );
$meta_tags = ghostpool_option( 'search_meta', 'tags' );
$meta_hub_fields = ghostpool_option( 'search_meta', 'hub_fields' );
$meta_site_rating = ghostpool_option( 'search_meta', 'site_rating' );
$meta_user_rating = ghostpool_option( 'search_meta', 'user_rating' );
$read_more_link = ghostpool_option( 'search_read_more_link' );

if ( ! is_array( ghostpool_option( 'search_post_types' ) ) ) {
	$post_types = array( ghostpool_option( 'search_post_types' ) );
} else {
	$post_types = ghostpool_option( 'search_post_types' );
}

if ( ! is_array( ghostpool_option( 'search_templates' ) ) ) {
	$templates = array( ghostpool_option( 'search_templates' ) );
} else {
	$templates = ghostpool_option( 'search_templates' );
}

?>

<?php ghostpool_page_title( '', ghostpool_option( 'search_page_header' ) ); ?>

<?php ghostpool_page_header( 
	$post_id = '', 
	$type = ghostpool_option( 'search_page_header' ),
	$bg = ghostpool_option( 'search_page_header_bg' ),
	$height = ghostpool_option( 'search_page_header_height', 'padding-bottom' )
); ?>

<div id="gp-content-wrapper" class="gp-container">

	<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>
		
	<div id="gp-inner-container">

		<div id="gp-left-column">

			<div id="gp-content">

				<?php if ( ghostpool_option( 'search_page_header' ) == 'gp-fullwidth-page-header' OR ghostpool_option( 'search_page_header' ) == 'gp-full-page-page-header' ) { ?>
					<?php ghostpool_breadcrumbs(); ?>
					<header class="gp-entry-header">		
						<h1 class="gp-entry-title">
							<?php if ( isset( $_GET['s'] ) && ( $_GET['s'] != '' ) ) { ?>
								<?php echo absint( $wp_query->found_posts ); ?> <?php esc_html_e( 'search results for', 'huber' ); ?> "<?php echo esc_attr( $s ); ?>"
							<?php } else { ?>
								<?php esc_html_e( 'Search', 'huber' ); ?>
							<?php } ?>
						</h1>
					</header>
				<?php } ?>

				<?php if ( isset( $_GET['s'] ) && ( $_GET['s'] != '' ) ) { ?>
	
					<div class="gp-blog-wrapper gp-archive-wrapper <?php echo sanitize_html_class( ghostpool_option( 'search_format' ) ); ?>" data-type="search" data-format="<?php echo esc_attr( ghostpool_option( 'search_format' ) ); ?>" data-posttypes="<?php echo esc_attr( implode( ',', $post_types ) ); ?>" data-templates="<?php echo esc_attr( implode( ',', $templates ) ); ?>" data-orderby="<?php echo esc_attr( ghostpool_option( 'search_orderby' ) ); ?>" data-perpage="<?php echo absint( ghostpool_option( 'search_per_page' ) ); ?>" data-offset="<?php echo esc_attr( ghostpool_option( 'search_offset' ) ); ?>" data-imagesizestandard="<?php echo esc_attr( $image_size_standard ); ?>" data-imagesizehub="<?php echo esc_attr( $image_size_hub ); ?>" data-imagesizereview="<?php echo esc_attr( $image_size_review ); ?>" data-imagesizepreview="<?php echo esc_attr( $image_size_preview ); ?>" data-contentdisplay="<?php echo esc_attr( ghostpool_option( 'search_content_display' ) ); ?>" data-excerptlength="<?php echo absint( ghostpool_option( 'search_excerpt_length' ) ); ?>" data-metareleasedate="<?php echo esc_attr( ghostpool_option( 'search_meta', 'release_date' ) ); ?>" data-metaauthor="<?php echo esc_attr( ghostpool_option( 'search_meta', 'author' ) ); ?>" data-metadate="<?php echo esc_attr( ghostpool_option( 'search_meta', 'date' ) ); ?>" data-metacommentcount="<?php echo esc_attr( ghostpool_option( 'search_meta', 'comment_count' ) ); ?>" data-metaviews="<?php echo esc_attr( ghostpool_option( 'search_meta', 'views' ) ); ?>" data-metalikes="<?php echo esc_attr( ghostpool_option( 'search_meta', 'likes' ) ); ?>" data-metafollowers="<?php echo esc_attr( ghostpool_option( 'search_meta', 'followers' ) ); ?>" data-metacats="<?php echo esc_attr( ghostpool_option( 'search_meta', 'cats' ) ); ?>" data-metatags="<?php echo esc_attr( ghostpool_option( 'search_meta', 'tags' ) ); ?>" data-metahubfields="<?php echo esc_attr( ghostpool_option( 'search_meta', 'hub_fields' ) ); ?>" data-metasiterating="<?php echo esc_attr( ghostpool_option( 'search_meta', 'site_rating' ) ); ?>" data-metauserrating="<?php echo esc_attr( ghostpool_option( 'search_meta', 'user_rating' ) ); ?>" data-readmorelink="<?php echo esc_attr( ghostpool_option( 'search_read_more_link' ) ); ?>" data-pagination="<?php echo esc_attr( ghostpool_option( 'search_pagination' ) ); ?>">
						
						<div id="gp-new-search">
							<?php get_search_form(); ?>
							<?php ghostpool_template_filter(
								ghostpool_option( 'search_templates' ),
								ghostpool_option( 'search_filters_templates' ),
								ghostpool_option( 'search_pagination' )
							); ?>
						</div>
						
						<?php ghostpool_filter( 
							ghostpool_option( 'search_filters' ),
							'',
							ghostpool_option( 'search_orderby' ),
							ghostpool_option( 'search_pagination' )
						); ?>
				
						<div class="gp-section-loop <?php echo sanitize_html_class( ghostpool_option( 'ajax' ) ); ?>">

							<?php if ( have_posts() ) : ?>
							
								<?php global $wp_query; echo ghostpool_search_results_total( $wp_query->found_posts ); ?>
							
								<div class="gp-section-loop-inner">							
									<?php if ( $format == 'gp-blog-masonry' ) { ?><div class="gp-gutter-size"></div><?php } ?>							
									<?php while ( have_posts() ) : the_post(); ?>
										<?php if ( function_exists( 'ghostpool_post_loop' ) ) { ghostpool_post_loop( $format, $image_size_standard, $image_size_hub, $image_size_review, $image_size_preview, $content_display, $excerpt_length, $meta_release_date, $meta_author, $meta_date, $meta_comment_count, $meta_views, $meta_likes, $meta_followers, $meta_cats, $meta_tags, $meta_hub_fields, $meta_site_rating, $meta_user_rating, $read_more_link ); } ?>
									<?php endwhile; ?>
								</div>

								<?php echo ghostpool_pagination( $wp_query->max_num_pages, ghostpool_option( 'search_pagination' ) ); ?>

							<?php else : ?>

								<strong class="gp-no-items-found"><?php esc_html_e( 'No items found.', 'huber' ); ?></strong>

							<?php endif; ?>
						
						</div>
		
					</div>
	
				<?php } else { ?>
			
					<p><?php esc_html_e( 'You left the search box empty, please enter a valid term.', 'huber' ); ?></p>
	
				<?php } ?>				

			</div>

			<?php get_sidebar( 'left' ); ?>

		</div>
	
		<?php get_sidebar( 'right' ); ?>
	
	</div>

	<?php do_action( 'ghostpool_end_content_wrapper' ); ?>
			
	<div class="gp-clear"></div>

</div>

<?php get_footer(); ?>