<?php if ( ! function_exists( 'ghostpool_images' ) ) {
	function ghostpool_images() {
		register_widget( 'GhostPool_Images' );
	}
}
add_action( 'widgets_init', 'ghostpool_images' );

if ( ! class_exists( 'GhostPool_Images' ) ) {
	class GhostPool_Images extends WP_Widget {
	
		function __construct() {
			$widget_ops = array( 'classname' => 'gp-images-box-widget', 'description' => esc_html__( 'Display the affiliate links you have set from your posts/pages.', 'huber' ) );
			parent::__construct( 'gp-images-widget', esc_html__( 'GP Images', 'huber' ), $widget_ops );
		}

		function widget( $args, $instance ) {

			extract( $args );

			$title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : esc_html__( 'Images', 'huber' );
			$number = isset( $instance['number'] ) ? esc_attr( $instance['number'] ) : 8;
							
			// Get image IDs
			$image_ids = array_filter( explode( ',', ghostpool_option( 'images_tab_gallery' ) ) );

			if ( $image_ids ) {
			
				echo html_entity_decode( $before_widget );
		
				if ( $title ) { echo html_entity_decode( $before_title . $title . $after_title ); } ?>
			
				<div class="gp-image-items">
	
					<?php
				
					$count = 0; 
		
					foreach ( array_reverse( $image_ids ) as $image_id ) { 
				
						if ( $count++ < $number ) {

							// Get attachment data
							$attachment = get_post( $image_id ); 
		
							$image = wp_get_attachment_image_src( $image_id, 'ghostpool-image-tab' );
		
							?>

							<div class="gp-image-item">

								<a href="<?php echo wp_get_attachment_url( $image_id ); ?>" title="<?php if ( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ) { echo esc_attr( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ); } ?>">
									<img src="<?php echo esc_url( $image[0] ); ?>" width="231" height="231" alt="<?php if ( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ) { echo esc_attr( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ); } ?>" />
								</a>

							</div>
													
						<?php }
				
					} ?>
				
				</div>	

				<?php echo html_entity_decode( $after_widget );
		
			}

		}

		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;				
			$instance['title'] = isset( $new_instance['title'] ) ? sanitize_text_field( $new_instance['title'] ) : esc_html__( 'Images', 'huber' );
			$instance['number'] = isset( $new_instance['number'] ) ? sanitize_text_field( $new_instance['number'] ) : 8;
			return $instance;
		}

		function form( $instance ) {
	
			// Defaults
			$title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : esc_html__( 'Images', 'huber' );
			$number = isset( $instance['number'] ) ? esc_attr( $instance['number'] ) : 8;
		
			?>
						
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'huber' ); ?></label>
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $title ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of Images:', 'huber' ); ?></label>
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" value="<?php echo esc_attr( $number ); ?>" />
			</p>
											
			<?php

		}
	}
} 

?>