<?php $post_preview = get_post( $_GET['id'] ); ?>
	
<article>

	<header class="gp-entry-header">
		<h1 class="gp-entry-title gp-single-title">
			<?php echo get_the_title( $post_preview->ID ); ?>
		</h1>
		
		<?php if ( ghostpool_site_rating( $post_preview->ID ) ) { ?>	
			<div id="gp-user-review-rating">
				<?php esc_html_e( 'User Rating:' , 'huber' ) ?> 
				<span id="gp-user-review-rating-score"><?php echo ghostpool_site_rating( $post_preview->ID ); ?></span>
			</div>
		<?php } ?>

		<?php get_template_part( 'lib/sections/user-review/entry-meta' ); ?>
				
		<?php if ( ghostpool_option( 'user_review_top_post_content' ) ) { ?>
			<div id="gp-top-of-post">
				<?php echo do_shortcode( ghostpool_option( 'user_review_top_post_content' ) ); ?>
			</div>
		<?php } ?>
									
	</header>

	<?php if ( has_post_thumbnail( $post_preview->ID ) && get_post_format( $post_preview->ID ) == '0' ) { ?>

		<div class="gp-post-thumbnail gp-entry-featured">
			<?php echo get_the_post_thumbnail( $post_preview->ID, 'ghostpool-featured-image' ); ?>									
			<?php $attachment_id = get_post( get_post_thumbnail_id( $post_preview->ID ) ); if ( $attachment_id->post_excerpt ) { ?><div class="wp-caption-text"><?php echo esc_attr( $attachment_id->post_excerpt ); ?></div><?php } ?>
		</div>

	<?php } elseif ( get_post_format( $post_preview->ID ) != '0' ) { ?>

		<div class="gp-entry-featured">
			<?php get_template_part( 'lib/sections/post/entry', get_post_format( $post_preview->ID ) ); ?>
		</div>

	<?php } ?>
																
	<div class="gp-entry-content" itemprop="text">
			
		<?php if ( get_post_format( $post_preview->ID ) == '0' OR get_post_format( $post_preview->ID ) == 'audio' OR get_post_format( $post_preview->ID ) == 'gallery' OR get_post_format( $post_preview->ID ) == 'video' ) {
			echo apply_filters( 'the_content', $post_preview->post_content );
		} ?>

		<?php wp_link_pages( array(
			'before' => '<div class="gp-entry-pagination">',
			'after'  => '</div>',
			'next_or_number' => 'ghostpool_next_and_number',
			'nextpagelink' => '',
			'previouspagelink' => '',
		) ); ?>

	</div>					

	<?php if ( ghostpool_option( 'user_review_meta', 'tags' ) == '1' ) { ?>
		<?php the_tags( '<div class="gp-entry-tags">' . esc_html__( 'Tags: ', 'huber' ), ', ', '</div>' ); ?>
	<?php } ?>
		
	<?php if ( ghostpool_option( 'user_review_author_info' ) == 'enabled' && ! empty( get_user_by( 'email', get_post_meta( $post_preview->ID, 'ghostpool_post_submission_email', true ) ) ) ) { ?>
		<?php get_template_part( 'lib/sections/post/author-info' ); ?>
	<?php } ?>
	
	<?php wp_nonce_field( 'ghostpool_post_preview_action', '_wpnonce' ); ?>

</article>