<?php 

// Get category options
$term_data = null;
if ( isset( get_queried_object()->term_id ) ) {
	$term_id = get_queried_object()->term_id;
	$term_data = get_option( "taxonomy_$term_id" );
}

$header = ! isset( $term_data['page_header'] ) || $term_data['page_header'] == 'default' ? ghostpool_option( 'cat_page_header' ) : $term_data['page_header'];
$format = ! isset( $term_data['format'] ) || $term_data['format'] == 'default' ? ghostpool_option( 'cat_format' ) : $term_data['format'];
$image_size_standard = ghostpool_option( 'cat_standard_post_image_size' );
$image_size_hub = ghostpool_option( 'cat_hub_image_size' );
$image_size_review = ghostpool_option( 'cat_review_image_size' );
$image_size_preview = ghostpool_option( 'cat_preview_image_size' );
$content_display = ghostpool_option( 'cat_content_display' );
$excerpt_length = ghostpool_option( 'cat_excerpt_length' );	
$meta_release_date = ghostpool_option( 'cat_meta', 'release_date' );
$meta_author = ghostpool_option( 'cat_meta', 'author' );
$meta_date = ghostpool_option( 'cat_meta', 'date' );
$meta_comment_count = ghostpool_option( 'cat_meta', 'comment_count' );
$meta_views = ghostpool_option( 'cat_meta', 'views' );
$meta_likes = ghostpool_option( 'cat_meta', 'likes' );
$meta_followers = ghostpool_option( 'cat_meta', 'followers' );
$meta_cats = ghostpool_option( 'cat_meta', 'cats' );
$meta_tags = ghostpool_option( 'cat_meta', 'tags' );
$meta_hub_fields = ghostpool_option( 'cat_meta', 'hub_fields' );
$meta_site_rating = ghostpool_option( 'cat_meta', 'site_rating' );
$meta_user_rating = ghostpool_option( 'cat_meta', 'user_rating' );
$read_more_link = ghostpool_option( 'cat_read_more_link' );

?>

<?php if ( have_posts() ) : ?>

		<?php while ( have_posts() ) : the_post();

			// First post image styling
			$bg = get_post_meta( get_the_ID(), 'page_header_bg', true );		
			
			if ( isset( $bg['id'] ) && $bg['id'] > 0 ) {
				$id = $bg['id'];
			} elseif ( has_post_thumbnail( get_the_ID() ) ) {
				$id = get_post_thumbnail_id( get_the_ID() );
			} else {
				$id = '';
			}
			
			if ( $id > 0 ) {
				$bg_image = wp_get_attachment_image_src( $id, apply_filters( 'ghostpool_page_header_image_size', 'ghostpool-page-header-image' ) );
				$bg_image = isset( $bg_image[0] ) ? $bg_image[0] : '';
			} else {
				$bg_image = '';
			}
				
			if ( $bg_image ) {
				$bg_css = 'background-image: url(' . $bg_image . ');';
			} else {
				$bg_css = '';
			}
			
			// Ratings class
			if ( $meta_site_rating == '1' && ghostpool_site_rating() && $meta_user_rating == '1' && get_post_meta( get_the_ID(), 'ghostpool_user_rating', true ) ) { 
				$ratings_class = 'gp-has-both-ratings';
			} else {
				$ratings_class = '';
			}
					
			if ( $wp_query->current_post == '0' ) { ?>	

				<?php echo ghostpool_meta_data( get_the_ID() ); ?>

				<header id="gp-page-header"<?php if ( ghostpool_option( 'theme_layout' ) == 'gp-boxed-layout' ) { ?> class="gp-container"<?php } ?>>
				
					<div id="gp-page-header-inner" style="<?php if ( $header != 'gp-full-page-page-header' ) { echo esc_attr( $bg_css ); } ?>">
				
						<div class="gp-container" style="padding-bottom: <?php echo absint( ghostpool_option( 'cat_page_header_height', 'padding-bottom' ) ); ?>px;">
									
							<a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo get_post_meta( get_the_ID(), 'link_target', true ); ?>"<?php } ?> class="gp-first-post-link"></a>
						
							<div class="gp-first-post-caption<?php if ( $ratings_class ) { echo ' ' . sanitize_html_class( $ratings_class ); ?><?php } ?>">
								<div class="gp-first-post-caption-inner">
									<h3 class="gp-first-post-caption-title"><a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo get_post_meta( get_the_ID(), 'link_target', true ); ?>"<?php } ?>><?php the_title(); ?></a></h3>
									<?php ghostpool_loop_meta(
										$meta_release_date,
										$meta_author,
										$meta_date,
										$meta_comment_count,
										$meta_views,
										$meta_likes,
										$meta_followers,
										$meta_cats,
										$meta_hub_fields
									); ?>	
								</div>
								<?php if ( $meta_site_rating == '1' OR $meta_user_rating == '1' ) { ?>
									<div class="gp-header-ratings">
										<?php if ( $meta_site_rating == '1' ) {
											get_template_part( 'lib/sections/taxonomies/loop-site-rating' );
										}
										if ( $meta_user_rating == '1' ) {
											get_template_part( 'lib/sections/taxonomies/loop-user-rating' );
										} ?>
									</div>
								<?php } ?>	
							</div>
							
						</div>
					</div>
					<?php if ( ghostpool_option( 'theme_layout' ) != 'gp-boxed-layout' ) { ?>
						<div class="gp-blurred-bg" style="<?php if ( $header != 'gp-full-page-page-header' ) { echo esc_attr( $bg_css ); } ?>"></div>
					<?php } ?>	
				</header>

				<div id="gp-content-wrapper" class="gp-container">
				
					<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>

					<div id="gp-inner-container">

						<div id="gp-left-column">

							<div id="gp-content">
							
								<div class="gp-blog-wrapper gp-archive-wrapper <?php echo sanitize_html_class( $format ); ?>" data-type="taxonomy" data-format="<?php echo esc_attr( $format ); ?>" data-orderby="<?php echo esc_attr( ghostpool_option( 'cat_orderby' ) ); ?>" data-perpage="<?php echo absint( ghostpool_option( 'cat_per_page' ) ); ?>" data-offset="<?php echo esc_attr( ghostpool_option( 'cat_offset' ) ); ?>" data-imagesizestandard="<?php echo esc_attr( $image_size_standard ); ?>" data-imagesizehub="<?php echo esc_attr( $image_size_hub ); ?>" data-imagesizereview="<?php echo esc_attr( $image_size_review ); ?>" data-imagesizepreview="<?php echo esc_attr( $image_size_preview ); ?>" data-contentdisplay="<?php echo esc_attr( ghostpool_option( 'cat_content_display' ) ); ?>" data-excerptlength="<?php echo absint( ghostpool_option( 'cat_excerpt_length' ) ); ?>" data-metareleasedate="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'release_date' ) ); ?>" data-metaauthor="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'author' ) ); ?>" data-metadate="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'date' ) ); ?>" data-metacommentcount="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'comment_count' ) ); ?>" data-metaviews="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'views' ) ); ?>" data-metalikes="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'likes' ) ); ?>" data-metafollowers="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'followers' ) ); ?>" data-metacats="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'cats' ) ); ?>" data-metatags="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'tags' ) ); ?>" data-metahubfields="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'hub_fields' ) ); ?>" data-metasiterating="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'site_rating' ) ); ?>" data-metauserrating="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'user_rating' ) ); ?>" data-readmorelink="<?php echo esc_attr( ghostpool_option( 'cat_read_more_link' ) ); ?>" data-pagination="<?php echo esc_attr( ghostpool_option( 'cat_pagination' ) ); ?>">
							
									<?php ghostpool_filter( 
										ghostpool_option( 'cat_filters' ),
										'',
										ghostpool_option( 'cat_orderby' ),
										ghostpool_option( 'cat_pagination' )
									); ?>
										
									<div class="gp-section-loop <?php echo sanitize_html_class( ghostpool_option( 'ajax' ) ); ?>">
									
										<div class="gp-section-loop-inner">
									
			<?php } else { ?>
			
				<?php if ( $format == 'gp-blog-masonry' ) { ?><div class="gp-gutter-size"></div><?php } ?>
				
				<?php if ( function_exists( 'ghostpool_post_loop' ) ) { ghostpool_post_loop( $format, $image_size_standard, $image_size_hub, $image_size_review, $image_size_preview, $content_display, $excerpt_length, $meta_release_date, $meta_author, $meta_date, $meta_comment_count, $meta_views, $meta_likes, $meta_followers, $meta_cats, $meta_tags, $meta_hub_fields, $meta_site_rating, $meta_user_rating, $read_more_link ); } ?>
				
			<?php } ?>
		
		<?php endwhile; ?>

					</div>
					
					<?php echo ghostpool_pagination( $wp_query->max_num_pages, ghostpool_option( 'cat_pagination' ) ); ?>

				</div>

			</div>

		</div>

	<?php else : ?>

		<div id="gp-content-wrapper" class="gp-container">

			<div id="gp-inner-container">

				<div id="gp-left-column">

					<div id="gp-content">
					
						<div class="gp-blog-wrapper gp-archive-wrapper <?php echo sanitize_html_class( $format ); ?>" data-type="taxonomy" data-format="<?php echo esc_attr( $format ); ?>" data-orderby="<?php echo esc_attr( ghostpool_option( 'cat_orderby' ) ); ?>" data-perpage="<?php echo absint( ghostpool_option( 'cat_per_page' ) ); ?>" data-offset="<?php echo esc_attr( ghostpool_option( 'cat_offset' ) ); ?>" data-contentdisplay="<?php echo esc_attr( ghostpool_option( 'cat_content_display' ) ); ?>" data-excerptlength="<?php echo absint( ghostpool_option( 'cat_excerpt_length' ) ); ?>" data-metaauthor="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'author' ) ); ?>" data-metadate="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'date' ) ); ?>" data-metacommentcount="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'comment_count' ) ); ?>" data-metaviews="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'views' ) ); ?>" data-metalikes="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'likes' ) ); ?>" data-metafollowers="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'followers' ) ); ?>" data-metacats="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'cats' ) ); ?>" data-metatags="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'tags' ) ); ?>" data-readmorelink="<?php echo esc_attr( ghostpool_option( 'cat_read_more_link' ) ); ?>" data-pagination="<?php echo esc_attr( ghostpool_option( 'cat_pagination' ) ); ?>">
																
							<strong class="gp-no-items-found"><?php esc_html_e( 'No items found.', 'huber' ); ?></strong>
							
						</div>

					</div>

	<?php endif; ?>

			<?php get_sidebar( 'left' ); ?>

		</div>

		<?php get_sidebar( 'right' ); ?>

	</div>

	<?php do_action( 'ghostpool_end_content_wrapper' ); ?>

	<div class="gp-clear"></div>

</div>