<?php 

global $wp_query;

// Get post or hub association ID
$a_post_id = get_hub_association_id( get_the_ID() );

// Tab Parameters
$reviews_tab_parameter = ghostpool_option( 'reviews_tab_parameter' );
$previews_tab_parameter = ghostpool_option( 'previews_tab_parameter' );
$news_tab_parameter = ghostpool_option( 'news_tab_parameter' );
$images_tab_parameter = ghostpool_option( 'images_tab_parameter' );
$videos_tab_parameter = ghostpool_option( 'videos_tab_parameter' );
$forums_tab_parameter = ghostpool_option( 'forums_tab_parameter' );
	
?>
	
<?php if ( ( ghostpool_option( 'hub_header_associated_content' ) == 'enabled' && $a_post_id != get_the_ID() ) OR get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) ) {
	
	$page_header_height = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header_height' );
			
	ghostpool_hub_header( 
		$post_id = $a_post_id, 
		$type = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' ) == 'default' ? ghostpool_option( 'hub_page_header' ) : redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' ),
		$bg = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header_bg' ),
		$height = $page_header_height && $page_header_height['padding-bottom'] != '' ? $page_header_height['padding-bottom'] : ghostpool_option( 'hub_page_header_height', 'padding-bottom' )
	);

} elseif ( ghostpool_option( 'review_hub_header_content' ) == 'enabled' ) {
	
	$page_header_height = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header_height' );
	
	ghostpool_hub_header( 
		$post_id = get_the_ID(), 
		$type = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ) == 'default' ? ghostpool_option( 'review_page_header' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ),
		$bg = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header_bg' ),
		$height = $page_header_height && $page_header_height['padding-bottom'] != '' ? $page_header_height['padding-bottom'] : ghostpool_option( 'review_page_header_height', 'padding-bottom' )
	);
		
} else {
	
	$page_header_height = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header_height' );
	
	ghostpool_page_header( 
		$post_id = get_the_ID(), 
		$type = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ) == 'default' ? ghostpool_option( 'review_page_header' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ),  
		$bg = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header_bg' ),
		$height = $page_header_height && $page_header_height['padding-bottom'] != '' ? $page_header_height['padding-bottom'] : ghostpool_option( 'review_page_header_height', 'padding-bottom' )
	);
	
} ?>

<?php if ( ( ghostpool_option( 'hub_tab_associated_content' ) == 'enabled' && $a_post_id != get_the_ID() ) OR get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) OR ( isset( $_GET['review_tabs'] ) && $_GET['review_tabs'] == 'enabled' ) ) { get_template_part( 'lib/sections/hub/hub-tabs' ); } ?>

<div id="gp-content-wrapper" class="gp-container">
		
	<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>

	<div id="gp-inner-container">
	
		<div id="gp-left-column">

			<div id="gp-content">
			
				<?php if ( ghostpool_option( 'hub_tab_associated_content' ) == 'enabled' && isset( $wp_query->query[$reviews_tab_parameter] ) ) {		
					
					get_template_part( 'lib/sections/hub/reviews-tab-page' ); 

				} elseif ( ghostpool_option( 'hub_tab_associated_content' ) == 'enabled' && isset( $wp_query->query[$previews_tab_parameter] ) ) {		
					
					get_template_part( 'lib/sections/hub/previews-tab-page' ); 
									
				} elseif ( ghostpool_option( 'hub_tab_associated_content' ) == 'enabled' && isset( $wp_query->query[$news_tab_parameter] ) ) {		
					
					get_template_part( 'lib/sections/hub/news-tab-page' ); 
				
				} elseif ( ghostpool_option( 'hub_tab_associated_content' ) == 'enabled' && isset( $wp_query->query[$images_tab_parameter] ) ) {		
					
					get_template_part( 'lib/sections/hub/images-tab-page' ); 
				
				} elseif ( ghostpool_option( 'hub_tab_associated_content' ) == 'enabled' && isset( $wp_query->query[$videos_tab_parameter] ) ) {		
					
					get_template_part( 'lib/sections/hub/videos-tab-page' ); 
				
				} elseif ( ghostpool_option( 'hub_tab_associated_content' ) == 'enabled' && isset( $wp_query->query[$forums_tab_parameter] ) ) {		
					
					get_template_part( 'lib/sections/hub/forums-tab-page' );

				} else {
					
					get_template_part( 'lib/sections/review/review-content' );
					
				} ?>
				
			</div>

			<?php if ( ! isset( $wp_query->query[$images_tab_parameter] ) ) {
				get_sidebar( 'left' );
			} ?>

		</div>

		<?php if ( ! isset( $wp_query->query[$images_tab_parameter] ) ) {
			get_sidebar( 'right' );
		} ?>	

	</div>

	<?php do_action( 'ghostpool_end_content_wrapper' ); ?>

	<div class="gp-clear"></div>

</div>