<?php

global $post;
 
$good_points = ghostpool_option( 'good_points' ); 
$bad_points = ghostpool_option( 'bad_points' ); 
$site_rating = ghostpool_option( 'site_rating' );

?>

<?php if ( ghostpool_option( 'summary' ) && ( $good_points && $good_points[0] ) OR ( $bad_points && $bad_points[0] ) ) { ?>
	<div id="gp-summary">
		<div id="gp-summary-title"><?php esc_html_e( 'Summary', 'huber' ); ?></div>
		<?php echo esc_attr( ghostpool_option( 'summary' ) ); ?>
	</div>
<?php } ?>

<?php if ( ( $good_points && $good_points[0] ) OR ( $bad_points && $bad_points[0] ) OR ( $site_rating && $site_rating[0] ) ) { ?>

	<div id="gp-review-results">
	
		<?php if ( ( $good_points && $good_points[0] ) OR ( $bad_points && $bad_points[0]  ) ) { ?>
		
			<div id="gp-points-wrapper">

				<?php if ( $good_points && $good_points[0] ) { ?>
					<div id="gp-good-points">
						<div id="gp-good-title"><?php esc_html_e( 'Good', 'huber' ); ?></div>
						<ul>
							<?php foreach( $good_points as $good_point ) { ?>							
								<li><i class="fa fa-plus-circle"></i><?php echo esc_attr( $good_point ); ?></li>
							<?php } ?>
						</ul>
					</div>
				<?php } ?>

				<?php if ( $bad_points && $bad_points[0] ) { ?>
					<div id="gp-bad-points">
						<div id="gp-bad-title"><?php esc_html_e( 'Bad', 'huber' ); ?></div>
						<ul>
							<?php foreach( $bad_points as $bad_point ) { ?>							
								<li><i class="fa fa-minus-circle"></i><?php echo esc_attr( $bad_point ); ?></li>
							<?php } ?>
						</ul>
					</div>
				<?php } ?>
			
			</div>

		<?php } elseif ( ghostpool_option( 'summary' ) ) { ?>
			<div id="gp-points-wrapper">
				<div id="gp-summary-title"><?php esc_html_e( 'Summary', 'huber' ); ?></div>
				<?php echo esc_attr( ghostpool_option( 'summary' ) ); ?>
			</div>
		<?php } ?>
		
		<?php if ( $site_rating && $site_rating[0] ) { 
					
			$ind_rating_criteria = ghostpool_option( 'rating_criteria' );
			if ( $ind_rating_criteria && $ind_rating_criteria[0] ) {
				$rating_criteria = ghostpool_option( 'rating_criteria' );
			} else {
				$rating_criteria = ghostpool_option( 'site_rating_criteria' );
			}	

			?> 
								
			<div id="gp-review-results-rating" class="<?php echo ghostpool_rating_color( ghostpool_site_rating() ); ?>">
				
				<div class="gp-site-rating">
					
					<div class="gp-rating-score">
						<?php echo ghostpool_site_rating(); ?>
					</div>
					<?php echo ghostpool_rating_text( ghostpool_site_rating( '', true ) ); ?>

					<?php if ( isset( $rating_criteria ) && is_array( $rating_criteria ) && count( $rating_criteria ) > 1 && isset( $site_rating[1] ) ) { ?>
						<div id="gp-site-rating-criterias">
							<?php foreach( $rating_criteria as $rating => $criteria ) { ?>
								<?php if ( isset( $site_rating[$rating] ) ) { ?>
									<div class="gp-site-rating-criteria">
										<?php $rating_percentage = floatval( ( ( $site_rating[$rating] / ghostpool_option( 'rating_number' ) ) * 100 ) ); ?>
										<div class="gp-site-rating-slider-wrapper">
											<div class="gp-site-rating-unselected">
												<div class="gp-site-rating-criteria-text"><?php echo esc_attr( $criteria ); ?> - <?php echo floatval( $site_rating[$rating] ); ?></div>
												<div class="gp-site-rating-selection" style="width: <?php echo floatval( $rating_percentage ); ?>%;"></div>
											</div>
										</div>
									</div>	
								<?php } ?>				
							<?php } ?>
						</div>				
					<?php } ?>
					
				</div>
			
				<script type="application/ld+json">
				{
				"@context": "http://schema.org/",
					"@type": "Review",
					"mainEntityOfPage": {
						  "@type": "WebPage",
						  "@id": "<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>"
					},
					"itemReviewed": {
						"@type": "<?php echo apply_filters( 'ghostpool_schema_type', 'Game' ); ?>",
						"name": "<?php the_title_attribute( array( 'post' => get_the_ID() ) ); ?>"
					},
					"author": {
						"@type": "Person",
						"name": "<?php echo the_author_meta( 'display_name', $post->post_author ); ?>"
					},
					"reviewRating": {
						"@type": "Rating",
						"ratingValue": "<?php echo ghostpool_site_rating(); ?>",
						"worstRating" : "1",
						"bestRating": "<?php echo floatval( ghostpool_option( 'rating_number' ) ); ?>"
					}
				}
				</script>
					
			</div>	
		
		<?php } ?>
		
		<div class="gp-standard-bg" style="background-image: url(<?php echo esc_url( ghostpool_option( 'page_header_bg', 'url' ) ); ?>);"></div>
													
	</div>

<?php } ?>