<?php $results_position = ghostpool_option( 'results_position' ) == 'default' ? ghostpool_option( 'preview_results_position' ) : ghostpool_option( 'results_position' ); ?>

<div id="gp-hub-tab-page" class="gp-hub-tab-page gp-selected">

	<article <?php post_class(); ?> itemscope itemtype="http://schema.org/Article">

		<?php echo ghostpool_meta_data( get_the_ID() ); ?>

		<?php ghostpool_breadcrumbs(); ?>

		<header class="gp-entry-header">
		
			<h1 class="gp-entry-title gp-single-title" itemprop="headline">
				<?php if ( ghostpool_option( 'custom_title' ) ) { echo esc_attr( ghostpool_option( 'custom_title' ) ); } else { the_title(); } ?>
			</h1>
		
			<?php if ( ghostpool_option( 'subtitle' ) ) { ?>
				<div class="gp-subtitle"><?php echo esc_attr( ghostpool_option( 'subtitle' ) ); ?></div>
			<?php } ?>
		
			<?php get_template_part( 'lib/sections/preview/entry-meta-preview' ); ?>

			<?php ghostpool_related_hubs( get_the_ID(), ghostpool_option( 'preview_related_hubs' ), ghostpool_option( 'preview_related_hubs_title' ) ); ?>
		
			<?php if ( ghostpool_option( 'preview_top_post_content' ) ) { ?>
				<div id="gp-top-of-post">
					<?php echo do_shortcode( ghostpool_option( 'preview_top_post_content' ) ); ?>
				</div>
			<?php } ?>

		</header>
		
		<?php if ( $results_position == 'top' ) { get_template_part( 'lib/sections/preview/preview-results' ); } ?>
									
		<?php if ( has_post_thumbnail() && ghostpool_option( 'preview_image' ) == 'enabled' && get_post_format() == '0' ) { ?>

			<div class="gp-post-thumbnail gp-entry-featured">
				<?php the_post_thumbnail( 'ghostpool-featured-image' ); ?>									
				<?php $attachment_id = get_post( get_post_thumbnail_id() ); if ( $attachment_id->post_excerpt ) { ?><div class="wp-caption-text"><?php echo esc_attr( $attachment_id->post_excerpt ); ?></div><?php } ?>
			</div>

		<?php } elseif ( get_post_format() != '0' ) { ?>

			<div class="gp-entry-featured">
				<?php get_template_part( 'lib/sections/post/entry', get_post_format() ); ?>
			</div>

		<?php } ?>
																
		<div class="gp-entry-content" itemprop="text">
			
			<?php if ( get_post_format() != 'quote' OR get_post_format() == 'link' ) {
				the_content();
			} ?>

			<?php wp_link_pages( array(
				'before' => '<div class="gp-entry-pagination">',
				'after'  => '</div>',
				'next_or_number' => 'ghostpool_next_and_number',
				'nextpagelink' => '',
				'previouspagelink' => '',
			) ); ?>

		</div>

		<?php if ( ghostpool_option( 'preview_meta', 'tags' ) == '1' ) { ?>
			<?php the_tags( '<div class="gp-entry-tags">' . esc_html__( 'Tags: ', 'huber' ), ', ', '</div>' ); ?>
		<?php } ?>
		
		<?php if ( $results_position == 'bottom' ) { get_template_part( 'lib/sections/preview/preview-results' ); } ?>					
	
		<?php if ( ghostpool_option( 'preview_author_info' ) == 'enabled' ) { ?>
			<?php get_template_part( 'lib/sections/post/author-info' ); ?>
		<?php } ?>
	
		<?php if ( ghostpool_option( 'preview_voting' ) == 'enabled' ) { ?>
			<div class="gp-voting-wrapper">
				 <?php if ( ghostpool_option( 'preview_voting_title' ) ) { ?>
					<h3><?php echo esc_attr( ghostpool_option( 'preview_voting_title' ) ); ?></h3>
				 <?php } ?>
				<?php echo ghostpool_voting(); ?>
			</div>
		<?php } ?>	

		<?php if ( ghostpool_option( 'preview_meta', 'post_nav' ) == '1' ) { ?>
			<?php echo ghostpool_post_navigation(); ?>						
		<?php } ?>
	
		<?php if ( ghostpool_option( 'preview_related_items' ) == 'enabled' ) { ?>
			<?php get_template_part( 'lib/sections/post/related-items' ); ?>
		<?php } ?>

		<?php if ( $GLOBALS['ghostpool_layout'] == 'gp-no-sidebar' OR $GLOBALS['ghostpool_layout'] == 'gp-fullwidth' ) {
		
			$comments_sidebar = get_post_meta( get_the_ID(), 'comments_sidebar', true ) == 'default' ? ghostpool_option( 'preview_comments_sidebar' ) : get_post_meta( get_the_ID(), 'comments_sidebar', true ); ?>
			
			<div id="gp-review-comments"><?php comments_template(); ?></div>
			<aside id="gp-review-sidebar">	
				<?php if ( is_active_sidebar( $comments_sidebar ) ) {
					dynamic_sidebar( $comments_sidebar );
				} ?>
			</aside>
		<?php } else { ?>
			<?php comments_template(); ?>
		<?php } ?>
		
	</article>

</div>