<?php

// Get image IDs
$image_ids = array_filter( explode( ',', get_post_meta( get_the_ID(), 'gallery_slider', true ) ) );	

if ( $image_ids ) { ?>
	
	<div class="gp-post-gallery gp-entry-featured">

		<div class="gp-post-format-gallery-slider gp-slider"> 
						
			 <ul class="slides">
				<?php foreach ( $image_ids as $image_id ) { ?>
					<li>
						<?php 
					
						$image = wp_get_attachment_image_src( $image_id, 'ghostpool-featured-image' ); 
						$attachment_id = get_post( $image_id );
					
						if ( $image[0] ) { ?>
							<img src="<?php echo esc_url( $image[0] ); ?>" alt="<?php if ( get_post_meta( $image_id, '_wp_attachment_image_alt', true) ) { echo esc_attr( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ); } else { the_title_attribute(); } ?>" />
						<?php }
					
						if ( $attachment_id->post_excerpt ) { ?>
							<div class="wp-caption-text"><?php echo esc_attr( $attachment_id->post_excerpt ); ?></div>
						<?php } ?>	
					
					</li>
				<?php } ?>
			</ul>
		
		 </div>

	</div>
		
<?php } ?>