<?php 

// Page options
$display_image = ghostpool_option( 'image' ) == 'default' ? ghostpool_option( 'page_image' ) : ghostpool_option( 'image' );
$results_position = ghostpool_option( 'results_position' ) == 'default' ? ghostpool_option( 'review_results_position' ) : ghostpool_option( 'results_position' );

?>

<?php if ( $results_position == 'top' ) { 
	get_template_part( 'lib/sections/review/review-results' ); 
} ?>

<?php if ( has_post_thumbnail() && $display_image == 'enabled' ) { ?>
	<div class="gp-post-thumbnail gp-entry-featured">
		<?php the_post_thumbnail( 'ghostpool-featured-image' ); ?>
		<?php $attachment_id = get_post( get_post_thumbnail_id() ); if ( $attachment_id->post_excerpt ) { ?><div class="wp-caption-text"><?php echo esc_attr( $attachment_id->post_excerpt ); ?></div><?php } ?>
	</div>
<?php } ?>

<div class="gp-entry-content" itemprop="text">

	<?php the_content(); ?>

	<?php wp_link_pages( array(
		'before' => '<div class="gp-entry-pagination">',
		'after'  => '</div>',
		'next_or_number' => 'ghostpool_next_and_number',
		'nextpagelink' => '',
		'previouspagelink' => '',
	) ); ?>

</div>

<?php if ( ghostpool_option( 'page_voting' ) == 'enabled' ) { ?>
	<div class="gp-voting-wrapper">
		 <?php if ( ghostpool_option( 'page_voting_title' ) ) { ?>
			<h3><?php echo esc_attr( ghostpool_option( 'page_voting_title' ) ); ?></h3>
		 <?php } ?>
		<?php echo ghostpool_voting(); ?>
	</div>
<?php } ?>

<?php if ( $results_position == 'bottom' ) { get_template_part( 'lib/sections/review/review-results' ); } ?>	
			
<?php if ( ghostpool_option( 'page_author_info' ) == 'enabled' ) { ?>
	<?php get_template_part( 'lib/sections/post/author-info' ); ?>
<?php } ?>

<?php comments_template(); ?>