<?php if ( ! is_user_logged_in() ) { ?>

	<div id="login">

		<div id="gp-login-modal">		
		
			<a href="#" id="gp-login-close"></a>
		
			<div class="gp-login-form-wrapper">

				<h3><?php esc_html_e( 'Sign In' ,'huber' ); ?></h3>		

				<form name="loginform" class="gp-login-form" action="<?php echo esc_url( site_url( 'wp-login.php', 'login_post' ) ); ?>" method="post">
	
					<p class="username"><input type="text" name="log" class="user_login" value="<?php if ( ! empty( $user_login ) ) { echo esc_html( stripslashes( $user_login ), 1 ); } ?>" size="20" placeholder="<?php esc_html_e( 'Username Or Email', 'huber' ); ?>" required /></p>
	
					<p class="password"><input type="password" name="pwd" class="user_pass" size="20" placeholder="<?php esc_html_e( 'Password', 'huber' ); ?>" required /></p>

					<p class="rememberme"><input name="rememberme" class="rememberme" type="checkbox" checked="checked" value="forever" /> <?php esc_html_e( 'Remember Me', 'huber' ); ?></p>
					
					<?php if ( function_exists( 'ghostpool_custom_captcha_display' ) ) {
						echo ghostpool_custom_captcha_display();
					} elseif ( function_exists( 'gglcptch_display' ) ) { 
						echo gglcptch_display(); 
					/*} elseif ( has_action( 'google_invre_render_widget_action' ) ) {
						do_action( 'google_invre_render_widget_action' );*/
					} elseif ( has_filter( 'hctpc_verify' ) ) {
						echo apply_filters( 'hctpc_display', '' );
					} elseif ( has_filter( 'cptch_verify' ) ) {
						echo apply_filters( 'cptch_display', '' ); 
					} ?>
								
					<?php if ( has_action( 'wordpress_social_login' ) OR function_exists( 'the_champ_init' ) ) { ?>
						<div class="gp-social-login">
							<div class="gp-login-or-lines">
								<div class="gp-login-or-left-line"></div>
								<div class="gp-login-or-text"><?php esc_html_e( 'or', 'huber' ); ?></div>
								<div class="gp-login-or-right-line"></div>
							</div>	
							<?php if ( has_action( 'wordpress_social_login' ) ) { 
								do_action( 'wordpress_social_login' ); 
							} 
							if ( function_exists( 'the_champ_init' ) ) { 
								echo do_shortcode( '[TheChamp-Login]' ); 
							} ?>
						</div>
					<?php } ?>
				
					<span class="gp-login-results" data-verify="<?php esc_html_e( 'Verifying...', 'huber' ); ?>"></span>
			
					<input type="submit" name="wp-submit" class="wp-submit" value="<?php esc_html_e( 'Sign In', 'huber' ); ?>" />

					<span class="gp-login-links">
						<?php if ( get_option( 'users_can_register' ) ) { ?><a href="<?php if ( function_exists( 'bp_is_active' ) ) { echo esc_url( bp_get_signup_page( false ) ); } else { echo '#register'; } ?>" class="gp-register-link"><?php esc_html_e( 'Register', 'huber' ); ?></a><?php } ?>
						<a href="#" class="gp-lost-password-link"><?php esc_html_e( 'Lost Password', 'huber' ); ?></a>
					</span>
		
					<input type="hidden" name="action" value="ghostpool_login" />
					
					<?php wp_nonce_field( 'ghostpool_login_action', 'ghostpool_login_nonce' ); ?>
			
				</form>
			
			</div>
			
					
			<div class="gp-lost-password-form-wrapper">

				<h3><?php esc_html_e( 'Lost Password', 'huber' ); ?></h3>

				<form name="lostpasswordform" class="gp-lost-password-form" action="#" method="post">
				
					<p id="gp-login-desc"><?php esc_html_e( 'Please enter your username or email address. You will receive a link to create a new password via email.', 'huber' ); ?></p>	
				
					<p><input type="text" name="user_login" class="user_login" value="" size="20" placeholder="<?php esc_html_e( 'Username or Email', 'huber' ); ?>" required /></p>
			
					<span class="gp-login-results" data-verify="<?php esc_html_e( 'Verifying...', 'huber' ); ?>"></span>
		
					<input type="submit" name="wp-submit" class="wp-submit" value="<?php esc_html_e( 'Reset Password', 'huber' ); ?>" />
			
					<span class="gp-login-links">
						<?php if ( get_option( 'users_can_register' ) ) { ?><a href="<?php if ( function_exists( 'bp_is_active' ) ) { echo esc_url( bp_get_signup_page( false ) ); } else { echo '#register'; } ?>" class="gp-register-link"><?php esc_html_e( 'Register', 'huber' ); ?></a><?php } ?>
						<a href="#" class="gp-login-link"><?php esc_html_e( 'Sign In', 'huber' ); ?></a>
					</span>
		
					<input type="hidden" name="action" value="ghostpool_lost_password" />
					
					<?php wp_nonce_field( 'ghostpool_lost_password_action', 'ghostpool_lost_password_nonce' ); ?>
							
				</form>

			</div>
			
						
			<?php if ( get_option( 'users_can_register' ) && ! function_exists( 'bp_is_active' ) ) { ?>
			
				<div class="gp-register-form-wrapper">

					<h3><?php esc_html_e( 'Sign Up' ,'huber' ); ?></h3>		

					<form name="registerform" class="gp-register-form" action="<?php echo esc_url( site_url( 'wp-login.php?action=register', 'login_post' ) ); ?>" method="post">
					
						<p class="user_login"><input type="text" name="user_login" class="user_login" value="<?php if ( ! empty( $user_login ) ) { echo esc_html( stripslashes( $user_login ), 1 ); } ?>" size="20" placeholder="<?php esc_html_e( 'Username', 'huber' ); ?>" required /></p>
		
						<p class="user_email"><input type="email" name="user_email" class="user_email" size="25" placeholder="<?php esc_html_e( 'Email', 'huber' ); ?>" required /></p>

						<p class="user_confirm_pass"><span class="gp-password-icon"></span><input type="password" name="user_confirm_pass" class="user_confirm_pass" size="25" placeholder="<?php esc_attr_e( 'Password', 'huber' ); ?>" required /></p>
						
						<p class="user_pass"><span class="gp-password-icon"></span><input type="password" name="user_pass" class="user_pass" size="25" placeholder="<?php esc_attr_e( 'Confirm Password', 'huber' ); ?>" required /></p>
					
						<?php if ( function_exists( 'ghostpool_custom_captcha_display' ) ) {
							return ghostpool_custom_captcha_display();
						} elseif ( function_exists( 'gglcptch_display' ) ) { 
							echo gglcptch_display(); 
						/*} elseif ( has_action( 'google_invre_render_widget_action' ) ) {
							do_action( 'google_invre_render_widget_action' );*/
						} elseif ( has_filter( 'hctpc_verify' ) ) {
							echo apply_filters( 'hctpc_display', '' );
						} elseif ( has_filter( 'cptch_verify' ) ) {
							echo apply_filters( 'cptch_display', '' ); 
						} ?>
					
						<span class="gp-login-results" data-verify="<?php esc_html_e( 'Verifying...', 'huber' ); ?>"></span>
									
						<input type="submit" name="wp-submit" class="wp-submit" value="<?php esc_html_e( 'Sign Up', 'huber' ); ?>" />

						<?php if ( ghostpool_option( 'registration_gdpr' ) == 'enabled' ) { ?>
							<p class="gp-gdpr"><input name="gdpr" class="gdpr" type="checkbox" value="1" required /> <label><?php echo wp_kses_post( ghostpool_option( 'registration_gdpr_text' ) ); ?></label></p>
						<?php } ?>
				
						<span class="gp-login-links">
							<a href="#" class="gp-login-link"><?php esc_html_e( 'Sign In', 'huber' ); ?></a>
						</span>
					
						<input type="hidden" name="action" value="ghostpool_register" />
					
						<?php wp_nonce_field( 'ghostpool_register_action', 'ghostpool_register_nonce' ); ?>
				
					</form>
				
				</div>
			
			<?php } ?>
								
		</div>
				
	</div>
	
<?php } ?>