<?php $post_edit = get_post( $_GET['post_id'] ); ?>

<?php if ( isset( $_GET['post_editted'] ) && $_GET['post_editted'] == '1' ) { ?>
	<div class="gp-post-submission-success">
		<span class="gp-post-submission-success-icon"></span>
		<h4><?php esc_html_e( 'Thanks for editing your post!', 'huber' ); ?></h4>
		<h5><?php if ( ghostpool_option( 'post_editing_status' ) == 'approved' ) {
			echo esc_html__( 'Your post was succesfully edited. You can view your post', 'huber' ) . ' <span class="gp-view-post-link"><a href="' . get_permalink( $_GET['post_id'] ) . '">' . esc_html__( 'here', 'huber' ) . '</a>.</span>';
		} else {
		 	if ( get_option( 'permalink_structure' ) ) {
				$permalink_structure = '?';
			} else { 
				$permalink_structure = '&';
			}
			esc_html_e( 'Your post is currently being reviewed. ', 'huber' );
			if ( is_user_logged_in() ) {
				echo esc_html__( 'You can check the status of your post', 'huber' ) . ' <span class="gp-view-post-link"><a href="' . get_permalink( ghostpool_option( 'post_submission_page' ) ) . '">' . esc_html__( 'here', 'huber' ) . '</a>.</span>';
			}	
		} ?></h5>
	</div>
<?php } ?>

<?php if ( get_post_meta( $post_edit->ID, 'ghostpool_hub_page_id', true ) ) { ?>
	<div id="post-submission-notice"><?php esc_html_e( 'You are editing a review for', 'huber' ); ?> <?php echo get_the_title( get_post_meta( $post_edit->ID, 'ghostpool_hub_page_id', true ) ); ?>.</div>
<?php } ?>
				
<form id="gp-post-submission-form" name="ghostpool_post_edit_form" method="post" enctype="multipart/form-data">						

	<p class="gp-post-submission-title">
		<input type="text" name="ghostpool_post_title" value="<?php echo esc_attr( stripslashes( $post_edit->post_title ) ); ?>" required>
	</p>	

	<p class="gp-post-submission-image">	
					
		<?php if ( has_post_thumbnail( $post_edit->ID ) ) { ?>
			
			<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post_edit->ID ), apply_filters( 'ghostpool_post_submission_image_size', 'thumbnail' ) ); ?>
			
			<img src="<?php echo esc_url( $image[0] ); ?>" alt="" class="gp-show-image" />
							
			<input type="file" name="ghostpool_post_image" id="gp-post-image" data-image-added="<?php esc_html_e( 'Image edited', 'huber' ); ?>" data-image-not-added="<?php esc_html_e( 'Invalid image format', 'huber' ); ?>" />
			<label for="gp-post-image" class="button"><?php esc_html_e( 'Edit image', 'huber' ); ?></label>
			
		<?php } else { ?>	
		
			<img src="" width="150" alt="" class="gp-add-image" />					
			<input type="file" name="ghostpool_post_image" id="gp-post-image" data-image-added="<?php esc_html_e( 'Image added', 'huber' ); ?>" data-image-not-added="<?php esc_html_e( 'Invalid image format', 'huber' ); ?>" />
			<label for="gp-post-image" class="button"><?php esc_html_e( 'Add image', 'huber' ); ?></label>
			
		<?php } ?>	
		
	</p>

	<?php if ( get_post_meta( $post_edit->ID, 'ghostpool_site_rating', true ) ) { ?>
		<p class="gp-post-submission-rating">
			<input type="text" name="ghostpool_post_user_rating" value="<?php echo floatval( get_post_meta( $post_edit->ID, 'ghostpool_site_rating', true ) ); ?>"  maxlength="3" size="3" placeholder="<?php esc_html_e( 'Enter rating', 'huber' ); ?>" required>		
			<?php if ( get_post_meta( $post_edit->ID, 'ghostpool_site_rating', true ) < 1 OR get_post_meta( $post_edit->ID, 'ghostpool_site_rating', true ) > ghostpool_option( 'rating_number' ) OR ! is_numeric( get_post_meta( $post_edit->ID, 'ghostpool_site_rating', true ) ) ) { ?>
				<span class="gp-post-submission-inline-error"><?php esc_html_e( 'Invalid rating', 'huber' ); ?></span>
			<?php } ?>								                       
		</p>
	<?php } ?>
	
	<?php if ( ghostpool_option( 'post_submission_categories' ) == 'enabled' ) { ?>		
		<p class="gp-post-submission-categories">
			<?php $categories = get_categories( array(
				'orderby' => 'name',
				'order'   => 'asc',							
			) ); ?>
			<select name="ghostpool_post_categories" required>	
				<option value=""><?php esc_html_e( 'Select a category', 'huber' ); ?></option>							
				<?php foreach ( $categories as $category ) { ?>
					<option value="<?php echo esc_attr( $category->term_id ); ?>"<?php if ( $category->term_id == $post_edit->post_category[0] ) { ?> selected<?php } ?>><?php echo esc_html( $category->name ); ?></option>
				<?php } ?>
			</select>
		</p>
	<?php } ?>
		
	<?php if ( ghostpool_option( 'post_submission_formats' ) == 'enabled' ) { ?>
		<p class="gp-post-submission-formats">
			<input type="radio" name="ghostpool_post_formats" value="0" required<?php if ( get_post_format( $post_edit->ID ) == 0 ) { ?> checked<?php } ?>><label><?php esc_html_e( 'Standard', 'huber' ); ?></label>
			<?php $post_formats = get_theme_support( 'post-formats' ); ?>
			<?php foreach ( $post_formats[0] as $post_format ) { ?>
				<input type="radio" name="ghostpool_post_formats" value="<?php echo esc_attr( $post_format ); ?>"<?php if ( $post_format == get_post_format( $post_edit->ID ) ) { ?> checked<?php } ?>><label><?php echo esc_attr( ucfirst( $post_format ) ); ?></label>
			<?php } ?>
		</p>
	<?php } ?>
			
	<p class="gp-post-submission-content">
		<textarea name="ghostpool_post_content" placeholder="<?php esc_html_e( 'Enter text', 'huber' ); ?>" required><?php echo stripslashes( $post_edit->post_content ); ?></textarea>
	</p>

	<p class="gp-post-submission-tags">
		<input type="text" name="ghostpool_post_tags" value="<?php echo esc_attr( implode( $post_edit->tags_input, ', ' ) ); ?>" placeholder="<?php esc_html_e( 'Separate tags with commas', 'huber' ); ?>">
	</p>
	
	<p class="gp-post-submission-submit">
		<input type="submit" value="<?php esc_attr_e( 'Edit Post', 'huber' ); ?>" tabindex="40" id="submit" name="submit" />
	</p>

	<input type="hidden" name="ghostpool_post_id" value="<?php echo absint( $post_edit->ID ); ?>" />
	<input type="hidden" name="ghostpool_action" value="ghostpool_edit_post" />

	<?php wp_nonce_field( 'ghostpool_post_edit_action', '_wpnonce' ); ?>

</form>