<?php if ( ghostpool_option( 'images_tab' ) == 'enabled' ) { ?>

	<div id="gp-images-tab-page" class="gp-hub-tab-page">
	
		<?php if ( ghostpool_option( 'images_tab_page_title' ) ) { ?><h3 class="gp-hub-sub-header"><?php echo esc_attr( ghostpool_option( 'images_tab_page_title' ) ); ?></h3><?php } ?>

		<?php
	
		// Get image IDs
		$image_ids = array_filter( explode( ',', ghostpool_option( 'images_tab_gallery' ) ) );
	
		if ( $image_ids ) { ?>

			<div class="gp-image-tab-items">

				<?php foreach ( array_reverse( $image_ids ) as $image_id ) { 

					// Get attachment data
					$attachment = get_post( $image_id ); 
				
					$image = wp_get_attachment_image_src( $image_id, 'ghostpool-image-tab' );
				
					?>

					<div class="gp-image-item">

						<a href="<?php echo wp_get_attachment_url( $image_id ); ?>" title="<?php if ( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ) { echo esc_attr( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ); } ?>">
							<img data-original="<?php echo esc_url( $image[0] ); ?>" width="231" height="231" alt="<?php if ( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ) { echo esc_attr( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ); } ?>" />
						</a>

					</div>
															
				<?php } ?>

			 </div>

		<?php } else { ?>

			<strong class="gp-no-items-found"><?php esc_html_e( 'No items found.', 'huber' ); ?></strong>

		<?php } ?>
	
	</div>	
	
<?php } ?>	