<?php 

global $post, $wp_query;

// Tab Parameters
$reviews_tab_parameter = ghostpool_option( 'reviews_tab_parameter' );
$previews_tab_parameter = ghostpool_option( 'previews_tab_parameter' );
$news_tab_parameter = ghostpool_option( 'news_tab_parameter' );
$images_tab_parameter = ghostpool_option( 'images_tab_parameter' );
$videos_tab_parameter = ghostpool_option( 'videos_tab_parameter' );
$forums_tab_parameter = ghostpool_option( 'forums_tab_parameter' );

$page_header_height = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header_height' );

ghostpool_hub_header( 
	$post_id = get_the_ID(), 
	$type = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ) == 'default' ? ghostpool_option( 'hub_page_header' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ),
	$bg = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header_bg' ),
	$height = $page_header_height && $page_header_height['padding-bottom'] != '' ? $page_header_height['padding-bottom'] : ghostpool_option( 'hub_page_header_height', 'padding-bottom' )
);
	
?>
	
<?php if ( ghostpool_option( 'hub_tabs' ) == 'enabled' ) { get_template_part( 'lib/sections/hub/hub-tabs' ); } ?>
	
<div id="gp-content-wrapper" class="gp-container">

	<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>
	
	<div id="gp-inner-container">
	
		<div id="gp-left-column">

			<div id="gp-content">

				<?php if ( ghostpool_option( 'reviews_tab' ) == 'enabled' && isset( $wp_query->query[$reviews_tab_parameter] ) ) {		
					
					get_template_part( 'lib/sections/hub/reviews-tab-page' ); 

				} elseif ( ghostpool_option( 'previews_tab' ) == 'enabled' && isset( $wp_query->query[$previews_tab_parameter] ) ) {		
					
					get_template_part( 'lib/sections/hub/previews-tab-page' ); 
									
				} elseif ( ghostpool_option( 'news_tab' ) == 'enabled' && isset( $wp_query->query[$news_tab_parameter] ) ) {		
					
					get_template_part( 'lib/sections/hub/news-tab-page' ); 
				
				} elseif ( ghostpool_option( 'images_tab' ) == 'enabled' && isset( $wp_query->query[$images_tab_parameter] ) ) {		
					
					get_template_part( 'lib/sections/hub/images-tab-page' ); 
				
				} elseif ( ghostpool_option( 'videos_tab' ) == 'enabled' && isset( $wp_query->query[$videos_tab_parameter] ) ) {		
					
					get_template_part( 'lib/sections/hub/videos-tab-page' ); 
				
				} elseif ( ghostpool_option( 'forums_tab' ) == 'enabled' && isset( $wp_query->query[$forums_tab_parameter] ) ) {		
					
					get_template_part( 'lib/sections/hub/forums-tab-page' );
					
				} elseif ( ghostpool_option( 'hub_tabs' ) == 'enabled' && isset( $wp_query->query['page'] ) ) {
				
					get_template_part( 'lib/sections/hub/hub-tab-page' );
				
				} else {
						
					get_template_part( 'lib/sections/hub/custom-tab-page' );
	
				} ?>

			</div>
			
			<?php get_sidebar( 'left' ); ?>	

		</div>

		<?php get_sidebar( 'right' );  ?>	

	</div>
	
	<?php do_action( 'ghostpool_end_content_wrapper' ); ?>
	
	<div class="gp-clear"></div>

	<?php if ( ghostpool_site_rating() ) { ?>
		<script type="application/ld+json">
		{
		"@context": "http://schema.org/",
			"@type": "Review",
			"mainEntityOfPage": {
				  "@type": "WebPage",
				  "@id": "<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>"
			},
			"itemReviewed": {
				"@type": "<?php echo apply_filters( 'ghostpool_schema_type', 'Game' ); ?>",
				"name": "<?php the_title_attribute( array( 'post' => get_the_ID() ) ); ?>"
			},
			"author": {
				"@type": "Person",
				"name": "<?php echo the_author_meta( 'display_name', $post->post_author ); ?>"
			},
			"reviewRating": {
				"@type": "Rating",
				"ratingValue": "<?php echo ghostpool_site_rating(); ?>",
				"worstRating" : "1",
				"bestRating": "<?php echo floatval( ghostpool_option( 'rating_number' ) ); ?>"
			}
		}
		</script>
	<?php } elseif ( get_post_meta( get_the_ID(), 'ghostpool_user_rating', true ) ) { ?>
		<script type="application/ld+json">
		{
		"@context": "http://schema.org/",
		"@type": "Product",
			"mainEntityOfPage": {
				  "@type": "WebPage",
				  "@id": "<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>"
			},	
			"name": "<?php the_title_attribute( array( 'post' => get_the_ID() ) ); ?>",
			"image": "<?php echo esc_url( wp_get_attachment_url( get_post_thumbnail_id() ) ); ?>",
			"description": "<?php echo strip_tags( get_post_meta( get_the_ID(), 'synopsis', true ) ); ?>",
			"aggregateRating": {
				"@type": "AggregateRating",
				"ratingValue": "<?php echo floatval( get_post_meta( get_the_ID(), 'ghostpool_user_rating', true ) ); ?>",
				"ratingCount": "<?php echo floatval( get_post_meta( get_the_ID(), 'ghostpool_user_votes', true ) ); ?>",
				"bestRating": "<?php echo floatval( ghostpool_option( 'rating_number' ) ); ?>",
				"worstRating": "1"
			}
		}
		</script>	
	<?php } ?>	
		
</div>