<?php 

global $wp_query;

// Get post or hub association ID
$a_post_id = get_hub_association_id( get_the_ID() );

// Get current page ID
$current_page_id = get_the_ID();

// Tab Parameters
$reviews_tab_parameter = ghostpool_option( 'reviews_tab_parameter' );
$previews_tab_parameter = ghostpool_option( 'previews_tab_parameter' );
$news_tab_parameter = ghostpool_option( 'news_tab_parameter' );
$images_tab_parameter = ghostpool_option( 'images_tab_parameter' );
$videos_tab_parameter = ghostpool_option( 'videos_tab_parameter' );
$forums_tab_parameter = ghostpool_option( 'forums_tab_parameter' );

// Permalink structure for tab URls
if ( ! get_option( 'permalink_structure' ) ) {
	$permalink_structure = '&';
	$trailing_slash = '';
} else {
	$permalink_structure = '';
	$trailing_slash = '/';
}

$show_news_tab = true;
$show_reviews_tab = true;
$show_user_reviews_tab = true;
$show_previews_tab = true;
$show_videos_tab = true;

// Check if hub has any associated images
if ( ghostpool_option( 'images_tab' ) == 'enabled' ) {
	$image_ids = array_filter( explode( ',', get_post_meta( $a_post_id, 'images_tab_gallery', true ) ) );
}

if ( 'enabled' === ghostpool_option( 'hub_tab_count' ) ) {

	// Check if hub has any associated news	
	if ( ghostpool_option( 'news_tab' ) == 'enabled' ) {
		$args = array(
			'post_status' => 'publish',
			'post_type' => 'post',
			'tax_query' => array(
				'relation' => 'OR',
				array(
					'taxonomy' => 'post_format',
					'field' => 'slug',
					'terms' => array( 'post-format-video' ),
					'operator' => 'NOT IN',
				)			
			),		
			'orderby'        => ghostpool_orderby( ghostpool_option( 'news_tab_orderby' ), 'orderby' ),
			'order'          => ghostpool_orderby( ghostpool_option( 'news_tab_orderby' ), 'order' ),
			'meta_key'       => ghostpool_orderby( ghostpool_option( 'news_tab_orderby' ), 'meta_key' ),
			'meta_query' 	 => array( 
				'relation' => 'AND', 
				array(
					'relation' => 'OR', 
					array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', $a_post_id ), 'compare' => 'LIKE' ),
					array( 'key' => 'hub_association_ids', 'value' => $a_post_id, 'compare' => '=' ),
				),
				array( 'key' => 'template', 'value' => 'gp-standard-post', 'compare' => '=' ),		
			),
			'posts_per_page'      => 1,
			'paged'			      => 1,
			'fields'              => 'ids',
			'no_found_rows'       => true,
			'ignore_sticky_posts' => 1,
		);		
		$args = apply_filters( 'ghostpool_news_query', $args, $a_post_id );
		$news_query = new WP_Query( $args );	
		if ( ! $news_query->have_posts() ) {
			$show_news_tab = false;
		}
		
	}

	// Check if hub has any associated reviews	
	if ( ghostpool_option( 'reviews_tab' ) == 'enabled' ) {
		$args = array(
			'post_status'    => 'publish',
			'post_type'      => array( 'post', 'page' ),		
			'orderby'        => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'orderby' ),
			'order'          => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'order' ),
			'meta_key'       => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'meta_key' ),
			'meta_query' 	 => array( 
				'relation' => 'AND', 
				array(
					'relation' => 'OR', 
					array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', $a_post_id ), 'compare' => 'LIKE' ),
					array( 'key' => 'hub_association_ids', 'value' => $a_post_id, 'compare' => '=' ),
				),	
				array( 'key' => 'template', 'value' => 'gp-review-post', 'compare' => '=' ),
			),
			'posts_per_page'      => 1,
			'paged'			      => 1,
			'fields'              => 'ids',
			'no_found_rows'       => true,
			'ignore_sticky_posts' => 1,
		);
		$args = apply_filters( 'ghostpool_reviews_query', $args, $a_post_id );
		$reviews_query = new WP_Query( $args );
		if ( ! $reviews_query->have_posts() ) {
			$show_reviews_tab = false;
		}
	}

	// Check if hub has any associated user reviews
	if ( ghostpool_option( 'reviews_tab' ) == 'enabled' ) {	
		$args = array(
			'post_status' => 'publish',
			'post_type' => 'post',		
			'orderby'        => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'orderby' ),
			'order'          => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'order' ),
			'meta_key'       => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'meta_key' ),
			'meta_query' 	 => array( 
				'relation' => 'AND', 
				array( 'key' => 'ghostpool_hub_page_id', 'value' => $a_post_id, 'compare' => '=' ),
			),
			'posts_per_page'      => 1,
			'paged'			      => 1,
			'fields'              => 'ids',
			'no_found_rows'       => true,
			'ignore_sticky_posts' => 1,
		);
		$args = apply_filters( 'ghostpool_user_reviews_query', $args, $a_post_id );
		$user_reviews_query = new WP_Query( $args );		
		if ( ! $user_reviews_query->have_posts() ) {
			$show_user_reviews_tab = false;
		}
	}

	// Check if hub has any associated previews
	if ( ghostpool_option( 'previews_tab' ) == 'enabled' ) {
		$args = array(
			'post_status'    => 'publish',
			'post_type'      => array( 'post', 'page' ),		
			'orderby'        => ghostpool_orderby( ghostpool_option( 'previews_tab_orderby' ), 'orderby' ),
			'order'          => ghostpool_orderby( ghostpool_option( 'previews_tab_orderby' ), 'order' ),
			'meta_key'       => ghostpool_orderby( ghostpool_option( 'previews_tab_orderby' ), 'meta_key' ),
			'meta_query' 	 => array( 
				'relation' => 'AND', 
				array(
					'relation' => 'OR', 
					array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', $a_post_id ), 'compare' => 'LIKE' ),
					array( 'key' => 'hub_association_ids', 'value' => $a_post_id, 'compare' => '=' ),
				),	
				array( 'key' => 'template', 'value' => 'gp-preview-post', 'compare' => '=' ),
			),
			'posts_per_page'      => 1,
			'paged'			      => 1,
			'fields'              => 'ids',
			'no_found_rows'       => true,
			'ignore_sticky_posts' => 1,
		);
		$args = apply_filters( 'ghostpool_previews_query', $args, $a_post_id );
		$previews_query = new WP_Query( $args );
		if ( ! $previews_query->have_posts() ) {
			$show_previews_tab = false;
		}
	}

	// Check if hub has any associated videos
	if ( ghostpool_option( 'videos_tab' ) == 'enabled' ) {
		$args = array(
			'post_status' => 'publish',
			'post_type' => 'post',
			'tax_query' => array(
				'relation' => 'OR',
				array(
					'taxonomy' => 'post_format',
					'field' => 'slug',
					'terms' => array( 'post-format-video' ),
				)			
			),		
			'orderby'        => ghostpool_orderby( ghostpool_option( 'videos_tab_orderby' ), 'orderby' ),
			'order'          => ghostpool_orderby( ghostpool_option( 'videos_tab_orderby' ), 'order' ),
			'meta_key'       => ghostpool_orderby( ghostpool_option( 'videos_tab_orderby' ), 'meta_key' ),
			'meta_query' 	 => array( 
				'relation' => 'OR', 
				array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', $a_post_id ), 'compare' => 'LIKE' ),
				array( 'key' => 'hub_association_ids', 'value' => $a_post_id, 'compare' => '=' ),
			),
			'posts_per_page'      => 1,
			'paged'			      => 1,
			'fields'              => 'ids',
			'no_found_rows'       => true,
			'ignore_sticky_posts' => 1,
		);
		$args = apply_filters( 'ghostpool_videos_query', $args, $a_post_id );
		$videos_query = new WP_Query( $args );
		if ( ! $videos_query->have_posts() ) {
			$show_videos_tab = false;
		}
	}

}
		
?>

<div id="gp-hub-tabs">

	<div class="gp-container">
	
		<div id="gp-hub-tabs-mobile-nav-button"><?php esc_html_e( 'More Info', 'huber' ); ?></div>

		<ul>

			<?php 
			
			// Hub tab
			$hub_tab = '';
			if ( ghostpool_option( 'hub_tab' ) == 'enabled' ) {
				if ( ghostpool_option( 'hub_tab_title' ) ) { 
					$title = esc_attr( ghostpool_option( 'hub_tab_title' ) ); 
				} else { 
					$title = get_the_title( $a_post_id ); 
				}
				if ( isset( $wp_query->query['page'] ) && $a_post_id === get_the_ID() ) {
					$selected = ' class="gp-selected"';
				} else {
					$selected = '';
				}	
				$hub_tab = '<li><a href="' . get_permalink( $a_post_id ) . '" id="gp-hub-tab"' . $selected . '>' . $title . '</a></li>';
			}
			
			// Reviews tabs
			$reviews_tab = '';
			if ( ghostpool_option( 'reviews_tab' ) == 'enabled' && ( true === $show_reviews_tab OR true === $show_user_reviews_tab ) ) {
				if ( 'enabled' === ghostpool_option( 'hub_tab_count' ) && $reviews_query->found_posts == 1 && $user_reviews_query->found_posts == 0 ) {
					while ( $reviews_query->have_posts() ) : $reviews_query->the_post();
						$selected = ( get_the_ID() === $current_page_id ) ? ' class="gp-selected"' : '';
						$reviews_tab = '<li><a href="' . get_permalink( get_the_ID() ) . '" id="gp-reviews-tab"' . $selected . '>' . esc_attr( ghostpool_option( 'reviews_tab_title' ) ) . '</a></li>';
					endwhile;
				} elseif ( 'enabled' === ghostpool_option( 'hub_tab_count' ) && $reviews_query->found_posts == 0 && $user_reviews_query->found_posts == 1 ) {
					while ( $user_reviews_query->have_posts() ) : $user_reviews_query->the_post();
						$selected = ( get_the_ID() === $current_page_id ) ? ' class="gp-selected"' : '';
						$reviews_tab = '<li><a href="' . get_permalink( get_the_ID() ) . '" id="gp-reviews-tab"' . $selected . '>' . esc_attr( ghostpool_option( 'reviews_tab_title' ) ) . '</a></li>';
					endwhile;					
				} else {
					$selected = isset( $wp_query->query[$reviews_tab_parameter] ) ? ' class="gp-selected"' : '';
					$reviews_tab = '<li><a href="' . get_permalink( $a_post_id ) . $permalink_structure . $reviews_tab_parameter . $trailing_slash . '" id="gp-reviews-tab"' . $selected .'>' . esc_attr( ghostpool_option( 'reviews_tab_title' ) ) . '</a></li>';
				}
			} wp_reset_postdata();

			// Previews tabs
			$previews_tab = '';
			if ( ghostpool_option( 'previews_tab' ) == 'enabled' && true === $show_previews_tab ) {
				if ( 'enabled' === ghostpool_option( 'hub_tab_count' ) && $previews_query->found_posts == 1 ) {
					while ( $previews_query->have_posts() ) : $previews_query->the_post();
						$selected = ( get_the_ID() === $current_page_id ) ? ' class="gp-selected"' : '';
						$previews_tab = '<li><a href="' . get_permalink( get_the_ID() ) . '" id="gp-previews-tab"' . $selected . '>' . esc_attr( ghostpool_option( 'previews_tab_title' ) ) . '</a></li>';
					endwhile;
				} else {
					$selected = isset( $wp_query->query[$previews_tab_parameter] ) ? ' class="gp-selected"' : '';
					$previews_tab = '<li><a href="' . get_permalink( $a_post_id ) . $permalink_structure . $previews_tab_parameter . $trailing_slash . '" id="gp-previews-tab"' . $selected . '>' . esc_attr( ghostpool_option( 'previews_tab_title' ) ) . '</a></li>';
				}
			} wp_reset_postdata();
						
			// News tab
			$news_tab = '';
			if ( ghostpool_option( 'news_tab' ) == 'enabled' && true === $show_news_tab ) {
				$selected = isset( $wp_query->query[$news_tab_parameter] ) ? ' class="gp-selected"' : '';
				$news_tab = '<li><a href="' . get_permalink( $a_post_id ) . $permalink_structure . $news_tab_parameter . $trailing_slash . '" id="gp-news-tab"' . $selected . '>' . esc_attr( ghostpool_option( 'news_tab_title' ) ). '</a></li>';
			}

			// Images tab
			$images_tab = '';
			if ( ghostpool_option( 'images_tab' ) == 'enabled' && $image_ids ) {
				$selected = isset( $wp_query->query[$images_tab_parameter] ) ? ' class="gp-selected"' : '';
				$images_tab = '<li><a href="' . get_permalink( $a_post_id ) . $permalink_structure . $images_tab_parameter . $trailing_slash . '" id="gp-images-tab"' . $selected . '>' . esc_attr( ghostpool_option( 'images_tab_title' ) ). '</a></li>';
			}

			// Videos tab
			$videos_tab = '';
			if ( ghostpool_option( 'videos_tab' ) == 'enabled' && true === $show_videos_tab ) {
				$selected = isset( $wp_query->query[$videos_tab_parameter] ) ? ' class="gp-selected"' : '';
				$videos_tab = '<li><a href="' . get_permalink( $a_post_id ) . $permalink_structure . $videos_tab_parameter . $trailing_slash . '" id="gp-videos-tab"' . $selected . '>' . esc_attr( ghostpool_option( 'videos_tab_title' ) ). '</a></li>';	
			}

			// Forums tab
			$forums_tab = '';
			if ( ghostpool_option( 'forums_tab' ) == 'enabled' && get_post_meta( $a_post_id, 'forum_tab_id', true ) ) {
				$selected = isset( $wp_query->query[$forums_tab_parameter] ) ? ' class="gp-selected"' : '';
				$forums_tab = '<li><a href="' . get_permalink( $a_post_id ) . $permalink_structure . $forums_tab_parameter . $trailing_slash . '" id="gp-forums-tab"' . $selected . '>' . esc_attr( ghostpool_option( 'forums_tab_title' ) ). '</a></li>';
			}
			
			// Post submission tab
			$post_submission_tab = '';
			if ( ghostpool_option( 'post_submission_tab' ) == 'enabled' ) { 
				if ( get_option( 'permalink_structure' ) ) {
					$post_submission_url = get_permalink( ghostpool_option( 'post_submission_page' ) ) . '?post_submission=1&hub_id=' . absint( $a_post_id ) . '&_wpnonce=' . wp_create_nonce( 'ghostpool_post_submission_action' );
				} else { 
					$post_submission_url = get_permalink( ghostpool_option( 'post_submission_page' ) ) . '&post_submission=1&hub_id=' . absint( $a_post_id ) . '&_wpnonce=' . wp_create_nonce( 'ghostpool_post_submission_action' );
				}
				$selected = ( isset( $_GET['post_submission'] ) && $_GET['post_submission'] == '1' ) ? ' class="gp-selected"' : '';
				$post_submission_tab = '<li><a href="' . esc_url( $post_submission_url ) . '" id="gp-post-submission-tab"' . $selected . '>' . esc_attr( ghostpool_option( 'post_submission_tab_title' ) ) . '</a></li>';
			}
			
			// Display custom tabs (and child page tabs from Gauge and The Review themes)
			$args = array(
				'post_status'    => 'publish',
				'post_type'      => array( 'post', 'page' ),
				'orderby'        => 'menu_order date', 
				'order'        => 'asc', 
				'meta_query' => array(
					'relation' => 'OR', 
					array( 'key' => 'custom_hub_tab_ids', 'value' => '"' . absint( $a_post_id ) . '"', 'compare' => 'LIKE' ),
					array( 'key' => 'custom_hub_tab_ids', 'value' => absint( $a_post_id ), 'compare' => '=' ),
				),	
				'posts_per_page' => -1,
				'no_found_rows'	 => true,
				'ignore_sticky_posts' => 1,
			);
			$local_tabs_query = new WP_Query( $args );
			$has_associated_tabs = '';
			if ( $local_tabs_query->have_posts() ) {
				$has_associated_tabs = true;
			}	
			
			// Hub tab order		
			if ( $tabs = ghostpool_option( 'hub_tab_order' ) ) {

				$tabs = str_replace( ' ', '', $tabs );
				preg_match_all( "~%(.*?)%~", $tabs, $all_tabs );
				$all_tabs = $all_tabs[1];
				//print_R($all_tabs);
				$output = '';
				foreach( $all_tabs as $tab ) {
					if ( 'HUB' === $tab ) {
						$output .= $hub_tab;	
					} elseif ( 'REVIEWS' === $tab ) {
						$output .= $reviews_tab;
					} elseif ( 'PREVIEWS' === $tab ) {
						$output .= $previews_tab;	
					} elseif ( 'NEWS' === $tab ) {
						$output .= $news_tab;
					} elseif ( 'IMAGES' === $tab ) {
						$output .= $images_tab;
					} elseif ( 'VIDEOS' === $tab ) {
						$output .= $videos_tab;
					} elseif ( 'FORUMS' === $tab ) {
						$output .= $forums_tab;
					} elseif ( 'POST_SUBMISSION' === $tab ) {
						$output .= $post_submission_tab;
					} elseif ( '' === $has_associated_tabs && ( 1 === preg_match( "/LOCAL_TAB_/", $tab ) ) ) {
					
						// Get post/page ID
						$tab_id = substr( $tab, strrpos( $tab, '_' ) + 1 ) . "\n";
						$tab_id = (int) $tab_id;
															
						// Display custom tabs (and child page tabs from Gauge and The Review themes)
						$args = array(
							'post_status'    => 'publish',
							'post_type'      => array( 'post', 'page' ),
							'post__in'		 => array( $tab_id ), 
							'orderby'        => 'menu_order date', 
							'order'        => 'asc', 
							'meta_query' => array(
								'relation' => 'OR', 
								array( 'key' => 'custom_hub_tab_ids', 'value' => '"' . absint( $a_post_id ) . '"', 'compare' => 'LIKE' ),
								array( 'key' => 'custom_hub_tab_ids', 'value' => absint( $a_post_id ), 'compare' => '=' ),
							),	
							'posts_per_page' => 1,
							'no_found_rows'	 => true,
							'ignore_sticky_posts' => 1,
						);
						$gp_query = new WP_Query( $args );
						if ( $gp_query->have_posts() ) : while ( $gp_query->have_posts() ) : $gp_query->the_post();
							if ( 'link' === get_post_format() ) {
								$url = get_post_meta( get_the_ID(), 'link', true );
								$target = ' target="' . get_post_meta( get_the_ID(), 'link_target', true );
							} elseif ( 'link-template.php' === get_post_meta( get_the_ID(), '_wp_page_template', true ) ) {
								$url = get_the_permalink( get_the_ID() );
								$target = ' target="' . get_post_meta( get_the_ID(), 'link_template_link_target', true ) . '"';
							} else {
								$url = get_the_permalink( get_the_ID() );
								$target = '';
							}
							if ( get_post_meta( get_the_ID(), 'tab_title', true ) ) {
								$title = esc_attr( get_post_meta( get_the_ID(), 'tab_title', true ) ); 
							} else { 
								$title = get_the_title( get_the_ID() ); 
							}
							$selected = ( get_the_ID() === $current_page_id ) ? ' class="gp-selected"' : '';
							$output .= '<li><a href="' . esc_url( $url ) . '"' . $target . $selected . '>' . esc_attr( $title ) . '</a></li>';
						endwhile; endif; wp_reset_postdata();
				
					} elseif ( 1 === preg_match( "/GLOBAL_TAB_/", $tab ) ) {
	
						if ( $custom_tabs = ghostpool_option( 'global_custom_tabs' ) ) {
	
							foreach( $custom_tabs as $custom_tab ) {

								preg_match_all( "/(.*):(.*)/", $custom_tab, $matches );
								$endpoint = isset( $matches[1][0] ) ? $matches[1][0] : $custom_tab;
								$title = isset( $matches[2][0] ) ? $matches[2][0] : '';
								
								if ( 'GLOBAL_TAB_' . $endpoint === $tab ) {
									$id = 'gp-' . $endpoint;
									if ( ! $title ) {
										$title = str_replace( '-', ' ', $endpoint );
										$title = ucwords( $endpoint );
									}	
									$selected = isset( $wp_query->query[$endpoint] ) ? ' class="gp-selected"' : '';
									$output .= '<li><a href="' . get_permalink( $a_post_id ) . $permalink_structure . $endpoint . $trailing_slash . '" id="' . esc_attr( $id ) . '"' . $selected . '>' . esc_attr( $title ). '</a></li>';
								}	
							}
					
						}
						
					}	
						
				}
				
				if ( true === $has_associated_tabs ) {
					if ( $local_tabs_query->have_posts() ) : while ( $local_tabs_query->have_posts() ) : $local_tabs_query->the_post();
						if ( 'link' === get_post_format() ) {
							$url = get_post_meta( get_the_ID(), 'link', true );
							$target = ' target="' . get_post_meta( get_the_ID(), 'link_target', true );
						} elseif ( 'link-template.php' === get_post_meta( get_the_ID(), '_wp_page_template', true ) ) {
							$url = get_the_permalink( get_the_ID() );
							$target = ' target="' . get_post_meta( get_the_ID(), 'link_template_link_target', true ) . '"';
						} else {
							$url = get_the_permalink( get_the_ID() );
							$target = '';
						}
						if ( get_post_meta( get_the_ID(), 'tab_title', true ) ) {
							$title = esc_attr( get_post_meta( get_the_ID(), 'tab_title', true ) ); 
						} else { 
							$title = get_the_title( get_the_ID() ); 
						}
						$selected = ( get_the_ID() === $current_page_id ) ? ' class="gp-selected"' : '';					
						$output .= '<li><a href="' . esc_url( $url ) . '"' . $target . $selected . '>' . esc_attr( $title ) . '</a></li>';
					endwhile; endif; wp_reset_postdata();	
				}
				
				echo apply_filters( 'ghostpool_hub_tabs', $output ); 
			
			} 

			?>
	
		</ul>
	
	</div>

</div>