<?php 

// Get post or hub association ID
$a_post_id = get_hub_association_id( get_the_ID() );

// Page options
$header = ghostpool_option( 'page_header' ) == 'default' ? ghostpool_option( 'associated_posts_page_header' ) : ghostpool_option( 'page_header' );

?>

<?php if ( ( ghostpool_option( 'hub_header_associated_content' ) == 'enabled' && $a_post_id != get_the_ID() ) OR get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) ) {

	$page_header_height = redux_post_meta( 'ghostpool_huber', $a_post_id, 'associated_posts_page_header_height' );

	ghostpool_hub_header( 
		$post_id = $a_post_id, 
		$type = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' ) == 'default' ? ghostpool_option( 'hub_page_header' ) : redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' ),
		$bg = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header_bg' ),
		$height = $page_header_height && $page_header_height['padding-bottom'] != '' ? $page_header_height['padding-bottom'] : ghostpool_option( 'hub_page_header_height', 'padding-bottom' )
	);

} else {

	$page_header_height = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header_height' );

	ghostpool_page_header( 
		$post_id = get_the_ID(), 
		$type = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ) == 'default' ? ghostpool_option( 'associated_posts_page_header' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ),  
		$bg = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header_bg' ),
		$height = $page_header_height && $page_header_height['padding-bottom'] != '' ? $page_header_height['padding-bottom'] : ghostpool_option( 'associated_posts_page_header_height', 'padding-bottom' )
	);

} ?>

<?php if ( ( ghostpool_option( 'hub_tab_associated_content' ) == 'enabled' && $a_post_id != get_the_ID() ) OR get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) ) { get_template_part( 'lib/sections/hub/hub-tabs' ); } ?>

<div id="gp-content-wrapper" class="gp-container">
	
	<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>
	
	<div id="gp-inner-container">

		<div id="gp-left-column">

			<div id="gp-content">
			
				<?php get_template_part( 'lib/sections/associated-post/post-content' ); ?>
				
			</div>

			<?php get_sidebar( 'left' ); ?>

		</div>

		<?php get_sidebar( 'right' ); ?>

	</div>

	<?php do_action( 'ghostpool_end_content_wrapper' ); ?>
	
	<div class="gp-clear"></div>

</div>