jQuery( document ).ready( function( $ ) {

	'use strict';
	
	/*--------------------------------------------------------------
	Resize header upon scrolling
	--------------------------------------------------------------*/

	function gpResizeHeader() {
	
		if ( ! $( 'body' ).hasClass( 'gp-relative-header' ) ) {
		
			var mainHeaderHeight = $( '#gp-main-header' ).innerHeight();
			if ( $( '#gp-top-header' ).length > 0 ) {
				var topHeaderHeight = $( '#gp-top-header' ).innerHeight();
			} else {
				var topHeaderHeight = 0;
			}
			
			if ( $( '#gp-top-header' ).length > 0 ) {
				var adminBar = $( '#wpadminbar' ).innerHeight();
			} else {
				var adminBar = 0;
			}
					
			$( '#gp-fixed-header-padding' ).height( mainHeaderHeight + topHeaderHeight );
	
			if ( $( window ).outerWidth() <= 600 && $( 'body' ).hasClass( 'gp-fixed-header-all' ) ) {
				if ( $( document ).scrollTop() > ( topHeaderHeight + adminBar ) ) {
					$( 'body' ).addClass( 'gp-mobile-scrolling' ).removeClass( 'gp-desktop-scrolling' );
				} else {
					$( 'body' ).removeClass( 'gp-mobile-scrolling' );
				}
			} else if ( $( window ).outerWidth() <= 1082 && $( 'body' ).hasClass( 'gp-fixed-header-all' ) ) {
				if ( $( document ).scrollTop() > topHeaderHeight ) {
					$( 'body' ).addClass( 'gp-mobile-scrolling' ).removeClass( 'gp-desktop-scrolling' );
				} else {
					$( 'body' ).removeClass( 'gp-mobile-scrolling' );
				}
			} else if ( $( window ).outerWidth() > 1082 ) {	
				if ( $( document ).scrollTop() > topHeaderHeight ) {
					$( 'body' ).addClass( 'gp-desktop-scrolling' ).removeClass( 'gp-mobile-scrolling' );
				} else {
					$( 'body' ).removeClass( 'gp-desktop-scrolling' );
				}
			} else {
				$( 'body' ).removeClass( 'gp-desktop-scrolling gp-mobile-scrolling' );
			}
		
		}
		
	}

	gpResizeHeader();
	$( window ).resize( gpResizeHeader );
	$( window ).scroll( gpResizeHeader );	
	
	
	/*--------------------------------------------------------------
	Move left sidebar into right sidebar
	--------------------------------------------------------------*/

	function gpMoveSidebars() {
		if ( $( 'body' ).hasClass( 'gp-both-sidebars' ) && $( window ).outerWidth() <= 1120 && $( window ).outerWidth() >= 768 ) {
			if ( $( 'body' ).hasClass( 'gp-sticky-sidebars' ) && $( 'div' ).hasClass( 'theiaStickySidebar' ) ) {
				$( '#gp-sidebar-left .theiaStickySidebar > *' ).addClass( 'gp-moved-widget' ).prependTo( '#gp-sidebar-right .theiaStickySidebar' );	
			} else {
				$( '#gp-sidebar-left > *' ).addClass( 'gp-moved-widget' ).prependTo( '#gp-sidebar-right' );	
			}
		} else {
			if ( $( 'body' ).hasClass( 'gp-sticky-sidebars' ) && $( 'div' ).hasClass( 'theiaStickySidebar' ) ) {
				$( '.gp-moved-widget' ).prependTo( '#gp-sidebar-left .theiaStickySidebar' );
			} else {
				$( '.gp-moved-widget' ).prependTo( '#gp-sidebar-left' );
			}
		}
	}
	
	gpMoveSidebars();
	$( window ).resize( gpMoveSidebars );
	

	/*--------------------------------------------------------------
	Profile dropdown on mobiles
	--------------------------------------------------------------*/

	$( '.gp-profile-link .main-menu-link' ).on( 'touchend', function( event ) {
		event.preventDefault();
	});	
	
	$( '.gp-profile-link .main-menu-link' ).on( 'click touchend', function( event ) {
		$( '.gp-profile-link' ).addClass( 'gp-active' );
		$( '.gp-profile-link .sub-menu' ).show();
	});	
	
	// Close menu when page clicked
	$( document ).mouseup( function(e) {		
		var container = $( '.gp-profile-link' );
		if ( ( ! container.is( e.target ) && container.has( e.target ).length === 0 ) && $( '.gp-profile-link' ).hasClass( 'gp-active' ) ) {
			$( '.gp-profile-link .sub-menu' ).hide();
		}
	});


	/*--------------------------------------------------------------
	Open/close mobile nav
	--------------------------------------------------------------*/

	// Open mobile nav
	$( document ).on( 'click', '#gp-mobile-nav-button.gp-open-nav', function() {
		$( 'html, body' ).animate({ scrollTop: 0 }, 'fast' );
		$( this ).removeClass( 'gp-open-nav' ).addClass( 'gp-close-nav' );
		$( 'body' ).addClass( 'gp-nav-active' );
	});
	
	// Close mobile nav
	$( document ).on( 'click', '#gp-mobile-nav-button.gp-close-nav', function() {
		$( 'body' ).removeClass( 'gp-nav-active' );
		$( '#gp-mobile-nav-button.gp-close-nav' ).removeClass( 'gp-close-nav' ).addClass( 'gp-open-nav' );
	});		
	
	// Close mobile nav when page clicked
	$( document ).mouseup( function(e) {		
		var container = $( '#gp-mobile-nav-button, #gp-mobile-nav' );
		if ( ! container.is( e.target ) && container.has( e.target ).length === 0 ) {
			$( 'body' ).removeClass( 'gp-nav-active' );
			$( '#gp-mobile-nav-button' ).removeClass( 'gp-close-nav' ).addClass( 'gp-open-nav' );
		}
	});	
	

	/*--------------------------------------------------------------
	Fallback for mega menu headers
	--------------------------------------------------------------*/
		
	if ( $( '.gp-megamenu' ).length > 0 ) {
		
		$( '#gp-desktop-nav .gp-megamenu > .sub-menu > li > a, #gp-top-nav .gp-megamenu > .sub-menu > li > a' ).contents().unwrap().wrap( '<span class="gp-menu-header"></span>' );
			
	}

	
	/*--------------------------------------------------------------
	Slide up/down mobile dropdown menus
	--------------------------------------------------------------*/

	$( '#gp-mobile-nav li' ).each( function() {
		if ( $( this ).find( 'ul' ).length > 0 ) {
			$( '<i class="gp-mobile-dropdown-icon fa" />' ).insertAfter( $( this ).children( ':first' ) );		
		}		
	});
		
	function gpMobileNav() {

		$( '#gp-mobile-nav li' ).each( function() {
			
			var navItem = $( this ),
				navItemID = $( navItem ).attr( 'id' );
			
			if ( $( navItem ).find( 'ul' ).length > 0 ) {	
		
				$( document ).on( 'click', '#' + navItemID + ':not(.gp-active) > .gp-mobile-dropdown-icon', function() {
					$( navItem ).addClass( 'gp-active' );
					$( navItem ).children( '.sub-menu' ).stop().slideDown()
					$( '#gp-mobile-nav' ).addClass( 'gp-auto-height' );
				});
				
				$( document ).on( 'click', '#' + navItemID + '.gp-active > .gp-mobile-dropdown-icon', function() {
					$( navItem ).removeClass( 'gp-active' );
					$( navItem ).children( '.sub-menu' ).stop().slideUp();
				});
				
			}
					
		});
	
	}
	
	gpMobileNav();


	/*--------------------------------------------------------------
	Search box
	--------------------------------------------------------------*/	
	
	// Open search box when button clicked
	$( document ).on( 'click', '#gp-search-button:not(.gp-active)', function() {
		$( this ).addClass( 'gp-active' );
		$( '#gp-search-box-wrapper' ).show();
		$( '#gp-search-box input[type="text"]' ).focus();
		$( '#gp-mobile-nav-button.gp-close-nav' ).removeClass( 'gp-close-nav' ).addClass( 'gp-open-nav' );
		$( 'body' ).removeClass( 'gp-nav-active' );
	});			
	
	// Close search box	when button clicked	
	$( document ).on( 'click', '#gp-search-button.gp-active', function() {
		$( this ).removeClass( 'gp-active' );
		$( '#gp-search-box-wrapper' ).hide();
	});

	// Close search box when page clicked
	$( document ).mouseup( function(e) {		
		var container1 = $( '#gp-search-box-wrapper' );
		var container2 = $( '#gp-search-button' );
		if ( ! container1.is( e.target ) && container1.has( e.target ).length === 0 && ! container2.is( e.target ) && container2.has( e.target ).length === 0 ) {
			$( '#gp-search-box-wrapper' ).hide();
			$( '#gp-search-button' ).removeClass( 'gp-active' );
		}
	});
	
				
	/*--------------------------------------------------------------
	Smooth scroll
	--------------------------------------------------------------*/

	if ( $( 'body' ).hasClass( 'gp-smooth-scrolling' ) && $( window ).outerWidth() > 767 && $( 'body' ).outerHeight( true ) > $( window ).height() ) {
		$( 'html' ).niceScroll({
			cursorcolor: '#424242',
			scrollspeed: 100,
			mousescrollstep: 40,
			cursorwidth: 10,
			cursorborder: '0',
			zindex: 10000,
			cursoropacitymin: 0.3,
			cursoropacitymax: 0.6
		});
	}

	
	/*--------------------------------------------------------------
	Back to top button
	--------------------------------------------------------------*/

	if ( ! $( 'body' ).hasClass( 'gp-no-back-to-top' ) ) {	
		$().UItoTop({ 
			containerID: 'gp-to-top',
			text: '<i class="fa fa-chevron-up"></i>',
			scrollSpeed: 600
		});
	}
		

	/*--------------------------------------------------------------
	Lightbox
	--------------------------------------------------------------*/
	
	if ( ghostpool_script.lightbox == 'group_images' ) {
		$( 'a[data-lightbox="gallery"]' ).featherlightGallery({
			previousIcon: '',
			nextIcon: ''
		});
	}
		
	// Add image alt text as lightbox caption
	if ( ghostpool_script.lightbox != 'disabled' ) {
		$.featherlightGallery.prototype.afterContent = function() {
			
			var caption = this.$currentTarget.find( 'img' ).attr( 'alt' );
			$( '.featherlight-caption' ).remove();
			$( '<div class="featherlight-caption">' ).text( caption ).appendTo( this.$instance.find( '.featherlight-content' ) );

			var img = $( '.featherlight-content img' );
			$( '<img>' ).attr( 'src', $( img ).attr( 'src' ) ).load( function() {
				var realWidth = this.width;
				$( '.featherlight-content' ).css( 'max-width', realWidth );
			});
							
		};
	}
		

	/*--------------------------------------------------------------
	Blog masonry
	--------------------------------------------------------------*/

	if ( $( '.gp-blog-wrapper' ).hasClass( 'gp-blog-masonry' ) ) {
	
		var container = $( '.gp-blog-masonry .gp-section-loop-inner' ),
			element = container;

		if ( container.find( 'img' ).length == 0 ) {
			element = $( '<img />' );
		}	

		imagesLoaded( element, function( instance ) {

			container.isotope({
				itemSelector: 'section',
				percentPosition: true,
				masonry: {
					columnWidth: container.find( 'section' )[0],
					gutter: '.gp-gutter-size'
				}
			});

			container.animate( { 'opacity': 1 }, 1300 );
			$( '.gp-pagination' ).animate( { 'opacity': 1 }, 1300 );
			$( '.gp-load-more' ).animate( { 'opacity': 1 }, 1300 );

		});
				
	}


	/*--------------------------------------------------------------
	Load more
	--------------------------------------------------------------*/
	
	var maxNumPages = ghostpool_script.max_num_pages;

	$( '#gp-content .gp-archive-wrapper .gp-section-loop-inner' ).infinitescroll({
		debug: false,
		loading: {
			finishedMsg: '',
			img: ghostpool_script.get_template_directory_uri + '/lib/framework/images/blank.gif',
			msgText: '',
			speed: 'fast',
		},
		nextSelector: '#gp-content .gp-archive-wrapper ul.page-numbers a',
		navSelector: '#gp-content .gp-archive-wrapper .gp-pagination',
		itemSelector: '#gp-content .gp-archive-wrapper section',
		maxPage: maxNumPages,
		extraScrollPx: 0,
		bufferPx: 0
	}, function( json, opts ) {
		if ( opts.state.currPage == maxNumPages ) {
			$( '#gp-content .gp-archive-wrapper .gp-load-more' ).remove();
		}
	});
	$( '#gp-content .gp-archive-wrapper .gp-section-loop-inner' ).infinitescroll( 'unbind' );
	$( '#gp-content .gp-archive-wrapper .gp-load-more-button' ).click( function() {
		 $( '#gp-content .gp-archive-wrapper .gp-section-loop-inner' ).infinitescroll( 'retrieve' );
		 return false;
	});	


	/*--------------------------------------------------------------
	Gallery category post slider
	--------------------------------------------------------------*/
	
	$( window ).on( 'load', function() {
		$( '.gp-blog-wrapper:not(.gp-blog-masonry) .gp-post-format-gallery-slider, .gp-showcase-wrapper .gp-post-format-gallery-slider' ).flexslider( { 
			animation: 'fade',
			slideshowSpeed: 9999999,
			animationSpeed: 600,
			directionNav: true,			
			controlNav: false,			
			pauseOnAction: true, 
			pauseOnHover: false,
			prevText: '',
			nextText: '',
			smoothHeight: true
		});
	});

	$( '.gp-blog-masonry .gp-post-format-gallery-slider' ).flexslider( { 
		animation: 'fade',
		slideshowSpeed: 9999999,
		animationSpeed: 600,
		directionNav: true,			
		controlNav: false,			
		pauseOnAction: true, 
		pauseOnHover: false,
		prevText: '',
		nextText: ''
	});
	
	
	/*--------------------------------------------------------------
	Gallery single post slider
	--------------------------------------------------------------*/

	$( window ).on( 'load', function() {
		$( '.gp-entry-featured .gp-post-format-gallery-slider' ).flexslider( { 
			animation: 'fade',
			slideshowSpeed: 9999999,
			animationSpeed: 600,
			directionNav: true,			
			controlNav: false,			
			pauseOnAction: true, 
			pauseOnHover: false,
			prevText: '',
			nextText: '',
			smoothHeight: true
		});
	});

	
	/*--------------------------------------------------------------
	Post submission image upload
	--------------------------------------------------------------*/

	function imageURL( input ) {
		if ( input.files && input.files[0] ) {
			var reader = new FileReader();
			reader.onload = function( e ) {
				$( '.gp-post-submission-image img' ).attr( 'src', e.target.result ).addClass( 'gp-show-image' );
			}
			reader.readAsDataURL( input.files[0] );
		}
	}

	$( '#gp-post-image' ).on( 'change', function() {		
		var fileExtension = ['jpeg', 'jpg', 'png', 'gif', 'bmp', 'ico'];
	    if ( $.inArray( $( this ).val().split( '.' ).pop().toLowerCase(), fileExtension ) == -1 ) {
            $( 'label[for="gp-post-image"]' ).text( $( this ).data( 'image-not-added' ) );
        } else {
			$( 'label[for="gp-post-image"]' ).text( $( this ).data( 'image-added' ) );
		}		
		imageURL( this );
	});


	/*--------------------------------------------------------------
	Vote Up/Down
	--------------------------------------------------------------*/

	// Get all voting containers
	$( '.gp-voting-container' ).each( function( index ) {

		// Get data attribute
		 var content_id = $( this ).data( 'content-id' );

		 var itemName = "gpvoting" + content_id;

		// Check if this content has localstorage
		if ( localStorage.getItem( itemName ) ) {

			// Check if it's Up or Down vote
			if ( localStorage.getItem( "gpvoting" + content_id + "-1" ) ) {
				$( this ).find( '.gp-voting-up' ).addClass( 'gp-voted' );
			}
			if ( localStorage.getItem( "gpvoting" + content_id + "-0" ) ) {
				$( this ).find( '.gp-voting-down' ).addClass( 'gp-voted' );
			}
		}
		
	});


	/*--------------------------------------------------------------
	Padding bottom of hub header
	--------------------------------------------------------------*/

	function gpHubHeaderPadding() {
		if ( $( '.gp-hub-header #gp-page-header-video' ).length ) {
			var height = $( '#gp-hub-details .gp-featured-caption' ).height();
			if ( $( window ).outerWidth() <= 859 ) {
				$( '.gp-hub-header #gp-page-header-video' ).css( 'padding-bottom', height + 20 );
			} else {
				$( '.gp-hub-header #gp-page-header-video' ).css( 'padding-bottom', height + 30 );		
			}
		}
	}	
	
	gpHubHeaderPadding();
	$( window ).resize( gpHubHeaderPadding );
		
		
	/*--------------------------------------------------------------
	Slide up/down hub tabs mobile navigation
	--------------------------------------------------------------*/

	function gpTabsMobileNav() {
		var clicked = false;
		$( '#gp-hub-tabs-mobile-nav-button' ).on( 'click', function () {
			if ( clicked ) {
				clicked = false;
				$( '#gp-hub-tabs ul' ).stop().slideUp();
				$( this ).removeClass( 'gp-active' );
			} else {
				clicked = true;
			   	$( '#gp-hub-tabs ul' ).stop().slideDown();
				$( this ).addClass( 'gp-active' );
			}
		});
	
			$( '#gp-hub-tabs li a' ).click( function() {
				clicked = false;
				$( '#gp-hub-tabs ul' ).stop().slideUp();
				$( this ).removeClass( 'gp-active' );
			});
			
			
	}
		
	gpTabsMobileNav();
	

	/*--------------------------------------------------------------
	Images tab page
	--------------------------------------------------------------*/

	if ( $( 'div' ).hasClass( 'gp-image-tab-items' ) ) {

		// Load lazy images
		$( this ).find( '.gp-image-item img' ).lazyload({
			 effect: 'fadeIn'
		});
		$( '.gp-image-tab-items' ).animate( { 'opacity': 1 }, 1300 );

		// Add alt text to Lightbox
		$( '.gp-image-tab-items' ).featherlightGallery({
			filter: 'a',
			afterContent: function() {
				this.$legend = this.$legend || $( '<div class="gp-legend"/>' ).insertAfter( this.$content );
				this.$legend.text( this.$currentTarget.attr( 'title' ) );
			}
		});
	
	}

	if ( $( 'div' ).hasClass( 'gp-image-items' ) ) {

		// Add alt text to Lightbox
		$( '.gp-image-items' ).featherlightGallery({
			filter: 'a',
			afterContent: function() {
				this.$legend = this.$legend || $( '<div class="gp-legend"/>' ).insertAfter( this.$content );
				this.$legend.text( this.$currentTarget.attr( 'title' ) );
			}
		});
	
	}
		

	/*--------------------------------------------------------------
	Follow Items
	--------------------------------------------------------------*/

	$( '.gp-unfollow-item' ).show();
	
	$( '.gp-follow-button-container' ).on( 'click', '.gp-follow-button', function() {
		var button = $( this );
		wpfp_do_js( button, 1 );
		// Following page
		if ( button.hasClass( 'gp-unfollow-item' ) ) {
			button.parent( 'section' ).fadeOut();
		}
		return false;
	});

	function wpfp_do_js( button, doAjax ) {
		button.addClass( 'gp-follow-loading' );
		var url = document.location.href.split( '#' )[0];
		var params = button.attr( 'href' ).replace( '?', '' ) + '&ajax=1';
		if ( doAjax ) {
			jQuery.get( url, params, function( data ) {
					button.parent().html( data );
					if ( typeof wpfp_after_ajax == 'function' ) {
						wpfp_after_ajax( button );
					}
					button.removeClass( 'gp-follow-loading' );
				}
			);
		}
	}
		

	/*--------------------------------------------------------------
	Category filter
	--------------------------------------------------------------*/

	$( '#gp-filter-release-date' ).change( function() {
		if ( $( this ).val() == 'date_range' ) {
			$( '.gp-filter-release-date-range' ).addClass( 'gp-selected' );
		} else {
			$( '.gp-filter-release-date-range' ).removeClass( 'gp-selected' );
		}				
	});
	
	$( function() {
		$( '.gp-datepicker' ).datepicker({ constrainInput: false });
	});
		

	/*--------------------------------------------------------------
	Load scripts in WPB tabs
	--------------------------------------------------------------*/

	$( '.vc_tta-tab, .vc_tta-panel-title' ).click( function() {
						
		setTimeout( function() {
		   $( window ).trigger( 'resize' );
		}, 0 );
		setTimeout( function() {
		   $( window ).trigger( 'resize' );
		}, 2 );

	});
	
					
	/*--------------------------------------------------------------
	Login box
	--------------------------------------------------------------*/

	// Submit forms
	var formArray = ['.gp-login-form', '.gp-lost-password-form', '.gp-register-form'];
	
	$.each( formArray, function( index, value ) {
	
		$( value ).submit( function() {
			var form = $( this ); 
			form.find( '.gp-login-results' ).html( '<span class="gp-verify-form">' + $( '.gp-login-results' ).data( 'verify' ) + '</span>' ).fadeIn();
			var input_data = form.serialize();
			$.ajax({
				type: 'POST',
				url:  ghostpool_script.url,
				data: input_data,
				success: function( msg ) {
					
					form.find( '.gp-verify-form' ).remove();
					
					$( '<span>' ).html( msg ).appendTo( form.find( '.gp-login-results' ) ).fadeIn( 'slow' );
					
					if ( $( '.gp-register-form' ).find( '.gp-login-results .gp-success' ) ) {						
						$( '.gp-register-form' ).find( 'p, .gglcptch, .wp-submit' ).hide();
					}
					
				},
				error: function( xhr, status, error ) {
				
					// Reset captcha on error
					if ( $( '.gglcptch > div' ).length > 0 ) {
						grecaptcha.getResponse();
						grecaptcha.reset();
					}
					
					form.find( '.gp-verify-form' ).remove();
					
					$( '<span>' ).html( xhr.responseText ).appendTo( form.find( '.gp-login-results' ) ).fadeIn( 'slow' );
					
				}
			});
			return false;
		});
	
	});

	// Close modal window when clicking outside of it		
	$( document ).mouseup( function( e ) {
		var container = $( '#gp-login-modal' );
		if ( ! container.is( e.target ) && container.has( e.target ).length === 0 ) {
			$( '#login' ).hide();
		}
	});
			
	// Close modal window when clicking close button
	$( '#gp-login-close' ).click( function() {		
		$( '#login' ).hide();
		$( '.gp-login-results > span' ).remove();
	});	
	
	// Open login modal window when clicking links		
	$( '.gp-login-link, a[href="#login"]' ).click( function() {
		$( '#login' ).show();
		$( '.gp-login-form-wrapper' ).show();
		$( '.gp-register-form-wrapper, .gp-lost-password-form-wrapper, .gp-social-login-form-wrapper' ).hide();
		$( '.gp-login-results > span' ).remove();
	});		

	// Open login modal window directly from URL
	if ( /#login/.test( window.location.href ) ) {
		$( '#login' ).show();
		$( '.gp-login-form-wrapper' ).show();
		$( '.gp-register-form-wrapper, .gp-lost-password-form-wrapper, .gp-social-login-form-wrapper' ).hide();
		$( '.gp-login-results > span' ).remove();
	}	
								
	// Open lost password modal window when clicking link								
	$( '.gp-lost-password-link' ).click( function() {
		$( '.gp-lost-password-form-wrapper' ).show();
		$( '.gp-register-form-wrapper, .gp-login-form-wrapper, .gp-social-login-form-wrapper' ).hide();
		$( '.gp-login-results > span' ).remove();
	});		

	// Open lost password modal window directly from URL
	if ( /#lost-password/.test( window.location.href ) ) {
		$( '#login' ).show();
		$( '.gp-lost-password-form-wrapper' ).show();
		$( '.gp-register-form-wrapper, .gp-login-form-wrapper, .gp-social-login-form-wrapper' ).hide();
		$( '.gp-login-results > span' ).remove();
	}
	
	// Open registration modal window when clicking links		
	$( 'a[href="#register"]' ).click( function() {
		$( '#login' ).show();
		$( '.gp-register-form-wrapper, .gp-register-form .login-form > p, .gp-register-form .wp-submit' ).show();
		$( '.gp-register-form .login-form p > input[type="text"]' ).val( '' );
		$( '.gp-login-form-wrapper, .gp-lost-password-form-wrapper, .gp-social-login-form-wrapper' ).hide();
		$( '.gp-login-results > span' ).remove();
	});

	// Open registration modal window directly from URL
	if ( /#register/.test( window.location.href ) ) {
		$( '#login' ).show();
		$( '.gp-register-form-wrapper, .gp-register-form .login-form > p, .gp-register-form .wp-submit' ).show();
		$( '.gp-register-form .login-form p > input[type="text"]' ).val( '' );
		$( '.gp-login-form-wrapper, .gp-lost-password-form-wrapper, .gp-social-login-form-wrapper' ).hide();
		$( '.gp-login-results > span' ).remove();
	}
				
	// Close reset success message	
	$( '#gp-close-reset-message' ).click( function() {
		$( '#gp-reset-message' ).remove();
	});
	
});