<?php

if ( ! class_exists( 'Ghostpool_Custom_Menu' ) ) {

	class Ghostpool_Custom_Menu extends Walker_Nav_Menu {
		
		private $curItem;

		// Start level (add classes to ul sub-menus)
		function start_lvl( &$output, $depth = 0, $args = array() ) {
		
			// Depth dependent classes
			$indent = ( $depth > 0  ? str_repeat( "\t", $depth ) : '' ); // code indent
			$display_depth = ( $depth + 1 ); // because it counts the first submenu as 0
			$classes = array(
				'sub-menu',
				( $display_depth % 2  ? 'menu-odd' : 'menu-even' ),
				( $display_depth >=2 ? 'sub-sub-menu' : '' ),
				'menu-depth-' . $display_depth
				);
			$class_names = implode( ' ', $classes );
			
			// Build html
			
			$bg_image = '';
			if ( get_post_meta( $this->curItem->ID, 'menu-item-gp-bg-image', true ) ) { 
				$bg_image = ' style="background-image: url(' . get_post_meta( $this->curItem->ID, 'menu-item-gp-bg-image', true ) . ');"';
			}
						
			$output .= "\n" . $indent . '<ul class="' . $class_names . '"' . $bg_image . '>' . "\n";
			
		}
  
		// Start element (add main/sub classes to li's and links)
		function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
			global $wp_query;
			
			$this->curItem = $item;
	
			$indent = ( $depth > 0 ? str_repeat( "\t", $depth ) : '' ); // code indent

			// Depth dependent classes
			$depth_classes = array(
				( $depth == 0 ? 'main-menu-item' : 'sub-menu-item' ),
				( $depth >=2 ? 'sub-sub-menu-item' : '' ),
				( $depth % 2 ? 'menu-item-odd' : 'menu-item-even' ),
				'menu-item-depth-' . $depth
			);
			$depth_class_names = esc_attr( implode( ' ', $depth_classes ) );

			// Depth dependent classes
			$display_depth = ( $depth + 1); // because it counts the first submenu as 0
			$sub_menu_classes = array(
				'sub-menu',
				( $display_depth % 2  ? 'menu-odd' : 'menu-even' ),
				( $display_depth >=2 ? 'sub-sub-menu' : '' ),
				'menu-depth-' . $display_depth
				);
			$submenu_depth_class_names = implode( ' ', $sub_menu_classes );
			
			// Parsed classes
			$classes = empty( $item->classes ) ? array() : (array) $item->classes;
			$class_names = esc_attr( implode( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) ) );
			$class_names = str_replace( 'fa ', '', $class_names ); // Remove fa added to <li>

			// Build html			
			$menu_type = get_post_meta( $item->ID, 'menu-item-gp-menu-type', true ) ? get_post_meta( $item->ID, 'menu-item-gp-menu-type', true ) : 'gp-standard-menu';
			
			$bg_image_class = get_post_meta( $item->ID, 'menu-item-gp-bg-image', true ) != '' ? 'gp-has-bg-image' : '';
						
			// Profile class
			if ( $menu_type == 'gp-profile-link' ) {
				$profile_class = 'gp-standard-menu';
			} else {
				$profile_class = '';
			}	
			
			if ( ( is_user_logged_in() && get_post_meta( $item->ID, 'menu-item-gp-user-display', true ) != 'gp-show-logged-out' ) OR ( ! is_user_logged_in() && get_post_meta( $item->ID, 'menu-item-gp-user-display', true ) != 'gp-show-logged-in' ) ) {
			
				if ( ( is_user_logged_in() && ( $menu_type == 'gp-login-link' OR $menu_type == 'gp-register-link' ) ) OR ( ! is_user_logged_in() && ( $menu_type == 'gp-logout-link' OR $menu_type == 'gp-profile-link' ) ) ) {
				
					$output .= '';

				} else {
						
					$output .= $indent . '<li id="nav-menu-item-'. $item->ID . '" class="' . $menu_type . ' ' . $profile_class . ' ' . get_post_meta( $item->ID, 'menu-item-gp-columns', true ) . ' ' . get_post_meta( $item->ID, 'menu-item-gp-display', true ) . ' ' . $depth_class_names . ' ' . get_post_meta( $item->ID, 'menu-item-gp-hide-nav-label', true ) . ' ' . $bg_image_class . ' ' . $class_names . '">';

					// Link attributes
					$attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
					$attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
					$attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
				
					// Menu type
					if ( $menu_type == 'gp-login-link' ) {			
						$item_link = '#login';
					} elseif ( $menu_type == 'gp-register-link' ) {
						if ( function_exists( 'bp_is_active' ) ) {
							$item_link = bp_get_signup_page( false );
						} else {
							$item_link = '#register';
						}	
					} elseif ( $menu_type == 'gp-logout-link' ) {	
						$item_link = wp_logout_url( apply_filters( 'ghostpool_logout_redirect', get_home_url() ) );
					} elseif ( $menu_type == 'gp-profile-link' ) {	
						if ( function_exists( 'bp_is_active' ) ) {
							global $bp;
							$item_link = $bp->loggedin_user->domain; 
						} else {
							$current_user = wp_get_current_user();
							$item_link = get_author_posts_url( $current_user->ID );
						}								
					} else {
						$item_link = $item->url;
					}
				
					$attributes .= ! empty( $item_link ) ? ' href="' . esc_attr( $item_link ) .'"' : '';
				
					$attributes .= ' class="menu-link ' . ( $depth > 0 ? 'sub-menu-link' : 'main-menu-link' ) . '"';
			
					// Tab content menu
					if ( $menu_type == 'gp-tab-content-menu' OR $menu_type == 'gp-content-menu' ) {
						
						// Posts per page depending on menu type
						if ( $menu_type == 'gp-content-menu' ) {
							$per_page = 5;
						} else {
							$per_page = 4;
						}
								
						$content_args = array(
							'post_status' 	      => 'publish',
							'post_type'           => array( 'post', 'page' ),
							'cat' 				  => $item->object_id,
							'orderby'             => 'date',
							'order'           	  => 'desc',
							'posts_per_page'      => $per_page,
							'paged'               => 1,
						);

						$gp_query = new WP_Query( $content_args );
				
						$dropdown = '<ul class="sub-menu ' . $submenu_depth_class_names . '">
						<li id="tab-nav-menu-item-'. $item->ID . '" class="' . $class_names . '"' . ' data-type="menu" data-cats="' . $item->object_id . '" data-perpage="' . $per_page . '">';
					
							if ( $gp_query->have_posts() ) :
				
								if ( $menu_type == 'gp-tab-content-menu' ) {
								
									if ( wp_is_mobile() ) {
										$mobile_menu_class = 'gp-mobile-menu-tabs';
									} else {
										$mobile_menu_class = '';
									}

									$terms = get_terms( array( 
										'taxonomy' => $item->object, 
										'parent'  => $item->object_id,
									) );
									if ( ! empty( $terms ) ) {
										$dropdown .= '<ul class="gp-menu-tabs ' . $mobile_menu_class . '">
											<li id="' . $item->object_id . '" class="gp-selected"><a href="' . $item->url . '">' . esc_html__( 'All', 'huber' ) . '</a></li>';		
											foreach( $terms as $term ) {
												if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
													$dropdown .= '<li id="' . $term->term_id . '"><a href="' . get_term_link( $term->term_id ) . '">' . $term->name . '</a></li>';
												}
											}
										$dropdown .= '</ul>';
										
									}
													
								}

								$dropdown .= '<div class="gp-section-loop ' . ghostpool_option( 'ajax' ) . '">';
								
									if ( ghostpool_option( 'ajax' ) == 'gp-ajax-loop' ) {
										$dropdown .= '<div class="gp-pagination gp-standard-pagination gp-pagination-arrows">' . ghostpool_pagination_arrows( $gp_query->max_num_pages ) . '</div>';
									}
															
									$dropdown .= '<div class="gp-section-loop-inner">';

										while ( $gp_query->have_posts() ) : $gp_query->the_post();
															
											// Post link
											if ( get_post_format() == 'link' ) { 
												$link = esc_url( get_post_meta( get_the_ID(), 'link', true ) );
												$target = 'target="' . get_post_meta( get_the_ID(), 'link_target', true ) . '"';
											} else {
												$link = get_permalink();
												$target = '';
											}
														
											$dropdown .= '<section class="' . implode( ' ' , get_post_class( 'gp-post-item' ) ) . '">';

												if ( has_post_thumbnail() ) {
									
													$dropdown .= '<div class="gp-post-thumbnail">
														<a href="' . $link . '" title="' . the_title_attribute( array( 'echo' => false ) ) . '"' . $target . '>' .
															get_the_post_thumbnail( get_the_ID(), apply_filters( 'ghostpool_menu_image_size', 'ghostpool-menu-image' ) ) .														
															'<span class="gp-loop-ratings">';														
																if ( ghostpool_site_rating() ) {
																	$dropdown .= '<span class="gp-site-rating' . ghostpool_rating_color( ghostpool_site_rating() ) . '">
																		<span class="gp-rating-score">' . 
																			ghostpool_site_rating() .
																		'</span>' .
																		ghostpool_rating_text( ghostpool_site_rating( '', true ) ) .
																	'</span>';
																}
																if ( get_post_meta( get_the_ID(), 'ghostpool_user_rating', true ) >=1 ) {						
																	$dropdown .= '<span class="gp-user-rating' . ghostpool_rating_color( get_post_meta( get_the_ID(), "ghostpool_user_rating", true ) ) . '">
																		<span class="gp-rating-score">' .
																			get_post_meta( get_the_ID(), 'ghostpool_user_rating', true ) .
																		'</span>' .
																		ghostpool_rating_text( get_post_meta( get_the_ID(), 'ghostpool_user_rating', true ) ). 
																		'<span class="gp-rating-avg-text">' . esc_html__( 'User Avg', 'huber' ) . '</span>
																	</span>';
																}
															$dropdown .= '</span>
														</a>
													</div>';
							
												}
								
												$dropdown .= '<div class="gp-loop-title"><a href="' . $link . '" title="' . the_title_attribute( array( 'echo' => false ) ) . '"'. $target. '>' . get_the_title() . '</a></div>
										
												<div class="gp-loop-meta">';
												
													if ( get_post_meta( get_the_ID(), 'release_date', true ) ) {
													
														$dropdown .= '<span class="gp-post-meta gp-meta-release-date">';
															$new_release_date = date_i18n( 'U', strtotime( get_post_meta( get_the_ID(), 'release_date', true ) ) );
															if ( $new_release_date > date( 'U' ) ) {
																$dropdown .= ghostpool_option( 'upcoming_date_text' ) . ': ';
															} else {
																$dropdown .= ghostpool_option( 'release_date_text' ) . ': ';
															}
															$dropdown .= date_i18n( ghostpool_option( 'release_date_format' ), strtotime( get_post_meta( get_the_ID(), 'release_date', true ) ) );
														$dropdown .= '</span>';
													
													} else {
												
														$dropdown .= '<time class="gp-post-meta gp-meta-date" datetime="' . get_the_date( 'c' ) . '">' . get_the_time( get_option( 'date_format' ) ) . '</time>';
													}
												
												$dropdown .= '</div>
						
											</section>';
						
										endwhile; 
					
									$dropdown .= '</div>
							
								</div>';
											
							endif; wp_reset_postdata();

						$dropdown .= '</li></ul>';

					} else {
					
						$dropdown = '';
					
					}
			
					// Defaults
					$attributes = '<a' . $attributes . '>';
					$link_before = $args->link_before;
					$nav_label = $item->title;
					$link_after = '</a>' . $args->link_after;
					$after = $args->after;
								
					// Navigation label
					if ( $menu_type == 'gp-profile-link' ) {
						if ( function_exists( 'bp_notifications_get_notifications_for_user' ) ) { 
							$notifications = bp_notifications_get_notifications_for_user( bp_loggedin_user_id(), 'object' );
							$count = ! empty( $notifications ) ? count( $notifications ) : 0;
							$count = apply_filters( 'ghostpool_notifications_url', '<a href="' . $bp->loggedin_user->domain . '/notifications" class="gp-notification-counter">' . $count . '</a>' );
						} else {
							$count = '';
						} 
						$current_user = wp_get_current_user();
						$username = $current_user->display_name;
						$limit = apply_filters( 'ghostpool_truncate_bp_username', 15 );
						if ( strlen( $username ) > $limit ) { 
							$username = mb_substr( $username, 0, (int) $limit ) . '...';
						}
						$nav_label = '<span class="gp-profile-link-icon"></span><span class="gp-profile-link-username">' . $username . '</span>';
						$after = $args->after . $count;
					} elseif ( get_post_meta( $item->ID, 'menu-item-gp-hide-nav-label', true ) == 'gp-hide-nav-label' ) {
						$nav_label = '';
					}

					// Menu Header
					if ( get_post_meta( $item->ID, 'menu-item-gp-content', true ) == 'gp-menu-header' ) {
						$attributes = '';
						$link_before = '<span class="gp-menu-header">';
						$link_after = '</span>';
					}
										
					// Menu Icon
					if ( strpos( $class_names, 'fa-' ) !== false ) {
						$link_before = $args->link_before . '<i class="gp-menu-icon fa ' . $class_names . '"></i>';
					}
					
					// Menu Text
					if ( get_post_meta( $item->ID, 'menu-item-gp-content', true ) == 'gp-menu-text' ) {
						$attributes = '';
						$link_before = '<span class="gp-menu-text">';
						$link_after = '</span>';
					}

					// Menu Image
					if ( get_post_meta( $item->ID, 'menu-item-gp-content', true ) == 'gp-menu-image' ) {
						$attributes = '';
						$link_before = '<img src="' . $item->url . '" class="gp-menu-image" alt="">';
						$nav_label = '';
						$link_after = '';
					}
										
					// Item Output
					$item_output = sprintf( '%1$s%2$s%3$s%4$s%5$s%6$s%7$s',
						$args->before,
						$attributes,
						$link_before,
						apply_filters( 'the_title', $nav_label, $item->ID ),
						$link_after,
						$after,
						$dropdown
					);
			
					// Build html
					$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
				}
				
			}
							
		}
		
		// End element (add closing li's)
		function end_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
		
			$menu_type = get_post_meta( $item->ID, 'menu-item-gp-menu-type', true ) ? get_post_meta( $item->ID, 'menu-item-gp-menu-type', true ) : 'gp-standard-menu';

			if ( ( is_user_logged_in() && get_post_meta( $item->ID, 'menu-item-gp-user-display', true ) != 'gp-show-logged-out' ) OR ( ! is_user_logged_in() && get_post_meta( $item->ID, 'menu-item-gp-user-display', true ) != 'gp-show-logged-in' ) ) {
			
				if ( ( is_user_logged_in() && ( $menu_type == 'gp-login-link' OR $menu_type == 'gp-register-link' ) ) OR ( ! is_user_logged_in() && ( $menu_type == 'gp-logout-link' OR $menu_type == 'gp-profile-link' ) ) ) {
				
					$output .= '';
				
				} else {
				
					$output .= '</li>';

				}
			
			}
								
		}

	}
} 

?>