<?php

/*--------------------------------------------------------------
Load User Rating Script
--------------------------------------------------------------*/

if ( ! function_exists( 'ghostpool_register_user_rating_script' ) ) {

	function ghostpool_register_user_rating_script() {
		
		if ( ( ghostpool_option( 'visitor_voting' ) == 'enabled' && ! is_user_logged_in() ) OR is_user_logged_in() ) {
			wp_enqueue_script( 'gp-user-ratings', get_template_directory_uri() . '/lib/scripts/user-ratings.js', array( 'jquery' ), '', true );						
		}

		// Get post or hub association ID
		$a_post_id = get_hub_association_id( get_the_ID() );	
				
		// Use old user meta values for Gauge and The Review users
		if ( get_user_meta( get_current_user_id(), 'ghostpool_rated_' . $a_post_id, true ) ) {
			$rated = get_user_meta( get_current_user_id(), 'ghostpool_rated_' . $a_post_id, true );
		} else {
			$rated = get_user_meta( get_current_user_id(), '_gp_rated_' . $a_post_id, true );
		}
		if ( get_user_meta( get_current_user_id(), 'ghostpool_current_position_' . $a_post_id, true ) ) {
			$position = get_user_meta( get_current_user_id(), 'ghostpool_current_position_' . $a_post_id, true );
		} else {
			$position = get_user_meta( get_current_user_id(), '_gp_current_position_' . $a_post_id, true );
		}
		if ( get_user_meta( get_current_user_id(), 'ghostpool_user_rating_' . $a_post_id, true ) ) {
			$rating = get_user_meta( get_current_user_id(), 'ghostpool_user_rating_' . $a_post_id, true );
		} else {
			$rating = get_user_meta( get_current_user_id(), '_gp_user_rating_' . $a_post_id, true );
		}				
		
		wp_localize_script( 'gp-user-ratings', 'ghostpool_rating', array(
			'post_id' => $a_post_id,
			'ajaxurl' => admin_url( 'admin-ajax.php' ),
			'rating_number' => ghostpool_option( 'rating_number' ),
			'rating_width' => ( apply_filters( 'ghostpool_custom_rating_width', 23.3 ) * ghostpool_option( 'rating_number' ) ),
			'rated' => $rated,
			'position' => $position,
			'rating' => $rating,
		) );
	}
	
}
add_action( 'wp_enqueue_scripts', 'ghostpool_register_user_rating_script' );


/*--------------------------------------------------------------
Reset user ratings and votes
--------------------------------------------------------------*/
	
if ( is_admin() ) {
	if ( ! function_exists( 'ghostpool_reset_user_ratings' ) ) {
		function ghostpool_reset_user_ratings() {
			global $wpdb, $post;
			if ( ! wp_is_post_revision( get_the_ID() ) ) {
				if ( get_post_meta( get_the_ID(), 'reset_user_ratings', true ) == 1 ) {
					delete_post_meta( get_the_ID(), 'ghostpool_user_rating' );
					delete_post_meta( get_the_ID(), 'ghostpool_user_votes' );
					delete_post_meta( get_the_ID(), 'ghostpool_user_sum' );
					delete_post_meta( get_the_ID(), 'ghostpool_current_position' );
					delete_user_meta( get_current_user_id(), 'ghostpool_rated_' . get_the_ID() );
					delete_user_meta( get_current_user_id(), 'ghostpool_user_rating_' . get_the_ID() );
					delete_user_meta( get_current_user_id(), 'ghostpool_current_position_' . get_the_ID() );
					update_post_meta( get_the_ID(), 'reset_user_ratings', 0 );
				}
			}	

		}
	}	
	add_action( 'publish_page', 'ghostpool_reset_user_ratings' );
	add_action( 'save_post', 'ghostpool_reset_user_ratings' );
}


/*--------------------------------------------------------------
Add user ratings
--------------------------------------------------------------*/
			
if ( ! class_exists( 'ghostpool_user_rating' ) ) {

    class ghostpool_user_rating {
    
        public $user_sum;
        public $user_rating;
        public $current_position;
        public $user_votes;

        function __construct() {

			if ( is_singular() ) {
				$this->retrieve_values();
			}
			
			add_action( 'wp_ajax_ghostpool_rating', array( &$this, 'sync_rating' ) );
			add_action( 'wp_ajax_nopriv_ghostpool_rating', array( &$this, 'sync_rating' ) );

        }
		
        private function retrieve_values() {
        
            $current_position = get_post_meta( get_the_ID(), 'ghostpool_current_position', true );
            if ( ! $current_position) {
                $current_position = 0;
            }
            $this->current_position = ( apply_filters( 'ghostpool_custom_rating_width', 23.3 ) * ghostpool_option( 'rating_number' ) );
                                
            $user_rating = get_post_meta( get_the_ID(), 'ghostpool_user_rating', true );
            if ( ! $user_rating ) {
                $user_rating = 0;
            }
            $this->user_rating = $user_rating;

            $user_votes = get_post_meta( get_the_ID(), 'ghostpool_user_votes', true );
            if ( ! $user_votes ) {
                $user_votes = 0;
            }
            $this->user_votes = $user_votes;

            $user_sum = get_post_meta( get_the_ID(), 'ghostpool_user_sum', true );
            if ( ! $user_sum && $user_rating && $user_votes ) {
                $user_sum = ( $user_rating * $user_votes );
            } elseif ( ! $user_sum ) {
            	$user_sum = 0;
            }
            $this->user_sum = $user_sum;

        }

        public function sync_rating() {
        	
            // Get post id, user rating and position from user rating box
            $post_id = floatval( $_POST['post_id'] );
            $added_rating = floatval( $_POST['rating_score'] );
            $added_position = floatval( $_POST['rating_position'] );

            // Current values
            $current_position = get_post_meta( $post_id, 'ghostpool_current_position', true );
            if ( ! $current_position ) {
                $current_position = 0;
            }
           	$user_rating = get_post_meta( $post_id, 'ghostpool_user_rating', true );
            if ( ! $user_rating ) {
                $user_rating = 0;
            }
            $user_votes = (int) get_post_meta( $post_id, 'ghostpool_user_votes', true );
            if ( ! $user_votes ) {
                $user_votes = 0;
            }
            $user_sum = get_post_meta( $post_id, 'ghostpool_user_sum', true );
            if ( ! $user_sum && $user_rating && $user_votes ) {
                $user_sum = ( $user_rating * $user_votes );
            } elseif ( ! $user_sum ) {
            	$user_sum = 0;
            }            

            // New values
            $new_user_sum = $user_sum + $added_rating;
            $new_position = ( $current_position * $user_votes + $added_position ) / ( $user_votes + 1 );
            $new_user_votes = $user_votes + 1;
            $new_user_rating = number_format( ( $new_user_sum ) / ( $new_user_votes ), 1 ) + 0;
             
            // Prevent rating higher than maximum rating being set
            if ( $new_user_rating > ghostpool_option( 'rating_number' ) ) {
				$new_user_rating = ghostpool_option( 'rating_number' );
			}
			           
            // Update post/user meta with new values
            update_post_meta( $post_id, 'ghostpool_user_sum', $new_user_sum, $user_sum );
            update_post_meta( $post_id, 'ghostpool_current_position', $new_position, $current_position );
            update_post_meta( $post_id, 'ghostpool_user_rating', $new_user_rating, $user_rating );
            update_post_meta( $post_id, 'ghostpool_user_votes', $new_user_votes, $user_votes );
            if ( is_user_logged_in() ) {
				add_user_meta( get_current_user_id(), 'ghostpool_rated_' . $post_id, 'rated' );
				add_user_meta( get_current_user_id(), 'ghostpool_user_rating_' . $post_id, $added_rating );
				add_user_meta( get_current_user_id(), 'ghostpool_current_position_' . $post_id, $added_position );
			}
            exit;
            
        }
    }
}

new ghostpool_user_rating();