<?php if ( ! function_exists( 'ghostpool_post_submission' ) ) {
	function ghostpool_post_submission() {
	
		if ( isset( $_GET['post_submission'] ) && $_GET['post_submission'] == '1' && wp_verify_nonce( $_REQUEST['_wpnonce'], 'ghostpool_post_submission_action' ) ) {

			$has_error = '';

			if ( 'POST' == $_SERVER['REQUEST_METHOD'] && ! empty( $_POST['ghostpool_action'] ) && $_POST['ghostpool_action'] == 'ghostpool_submit_post' ) {
					
				// Check all required fields are filled in
				if ( trim( $_POST['ghostpool_post_title'] ) === '' ) {
					$has_error = true;
				}

				if ( isset( $_POST['ghostpool_post_username'] ) && trim( $_POST['ghostpool_post_username'] ) === '' && ! is_user_logged_in() ) {
					$has_error = true;
				}

				if ( isset( $_POST['ghostpool_post_email'] ) && trim( $_POST['ghostpool_post_email'] ) === '' && ! is_user_logged_in() && ! is_email( $_POST['ghostpool_post_email'] ) ) {
					$has_error = true;
				}

				if ( isset( $_POST['ghostpool_post_user_rating'] ) && ( trim( $_POST['ghostpool_post_user_rating'] ) === '' OR $_POST['ghostpool_post_user_rating'] < 1 OR $_POST['ghostpool_post_user_rating'] > ghostpool_option( 'rating_number' ) OR ! is_numeric( $_POST['ghostpool_post_user_rating'] ) ) ) {
					$has_error = true;
				}
	
				if ( ghostpool_option( 'post_submission_categories' ) == 'enabled' && isset( $_POST['ghostpool_post_categories'] ) && trim( $_POST['ghostpool_post_categories'] ) === '' ) {
					$has_error = true;
				} elseif ( ghostpool_option( 'post_submission_categories' ) == 'disabled' ) {
					$_POST['ghostpool_post_categories'] = '';
				}

				if ( ghostpool_option( 'post_submission_formats' ) == 'enabled' && isset( $_POST['ghostpool_post_formats'] ) && trim( $_POST['ghostpool_post_formats'] ) === '' ) {
					$has_error = true;
				} elseif ( ghostpool_option( 'post_submission_formats' ) == 'disabled' ) {
					$_POST['ghostpool_post_formats'] = '';	
				}	
										
				if ( isset( $_POST['ghostpool_post_content'] ) && trim( $_POST['ghostpool_post_content'] ) === '' ) {
					$has_error = true;
				}

				if ( isset( $_POST['ghostpool_post_toc'] ) && $_POST['ghostpool_post_toc'] != 1 ) {
					$has_error = true;
				}
				
				$captcha = ghostpool_captcha();
				if ( $captcha && $captcha['reason'] != '' ) {
					$has_error = true;
				}	
	
				// If all required fields are valid submit form	
				if ( $has_error == false ) {
		
					global $wpdb;
	
					// Approve or pending submitted post
					if ( ghostpool_option( 'post_submission_status' ) == 'approved' ) {
						$post_status = 'publish';
					} else {
						$post_status = 'pending';
					}
		
					// Create post
					$new_post = array(
						'post_type'     => 'post',
						'post_status'   => $post_status,
						'post_title'    => $_POST['ghostpool_post_title'],
						'post_content'  => $_POST['ghostpool_post_content'],
						'post_category' => array( $_POST['ghostpool_post_categories'] ),
						'tags_input'    => array( $_POST['ghostpool_post_tags'] ),
					);
			
					$new_post = apply_filters( 'ghostpool_post_submission_query', $new_post, $post_status );
			
					$post_id = wp_insert_post( $new_post );
					wp_set_post_terms( $post_id, $_POST['ghostpool_post_formats'], 'post_format' );
			
					// Associate with hub page
					if ( isset( $_GET['hub_id'] ) ) {
						update_post_meta( $post_id, 'ghostpool_hub_page_id', $_GET['hub_id'] );
						update_post_meta( $post_id, 'template', 'gp-user-review-post' );
					}
		
					// Add rating custom field
					update_post_meta( $post_id, 'ghostpool_site_rating', $_POST['ghostpool_post_user_rating'] );
						
					// Upload featured image
					if ( ! empty( $_FILES ) ) {
						foreach ( $_FILES as $file => $array ) {
							$newupload = ghostpool_insert_attachment( $file, $post_id );
						}
					}
		
					// Add name field
					if ( isset( $_POST['ghostpool_post_username'] ) && ! is_user_logged_in() ) {
						update_post_meta( $post_id, 'ghostpool_post_submission_username', $_POST['ghostpool_post_username'] );	
					}

					// Add email field
					if ( is_user_logged_in() ) {			
						$author_id = get_post_field( 'post_author', $post_id );
						$_POST['ghostpool_post_email'] = get_the_author_meta( 'user_email', $author_id );
					}	
					update_post_meta( $post_id, 'ghostpool_post_submission_email', $_POST['ghostpool_post_email'] );	

					// Add rating to user average rating
					/*if ( ghostpool_option( 'post_submission_add_to_user_average' ) == 'enabled' && ghostpool_option( 'post_submission_status' ) == 'approved' ) {
		
						// Get user rating and position from post submission form
						$added_rating = floatval( $_POST['ghostpool_post_user_rating'] );
						$added_position = floatval( $_POST['ghostpool_post_user_rating'] * apply_filters( 'ghostpool_custom_rating_width', 23.3 ) );

						// Current values
						$current_position = get_post_meta( $_GET['hub_id'], 'ghostpool_current_position', true );
						if ( ! $current_position ) {
							$current_position = 0;
						}
						$user_rating = get_post_meta( $_GET['hub_id'], 'ghostpool_user_rating', true );
						if ( ! $user_rating ) {
							$user_rating = 0;
						}
						$user_votes = (int) get_post_meta( $_GET['hub_id'], 'ghostpool_user_votes', true );
						if ( ! $user_votes ) {
							$user_votes = 0;
						}
						$user_sum = get_post_meta( $_GET['hub_id'], 'ghostpool_user_sum', true );
						if ( ! $user_sum && $user_rating && $user_votes ) {
							$user_sum = ( $user_rating * $user_votes );
						} elseif ( ! $user_sum ) {
							$user_sum = 0;
						} 

						// New values
						$new_user_sum = $user_sum + $added_rating;
						$new_position = ( $current_position * $user_votes + $added_position ) / ( $user_votes + 1 ) ;
						$new_user_votes = $user_votes + 1;
						$new_user_rating = number_format( ( $new_user_sum ) / ( $new_user_votes ), 1 ) + 0;
							
						// Update post/user meta with new values
						update_post_meta( $_GET['hub_id'], 'ghostpool_user_sum', $new_user_sum, $user_sum );
						update_post_meta( $_GET['hub_id'], 'ghostpool_current_position', $new_position, $current_position );
						update_post_meta( $_GET['hub_id'], 'ghostpool_user_rating', $new_user_rating, $user_rating );
						update_post_meta( $_GET['hub_id'], 'ghostpool_user_votes', $new_user_votes, $user_votes );
			
						if ( is_user_logged_in() ) {
							add_user_meta( get_current_user_id(), 'ghostpool_rated_' . $_GET['hub_id'], 'rated' );
							add_user_meta( get_current_user_id(), 'ghostpool_user_rating_' . $_GET['hub_id'], $added_rating );
							add_user_meta( get_current_user_id(), 'ghostpool_current_position_' . $_GET['hub_id'], $added_position );
						}
			
					}*/
													
					// Notify admin of post via email
					if ( $post_status == 'pending' && ghostpool_option( 'post_submission_email_notification' ) != 'disabled' ) {
						if ( $_POST['ghostpool_post_username'] != '' ) {
							$author = $_POST['ghostpool_post_username'];
						} else {
							$author_id = get_post_field( 'post_author', $post_id );
							$author = get_the_author_meta( 'display_name', $author_id );
						}
						$to = get_option( 'admin_email' );
						$subject = esc_html__( 'Post [submitted]: ', 'huber' ) . "'" . esc_attr( $_POST['ghostpool_post_title'] ) . "' - " . get_bloginfo( 'name' );
						$message = esc_html__( 'A post was submitted on ', 'huber' ) . get_bloginfo( 'name' ) . "\r\n\r\n";
						$message .= esc_html__( 'Title: ', 'huber' ) . esc_attr( $_POST['ghostpool_post_title'] ) . "\n";
						$message .= esc_html__( 'Author: ', 'huber' ) . esc_attr( $author ) . " (" . sanitize_email( $_POST['ghostpool_post_email'] ) . ")\r\n\r\n";
						$message .= esc_html__( 'You can view this post at ', 'huber' ) . esc_url( get_permalink( $post_id ) );
						$headers = '';
						if ( function_exists( 'ghostpool_wp_mail' ) ) { 
							ghostpool_wp_mail( $to, $subject, $message, $headers );				
						}			
					}
			
					if ( get_option( 'permalink_structure' ) ) {
						$permalink_structure = '?';
					} else { 
						$permalink_structure = '&';
					}
			
					wp_redirect( get_permalink( ghostpool_option( 'post_submission_page' ) ) . $permalink_structure . 'post_submission=1&post_submitted=1&post_id=' . $post_id . '&_wpnonce=' . wp_create_nonce( 'ghostpool_post_submission_action' ) );
		
					exit;
	
				}
	
			}

		}
		
	} 
}	
add_action( 'init', 'ghostpool_post_submission' ); ?>