<?php if ( ! function_exists( 'ghostpool_post_loop_minimal' ) ) {
	function ghostpool_post_loop_minimal( $format = '', $image_size_standard = '', $image_size_hub = '', $image_size_review = '', $image_size_preview = '', $excerpt_length = '', $meta_release_date = '', $meta_author = '', $meta_date = '', $meta_comment_count = '', $meta_views = '', $meta_likes = '', $meta_followers = '', $meta_cats = '', $meta_tags = '', $meta_hub_fields = '',	$meta_site_rating = '', $meta_user_rating = '', $read_more_link = '', $counter = '', $ranking = '', $ranking_counter = '', $per_page = '' ) { ?>

		<?php if ( $counter % $per_page == 1 OR $counter == 1 ) { ?>
			<div class="gp-large-post">
		<?php } ?>

			<section <?php post_class( 'gp-post-item ' . get_post_meta( get_the_ID(), 'template', true ) ); ?>>

				<?php if ( has_post_thumbnail() && ( $counter % $per_page == 1 OR $counter == 1 ) ) { ?>
					<div class="gp-post-thumbnail gp-loop-featured">
						<a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo get_post_meta( get_the_ID(), 'link_target', true ); ?>"<?php } ?>>
							
							<?php if ( get_post_meta( get_the_ID(), 'template', true ) == 'gp-hub-post' ) {
					
								if ( $image_size_hub != 'default' ) { 										
									if ( function_exists( 'kdmfi_get_featured_image_id' ) && kdmfi_has_featured_image( 'ghostpool-featured-image-2' ) ) {
										kdmfi_the_featured_image( 'ghostpool-featured-image-2', $image_size_hub );
									} else {
										the_post_thumbnail( $image_size_hub ); 
									}
								} else {
									the_post_thumbnail( 'ghostpool-col-category-image' );	
								}
					
							} elseif ( get_post_meta( get_the_ID(), 'template', true ) == 'gp-review-post' OR get_post_meta( get_the_ID(), 'template', true ) == 'gp-user-review-post' ) {
					
								if ( $image_size_review != 'default'  ) {
									if ( function_exists( 'kdmfi_get_featured_image_id' ) && kdmfi_has_featured_image( 'ghostpool-featured-image-2' ) ) {
										kdmfi_the_featured_image( 'ghostpool-featured-image-2', $image_size_review );
									} else {
										the_post_thumbnail( $image_size_review ); 
									}
								} else {
									the_post_thumbnail( 'ghostpool-col-category-image' );	
								}
															
							} elseif ( get_post_meta( get_the_ID(), 'template', true ) == 'gp-preview-post' ) {
					
								if ( $image_size_preview != 'default' ) {
									the_post_thumbnail( $image_size_preview );
								} else {
									the_post_thumbnail( 'ghostpool-col-category-image' );	
								}
						
							} else {
						
								if ( $image_size_standard != 'default' ) { 
									the_post_thumbnail( $image_size_standard );
								} else {
									the_post_thumbnail( 'ghostpool-col-category-image' );	
								}
					
							} ?>
					
						</a>					
					</div>
				<?php } ?>
		
				<div class="gp-minimal-content">
					
					<?php if ( $ranking == 'gp-ranking' && $ranking_counter > 0 ) { ?>
						<div class="gp-ranking-counter"><?php echo absint( $ranking_counter ); ?></div>
					<?php } ?>	

					<div class="gp-loop-content">	

						<h2 class="gp-loop-title"><a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo get_post_meta( get_the_ID(), 'link_target', true ); ?>"<?php } ?>><?php the_title(); ?></a></h2>

						<?php if ( $excerpt_length != '0' ) { ?>
							<div class="gp-loop-text">
								<p><?php echo ghostpool_excerpt( $excerpt_length, $read_more_link ); ?></p>
							</div>
						<?php } ?>

						<?php ghostpool_loop_meta(
							$meta_release_date,
							$meta_author,
							$meta_date,
							$meta_comment_count,
							$meta_views,
							$meta_likes,
							$meta_followers,
							$meta_cats,
							$meta_hub_fields
						); ?>

						<?php if ( $meta_tags ) { the_tags( '<div class="gp-loop-tags">', ' ', '</div>' ); } ?>

					</div>

					<span class="gp-loop-ratings">
						<?php if ( $meta_site_rating == '1' ) {
							get_template_part( 'lib/sections/taxonomies/loop-site-rating' ); 
						} 	
						if ( $meta_user_rating == '1' ) {
							get_template_part( 'lib/sections/taxonomies/loop-user-rating' ); 
						} ?>
					</span>
		
					<?php if ( ghostpool_site_rating() ) { ?>
						<div class="gp-rating-bg<?php echo ghostpool_rating_color( ghostpool_site_rating() ); ?>"></div>				
					<?php } elseif ( get_post_meta( get_the_ID(), 'ghostpool_user_rating', true ) >=1 ) { ?>
						<div class="gp-rating-bg<?php echo ghostpool_rating_color( get_post_meta( get_the_ID(), 'ghostpool_user_rating', true ) ); ?>>"></div>
					<?php } else { ?>
						<div class="gp-rating-bg"></div>
					<?php } ?>
						
					<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id(), apply_filters( 'ghostpool_minimal_format_bg_image_size', 'ghostpool-col-category-image' ) ); 
					if ( $image[0] ) { ?>
						<div class="gp-standard-bg" style="background-image: url(<?php echo esc_url( $image[0] ); ?>);"></div>
					<?php } ?>
						
				</div>
				
			</section>

		<?php if ( $counter % $per_page == 1 OR $counter == 1 ) { ?>
			</div>
		<?php } ?>

	<?php }

} ?>