<?php

/**
 * Deactivate Gauge/The Review plugins
 *
 */
function ghostpool_deactivate_old_plugins() {
	if ( is_plugin_active( 'the-review-plugin/index.php' ) ) {
		deactivate_plugins( 'the-review-plugin/index.php' );
	}
	if ( is_plugin_active( 'gauge-plugin/index.php' ) ) {
		deactivate_plugins( 'gauge-plugin/index.php' );
	}	
}	
add_action( 'admin_init', 'ghostpool_deactivate_old_plugins' );

/**
 * Set default option values for WordPress Social Login
 *
 */
if ( has_action( 'wordpress_social_login' ) && get_option( 'ghostpool_wp_social_defaults' ) !== '1' ) {
	function ghostpool_wp_social_defaults() {	
		update_option( 'wsl_settings_social_icon_set', 'none' );
	}	
	add_action( 'init', 'ghostpool_wp_social_defaults', 1 );	
	update_option( 'ghostpool_wp_social_defaults', '1' );		
}

/**
 * Set default option values for fresh MashShare plugin installations
 *
 */
function ghostpool_mashshare_set_defaults() {
	$settings = get_option( 'mashsb_settings', array() );
	// Skip if already set.
	if ( ! empty( $settings ) ) {
		return;
	}
	$defaults = array(
		'sharecount_title' => 'shares',
		'share_color' => '#fe4a49',
		'mashsharer_position' => 'manual',
		'responsive_buttons' => '1',
		'button_margin' => '1',
		'loadall' => '1',
		'visible_services' => '2',
		'networks' => array(
			'0' => '1',
			'1' => '1',
			'2' => '1',
		),
	);
	update_option( 'mashsb_settings', $defaults );
}
add_action( 'init', 'ghostpool_mashshare_set_defaults', 1 );	

?>