<?php
									
/**
 * Pagination numbers/load more
 *
 */	
if ( ! function_exists( 'ghostpool_pagination' ) ) {
	function ghostpool_pagination( $query, $pagination = 'disabled' ) {
		
		$big = 999999999;
		
		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}
		
		if ( $query > 1 && $pagination != 'disabled' ) {
		
			$output = '';
			
			if ( $pagination == 'load-more' ) {
				$output .= '<div class="gp-load-more">
					<div class="gp-load-more-button button">' . esc_html__( 'Load More', 'huber' ) . '</div>';
			}
							
				$output .= '<div class="gp-pagination gp-pagination-numbers gp-standard-pagination">' . paginate_links( array(
					'base'      => str_replace( $big, '%#%', get_pagenum_link( $big, false ) ),
					'format'    => '?paged=%#%',
					'current'   => max( 1, $paged ),
					'total'     => $query,
					'type'      => 'list',
					'prev_text' => '',
					'next_text' => '',
					'end_size'  => 1,
					'mid_size'  => 1, 
				) ) . '</div>';
			
			if ( $pagination == 'load-more' ) {
				$output .= '</div>';
			}
			
			return $output;
				
		}
	}
}

/**
 * Pagination arrows
 *
 */	
if ( ! function_exists( 'ghostpool_pagination_arrows' ) ) {
	function ghostpool_pagination_arrows( $max_page = 0 ) {
		
		global $paged;
		
		$output = '';
		
		if ( ! $paged ) {
			$paged = 1;
		}	
		
		$nextpage = intval( $paged ) - 1;
		if ( $nextpage < 1 ) {
			$nextpage = 1;
		}	
		if ( $paged > 1 ) {
			$output .= '<a href="#" data-pagelink="' . esc_attr( $nextpage ) . '" class="prev"></a>';
		} else {
			$output .= '<span class="prev gp-disabled"></span>';
		}

		$nextpage = intval( $paged ) + 1;
		if ( $max_page >= $nextpage ) {
			$output .= '<a href="#" data-pagelink="' . esc_attr( $nextpage ) . '" class="next"></a>';
		} else {
			$output .= '<span class="next gp-disabled"></span>';
		}
		
		return $output;
		
	}
}

/**
 * Previous/next post navigation
 *
 */	
if ( ! function_exists( 'ghostpool_post_navigation' ) ) {
	function ghostpool_post_navigation() {
	
		// Get prev/next post IDs						
		$prev_post = get_adjacent_post( false, '', true );
		$next_post = get_adjacent_post( false, '', false );

		$post_nav = '';

		// Add prev/next post links
		if ( $prev_post ) { 		        
			$post_nav .= '<a href="' . get_permalink( $prev_post->ID ) . '" title="' . esc_attr( $prev_post->post_title ) . '" class="gp-prev-link" rel="prev"><span class="gp-post-link-header">' . esc_html__( 'Previous Article', 'huber' ) . '</span><span class="gp-post-link-title">' . get_the_title( $prev_post->ID ) . '</span></a>';
		}

		if ( $next_post ) { 		        
			$post_nav .= '<a href="' . get_permalink( $next_post->ID ) . '" title="' . esc_attr( $next_post->post_title ) . '" class="gp-next-link" rel="next"><span class="gp-post-link-header">' . esc_html__( 'Next Article', 'huber' ) . '</span><span class="gp-post-link-title">' . get_the_title( $next_post->ID ) . '</span></a>';
		}
		
		if ( $prev_post OR $next_post ) { 		
			return '<div id="gp-post-navigation">' . $post_nav . '</div>';
		} else {
			return '';
		}	

	}
}

/**
 * Post pagination <!--nextpage-->
 *
 */
function ghostpool_add_next_and_number( $args ) {
    if ( $args['next_or_number'] == 'ghostpool_next_and_number' ) {
        global $page, $numpages, $multipage, $more, $pagenow;
        $prev = '';
        $next = '';
        $page_count = '';
        if ( $multipage ) {
            if ( $more ) {
                $i = $page - 1;
                if ( $i && $more ) {
                    $prev .= _wp_link_page( $i );
                    $prev .= '<span class="gp-previous-page">' . esc_html__( 'Previous', 'huber' ) . '</span>' . '</a>';
                }
                $i = $page + 1;
                if ( $i <= $numpages && $more ) {
                    $next .= _wp_link_page( $i );
                    $next .= '<span class="gp-next-page">' . esc_html__( 'Next', 'huber' ) . '</span>' . '</a>';
                }
            }
            $page_count = '<span class="gp-page-count">' . esc_html__( 'Page', 'huber' ) . ' ' . $page . ' ' . esc_html__( 'of', 'huber' ) . ' ' . $numpages . '</span>';
        }
        $args['before'] = $args['before'] . $prev . $page_count;
        $args['after'] = $next . $args['after'];    
    }
    return $args;
}
add_filter( 'wp_link_pages_args','ghostpool_add_next_and_number' );

/**
 * Custom wp_title
 *
 */
if ( function_exists( 'wpseo_auto_load' ) ) {
	if ( ! function_exists( 'ghostpool_custom_wpseo_title' ) ) {
		function ghostpool_custom_wpseo_title( $title ) { 

			global $wp_query;	

			// Tab Parameters
			$reviews_tab_parameter = ghostpool_option( 'reviews_tab_parameter' );
			$previews_tab_parameter = ghostpool_option( 'previews_tab_parameter' );
			$news_tab_parameter = ghostpool_option( 'news_tab_parameter' );
			$images_tab_parameter = ghostpool_option( 'images_tab_parameter' );
			$videos_tab_parameter = ghostpool_option( 'videos_tab_parameter' );
			$forums_tab_parameter = ghostpool_option( 'forums_tab_parameter' );
	
			if ( ! function_exists( 'ghostpool_change_wpseo_title' ) ) {
				function ghostpool_change_wpseo_title( $tab_title = '', $title = '' ) {
					$wpseo_titles = get_option( 'wpseo_titles' );
					$sep_options = WPSEO_Option_Titles::get_instance()->get_separator_options();
					if ( isset( $wpseo_titles['separator'] ) && isset( $sep_options[$wpseo_titles['separator']] ) ) {
						$sep = $sep_options[$wpseo_titles['separator']];
					} else {
						$sep = '-';
					}
					$sep_position = strrpos( $title, $sep );
					$new_title = mb_substr( $title, 0, (int) $sep_position ) . $tab_title . ' ' . mb_substr( $title, (int) $sep_position );	
					return esc_attr( $new_title );
				}	
			}
	
			if ( isset( $wp_query->query[$reviews_tab_parameter] ) ) {
			
				return ghostpool_change_wpseo_title( ghostpool_option( 'reviews_tab_page_title' ), $title );	

			} elseif ( isset( $wp_query->query[$previews_tab_parameter] ) ) {		
			
				return ghostpool_change_wpseo_title( ghostpool_option( 'previews_tab_page_title' ), $title );
							
			} elseif ( isset( $wp_query->query[$news_tab_parameter] ) ) {		
			
				 return ghostpool_change_wpseo_title( ghostpool_option( 'news_tab_page_title' ), $title );	
				 
			} elseif ( isset( $wp_query->query[$images_tab_parameter] ) ) {		
			
				return ghostpool_change_wpseo_title( ghostpool_option( 'images_tab_page_title' ), $title );	
				
			} elseif ( isset( $wp_query->query[$videos_tab_parameter] ) ) {		
			
				return ghostpool_change_wpseo_title( ghostpool_option( 'videos_tab_page_title' ), $title );	
		
			} elseif ( isset( $wp_query->query[$forums_tab_parameter] ) ) {		
			
				return ghostpool_change_wpseo_title( ghostpool_option( 'forums_tab_page_title' ), $title );	
			
			/*} elseif ( get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) ) {	
			
				$a_post_id = get_hub_association_id( get_the_ID() );
				
				if ( get_post_meta( $a_post_id, 'custom_title', true ) ) { 
					$page_title = get_post_meta( $a_post_id, 'custom_title', true ); 
				} else { 
					$page_title = get_the_title( $a_post_id ); 
				}

				return ghostpool_change_wpseo_title( $page_title, $title );*/

			} else {	
			
				$custom_tabs = ghostpool_option( 'global_custom_tabs' );
			
				if ( $custom_tabs ) {
					
					foreach( $custom_tabs as $custom_tab ) {
		
						preg_match_all( "/(.*):/", $custom_tab, $matches );
						$endpoint = isset( $matches[1][0] ) ? $matches[1][0] : $custom_tab;

						if ( isset( $wp_query->query[$endpoint] ) ) {							
							$page = get_posts( array( 
								'name' => $endpoint,
								'post_type' => 'any',
							) );
							break;
						}
						
					}
					if ( isset( $page[0]->post_title ) ) {
						return ghostpool_change_wpseo_title( $page[0]->post_title, $title );
					} else {
						return $title;
					}
					
				} else {
				
					return $title;
				}	
				
			}
			
		}
	}
	add_filter( 'wpseo_title', 'ghostpool_custom_wpseo_title', 10, 1 ); 
}

/**
 * Custom next and prev rel links
 *
 */
if ( function_exists( 'wpseo_auto_load' ) ) {
	if ( ! function_exists( 'ghostpool_rel_prev_next' ) ) {
		function ghostpool_rel_prev_next() {
			
			if ( is_single() OR is_page() ) {
			
				global $paged, $wp_query;	
		
				// Tab Parameters
				$reviews_tab_parameter = ghostpool_option( 'reviews_tab_parameter' );
				$previews_tab_parameter = ghostpool_option( 'previews_tab_parameter' );
				$news_tab_parameter = ghostpool_option( 'news_tab_parameter' );
				$images_tab_parameter = ghostpool_option( 'images_tab_parameter' );
				$videos_tab_parameter = ghostpool_option( 'videos_tab_parameter' );
				$forums_tab_parameter = ghostpool_option( 'forums_tab_parameter' );
		
				$custom_query = false;

				if ( is_page_template( 'blog-template.php' ) ) {
		
					$custom_query = true;
			
					$args = array(
						'post_status' 	      => 'publish',
						'post_type'           => implode( ',', ghostpool_option( 'blog_post_types' ) ),
						ghostpool_cats( ghostpool_option( 'blog_cats' ), 'param' ) => ghostpool_cats( ghostpool_option( 'blog_cats' ), 'variables' ),
						'orderby'             => ghostpool_orderby( ghostpool_option( 'blog_orderby' ), 'orderby' ),
						'order'               => ghostpool_orderby( ghostpool_option( 'blog_orderby' ), 'order' ),
						'meta_key'            => ghostpool_orderby( ghostpool_option( 'blog_orderby' ), 'meta_key' ),
						'posts_per_page'      => ghostpool_option( 'blog_per_page' ),
					);	

				} elseif ( isset( $wp_query->query[$reviews_tab_parameter] ) ) {		
			
					$custom_query = true;
					
					$args = array(
						'post_status'    => 'publish',
						'post_type'      => array( 'post', 'page' ),		
						'orderby'        => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'orderby' ),
						'order'          => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'order' ),
						'meta_key'       => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'meta_key' ),
						'meta_query' 	 => array( 
							'relation' => 'AND', 
							array(
								'relation' => 'OR', 
								array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', get_the_ID() ), 'compare' => 'LIKE' ),
								array( 'key' => 'hub_association_ids', 'value' => get_the_ID(), 'compare' => '=' ),
							),	
							array( 'key' => 'template', 'value' => 'gp-review-post', 'compare' => '=' ),
						),
						'posts_per_page' => ghostpool_option( 'reviews_tab_per_page' ),
						'paged'          => ghostpool_paged(),
						'ignore_sticky_posts' => 1,
					);

				} elseif ( isset( $wp_query->query[$previews_tab_parameter] ) ) {		
			
					$custom_query = true;
			
					$args = array(
						'post_status'    => 'publish',
						'post_type'      => array( 'post', 'page' ),		
						'orderby'        => ghostpool_orderby( ghostpool_option( 'previews_tab_orderby' ), 'orderby' ),
						'order'          => ghostpool_orderby( ghostpool_option( 'previews_tab_orderby' ), 'order' ),
						'meta_key'       => ghostpool_orderby( ghostpool_option( 'previews_tab_orderby' ), 'meta_key' ),
						'meta_query' 	 => array( 
							'relation' => 'AND', 
							array(
								'relation' => 'OR', 
								array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', get_the_ID() ), 'compare' => 'LIKE' ),
								array( 'key' => 'hub_association_ids', 'value' => get_the_ID(), 'compare' => '=' ),
							),	
							array( 'key' => 'template', 'value' => 'gp-preview-post', 'compare' => '=' ),
						),
						'posts_per_page' => ghostpool_option( 'previews_tab_per_page' ),
						'paged'          => ghostpool_paged(),
						'ignore_sticky_posts' => 1,
					);
							
				} elseif ( isset( $wp_query->query[$news_tab_parameter] ) ) {		
			
					$custom_query = true;
			
					$args = array(
						'post_status' => 'publish',
						'post_type' => 'post',
						'tax_query' => array(
							'relation' => 'OR',
							array(
								'taxonomy' => 'post_format',
								'field' => 'slug',
								'terms' => array( 'post-format-video' ),
								'operator' => 'NOT IN',
							)			
						),		
						'orderby'        => ghostpool_orderby( ghostpool_option( 'news_tab_orderby' ), 'orderby' ),
						'order'          => ghostpool_orderby( ghostpool_option( 'news_tab_orderby' ), 'order' ),
						'meta_key'       => ghostpool_orderby( ghostpool_option( 'news_tab_orderby' ), 'meta_key' ),
						'meta_query' 	 => array( 
							'relation' => 'AND', 
							array(
								'relation' => 'OR', 
								array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', get_the_ID() ), 'compare' => 'LIKE' ),
								array( 'key' => 'hub_association_ids', 'value' => get_the_ID(), 'compare' => '=' ),
							),
							array( 'key' => 'template', 'value' => 'gp-standard-post', 'compare' => '=' ),
						),
						'posts_per_page' => ghostpool_option( 'news_tab_per_page' ),
						'paged'          => ghostpool_paged(),
						'ignore_sticky_posts' => 1,
					);
		
				} elseif ( isset( $wp_query->query[$videos_tab_parameter] ) ) {		
				
					$custom_query = true;
			
					$args = array(
						'post_status' => 'publish',
						'post_type' => 'post',
						'tax_query' => array(
							'relation' => 'OR',
							array(
								'taxonomy' => 'post_format',
								'field' => 'slug',
								'terms' => array( 'post-format-video' ),
							)			
						),		
						'orderby'        => ghostpool_orderby( ghostpool_option( 'videos_tab_orderby' ), 'orderby' ),
						'order'          => ghostpool_orderby( ghostpool_option( 'videos_tab_orderby' ), 'order' ),
						'meta_key'       => ghostpool_orderby( ghostpool_option( 'videos_tab_orderby' ), 'meta_key' ),
						'meta_query' 	 => array( 
							'relation' => 'OR', 
							array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', get_the_ID() ), 'compare' => 'LIKE' ),
							array( 'key' => 'hub_association_ids', 'value' => get_the_ID(), 'compare' => '=' ),
						),
						'posts_per_page' => ghostpool_option( 'videos_tab_per_page' ),
						'paged'          => ghostpool_paged(),
						'ignore_sticky_posts' => 1,
					);
			
				} elseif ( get_post_meta( get_the_ID(), 'template', true ) == 'gp-hub-post' ) {
		
					$custom_query = true;
			
					$args = array(
						'post_status'  => 'publish',
						'post_type'    => 'post',
						'orderby'      => ghostpool_orderby( ghostpool_option( 'hub_tab_orderby' ), 'orderby' ),
						'order'        => ghostpool_orderby( ghostpool_option( 'hub_tab_orderby' ), 'order' ),
						'meta_key'     => ghostpool_orderby( ghostpool_option( 'hub_tab_orderby' ), 'meta_key' ),
						'meta_query'   => array( 
							'relation' => 'AND', 
							array(
								'relation' => 'OR', 
								array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', get_the_ID() ), 'compare' => 'LIKE' ),
								array( 'key' => 'hub_association_ids', 'value' => get_the_ID(), 'compare' => '=' ),
							),
						),
						'posts_per_page' => ghostpool_option( 'hub_tab_per_page' ),
						'paged'          => ghostpool_paged(),
						'ignore_sticky_posts' => 1,
					);

				}
		
				if ( $custom_query == true ) {

					// Contains query data
					$query = new WP_Query( $args );
		
					// Get maximum pages from query
					$max_page = $query->max_num_pages;
		
					if ( ! $paged ) {
						$paged = 1;
					}
	
					// Prev rel link
					$prevpage = intval( $paged ) - 1;
					if ( $prevpage < 1 ) {
						$prevpage = 1;
					}	
					if ( $paged > 1 ) {
						echo '<link rel="prev" href="' . get_pagenum_link( $prevpage ) . '">';
					}
	
					// Next rel link
					$nextpage = intval( $paged ) + 1;	
					
					if ( $max_page >= $nextpage ) {
						echo '<link rel="next" href="' . get_pagenum_link( $nextpage ) . '">';
					}

					// Meta noindex,follow on paginated page templates
					if ( $paged > 1 ) {
						echo '<meta name="robots" content="noindex,follow">';
					}
		
				}

			}
							
		}
	}
	add_action( 'wp_head', 'ghostpool_rel_prev_next' );
}

/**
 * Custom canonical rel link
 *
 */
if ( function_exists( 'wpseo_auto_load' ) ) {
	if ( ! function_exists( 'ghostpool_canonical_link' ) ) {	
		function ghostpool_canonical_link( $canonical ) {
	
			global $paged, $wp_query;
		
			// Tab Parameters
			$reviews_tab_parameter = ghostpool_option( 'reviews_tab_parameter' );
			$previews_tab_parameter = ghostpool_option( 'previews_tab_parameter' );
			$news_tab_parameter = ghostpool_option( 'news_tab_parameter' );
			$images_tab_parameter = ghostpool_option( 'images_tab_parameter' );
			$videos_tab_parameter = ghostpool_option( 'videos_tab_parameter' );
			$forums_tab_parameter = ghostpool_option( 'forums_tab_parameter' );

			// Paged number
			if ( ! $paged ) {
				$paged = '';
			}

			// Permalink structure for tab URls
			if ( ! get_option( 'permalink_structure' ) ) {
				$permalink_structure = '&';
			}  else {
				$permalink_structure = '';
			}
		
			// Paged structure for tab URLs
			if ( ! get_option( 'permalink_structure' ) ) {
				if ( $paged != '' ) {
					$page_url_structure = '&paged=';
				} else {
					$page_url_structure = '';
				}
			}  else {
				if ( $paged != '' ) {
					$page_url_structure = 'page/';
				} else {
					$page_url_structure = '/';
				}
			}

			if ( is_page_template( 'blog-template.php' ) ) {

				return get_pagenum_link( $paged );
	
			} elseif ( isset( $wp_query->query[$reviews_tab_parameter] ) ) {		
					
				return get_permalink() . $permalink_structure . $reviews_tab_parameter . $page_url_structure . $paged;
		
			} elseif ( isset( $wp_query->query[$previews_tab_parameter] ) ) {		
			
				return get_permalink() . $permalink_structure . $previews_tab_parameter . $page_url_structure . $paged;	
							
			} elseif ( isset( $wp_query->query[$news_tab_parameter] ) ) {		
			
				 return get_permalink() . $permalink_structure . $news_tab_parameter . $page_url_structure . $paged;
		
			} elseif ( isset( $wp_query->query[$images_tab_parameter] ) ) {		
			
				return get_permalink() . $permalink_structure . $images_tab_parameter;		
		
			} elseif ( isset( $wp_query->query[$videos_tab_parameter] ) ) {		
			
				return get_permalink() . $permalink_structure . $videos_tab_parameter . $page_url_structure . $paged;
			
			} elseif ( isset( $wp_query->query[$forums_tab_parameter] ) ) {		
			
				return get_permalink() . $permalink_structure . $forums_tab_parameter;
		
			} elseif ( is_singular() && get_post_meta( get_the_ID(), 'template', true ) == 'gp-hub-post' ) {	
		
				if ( $paged == '' ) { $page_url_structure = ''; }
				
				return get_permalink() . $page_url_structure . $paged;		
		
			} else {
		
				return $canonical;
			
			}
			
		}
	}	
	add_filter( 'wpseo_canonical', 'ghostpool_canonical_link' );
}

?>