<?php if ( ! function_exists( 'ghostpool_page_title' ) ) {

	function ghostpool_page_title( $post_id = '', $type = 'gp-standard-page-header' ) {

		if ( $type == 'gp-standard-page-header' OR $type == 'gp-first-post-page-header' && ( ! function_exists( 'bp_is_active' ) OR ( function_exists( 'bp_is_active' ) && ! bp_is_user() && ! bp_is_group_single() ) ) ) { 
		
			// Category header color							
			$term_data = null;
			if ( isset( get_queried_object()->term_id ) ) {
				$term_id = get_queried_object()->term_id;
				$term_data = get_option( "taxonomy_$term_id" );
				if ( isset( $term_data['color'] ) )  {
					$bg_color_css = 'background-color: ' . $term_data['color'] . ';';
				} else {
					$bg_color_css = '';
				}
			} else {
				$bg_color_css = '';
			}
		
			?>

				<header id="gp-page-title"<?php if ( ghostpool_option( 'theme_layout' ) == 'gp-boxed-layout' ) { ?> class="gp-container"<?php } ?><?php if ( $bg_color_css ) { ?> style="<?php echo esc_attr( $bg_color_css ); ?>"<?php } ?>>

					<div class="gp-container">
											
						<?php ghostpool_breadcrumbs(); ?>
		
						<h1>
							<?php if ( is_category() OR is_tag() OR is_tax() ) { ?>
								
								<?php single_cat_title(); ?>
								
							<?php } elseif ( is_search() ) { ?>
								
								<?php if ( isset( $_GET['s'] ) && ( $_GET['s'] != '' ) ) { ?>
									<?php esc_html_e( 'search results for', 'huber' ); ?> "<?php echo get_search_query(); ?>"
								<?php } else { ?>
									<?php esc_html_e( 'Search', 'huber' ); ?>
								<?php } ?>
								
							<?php } elseif ( isset( $_GET['post_submission'] ) && $_GET['post_submission'] == 1 ) { ?>
								
								<?php if ( ghostpool_option( 'post_submission_page_title' ) ) { echo esc_attr( ghostpool_option( 'post_submission_page_title' ) ); } ?>

							<?php } elseif ( isset( $_GET['post_edit'] ) && $_GET['post_edit'] == 1 ) { ?>
								
								<?php if ( ghostpool_option( 'post_edit_page_title' ) ) { echo esc_attr( ghostpool_option( 'post_edit_page_title' ) ); } ?>							
								
							<?php } elseif ( isset( $_GET['post_preview'] ) && $_GET['post_preview'] == 1 ) { ?>
								
								<?php if ( ghostpool_option( 'post_preview_page_title' ) ) { echo esc_attr( ghostpool_option( 'post_preview_page_title' ) ); } ?>
												
							<?php } elseif ( is_singular() OR ( function_exists( 'is_bbpress' ) && bbp_is_forum_archive() ) OR ( function_exists( 'is_woocommerce' ) && is_shop() ) ) { 
										
								// Get WooCommerce shop page ID 
								if ( function_exists( 'is_woocommerce' ) && is_shop() ) {
									$post_id = get_option( 'woocommerce_shop_page_id' );
								} ?>
								
								<?php if ( ghostpool_option( 'custom_title' ) ) { echo esc_attr( ghostpool_option( 'custom_title' ) ); } else { echo get_the_title( $post_id ); } ?>
								
							<?php } elseif ( is_archive() ) { ?>
							
								<?php if ( ! function_exists( '_wp_render_title_tag' ) && ! function_exists( 'ghostpool_render_title' ) ) { 
									echo apply_filters( 'ghostpool_archives_title', esc_html__( 'Archives', 'huber' ) ); 
								} else { 
									echo apply_filters( 'ghostpool_archives_title', get_the_archive_title() );
								} ?>
							
							<?php } elseif ( is_front_page() ) { ?>
					
								<?php echo apply_filters( 'ghostpool_blog_title', esc_html__( 'Blog', 'huber' ) ); ?>

							<?php } else { ?>
						
								<?php wp_title( '' ); ?>
							
							<?php } ?>
							
						</h1>	
					
						<?php if ( category_description() != '' ) { ?>
							<h2 id="gp-page-title-subtitle"><?php echo str_replace( array( '<p>', '</p>' ), '', category_description() ); ?></h2>
						<?php } elseif ( is_author() && get_the_author_meta( 'description', get_query_var( 'author' ) ) ) { ?>
							<h2 id="gp-page-title-subtitle"><?php echo get_the_author_meta( 'description', get_query_var( 'author' ) ); ?></h2>
						<?php } elseif ( is_singular() && ghostpool_option( 'subtitle' ) ) { ?>
							<h2 id="gp-page-title-subtitle"><?php echo esc_attr( ghostpool_option( 'subtitle' ) ); ?></h2>
						<?php } ?>

					</div>
			
				</header>		
		
		<?php } 
	}		
} ?>