<?php

require_once( get_template_directory() . '/lib/inc/post-loop.php' );
require_once( get_template_directory() . '/lib/inc/post-loop-minimal.php' );
require_once( get_template_directory() . '/lib/inc/post-loop-showcase.php' );
		
/**
 * Loop meta
 *
 */
if ( ! function_exists( 'ghostpool_loop_meta' ) ) {	
	function ghostpool_loop_meta( $release_date = '', $author = '', $date = '', $comment_count = '', $views = '', $likes = '', $followers = '', $cats = '', $hub_fields = '' ) {

		if ( $release_date == 1 OR $author == 1 OR $date == 1 OR $comment_count == 1 OR $views == 1 OR $likes == 1 OR $followers == 1 OR $cats == 1 OR $hub_fields == 1 ) { ?>

			<div class="gp-loop-meta">
	
				<?php if ( $release_date == '1' && get_post_meta( get_the_ID(), 'release_date', true ) ) { ?>
					<span class="gp-post-meta gp-meta-release-date">
						<?php $new_release_date = date_i18n( 'U', strtotime( get_post_meta( get_the_ID(), 'release_date', true ) ) );
						if ( $new_release_date > date( 'U' ) ) {
							echo esc_attr( ghostpool_option( 'upcoming_date_text' ) ) . ': ';
						} else {
							echo esc_attr( ghostpool_option( 'release_date_text' ) ) . ': ';
						}
						echo date_i18n( ghostpool_option( 'release_date_format' ), strtotime( get_post_meta( get_the_ID(), 'release_date', true ) ) ); ?>
					</span>
				<?php } ?>
			
				<?php if ( $author == '1' ) { ?><span class="gp-post-meta gp-meta-author"><?php echo ghostpool_author_name( get_the_ID() ); ?></span><?php } ?>

				<?php if ( $date == '1' ) { ?>	
					<span class="gp-post-meta gp-meta-date"><a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo get_post_meta( get_the_ID(), 'link_target', true ); ?>"<?php } ?>><time itemprop="datePublished" datetime="<?php echo get_the_date( 'c' ); ?>"><?php the_time( get_option( 'date_format' ) ); ?></time></a></span>
				<?php } ?>

				<?php if ( $comment_count == '1' ) { ?><span class="gp-post-meta gp-meta-comments"><?php comments_popup_link( esc_html__( 'No Comments', 'huber' ), esc_html__( '1 Comment', 'huber' ), esc_html__( '% Comments', 'huber' ), 'comments-link', esc_html__( 'Comments Closed', 'huber' ) ); ?></span><?php } ?>
	
				<?php if ( function_exists( 'wpp_get_views' ) && $views == '1' ) { ?><span class="gp-post-meta gp-meta-views"><?php if ( function_exists( 'wpp_get_views' ) ) { echo wpp_get_views( get_the_ID() ); } ?> <?php esc_html_e( 'views', 'huber' ); ?></span><?php } ?>		
		
				<?php if ( $likes == '1' ) { ?>
					<span class="gp-post-meta gp-meta-likes"><?php echo ghostpool_voting_show_up_votes(); ?></span>
				<?php } ?>

				<?php if ( $followers == '1' ) { ?>
					<span class="gp-post-meta gp-meta-followers"><?php echo absint( get_post_meta( get_the_ID(), 'ghostpool_followers', true ) ); ?> <?php esc_html_e( 'followers', 'huber' ); ?></span>
				<?php } ?>
			
				<?php if ( $cats == '1' ) { ?>
					<span class="gp-post-meta gp-meta-cats"><?php echo ghostpool_exclude_cats( get_the_ID(), false, true ); ?></span>
				<?php } ?>

				<?php if ( $hub_fields == '1' ) {
					if ( ghostpool_option( 'hub_header_fields' ) ) {
						foreach( ghostpool_option( 'hub_header_fields' ) as $hub_field ) {
							$taxonomy = get_taxonomy( $hub_field );
							if ( ! $taxonomy ) {
								continue;
							}
							$name = $taxonomy->labels->singular_name;
							$term_list = get_the_term_list( get_the_ID(), $hub_field, '<span class="gp-post-meta gp-meta-hub-fields">' . $name . ': ', ', ', '</span>' );		
							if ( ghostpool_option( 'hub_field_links' ) == 'disabled' ) {
								$term_list = preg_replace( '/<\/?a[^>]*>/', '', $term_list );
							}
							if ( ! $term_list OR is_wp_error( $term_list ) ) {
								continue;
							}	
							echo wp_kses_post( $term_list );	
						}
					}
				} ?>
				
			</div>

		<?php }
	}
}

/**
 * Remove hentry tag from post loop
 *
 */
if ( ! function_exists( 'ghostpool_remove_hentry' ) ) {
	function ghostpool_remove_hentry( $classes ) {
		$classes = array_diff( $classes, array( 'hentry' ) );
		return $classes;
	}
}
add_filter( 'post_class', 'ghostpool_remove_hentry' );


/**
 * Exclude categories from post loop
 *
 */
if ( ! function_exists( 'ghostpool_exclude_cats' ) ) {
	function ghostpool_exclude_cats( $post_id, $no_link = false, $loop = '' ) {
					
		// Get all post categories
		$cats = wp_get_object_terms( $post_id, 'category', array( 'fields' => 'ids' ) );
		
		// Exclude specified post categories
		if ( ghostpool_option( 'exclude_cats' ) ) { 
			$included_cats = array_diff( $cats, ghostpool_option( 'exclude_cats' ) );
		} else {
			$included_cats = $cats;
		}
									
		// Construct new categories loop
		if ( ! empty( $included_cats ) && ! is_wp_error( $included_cats ) ) { 		
			$cat_link = '';
			foreach( $included_cats as $included_cat ) {
				if ( has_term( $included_cat, 'category', $post_id ) ) {
					$term = get_term( $included_cat, 'category' );
					$term_link = get_term_link( $term, 'category' );
					if ( ! $term_link OR is_wp_error( $term_link ) ) {
						continue;
					}

					if ( $no_link == true ) {
						$cat_link .= esc_attr( $term->name ) . ' / ';
					} else {
						$cat_link .= '<a href="' . esc_url( $term_link ) . '">' . esc_attr( $term->name ) . '</a>, ';
					}
				}
			}
			$cat_link = rtrim ( $cat_link, ', ' );
			return $cat_link;
		}

	}
}

/**
 * Change excerpt character length
 *
 */	
if ( ! function_exists( 'ghostpool_excerpt_length' ) ) {
	function ghostpool_excerpt_length() {
		return 10000;
	}
}

/**
 * Custom excerpt format
 *
 */	
if ( ! function_exists( 'ghostpool_excerpt' ) ) {
	function ghostpool_excerpt( $length = 0, $read_more_link = 'disabled' ) {
		
		add_filter( 'excerpt_length', 'ghostpool_excerpt_length' );
		
		if ( $read_more_link == 'enabled' ) {
			$more_text = '...<a href="' . esc_url( get_permalink( get_the_ID() ) ) . '" class="gp-read-more" title="' . the_title_attribute( 'echo=0&post=' . get_the_ID() ) . '">' . esc_html__( '[Read More]', 'huber' ) . '</a>';
		} else {
			$more_text = '...';
		}	

		if ( get_post_meta( get_the_ID(), 'synopsis', true ) ) {
			$excerpt = get_post_meta( get_the_ID(), 'synopsis', true ); 	
		} elseif ( get_post_meta( get_the_ID(), 'video_description', true ) ) {
			$excerpt = get_post_meta( get_the_ID(), 'video_description', true );
		} else {
			$excerpt = get_the_excerpt();
		}
						
		$excerpt = strip_tags( $excerpt );
		if ( function_exists( 'mb_strlen' ) && function_exists( 'mb_substr' ) ) { 
			if ( mb_strlen( $excerpt ) > $length ) {
				$excerpt = mb_substr( $excerpt, 0, (int) $length ) . $more_text;
			}
		} else {
			if ( strlen( $excerpt ) > $length ) {
				$excerpt = substr( $excerpt, 0, (int) $length ) . $more_text;
			}	
		}
		return $excerpt;
	}
	
	remove_filter( 'excerpt_length', 'ghostpool_excerpt_length' );
	
}

/**
 * Generate video content
 *
 */	
if ( ! function_exists( 'ghostpool_video_loop_content' ) ) {
	function ghostpool_video_loop_content( $format = '', $image_size_standard = '' ) {	

		global $wp_embed, $_wp_additional_image_sizes;
					
		// Get image dimensions
		if ( in_array( $image_size_standard, array( 'thumbnail', 'medium', 'medium_large', 'large' ) ) ) {
			$image_width  = get_option( "{$image_size_standard}_size_w" );		
			$image_height  = get_option( "{$image_size_standard}_size_h" );		
		} elseif ( $image_size_standard != 'default' ) { 
			$image_width = $_wp_additional_image_sizes[$image_size_standard]['width'];
			$image_height = $_wp_additional_image_sizes[$image_size_standard]['height'];
		} elseif ( $format == 'gp-blog-list' ) {
			$image_width = $_wp_additional_image_sizes['ghostpool-list-category-image']['width'];
			$image_height = $_wp_additional_image_sizes['ghostpool-list-category-image']['height'];
		} elseif ( $format == 'gp-blog-columns-1' ) {
			$image_width = $_wp_additional_image_sizes['ghostpool-one-col-category-image']['width'];
			$image_height = $_wp_additional_image_sizes['ghostpool-one-col-category-image']['height'];
		} else {
			$image_width = $_wp_additional_image_sizes['ghostpool-col-category-image']['width'];	
			$image_height = $_wp_additional_image_sizes['ghostpool-col-category-image']['height'];	
		}
				
		?>
	 
		<div class="gp-post-video gp-loop-featured">

			<?php if ( get_post_meta( get_the_ID(), 'video_embed_url', true ) ) {

				echo do_shortcode( $wp_embed->run_shortcode( '[embed width="' . absint( $image_width ) . '" height="' . absint( $image_height ) . '"]' . esc_url( get_post_meta( get_the_ID(), 'video_embed_url', true ) ) . '[/embed]' ) ); 
		
			} else {
	
				$mp4 = '';
				$m4v = '';
				$webm = '';
				$ogv = '';
		
				if ( get_post_meta( get_the_ID(), 'video_mp4_url', true ) ) {	
					$mp4 = get_post_meta( get_the_ID(), 'video_mp4_url', true );
					$mp4 = $mp4['url'];
				}
	
				if ( get_post_meta( get_the_ID(), 'video_m4v_url', true ) ) {		
					$m4v = get_post_meta( get_the_ID(), 'video_m4v_url', true );
					$m4v = $m4v['url'];
				}
	
				if ( get_post_meta( get_the_ID(), 'video_webm_url', true ) ) {	
					$webm = get_post_meta( get_the_ID(), 'video_webm_url', true );
					$webm = $webm['url'];
				}
	
				if ( get_post_meta( get_the_ID(), 'video_ogv_url', true ) ) {	
					$ogv = get_post_meta( get_the_ID(), 'video_ogv_url', true );
					$ogv = $ogv['url'];
				}
	
				?>

				<?php echo do_shortcode( '[video mp4="' . esc_url( $mp4 ) . '" m4v="' . esc_url( $m4v ) . '" webm="' . esc_url( $webm ). '" ogv="' . esc_url( $ogv ) . '" width="' . absint( $image_width ) . '" height="' . absint( $image_height ) . '"][/video]' ); ?>

			<?php } ?>

		</div>

	<?php }
}

/**
 * Generate loop gallery slider
 *
 */	
if ( ! function_exists( 'ghostpool_gallery_slider_loop_content' ) ) {
	function ghostpool_gallery_slider_loop_content( $format = '', $image_size_standard = '' ) { ?>

		<div class="gp-post-gallery gp-loop-featured">

			<?php

			// Get image IDs
			$image_ids = array_filter( explode( ',', get_post_meta( get_the_ID(), 'gallery_slider', true ) ) );	

			if ( $image_ids ) {
				
				global $_wp_additional_image_sizes; 

				// Get image width
				if ( in_array( $image_size_standard, array( 'thumbnail', 'medium', 'medium_large', 'large' ) ) ) {
					$image_width  = get_option( "{$image_size_standard}_size_w" );				
				} elseif ( $image_size_standard != 'default' ) { 
					$image_width = $_wp_additional_image_sizes[$image_size_standard]['width'];
				} elseif ( $format == 'gp-blog-list' ) {
					$image_width = $_wp_additional_image_sizes['ghostpool-list-category-image']['width'];
				} elseif ( $format == 'gp-blog-columns-1' ) {
					$image_width = $_wp_additional_image_sizes['ghostpool-one-col-category-image']['width'];
				} else {
					$image_width = $_wp_additional_image_sizes['ghostpool-col-category-image']['width'];	
				} ?>

				<div class="gp-post-format-gallery-slider gp-slider"<?php if ( $format == 'gp-blog-list' ) { ?> style="width: <?php echo absint( $image_width ); ?>px;"<?php } ?>> 
			
					 <ul class="slides">
				
						<?php foreach ( $image_ids as $image_id ) { ?>
					
							<li>
								<?php
						
								// Get image url
								if ( $image_size_standard != 'default' ) { 
									$image = wp_get_attachment_image_src( $image_id, $image_size_standard );
								} elseif ( $format == 'gp-blog-list' ) {
									$image = wp_get_attachment_image_src( $image_id, 'ghostpool-list-category-image' );
								} elseif ( $format == 'gp-blog-columns-1' ) {
									$image = wp_get_attachment_image_src( $image_id, 'ghostpool-one-col-category-image' );	
								} else {
									$image = wp_get_attachment_image_src( $image_id, 'ghostpool-col-category-image' );	
								} 
						
								if ( $image[0] ) { ?>
									<img src="<?php echo esc_url( $image[0] ); ?>" alt="<?php if ( get_post_meta( $image_id, '_wp_attachment_image_alt', true) ) { echo esc_attr( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ); } else { the_title_attribute(); } ?>" />
								<?php } ?>
						
							</li>
					
						<?php } ?>
				
					</ul>
			
				 </div>

			<?php } ?>
	
		</div>
	
	<?php }
}