<?php

if ( ! function_exists( 'ghostpool_init_variables' ) ) {
	function ghostpool_init_variables() {

		global $pagenow;

		if ( 'widgets.php' === $pagenow ) {
			return;
		}
			
		// Get hub ID associated with post
		$a_post_id = get_hub_association_id( get_the_ID() );

		/*--------------------------------------------------------------
		BuddyPress
		--------------------------------------------------------------*/

		if ( function_exists( 'bp_is_active' ) && ! bp_is_blog_page() ) {

			if ( bp_is_user() ) {

				$GLOBALS['ghostpool_page_header'] = 'gp-standard-page-header';
			
				$GLOBALS['ghostpool_layout'] = ghostpool_option( 'bp_profile_layout' ) != 'default' ? ghostpool_option( 'bp_profile_layout' ) : ghostpool_option( 'bp_layout' );
			
				$GLOBALS['ghostpool_left_sidebar'] = ghostpool_option( 'bp_members_left_sidebar' ) != 'default' ? ghostpool_option( 'bp_members_left_sidebar' ) : ghostpool_option( 'bp_left_sidebar' );
			
				$GLOBALS['ghostpool_right_sidebar'] = ghostpool_option( 'bp_members_right_sidebar' ) != 'default' ? ghostpool_option( 'bp_members_right_sidebar' ) : ghostpool_option( 'bp_right_sidebar' );
							
										
			} elseif ( bp_is_activity_component() ) {
				
				$GLOBALS['ghostpool_page_header'] = ghostpool_option( 'bp_activity_page_header' ) != 'default' ? ghostpool_option( 'bp_activity_page_header' ) : ghostpool_option( 'bp_page_header' );

				$GLOBALS['ghostpool_layout'] = ghostpool_option( 'bp_activity_layout' ) != 'default' ? ghostpool_option( 'bp_activity_layout' ) : ghostpool_option( 'bp_layout' );
			
				$GLOBALS['ghostpool_left_sidebar'] = ghostpool_option( 'bp_activity_left_sidebar' ) != 'default' ? ghostpool_option( 'bp_activity_left_sidebar' ) : ghostpool_option( 'bp_left_sidebar' );
			
				$GLOBALS['ghostpool_right_sidebar'] = ghostpool_option( 'bp_activity_right_sidebar' ) != 'default' ? ghostpool_option( 'bp_activity_right_sidebar' ) : ghostpool_option( 'bp_right_sidebar' );
				
			} elseif ( bp_is_members_component() ) {

				$GLOBALS['ghostpool_page_header'] = ghostpool_option( 'bp_members_page_header' ) != 'default' ? ghostpool_option( 'bp_members_page_header' ) : ghostpool_option( 'bp_page_header' );
					
				$GLOBALS['ghostpool_layout'] = ghostpool_option( 'bp_members_layout' ) != 'default' ? ghostpool_option( 'bp_members_layout' ) : ghostpool_option( 'bp_layout' );
			
				$GLOBALS['ghostpool_left_sidebar'] = ghostpool_option( 'bp_members_left_sidebar' ) != 'default' ? ghostpool_option( 'bp_members_left_sidebar' ) : ghostpool_option( 'bp_left_sidebar' );
			
				$GLOBALS['ghostpool_right_sidebar'] = ghostpool_option( 'bp_members_right_sidebar' ) != 'default' ? ghostpool_option( 'bp_members_right_sidebar' ) : ghostpool_option( 'bp_right_sidebar' );

			} elseif ( bp_is_groups_component() ) {

				if ( bp_is_group_single() ) {
					$GLOBALS['ghostpool_page_header'] = 'gp-standard-page-header';
				} else {
					$GLOBALS['ghostpool_page_header'] = ghostpool_option( 'bp_groups_page_header' ) != 'default' ? ghostpool_option( 'bp_groups_page_header' ) : ghostpool_option( 'bp_page_header' );
				}
			
				$GLOBALS['ghostpool_layout'] = ghostpool_option( 'bp_groups_layout' ) != 'default' ? ghostpool_option( 'bp_groups_layout' ) : ghostpool_option( 'bp_layout' );
			
				$GLOBALS['ghostpool_left_sidebar'] = ghostpool_option( 'bp_groups_left_sidebar' ) != 'default' ? ghostpool_option( 'bp_groups_left_sidebar' ) : ghostpool_option( 'bp_left_sidebar' );
			
				$GLOBALS['ghostpool_right_sidebar'] = ghostpool_option( 'bp_groups_right_sidebar' ) != 'default' ? ghostpool_option( 'bp_groups_right_sidebar' ) : ghostpool_option( 'bp_right_sidebar' );

			} elseif ( bp_is_register_page() ) {

				$GLOBALS['ghostpool_page_header'] = ghostpool_option( 'bp_register_page_header' ) != 'default' ? ghostpool_option( 'bp_register_page_header' ) : ghostpool_option( 'bp_page_header' );
					
				$GLOBALS['ghostpool_layout'] = ghostpool_option( 'bp_register_layout' ) != 'default' ? ghostpool_option( 'bp_register_layout' ) : ghostpool_option( 'bp_layout' );
			
				$GLOBALS['ghostpool_left_sidebar'] = ghostpool_option( 'bp_register_left_sidebar' ) != 'default' ? ghostpool_option( 'bp_register_left_sidebar' ) : ghostpool_option( 'bp_left_sidebar' );
			
				$GLOBALS['ghostpool_right_sidebar'] = ghostpool_option( 'bp_register_right_sidebar' ) != 'default' ? ghostpool_option( 'bp_register_right_sidebar' ) : ghostpool_option( 'bp_right_sidebar' );
								
			} else {
			
				$GLOBALS['ghostpool_page_header'] = ghostpool_option( 'bp_page_header' );
			
				$GLOBALS['ghostpool_layout'] = ghostpool_option( 'bp_layout' );
			
				$GLOBALS['ghostpool_left_sidebar'] = ghostpool_option( 'bp_left_sidebar' );
			
				$GLOBALS['ghostpool_right_sidebar'] = ghostpool_option( 'bp_right_sidebar' );
				
			}
			

		/*--------------------------------------------------------------
		bbPress
		--------------------------------------------------------------*/

		} elseif ( function_exists( 'is_bbpress' ) && is_bbpress() ) {
							
			$GLOBALS['ghostpool_page_header'] = ghostpool_option( 'bbpress_page_header' );
			
			$GLOBALS['ghostpool_layout'] = ghostpool_option( 'bbpress_layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = ghostpool_option( 'bbpress_left_sidebar' );
			
			$GLOBALS['ghostpool_right_sidebar'] = ghostpool_option( 'bbpress_right_sidebar' );
			
				
		/*--------------------------------------------------------------
		WooCommerce shop page
		--------------------------------------------------------------*/

		} elseif ( function_exists( 'is_woocommerce' ) && is_shop() ) {

			$GLOBALS['ghostpool_page_header'] = ghostpool_option( 'wc_shop_page_header' );

			$GLOBALS['ghostpool_layout'] = ghostpool_option( 'wc_shop_layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = ghostpool_option( 'wc_shop_left_sidebar' ); 
			
			$GLOBALS['ghostpool_right_sidebar'] = ghostpool_option( 'wc_shop_right_sidebar' );


		/*--------------------------------------------------------------
		WooCommerce product categories/tags
		--------------------------------------------------------------*/

		} elseif ( function_exists( 'is_woocommerce' ) && is_woocommerce() && ( is_product_category() OR is_product_tag() OR is_tax() ) ) {
		
			// Get category option
			$term_data = null;
			if ( isset( get_queried_object()->term_id ) ) {
				$term_id = get_queried_object()->term_id;
				$term_data = get_option( "taxonomy_$term_id" );
			}
			
			$GLOBALS['ghostpool_page_header'] = ! isset( $term_data['page_header'] ) || $term_data['page_header'] == 'default' ? ghostpool_option( 'wc_product_cat_page_header' ) : $term_data['page_header'];
			
			$GLOBALS['ghostpool_layout'] = ! isset( $term_data['layout'] ) || $term_data['layout'] == 'default' ? ghostpool_option( 'wc_product_cat_layout' ) : $term_data['layout'];
			
			$GLOBALS['ghostpool_left_sidebar'] = ! isset( $term_data['left_sidebar'] ) || $term_data['left_sidebar'] == 'default' ? ghostpool_option( 'wc_product_cat_left_sidebar' ) : $term_data['left_sidebar']; 
						
			$GLOBALS['ghostpool_right_sidebar'] = ! isset( $term_data['right_sidebar'] ) || $term_data['right_sidebar'] == 'default' ? ghostpool_option( 'wc_product_cat_right_sidebar' ) : $term_data['right_sidebar'];
			
		
		/*--------------------------------------------------------------
		WooCommerce products
		--------------------------------------------------------------*/

		} elseif ( function_exists( 'is_woocommerce' ) && is_singular( 'product' ) ) {

			$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ) == 'default' ? ghostpool_option( 'wc_product_page_header' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' );

			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' ) == 'default' ? 
			ghostpool_option( 'wc_product_layout' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' ) == 'default' ? ghostpool_option( 'wc_product_left_sidebar' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' );	
					
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' ) == 'default' ? ghostpool_option( 'wc_product_right_sidebar' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' );
			

		/*--------------------------------------------------------------
		Search results
		--------------------------------------------------------------*/

		} elseif ( is_search() ) {
			
			$GLOBALS['ghostpool_page_header'] = ghostpool_option( 'search_page_header' );

			$GLOBALS['ghostpool_layout'] = ghostpool_option( 'search_layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = ghostpool_option( 'search_left_sidebar' ); 
			
			$GLOBALS['ghostpool_right_sidebar'] = ghostpool_option( 'search_right_sidebar' );
			
		/*--------------------------------------------------------------
		Author posts
		--------------------------------------------------------------*/

		} elseif ( is_author() ) {
			
			$GLOBALS['ghostpool_page_header'] = ghostpool_option( 'author_page_header' );

			$GLOBALS['ghostpool_layout'] = ghostpool_option( 'author_layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = ghostpool_option( 'author_left_sidebar' ); 
			
			$GLOBALS['ghostpool_right_sidebar'] = ghostpool_option( 'author_right_sidebar' );


		/*--------------------------------------------------------------
		Blank page
		--------------------------------------------------------------*/

		} elseif ( is_page_template( 'blank-page-template.php' ) ) {

			$GLOBALS['ghostpool_page_header'] = 'gp-standard-page-header';
			
			$GLOBALS['ghostpool_layout'] = apply_filters( 'ghostpool_blank_layout', 'gp-no-sidebar' );
	
			$GLOBALS['ghostpool_left_sidebar'] = apply_filters( 'ghostpool_blank_left_sidebar', 'gp-left-sidebar' );
			
			$GLOBALS['ghostpool_right_sidebar'] = apply_filters( 'ghostpool_blank_right_sidebar', 'gp-right-sidebar' );
			

		/*--------------------------------------------------------------
		Attachment page
		--------------------------------------------------------------*/

		} elseif ( is_attachment() ) {

			$GLOBALS['ghostpool_page_header'] = 'gp-standard-page-header';
			
			$GLOBALS['ghostpool_layout'] = apply_filters( 'ghostpool_attachment_layout', 'gp-no-sidebar' );
	
			$GLOBALS['ghostpool_left_sidebar'] = apply_filters( 'ghostpool_attachment_left_sidebar', 'gp-left-sidebar' );
			
			$GLOBALS['ghostpool_right_sidebar'] = apply_filters( 'ghostpool_attachment_right_sidebar', 'gp-right-sidebar' );
			
												
		/*--------------------------------------------------------------
		Error 404 page
		--------------------------------------------------------------*/

		} elseif ( is_404() ) {
		
			$GLOBALS['ghostpool_page_header'] = 'gp-standard-page-header';

			$GLOBALS['ghostpool_layout'] = apply_filters( 'ghostpool_error_layout', 'gp-no-sidebar' );
	
			$GLOBALS['ghostpool_left_sidebar'] = apply_filters( 'ghostpool_error_left_sidebar', 'gp-left-sidebar' );
			
			$GLOBALS['ghostpool_right_sidebar'] = apply_filters( 'ghostpool_error_right_sidebar', 'gp-right-sidebar' );
			
								
		/*--------------------------------------------------------------
		Post Categories, Archives & Tags
		--------------------------------------------------------------*/

		} elseif ( is_home() OR is_archive() ) {

			// Get category option
			$term_data = null;
			if ( isset( get_queried_object()->term_id ) ) {
				$term_id = get_queried_object()->term_id;
				$term_data = get_option( "taxonomy_$term_id" );
			}
			
			$GLOBALS['ghostpool_page_header'] = ! isset( $term_data['page_header'] ) || $term_data['page_header'] == 'default' ? ghostpool_option( 'cat_page_header' ) : $term_data['page_header'];
			
			$GLOBALS['ghostpool_layout'] = ! isset( $term_data['layout'] ) || $term_data['layout'] == 'default' ? ghostpool_option( 'cat_layout' ) : $term_data['layout'];
			
			$GLOBALS['ghostpool_left_sidebar'] = ! isset( $term_data['left_sidebar'] ) || $term_data['left_sidebar'] == 'default' ? ghostpool_option( 'cat_left_sidebar' ) : $term_data['left_sidebar']; 
						
			$GLOBALS['ghostpool_right_sidebar'] = ! isset( $term_data['right_sidebar'] ) || $term_data['right_sidebar'] == 'default' ? ghostpool_option( 'cat_right_sidebar' ) : $term_data['right_sidebar'];
			

		/*--------------------------------------------------------------
		Hub
		--------------------------------------------------------------*/

		} elseif ( redux_post_meta( 'ghostpool_huber', get_the_ID(), 'template' ) == 'gp-hub-post' ) {

			if ( ( ghostpool_option( 'hub_header_associated_content' ) == 'enabled' && $a_post_id != get_the_ID() ) OR get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) ) {
				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' ) == 'default' ? ghostpool_option( 'hub_page_header' ) : redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' );
			} else {
				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ) == 'default' ? ghostpool_option( 'hub_page_header' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' );
			}

			global $wp_query;
			$images_tab_parameter = ghostpool_option( 'images_tab_parameter' );
			if ( isset( $wp_query->query[$images_tab_parameter] ) ) {
				$GLOBALS['ghostpool_layout'] = apply_filters( 'ghostpool_images_tab_layout', 'gp-no-sidebar' );
			} else {
				$GLOBALS['ghostpool_layout'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' ) == 'default' ? 
				ghostpool_option( 'hub_layout' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' );
			}	
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' ) == 'default' ? ghostpool_option( 'hub_left_sidebar' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' );	
					
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' ) == 'default' ? ghostpool_option( 'hub_right_sidebar' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' );
			
			
		/*--------------------------------------------------------------
		Review
		--------------------------------------------------------------*/

		} elseif ( redux_post_meta( 'ghostpool_huber', get_the_ID(), 'template' ) == 'gp-review-post' ) {

			if ( ( ghostpool_option( 'hub_header_associated_content' ) == 'enabled' && $a_post_id != get_the_ID() ) OR get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) ) {
				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' ) == 'default' ? ghostpool_option( 'hub_page_header' ) : redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' );
			} else {
				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ) == 'default' ? ghostpool_option( 'review_page_header' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' );
			}

			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' ) == 'default' ? 
			ghostpool_option( 'review_layout' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' ) == 'default' ? ghostpool_option( 'review_left_sidebar' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' );	
					
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' ) == 'default' ? ghostpool_option( 'review_right_sidebar' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' );


		/*--------------------------------------------------------------
		User Review
		--------------------------------------------------------------*/

		} elseif ( redux_post_meta( 'ghostpool_huber', get_the_ID(), 'template' ) == 'gp-user-review-post' ) {

			if ( ( ghostpool_option( 'hub_header_associated_content' ) == 'enabled' && $a_post_id != get_the_ID() ) OR get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) ) {
				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' ) == 'default' ? ghostpool_option( 'hub_page_header' ) : redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' );
			} else {
				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ) == 'default' ? ghostpool_option( 'user_review_page_header' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' );
			}

			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' ) == 'default' ? 
			ghostpool_option( 'user_review_layout' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' ) == 'default' ? ghostpool_option( 'user_review_left_sidebar' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' );	
					
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' ) == 'default' ? ghostpool_option( 'user_review_right_sidebar' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' );


		/*--------------------------------------------------------------
		Preview
		--------------------------------------------------------------*/

		} elseif ( redux_post_meta( 'ghostpool_huber', get_the_ID(), 'template' ) == 'gp-preview-post' ) {

			if ( ( ghostpool_option( 'hub_header_associated_content' ) == 'enabled' && $a_post_id != get_the_ID() ) OR get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) ) {
				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' ) == 'default' ? ghostpool_option( 'hub_page_header' ) : redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' );
			} else {
				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ) == 'default' ? ghostpool_option( 'preview_page_header' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' );
			}

			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' ) == 'default' ? 
			ghostpool_option( 'preview_layout' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' ) == 'default' ? ghostpool_option( 'preview_left_sidebar' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' );	
					
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' ) == 'default' ? ghostpool_option( 'preview_right_sidebar' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' );

		/*--------------------------------------------------------------
		Associated Posts
		--------------------------------------------------------------*/

		} elseif ( is_singular( 'post' ) && get_post_meta( get_the_ID(), 'hub_association_ids', true ) ) {

			if ( ( ghostpool_option( 'hub_header_associated_content' ) == 'enabled' && $a_post_id != get_the_ID() ) OR get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) ) {
				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' ) == 'default' ? ghostpool_option( 'hub_page_header' ) : redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' );
			} else {
				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ) == 'default' ? ghostpool_option( 'associated_posts_page_header' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' );
			}

			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' ) == 'default' ? 
			ghostpool_option( 'associated_posts_layout' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' ) == 'default' ? ghostpool_option( 'associated_posts_left_sidebar' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' );	
					
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' ) == 'default' ? ghostpool_option( 'associated_posts_right_sidebar' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' );

			
		/*--------------------------------------------------------------
		Posts
		--------------------------------------------------------------*/

		} elseif ( is_singular( 'post' ) ) {

			if ( ( ghostpool_option( 'hub_header_associated_content' ) == 'enabled' && $a_post_id != get_the_ID() ) OR get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) ) {
				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' ) == 'default' ? ghostpool_option( 'hub_page_header' ) : redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' );
			} else {
				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ) == 'default' ? ghostpool_option( 'post_page_header' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' );
			}
			
			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' ) == 'default' ? 
			ghostpool_option( 'post_layout' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' ) == 'default' ? ghostpool_option( 'post_left_sidebar' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' );	
					
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' ) == 'default' ? ghostpool_option( 'post_right_sidebar' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' );

	
		/*--------------------------------------------------------------
		Pages
		--------------------------------------------------------------*/

		} else {

			if ( ( ghostpool_option( 'hub_header_associated_content' ) == 'enabled' && $a_post_id != get_the_ID() ) OR get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) ) {
				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' ) == 'default' ? ghostpool_option( 'hub_page_header' ) : redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' );
			} else {
				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ) == 'default' ? ghostpool_option( 'page_page_header' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' );
			}

			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' ) && redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' ) != 'default' ? redux_post_meta( 'ghostpool_huber', get_the_ID(), 'layout' ) : ghostpool_option( 'page_layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' ) && redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' ) != 'default' ? redux_post_meta( 'ghostpool_huber', get_the_ID(), 'left_sidebar' ) : ghostpool_option( 'page_left_sidebar' );	
					
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' ) && redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' ) != 'default' ? redux_post_meta( 'ghostpool_huber', get_the_ID(), 'right_sidebar' ) : ghostpool_option( 'page_right_sidebar' );

		}
		
		
		/*--------------------------------------------------------------
		Add init variables via your child theme using this function
		--------------------------------------------------------------*/

		if ( function_exists( 'ghostpool_custom_init_variables' ) ) {
			ghostpool_custom_init_variables();
		}
		
	}
}

?>