<?php if ( ! function_exists( 'ghostpool_hub_header' ) ) {

	function ghostpool_hub_header( $post_id = '', $type = 'gp-fullwidth-page-header', $bg = '', $height = '' ) {

		if ( $post_id == '' ) {
			$post_id = get_the_ID();
		}
		
		if ( $type != 'gp-standard-page-header' OR get_post_meta( $post_id, 'page_header_video_bg', true ) != ''  ) {
		
			if ( isset( $bg['id'] ) && $bg['id'] > 0 ) {
				$id = $bg['id'];
			} elseif ( is_singular() && has_post_thumbnail( $post_id ) ) {
				$id = get_post_thumbnail_id( $post_id );
			} else {
				$id = '';
			}
			
			if ( $id > 0 ) {
				$bg_image = wp_get_attachment_image_src( $id, apply_filters( 'ghostpool_page_header_image_size', 'ghostpool-page-header-image' ) );
				$bg_image = isset( $bg_image[0] ) ? $bg_image[0] : '';
				$full_bg_image = wp_get_attachment_image_src( $id, apply_filters( 'ghostpool_full_page_header_image_size', 'full' ) );
				$full_bg_image = isset( $full_bg_image[0] ) ? $full_bg_image[0] : '';
			} else {
				$bg_image = '';
				$full_bg_image = '';
			}
		
			if ( $bg_image ) {
				$bg_css = 'background-image: url(' . esc_url( $bg_image ) . ');';
				$full_bg_css = 'background-image: url(' . esc_url( $full_bg_image ) . ');';
			} else {
				$bg_css = '';
				$full_bg_css = '';
			} 
						
			// Page header height styling
			$height_css = 'padding-bottom: ' . $height . ';';
		
		} else {
			
			$bg_css = '';
			$height_css = '';
		
		}
				
		// Ratings class
		if ( ghostpool_site_rating( $post_id ) && get_post_meta( $post_id, 'ghostpool_user_rating', true ) ) { 
			$ratings_class = 'gp-has-both-ratings';
		} else {
			$ratings_class = '';
		}
		
		?>
									
		<?php if ( $type == 'gp-full-page-page-header' ) { ?>
			<div id="gp-full-page-bg" style="<?php echo esc_attr( $full_bg_css ); ?>"></div>
		<?php } ?>

 		<?php if ( $type == 'gp-fullwidth-page-header' OR $type == 'gp-full-page-page-header' ) { ?>
	
			<header id="gp-page-header" class="gp-hub-header<?php if ( ghostpool_option( 'theme_layout' ) == 'gp-boxed-layout' ) { ?> gp-container<?php } ?>">										

				<div id="gp-page-header-inner" style="<?php if ( $type != 'gp-full-page-page-header' && get_post_meta( $post_id, 'page_header_video', true ) == '' ) { echo esc_attr( $bg_css ); } ?>">
				
					<?php ghostpool_page_header_video_bg( $post_id ); ?>
		
					<div class="gp-container" style="<?php echo esc_attr( $height_css ); ?>">
					
						<?php ghostpool_page_header_video( $post_id ); ?>
						
						<?php if ( function_exists( 'ghostpool_follow_button' ) ) { ghostpool_follow_button( $post_id ); } ?>
							
						<div id="gp-hub-details">

							<div class="gp-featured-caption<?php if ( $ratings_class ) { echo ' ' . sanitize_html_class( $ratings_class ); ?><?php } ?>">
						
								<?php if ( ( function_exists( 'kdmfi_get_featured_image_id' ) && kdmfi_has_featured_image( 'ghostpool-featured-image-2', $post_id ) ) OR has_post_thumbnail( $post_id ) ) { ?>
									<div class="gp-post-thumbnail">
									 	<?php if ( function_exists( 'kdmfi_get_featured_image_id' ) && kdmfi_has_featured_image( 'ghostpool-featured-image-2', $post_id ) ) {
									 		kdmfi_the_featured_image( 'ghostpool-featured-image-2', 'thumbnail', $post_id );
									 	} else {
											echo get_the_post_thumbnail( $post_id, apply_filters( 'ghostpool_hub_image_size', 'thumbnail' ) ); 
										} ?>
									</div>
								<?php } ?>
								
								<div class="gp-featured-caption-inner">
								
									<<?php if ( $post_id != get_the_ID() OR get_post_meta( get_the_ID(), 'template', true ) != 'gp-hub-post' ) { ?>h2<?php } else { ?>h1<?php } ?> class="gp-featured-caption-title">
										<?php if ( ghostpool_option( 'custom_title' ) ) { echo esc_attr( ghostpool_option( 'custom_title' ) ); } else { echo get_the_title( $post_id ); } ?>
									</<?php if ( $post_id != get_the_ID() OR get_post_meta( get_the_ID(), 'template', true ) != 'gp-hub-post' ) { ?>h2<?php } else { ?>h1<?php } ?>>	
	
									<?php if ( get_post_meta( $post_id, 'release_date', true ) OR ghostpool_option( 'hub_header_fields' ) ) { ?>

										<div id="gp-hub-fields">
								
											<?php if ( get_post_meta( $post_id, 'release_date', true ) ) {
												echo '<span class="gp-hub-meta">';
												$new_release_date = date_i18n( 'U', strtotime( get_post_meta( $post_id, 'release_date', true ) ) );
												if ( $new_release_date > date( 'U' ) ) {
													echo esc_attr( ghostpool_option( 'upcoming_date_text' ) ) . ': ';
												} else {
													echo esc_attr( ghostpool_option( 'release_date_text' ) ) . ': ';
												}
												echo date_i18n( ghostpool_option( 'release_date_format' ), strtotime( get_post_meta( $post_id, 'release_date', true ) ) );
												echo '</span>';
											} ?>
								
											<?php if ( ghostpool_option( 'hub_header_fields' ) ) {
												foreach( ghostpool_option( 'hub_header_fields' ) as $hub_field ) {
													$taxonomy = get_taxonomy( $hub_field );
													if ( ! $taxonomy ) {
														continue;
													}
													$name = $taxonomy->labels->singular_name;
													$term_list = get_the_term_list( $post_id, $hub_field, '<span class="gp-hub-meta">' . $name . ': ', ', ', '</span>' );		
													if ( ghostpool_option( 'hub_field_links' ) == 'disabled' ) {
														$term_list = preg_replace( '/<\/?a[^>]*>/', '', $term_list );
													}
													if ( ! $term_list OR is_wp_error( $term_list ) ) {
														continue;
													}	
													echo wp_kses_post( $term_list );	
												}
											} ?>
								
										</div>
																	
									<?php } ?>
	
									<div id="gp-hub-cats">
										<?php echo ghostpool_exclude_cats( $post_id, false, false ); ?>
									</div>
									
								</div>	
										
								<?php if ( ghostpool_site_rating( $post_id ) OR get_post_meta( $post_id, 'ghostpool_user_rating', true ) >= 1 ) { ?>								
									
									<div class="gp-header-ratings">
										
										<?php if ( ghostpool_site_rating( $post_id, true ) ) { ?>
											<div class="gp-site-rating<?php echo ghostpool_rating_color( ghostpool_site_rating( $post_id ) ); ?>">
												<div class="gp-rating-score">
													<?php echo ghostpool_site_rating( $post_id ); ?>
												</div>
												<?php echo ghostpool_rating_text( ghostpool_site_rating( $post_id, true ) ); ?>
											</div>
										<?php } ?>

										<?php if ( get_post_meta( $post_id, 'ghostpool_user_rating', true ) >= 1 ) {  ?>								
											<div class="gp-user-rating<?php echo ghostpool_rating_color( get_post_meta( $post_id, 'ghostpool_user_rating', true ) ); ?>">
												<div class="gp-rating-score">
													<?php echo ghostpool_user_rating( $post_id ); ?>
												</div>
												<?php echo ghostpool_rating_text( get_post_meta( $post_id, 'ghostpool_user_rating', true ) ); ?>
												<span class="gp-rating-avg-text"><?php esc_html_e( 'User Avg', 'huber' ); ?></span>
											</div>
										<?php } ?>	
										
									</div>
									
								<?php } ?>		
							
							</div>
						
						</div>
					
					</div>
																			
				</div>
						
				<?php if ( ghostpool_option( 'theme_layout' ) != 'gp-boxed-layout' ) { ?>
					<div class="gp-blurred-bg" style="<?php if ( $type != 'gp-full-page-page-header' ) { echo esc_attr( $bg_css ); } ?>"></div>
				<?php } ?>
					
			</header>
		
		<?php }
	
	}	

} ?>