<?php

/**
 * Return site rating
 *
 */
if ( ! function_exists( 'ghostpool_site_rating' ) ) {
	function ghostpool_site_rating( $post_id = '', $just_score = false ) {
	
		// Get ID from loop if none specified	
		if ( $post_id == '' ) {
			$post_id = get_the_ID();
		}
		
		// Get latest review ID if hub doesn't have site rating
		$rating = get_post_meta( $post_id, 'site_rating', true );
		if ( ! get_post_meta( $post_id, 'ghostpool_site_rating', true ) && ( ! $rating OR ( is_array( $rating ) && '' === $rating[0] ) ) ) {
			$args = array(
				'post_status'    => 'publish',
				'post_type'      => array( 'post', 'page' ),		
				'orderby'        => apply_filters( 'ghostpool_get_review_rating_orderby', 'date' ),
				'order'          => apply_filters( 'ghostpool_get_review_rating_order', 'desc' ),
				'meta_query' 	 => array( 
					'relation' => 'AND', 
					array(
						'relation' => 'OR', 
						array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', $post_id ), 'compare' => 'LIKE' ),
						array( 'key' => 'hub_association_ids', 'value' => $post_id, 'compare' => '=' ),
					),	
					array( 'key' => 'template', 'value' => 'gp-review-post', 'compare' => '=' ),
				),
				'posts_per_page' => 1,
				'no_found_rows'  => true,
				'fields' => 'ids',
			);
			$query = new WP_Query( $args );
			if ( isset( $query ) && $query->have_posts() ) { 
				$post_id = implode( ',', $query->posts );
			}
		}
		
		if ( get_post_meta( $post_id, 'ghostpool_site_rating', true ) ) {
			$site_rating = get_post_meta( $post_id, 'ghostpool_site_rating', true );
		} else {
			$rating = get_post_meta( $post_id, 'site_rating', true );
			if ( is_array( $rating ) ) {
				if ( $rating[0] != '' ) {
					if ( count( $rating ) === 1 ) {
						$site_rating = $rating[0];
					} else {
						$site_rating_sum = array_sum( $rating );
						$site_rating = number_format( $site_rating_sum / count( $rating ), 1 ) + 0;
					}
				} else {
					$site_rating = '';
				}		
			} else {
				$site_rating = $rating;
			}
		}
												
		return floatval( $site_rating );
	}
}	

/**
 * Create string site rating custom field
 *
 */
if ( is_admin() ) {
	if ( ! function_exists( 'ghostpool_site_rating_field' ) ) {
		function ghostpool_site_rating_field() {
			if ( get_post_meta( get_the_ID(), 'site_rating', true ) && 'gp-user-review-post' !== get_post_meta( get_the_ID(), 'template', true ) ) {
				$rating = get_post_meta( get_the_ID(), 'site_rating', true );
				if ( is_array( $rating ) ) {
					if ( $rating[0] != '' ) {
						if ( count( $rating ) === 1 ) {
							$site_rating = $rating[0];
						} else {
							$site_rating_sum = array_sum( $rating );
							$site_rating = number_format( $site_rating_sum / count( $rating ), 1 ) + 0;
						}
					} else {
						$site_rating = '';
						delete_post_meta( get_the_ID(), 'ghostpool_site_rating' );
					}	
				} elseif ( '' === $rating ) {
					$site_rating = '';
					delete_post_meta( get_the_ID(), 'ghostpool_site_rating' );	
				} else {
					$site_rating = $rating;
				}
		
				if ( $site_rating >= 1 ) {
					if ( ! update_post_meta( get_the_ID(), 'ghostpool_site_rating', $site_rating ) ) {
						add_post_meta( get_the_ID(), 'ghostpool_site_rating', $site_rating, true );
					} else {
						update_post_meta( get_the_ID(), 'ghostpool_site_rating', $site_rating );
					}
				}
					
			}
		}
	}	
	add_action( 'publish_page', 'ghostpool_site_rating_field' );
	add_action( 'save_post', 'ghostpool_site_rating_field' );
}	

/**
 * Return user rating
 *
 */
if ( ! function_exists( 'ghostpool_user_rating' ) ) {
	function ghostpool_user_rating( $post_id = '' ) {
	
		// Get ID from loop if none specified	
		if ( $post_id == '' ) {
			$post_id = get_the_ID();
		}
		 
		if ( get_post_meta( $post_id, 'ghostpool_user_rating', true ) >= 1 ) {
			$user_rating = get_post_meta( $post_id, 'ghostpool_user_rating', true );
		} else {
			$user_rating = '';
		}
												
		return floatval( $user_rating );
		
	}
}	


/**
 * Return rating text
 *
 */
if ( ! function_exists( 'ghostpool_rating_text' ) ) {
	function ghostpool_rating_text( $rating ) {
		$rating_text = '';
		if ( $rating < 2 ) {
			$rating_text = ghostpool_option( 'site_rating_text_1' );
		} elseif ( $rating < 3 ) {
			$rating_text = ghostpool_option( 'site_rating_text_2' );
		} elseif ( $rating < 4 ) {
			$rating_text = ghostpool_option( 'site_rating_text_3' );
		} elseif ( $rating < 5 ) {
			$rating_text = ghostpool_option( 'site_rating_text_4' );
		} elseif ( $rating < 6 ) {
			$rating_text = ghostpool_option( 'site_rating_text_5' );				
		} elseif ( $rating < 7 ) {
			$rating_text = ghostpool_option( 'site_rating_text_6' );
		} elseif ( $rating < 8 ) {
			$rating_text = ghostpool_option( 'site_rating_text_7' );
		} elseif ( $rating < 9 ) {
			$rating_text = ghostpool_option( 'site_rating_text_8' );
		} elseif ( $rating < 10 ) {
			$rating_text = ghostpool_option( 'site_rating_text_9' );
		} elseif ( $rating < 11 ) {
			$rating_text = ghostpool_option( 'site_rating_text_10' );
		}	
		return '<span class="gp-rating-text">' . $rating_text . '</span>';	
	}
}	
	
/**
 * Return rating color
 *
 */
if ( ! function_exists( 'ghostpool_rating_color' ) ) {
	function ghostpool_rating_color( $rating ) {
		$class = '';
		if ( $rating <= 2.9 ) {
			$class = 'gp-rating-color-1';
		} elseif ( $rating <= 4.9 ) {
			$class = 'gp-rating-color-2';
		} elseif ( $rating <= 6.9 ) {
			$class = 'gp-rating-color-3';
		} elseif ( $rating <= 8.9 ) {
			$class = 'gp-rating-color-4';
		} elseif ( $rating <= 10 ) {
			$class = 'gp-rating-color-5';
		}	
		return ' ' . $class;
	}
}	

?>