<?php if ( ! function_exists( 'ghostpool_register_ajax' ) ) {
	function ghostpool_register_ajax() {
		if ( ghostpool_option( 'ajax' ) == 'gp-ajax-loop' ) {			

			global $query_string;
	
			// Determine http or https for admin-ajax.php URL
			if ( is_ssl() ) { $scheme = 'https'; } else { $scheme = 'http'; }

			// Load scripts
			wp_enqueue_style( 'wp-mediaelement' );
			wp_enqueue_script( 'wp-mediaelement' );			
			wp_enqueue_script( 'jquery-flexslider' );
			wp_enqueue_script( 'ghostpool-ajax-loop', get_template_directory_uri() . '/lib/scripts/ajax-loop.js', array( 'jquery' ), '', true );
			wp_localize_script( 'ghostpool-ajax-loop', 'ghostpool_ajax_loop', array(
				'ajaxurl' => admin_url( 'admin-ajax.php', $scheme ),
				'nonce' => wp_create_nonce( 'ghostpool_ajax_loop_action' ),
				'querystring' => $query_string,
			) ); 
		
		}	
	}
}
add_action( 'wp_enqueue_scripts', 'ghostpool_register_ajax' );

if ( ! function_exists( 'ghostpool_ajax' ) ) {
	function ghostpool_ajax() {
		if ( ghostpool_option( 'ajax' ) == 'gp-ajax-loop' ) {			
			
			if ( ! wp_verify_nonce( $_GET['ghostpool_ajax_loop_nonce'], 'ghostpool_ajax_loop_action' ) )
				die();
	
			// Use filtered category if selected
			if ( isset( $_GET['cats_filtered'] ) && $_GET['cats_filtered'] != '0' ) {
				$cats = $_GET['cats_filtered'];
			} elseif ( isset( $_GET['tab_cat_filtered'] ) && $_GET['tab_cat_filtered'] != '0' ) {
				$cats = $_GET['tab_cat_filtered'];				
			} elseif ( isset( $_GET['cats'] ) ) {
				$cats = $_GET['cats'];
			} else {
				$cats = '';
			}
						
			// Use filtered template if selected
			if ( isset( $_GET['templates_filtered'] ) && $_GET['templates_filtered'] != '0' ) {
				$templates = explode( ',', $_GET['templates_filtered'] );
			} else {
				$templates = explode( ',', $_GET['templates'] );
			}
			
			// Use filtered orderby if selected
			if ( isset( $_GET['orderby_filtered'] ) && $_GET['orderby_filtered'] != '0' ) {
				$orderby = $_GET['orderby_filtered'];
			} else {
				$orderby = $_GET['orderby'];
			}	

			// Page IDs
			if ( isset( $_GET['pageids'] ) ) {
				$page_ids = explode( ',', $_GET['pageids'] );
			} else {
				$page_ids = '';
			}
		
			// Get theme options from ajax values
			$ranking = isset( $_GET['ranking'] ) ? $_GET['ranking'] : '';
			$format = isset( $_GET['format'] ) ? $_GET['format'] : '';
			$per_page = isset( $_GET['perpage'] ) ? $_GET['perpage'] : '';
			$image_size_standard = isset( $_GET['imagesizestandard'] ) ? $_GET['imagesizestandard'] : '';
			$image_size_hub = isset( $_GET['imagesizehub'] ) ? $_GET['imagesizehub'] : '';
			$image_size_review = isset( $_GET['imagesizereview'] ) ? $_GET['imagesizereview'] : '';
			$image_size_preview = isset( $_GET['imagesizepreview'] ) ? $_GET['imagesizepreview'] : '';
			$content_display = isset( $_GET['contentdisplay'] ) ? $_GET['contentdisplay'] : '';
			$excerpt_length = isset( $_GET['excerptlength'] ) ? $_GET['excerptlength'] : '0';
			$meta_release_date = isset( $_GET['metareleasedate'] ) ? $_GET['metareleasedate'] : '';
			$meta_author = isset( $_GET['metaauthor'] ) ? $_GET['metaauthor'] : '';
			$meta_date = isset( $_GET['metadate'] ) ? $_GET['metadate'] : '';
			$meta_comment_count = isset( $_GET['metacommentcount'] ) ? $_GET['metacommentcount'] : '';
			$meta_views = isset( $_GET['metaviews'] ) ? $_GET['metaviews'] : '';
			$meta_likes = isset( $_GET['metalikes'] ) ? $_GET['metalikes'] : '';
			$meta_followers = isset( $_GET['metafollowers'] ) ? $_GET['metafollowers'] : '';
			$meta_cats = isset( $_GET['metacats'] ) ? $_GET['metacats'] : '';
			$meta_tags = isset( $_GET['metatags'] ) ? $_GET['metatags'] : '';
			$meta_hub_fields = isset( $_GET['metahubfields'] ) ? $_GET['metahubfields'] : '';
			$meta_site_rating = isset( $_GET['metasiterating'] ) ? $_GET['metasiterating'] : '';
			$meta_user_rating = isset( $_GET['metauserrating'] ) ? $_GET['metauserrating'] : '';
			$read_more_link = isset( $_GET['readmorelink'] ) ? $_GET['readmorelink'] : '';
									
			// Query														
			if ( $_GET['type'] == 'menu' ) {	
				
				$args = array(
					'post_status' 	  => 'publish',
					'post_type'       => array( 'post', 'page' ),
					ghostpool_cats( $cats, 'param' ) => ghostpool_cats( $cats, 'variables' ),
					'orderby'         => 'date',
					'order'           => 'desc',
					'posts_per_page'  => $_GET['perpage'],
					'paged'           => $_GET['pagenumber'],		
				);
				
				$args = apply_filters( 'ghostpool_ajax_menu_query', $args, $cats );
				
			} elseif ( $_GET['type'] == 'home' ) {			
			
				$args = $_GET['querystring'] . "&post_status=publish&paged=" . $_GET['pagenumber'];		
				$args = wp_parse_args( $args );		
				$args = apply_filters( 'ghostpool_ajax_home_query', $args );

			} elseif ( $_GET['type'] == 'search' OR $_GET['type'] == 'author' ) {	
			
				// Get release date
				if ( $_GET['release_date'] == '12months' ) {
					$release_date = array( 'meta_query' => ghostpool_orderby( 'release_date', 'meta_query', date( 'Ymd', strtotime( '-12 months' ) ) ) );
				} elseif ( $_GET['release_date'] == '6months' ) {
					$release_date = array( 'meta_query' => ghostpool_orderby( 'release_date', 'meta_query', date( 'Ymd', strtotime( '-6 months' ) ) ) );
				} elseif ( $_GET['release_date'] == '3months' ) {
					$release_date = array( 'meta_query' => ghostpool_orderby( 'release_date', 'meta_query', date( 'Ymd', strtotime( '-3 months' ) ) ) );
				} elseif ( $_GET['release_date'] == 'date_range' ) {
					$release_date = ghostpool_orderby( 'release_date', 'meta_query', $_GET['release_date_from'], $_GET['release_date_to'] );		
				} else {
					$release_date = null;
				}		
						
				$defaults = array(
					'post_type' => explode( ',', $_GET['posttypes'] ),
					'meta_query' => array( 'relation' => 'AND', $release_date, ghostpool_templates_query( $templates ) ),
				);
			
				$args = $_GET['querystring'] . "&post_status=publish&orderby=" . ghostpool_orderby( $orderby, 'orderby' ) . "&order=" . ghostpool_orderby( $orderby, 'order' ) . "&meta_key=" . ghostpool_orderby( $orderby, 'meta_key' ) . "&posts_per_page=" . $_GET['perpage'] . "&paged=" . $_GET['pagenumber'];	
					
				$args = wp_parse_args( $args, $defaults );	
				
				$args = apply_filters( 'ghostpool_ajax_search_author_query', $args, $orderby, $release_date, $templates );
							
			} elseif ( $_GET['type'] == 'taxonomy' ) {
			
				// Get release date
				if ( $_GET['release_date'] == '12months' ) {
					$release_date = array( 'meta_query' => ghostpool_orderby( 'release_date', 'meta_query', date( 'Ymd', strtotime( '-12 months' ) ) ) );
				} elseif ( $_GET['release_date'] == '6months' ) {
					$release_date = array( 'meta_query' => ghostpool_orderby( 'release_date', 'meta_query', date( 'Ymd', strtotime( '-6 months' ) ) ) );
				} elseif ( $_GET['release_date'] == '3months' ) {
					$release_date = array( 'meta_query' => ghostpool_orderby( 'release_date', 'meta_query', date( 'Ymd', strtotime( '-3 months' ) ) ) );
				} elseif ( $_GET['release_date'] == 'date_range' ) {
					$release_date = ghostpool_orderby( 'release_date', 'meta_query', $_GET['release_date_from'], $_GET['release_date_to'] );		
				} else {
					$release_date = null;
				}		
				
				$defaults = array(
					'post_type' => array( 'post', 'page' ),
					'meta_query' => array( 'relation' => 'AND', $release_date ),
				);
				
				$category_name = '';
				if ( $cats ) {
					$category_name = 'category_name=' . $cats . '&';
				}	
			
				$args = $_GET['querystring'] . "&post_status=publish&" . $category_name . "orderby=" . ghostpool_orderby( $orderby, 'orderby' ) . "&order=" . ghostpool_orderby( $orderby, 'order' ) . "&meta_key=" . ghostpool_orderby( $orderby, 'meta_key' ) . "&posts_per_page=" . $_GET['perpage'] . "&paged=" . $_GET['pagenumber'];	
					
				$args = wp_parse_args( $args, $defaults );	
				
				$args = apply_filters( 'ghostpool_ajax_taxonomy_query', $args, $cats, $category_name, $release_date, $orderby );		
					
			} elseif ( $_GET['type'] == 'hub-tab-page' ) {	
				
				$args = array(
					'post_status' 	 => 'publish',
					'orderby' 		 => ghostpool_orderby( $orderby, 'orderby' ),
					'order' 		 => ghostpool_orderby( $orderby, 'order' ),
					'meta_key' 		 => ghostpool_orderby( $orderby, 'meta_key' ),
					'meta_query' 	 => array( 
						'relation' => 'AND', 
						array(
							'relation' => 'OR', 
							array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', $_GET['postid'] ), 'compare' => 'LIKE' ),
							array( 'key' => 'hub_association_ids', 'value' => $_GET['postid'], 'compare' => '=' ),
						),
					),
					'posts_per_page' => $_GET['perpage'],
					'offset' 		 => $_GET['offset'],
					'paged'          => $_GET['pagenumber'],
				);
				
				$args = apply_filters( 'ghostpool_ajax_hub_tab_query', $args, $orderby );
				
			} elseif ( $_GET['type'] == 'reviews-tab-page' ) {	
				
				$args = array(
					'post_status' 	 => 'publish',
					'orderby' 		 => ghostpool_orderby( $orderby, 'orderby' ),
					'order' 		 => ghostpool_orderby( $orderby, 'order' ),
					'meta_key' 		 => ghostpool_orderby( $orderby, 'meta_key' ),
					'meta_query' 	 => array( 
						'relation' => 'AND', 
						array(
							'relation' => 'OR', 
							array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', $_GET['postid'] ), 'compare' => 'LIKE' ),
							array( 'key' => 'hub_association_ids', 'value' => $_GET['postid'], 'compare' => '=' ),
						),
						array( 'key' => 'template', 'value' => 'gp-review-post', 'compare' => '=' ),
					),
					'posts_per_page' => $_GET['perpage'],
					'offset' 		 => $_GET['offset'],
					'paged'          => $_GET['pagenumber'],
				);
				
				$args = apply_filters( 'ghostpool_ajax_reviews_tab_query', $args, $orderby );

			} elseif ( $_GET['type'] == 'user-reviews-tab-page' ) {	
				
				$args = array(
					'post_status' 	 => 'publish',
					'orderby' 		 => ghostpool_orderby( $orderby, 'orderby' ),
					'order' 		 => ghostpool_orderby( $orderby, 'order' ),
					'meta_key' 		 => ghostpool_orderby( $orderby, 'meta_key' ),
					'meta_query' 	 => array( 
						'relation' => 'AND',
						array( 'key' => 'ghostpool_hub_page_id', 'value' => $_GET['postid'], 'compare' => '=' ),
					),
					'posts_per_page' => $_GET['perpage'],
					'offset' 		 => $_GET['offset'],
					'paged'          => $_GET['pagenumber'],
				);
				
				$args = apply_filters( 'ghostpool_ajax_user_reviews_tab_query', $args, $orderby );
								
			} elseif ( $_GET['type'] == 'previews-tab-page' ) {	
				
				$args = array(
					'post_status' 	 => 'publish',
					'orderby' 		 => ghostpool_orderby( $orderby, 'orderby' ),
					'order' 		 => ghostpool_orderby( $orderby, 'order' ),
					'meta_key' 		 => ghostpool_orderby( $orderby, 'meta_key' ),
					'meta_query' 	 => array( 
						'relation' => 'AND', 
						array(
							'relation' => 'OR', 
							array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', $_GET['postid'] ), 'compare' => 'LIKE' ),
							array( 'key' => 'hub_association_ids', 'value' => $_GET['postid'], 'compare' => '=' ),
						),
						array( 'key' => 'template', 'value' => 'gp-preview-post', 'compare' => '=' ),
					),
					'posts_per_page' => $_GET['perpage'],
					'offset' 		 => $_GET['offset'],
					'paged'          => $_GET['pagenumber'],
				);				
				
				$args = apply_filters( 'ghostpool_ajax_previews_tab_query', $args, $orderby );
				
			} elseif ( $_GET['type'] == 'news-tab-page' ) {	
				
				$args = array(
					'post_status' 	 => 'publish',
					'tax_query' => array(
						'relation' => 'OR',
						array(
							'taxonomy' => 'post_format',
							'field' => 'slug',
							'terms' => array( 'post-format-video' ),
							'operator' => 'NOT IN',
						)			
					),
					'orderby' 		 => ghostpool_orderby( $orderby, 'orderby' ),
					'order' 		 => ghostpool_orderby( $orderby, 'order' ),
					'meta_key' 		 => ghostpool_orderby( $orderby, 'meta_key' ),
					'meta_query' 	 => array( 
						'relation' => 'AND',
						array(
							'relation' => 'OR', 
							array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', $_GET['postid'] ), 'compare' => 'LIKE' ),
							array( 'key' => 'hub_association_ids', 'value' => $_GET['postid'], 'compare' => '=' ),
						),
						array( 'key' => 'template', 'value' => 'gp-standard-post', 'compare' => '=' ),
					),
					'posts_per_page' => $_GET['perpage'],
					'offset' 		 => $_GET['offset'],
					'paged'          => $_GET['pagenumber'],
				);
				
				$args = apply_filters( 'ghostpool_ajax_news_tab_query', $args, $orderby );
				
			} elseif ( $_GET['type'] == 'videos-tab-page' ) {	
				
				$args = array(
					'post_status' 	 => 'publish',
					'tax_query' => array(
						'relation' => 'OR',
						array(
							'taxonomy' => 'post_format',
							'field' => 'slug',
							'terms' => array( 'post-format-video' ),
						)			
					),
					'orderby' 		 => ghostpool_orderby( $orderby, 'orderby' ),
					'order' 		 => ghostpool_orderby( $orderby, 'order' ),
					'meta_key' 		 => ghostpool_orderby( $orderby, 'meta_key' ),
					'meta_query' 	 => array(
						'relation' => 'OR', 
						array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', $_GET['postid'] ), 'compare' => 'LIKE' ),
						array( 'key' => 'hub_association_ids', 'value' => $_GET['postid'], 'compare' => '=' ),
					),
					'posts_per_page' => $_GET['perpage'],
					'offset' 		 => $_GET['offset'],
					'paged'          => $_GET['pagenumber'],
				);
				
				$args = apply_filters( 'ghostpool_ajax_videos_tab_query', $args, $orderby );
				
			} else {
				
				$args = array(
					'post_status' 	 => 'publish',
					'post_type' 	 => explode( ',', $_GET['posttypes'] ),
					'post__in'       => $page_ids,
					ghostpool_cats( $cats, 'param' ) => ghostpool_cats( $cats, 'variables' ),
					'tax_query'      => ghostpool_tax( $_GET['hubfields'] ),
					'orderby' 		 => ghostpool_orderby( $orderby, 'orderby' ),
					'order' 		 => ghostpool_orderby( $orderby, 'order' ),
					'meta_key' 		 => ghostpool_orderby( $orderby, 'meta_key' ),					
					'meta_query' 	 => ghostpool_orderby( $orderby, 'meta_query', $_GET['releasedatefrom'], $_GET['releasedateto'], $_GET['postassociation'], $_GET['postid'] ),
					'posts_per_page' => $_GET['perpage'],
					'offset' 		 => $_GET['offset'],
					'paged'          => $_GET['pagenumber'],
				);
				
				$args = apply_filters( 'ghostpool_ajax_standard_query', $args, $page_ids, $orderby );
				
			}
	
			//print_r($args);
	
			$gp_query = new WP_Query( $args );
	
			// Showcase post counter
			$counter = 1;
		
			// Ranking counter
			if ( $_GET['pagenumber'] > 1 ) {
				$ranking_counter = 1 + ( $_GET['perpage'] * ( $_GET['pagenumber'] - 1 ) );
			} else {
				$ranking_counter = 1;
			}

			if ( $gp_query->have_posts() ) :
	
				$total_pages = $gp_query->max_num_pages;

				// Pagination (Arrows)
				if ( $_GET['pagearrows'] == 'enabled' OR $_GET['type'] == 'menu' ) {
					echo '<div class="gp-pagination-arrows gp-ajax-pagination">';
						if ( $_GET['pagenumber'] > 1 ) {
							echo '<a href="#" data-pagelink="' . ( $_GET['pagenumber'] - 1 ) . '" class="prev"></a>';
						} else {
							echo '<span class="prev gp-disabled"></span>';
						}
						if ( $_GET['pagenumber'] < $total_pages ) {
							echo '<a href="#" data-pagelink="' . ( $_GET['pagenumber'] + 1 ) . '" class="next"></a>';
						} else {
							echo '<span class="next gp-disabled"></span>';
						}
					echo '</div>'; 
				}
		
				if ( $_GET['type'] == 'search' ) {
					echo ghostpool_search_results_total( $gp_query->found_posts );
				}
				
				echo '<div class="gp-section-loop-inner">';
			
					if ( $_GET['format'] == 'gp-blog-masonry' ) { echo '<div class="gp-gutter-size"></div>'; }
		
					while ( $gp_query->have_posts() ) : $gp_query->the_post(); 	
			
						// Load Visual Composer shortcodes
						if ( function_exists( 'vc_set_as_theme' ) ) {
							WPBMap::addAllMappedShortcodes();
						}
						
						// Large and small options for showcase element
						if ( $_GET['type'] == 'showcase' ) {
							if ( $counter % $_GET['perpage'] == 1 ) {
								$excerpt_length = isset( $_GET['largeexcerptlength'] ) ? $_GET['largeexcerptlength'] : '0';
								$meta_release_date = isset( $_GET['largemetareleasedate'] ) ? $_GET['largemetareleasedate'] : '';
								$meta_author = isset( $_GET['largemetaauthor'] ) ? $_GET['largemetaauthor'] : '';
								$meta_date = isset( $_GET['largemetadate'] ) ? $_GET['largemetadate'] : '';
								$meta_comment_count = isset( $_GET['largemetacommentcount'] ) ? $_GET['largemetacommentcount'] : '';
								$meta_views = isset( $_GET['largemetaviews'] ) ? $_GET['largemetaviews'] : '';
								$meta_likes = isset( $_GET['largemetalikes'] ) ? $_GET['largemetalikes'] : '';
								$meta_followers = isset( $_GET['largemetafollowers'] ) ? $_GET['largemetafollowers'] : '';
								$meta_cats = isset( $_GET['largemetacats'] ) ? $_GET['largemetacats'] : '';
								$meta_tags = isset( $_GET['largemetatags'] ) ? $_GET['largemetatags'] : '';
								$meta_hub_fields = isset( $_GET['largemetahubfields'] ) ? $_GET['largemetahubfields'] : '';
								$meta_site_rating = isset( $_GET['largemetasiterating'] ) ? $_GET['largemetasiterating'] : '';
								$meta_user_rating = isset( $_GET['largemetauserrating'] ) ? $_GET['largemetauserrating'] : '';
								$read_more_link = isset( $_GET['largereadmorelink'] ) ? $_GET['largereadmorelink'] : '';
							} else {
								$excerpt_length = isset( $_GET['smallexcerptlength'] ) ? $_GET['smallexcerptlength'] : '0';
								$meta_release_date = isset( $_GET['smallmetareleasedate'] ) ? $_GET['smallmetareleasedate'] : '';
								$meta_author = isset( $_GET['smallmetaauthor'] ) ? $_GET['smallmetaauthor'] : '';
								$meta_date = isset( $_GET['smallmetadate'] ) ? $_GET['smallmetadate'] : '';
								$meta_comment_count = isset( $_GET['smallmetacommentcount'] ) ? $_GET['smallmetacommentcount'] : '';
								$meta_views = isset( $_GET['smallmetaviews'] ) ? $_GET['smallmetaviews'] : '';
								$meta_likes = isset( $_GET['smallmetalikes'] ) ? $_GET['smallmetalikes'] : '';
								$meta_followers = isset( $_GET['smallmetafollowers'] ) ? $_GET['smallmetafollowers'] : '';
								$meta_cats = isset( $_GET['smallmetacats'] ) ? $_GET['smallmetacats'] : '';
								$meta_tags = isset( $_GET['smallmetatags'] ) ? $_GET['smallmetatags'] : '';
								$meta_hub_fields = isset( $_GET['smallmetahubfields'] ) ? $_GET['smallmetahubfields'] : '';
								$meta_site_rating = isset( $_GET['smallmetasiterating'] ) ? $_GET['smallmetasiterating'] : '';
								$meta_user_rating = isset( $_GET['smallmetauserrating'] ) ? $_GET['smallmetauserrating'] : '';
								$read_more_link = isset( $_GET['smallreadmorelink'] ) ? $_GET['smallreadmorelink'] : '';
							}
						}
										
						?>

							<?php if ( $_GET['type'] == 'menu' ) {
														
								// Post link
								if ( get_post_format() == 'link' ) { 
									$link = esc_url( get_post_meta( get_the_ID(), 'link', true ) );
									$target = 'target="' . get_post_meta( get_the_ID(), 'link_target', true ) . '"';
								} else {
									$link = get_permalink();
									$target = '';
								}
					
								echo '<section class="' . implode( ' ' , get_post_class( 'gp-post-item' ) ) . '">';
					
									if ( has_post_thumbnail() ) {
								
										echo '<div class="gp-post-thumbnail">
											<a href="' . $link . '" title="' . the_title_attribute( array( 'echo' => false ) ) . '"' . $target . '>' .
												get_the_post_thumbnail( get_the_ID(), apply_filters( 'ghostpool_menu_image_size', 'ghostpool-menu-image' ) ) . 
												'<span class="gp-loop-ratings">';														
													if ( ghostpool_site_rating() ) {
														echo '<span class="gp-site-rating' . ghostpool_rating_color( ghostpool_site_rating() ) . '">
															<span class="gp-rating-score">' . 
																ghostpool_site_rating() .
															'</span>' .
															ghostpool_rating_text( ghostpool_site_rating( '', true ) ) .
														'</span>';
													}
													if ( get_post_meta( get_the_ID(), 'ghostpool_user_rating', true ) >=1 ) {						
														echo '<span class="gp-user-rating' . ghostpool_rating_color( get_post_meta( get_the_ID(), "ghostpool_user_rating", true ) ) . '">
															<span class="gp-rating-score">' .
																get_post_meta( get_the_ID(), 'ghostpool_user_rating', true ) .
															'</span>' .
															ghostpool_rating_text( get_post_meta( get_the_ID(), 'ghostpool_user_rating', true ) ). 
															'<span class="gp-rating-avg-text">' . esc_html__( 'User Avg', 'huber' ) . '</span>
														</span>';
													}
												echo '</span>
											</a>
										</div>';
			
									}
								
									echo '<div class="gp-loop-title"><a href="' . $link . '" title="' . the_title_attribute( array( 'echo' => false ) ) . '"' . $target . '>' . get_the_title() . '</a></div>		
						
									<div class="gp-loop-meta">';
											
										if ( get_post_meta( get_the_ID(), 'release_date', true ) ) {
										
											echo '<span class="gp-post-meta gp-meta-release-date">';
												$new_release_date = date_i18n( 'U', strtotime( get_post_meta( get_the_ID(), 'release_date', true ) ) );
												if ( $new_release_date > date( 'U' ) ) {
													echo esc_attr( ghostpool_option( 'upcoming_date_text' ) ) . ': ';
												} else {
													echo esc_attr( ghostpool_option( 'release_date_text' ) ) . ': ';
												}
												echo date_i18n( ghostpool_option( 'release_date_format' ), strtotime( get_post_meta( get_the_ID(), 'release_date', true ) ) );
											echo '</span>';
									
										} else {
								
											echo '<time class="gp-post-meta gp-meta-date" datetime="' . get_the_date( 'c' ) . '">' . get_the_time( get_option( 'date_format' ) ) . '</time>';
										}
								
									echo '</div>
									
								</section>';						

							} elseif ( $_GET['type'] == 'showcase' ) {
		
								if ( function_exists( 'ghostpool_post_loop_showcase' ) ) { ghostpool_post_loop_showcase( $format, $excerpt_length, $meta_release_date, $meta_author, $meta_date, $meta_comment_count, $meta_views, $meta_likes, $meta_followers, $meta_cats, $meta_tags, $meta_hub_fields, $meta_site_rating, $meta_user_rating, $read_more_link, $counter, $ranking, $ranking_counter, $per_page ); }
						
							} elseif ( $_GET['format'] == 'gp-blog-minimal' ) {
		
								if ( function_exists( 'ghostpool_post_loop_minimal' ) ) { ghostpool_post_loop_minimal( $format, $image_size_standard, $image_size_hub, $image_size_review, $image_size_preview, $excerpt_length, $meta_release_date, $meta_author, $meta_date, $meta_comment_count, $meta_views, $meta_likes, $meta_followers, $meta_cats, $meta_tags, $meta_hub_fields, $meta_site_rating, $meta_user_rating, $read_more_link, $counter, $ranking, $ranking_counter, $per_page ); }

							} else {
		
								if ( function_exists( 'ghostpool_post_loop' ) ) { ghostpool_post_loop( $format, $image_size_standard, $image_size_hub, $image_size_review, $image_size_preview, $content_display, $excerpt_length, $meta_release_date, $meta_author, $meta_date, $meta_comment_count, $meta_views, $meta_likes, $meta_followers, $meta_cats, $meta_tags, $meta_hub_fields, $meta_site_rating, $meta_user_rating, $read_more_link, $counter, $ranking, $ranking_counter ); }		
													
							} ?>

					<?php $counter++; $ranking_counter++; endwhile;
			
				echo '</div>';
		
				// Pagination (Numbers)		
				if ( $total_pages > 1 && $_GET['type'] != 'menu' && $_GET['pagination'] == 'page-numbers' ) { 
					  echo '<div class="gp-pagination gp-pagination-numbers gp-ajax-pagination">';
					  echo paginate_links( array(  
						'base'      => '%_%',  
						'format'    => '/page/%#%',
						'current'   => $_GET['pagenumber'],  
						'total'     => $total_pages,  
						'type'      => 'list',
						'prev_text' => '',
						'next_text' => '',
						'end_size'  => 1,
						'mid_size'  => 1,      
					  ));
					  echo '</div>'; 
				}
				?>
	
			<?php else : ?>

				<strong class="gp-no-items-found"><?php esc_html_e( 'No items found.', 'huber' ); ?></strong>

			<?php endif; wp_reset_postdata();

			die();
			
		}		
	}	
}
add_action( 'wp_ajax_ghostpool_ajax_loop_action', 'ghostpool_ajax' );
add_action( 'wp_ajax_nopriv_ghostpool_ajax_loop_action', 'ghostpool_ajax' );

?>