<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    // This is your option name where all the Redux data is stored.
    $opt_name = "ghostpool_huber";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'Theme Options', 'huber' ),
        'page_title'           => esc_html__( 'Theme Options', 'huber' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => 'AIzaSyDipV4M7FL2ylBHtJ5OvW1CSBWTyKKrP6E',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => apply_filters( 'ghostpool_async_typography', false ),
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-admin-generic',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => 'huber',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

	// ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
	$args['admin_bar_links'][] = array(
		'id'    => 'gp-help',
		'href'   => 'http://ghostpool.com/help/huber/help.html',
		'title' => esc_html__( 'Documentation', 'huber' ),
	);

	$args['admin_bar_links'][] = array(
		'id'    => 'gp-changelog',
		'href'   => 'http://ghostpool.com/help/huber/changelog.html',
		'title' => esc_html__( 'Changelog', 'huber' ),
	);

	$args['admin_bar_links'][] = array(
		'id'    => 'gp-support',
		'href'   => 'http://ghostpool.ticksy.com',
		'title' => esc_html__( 'Support', 'huber' ),
	);

	// SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
	$args['share_icons'][] = array(
		'url'   => 'http://twitter.com/ghostpool',
		'title' => esc_html__( 'Follow us on Twitter', 'huber' ),
		'icon'  => 'el el-icon-twitter'
	);

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

	 $tabs = array(
		array(
			'id'        => 'documentation-tab',
			'title'     => esc_html__( 'Documentation', 'huber' ),
			'content'   => '<p>' . esc_html__( 'The documentation explains how to install, set up and use the main features of the theme. The docuementation comes with the full theme download or you can view the latest version online.', 'huber' ) . '</p>' . '<p><a href="' . esc_url( 'http://ghostpool.com/help/huber/help.html' ) . '" target="_blank">' . esc_html__( 'View Documentation', 'huber' ) . '</a></p>',
		),
		array(
			'id'        => 'changelog-tab',
			'title'     => esc_html__( 'Changelog', 'huber' ),
			'content'   => '<p>' . esc_html__( 'The changelog is a record of changes made to theme including bug fixes, new features and tweaks. The changelog comes with the full theme download or you can view the latest version online.', 'huber' ) . '</p>' . '<p><a href="' . esc_url( 'http://ghostpool.com/help/huber/changelog.html' ) . '" target="_blank">' . esc_html__( 'View Changelog', 'huber' ) . '</a></p>',
		),
		array(
			'id'        => 'support-tab',
			'title'     => esc_html__( 'Support', 'huber' ),
			'content'   => '<p>' . esc_html__( 'If you have any questions about how to use the theme or want to report a bug then we can help you out on our ticket support site. However support does not include any services that modify or extend the theme beyond the original features, style and functionality advertised on the item page. For a more detailed explanation of what support does and does not cover check out Envato\'s support definition and guidelines for buyers', 'huber' ) . ' <a href="' . esc_url( 'http://themeforest.net/page/item_support_policy' ) . '" target="_blank">' . esc_html__( 'here', 'huber' ) . '</a>.</p>' . '<p><a href="' . esc_url( 'http://ghostpool.ticksy.com', 'huber' ) . '" target="_blank">' . esc_html__( 'Submit Support Ticket', 'huber' ) . '</a></p>',
		),
		array(
			'id'        => 'youtube_google',
			'title'     => esc_html__( 'Privacy Policy', 'huber' ),
			'content'   => wp_kses( __( '<p>The Google webfonts are generated using the YouTube API.</p><p><a href="https://www.youtube.com/t/terms">YouTube Terms of Service</a> | <a href="https://policies.google.com/privacy">Google Privacy Policy</a></p>', 'huber' ), array( 'a' => array( 'href' => array(), 'target' => array() ), 'p' => array() ) ),
		),		
	);
	Redux::setHelpTab( $opt_name, $tabs );
        
    // Set the help sidebar
    $content = sprintf( wp_kses( __( '<p>If you need any help using the theme then take a look at the tabs to the left.</p>', 'huber' ), array( 'p' => array() ) ) );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */
     
	Redux::setSection( $opt_name, array(
		'id' => 'general_options',
		'title' => esc_html__( 'General', 'huber' ),
		'desc' => esc_html__( 'General theme options.', 'huber' ),
		'icon' => 'el-icon-cogs',
		'fields' => array(

			array(  
				'id' => 'theme_layout',
				'title' => esc_html__( 'Theme Layout', 'huber' ),
				'desc' => esc_html__( 'Choose whether the theme layout is wide or boxed.', 'huber' ),
				'type' => 'button_set',
				'options'   => array(
					'gp-wide-layout' => esc_html__( 'Wide', 'huber' ),
					'gp-boxed-layout' => esc_html__( 'Boxed', 'huber' ),
				), 
				'default'   => 'gp-wide-layout'						
			),

			array(
				'id'       => 'exclude_cats',
				'type'     => 'select',
				'multi' => true,
				'title'    => esc_html__( 'Exclude Post Categories', 'huber' ),
				'data' => 'terms',
				'args' => array( 'taxonomies' => 'category', 'hide_empty' => false ),
				'desc' => esc_html__( 'Select the post categories you want to exclude from the post meta.', 'huber' ),
				'default' => '',
			),
						
			array(  
				'id' => 'smooth_scrolling',
				'title' => esc_html__( 'Smooth Scrolling', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Scroll down the page smoothly without incremental stops.', 'huber' ),
				'options' => array(
					'gp-smooth-scrolling' => esc_html__( 'Enabled', 'huber' ),
					'gp-normal-scrolling' => esc_html__( 'Disabled', 'huber' )
				),
				'default' => 'gp-normal-scrolling',
			),
			
			array(  
				'id' => 'back_to_top',
				'title' => esc_html__( 'Back To Top Button', 'huber' ),
				'type' => 'radio',
				'desc' => esc_html__( 'Add a button to the bottom right corner of the page that takes you back to the top of the page.', 'huber' ),
				'options' => array(
					'gp-back-to-top-all' => esc_html__( 'Show on all devices', 'huber' ),
					'gp-back-to-top-desktop' => esc_html__( 'Only show on desktop devices', 'huber' ),
					'gp-no-back-to-top' => esc_html__( 'Disabled', 'huber' )
				),
				'default' => 'gp-back-to-top-desktop',
			),
			 
			array(  
				'id' => 'ajax',
				'title' => esc_html__( 'Ajax', 'huber' ),
				'desc' => esc_html__( 'Load and filter content dynamically using ajax.', 'huber' ),
				'type' => 'button_set',
				'options'   => array(
					'gp-ajax-loop' => esc_html__( 'Enabled', 'huber' ),
					'gp-standard-loop' => esc_html__( 'Disabled', 'huber' ),
				), 
				'default'   => 'gp-ajax-loop'						
			),

			array(
				'id'        => 'lightbox',
				'type'      => 'radio',
				'title'     => esc_html__( 'Lightbox', 'huber' ),
				'subtitle' => esc_html__( 'Make sure the images open the media file and not the attachment page.', 'huber' ),
				'desc' => esc_html__( 'Choose how images open in the lightbox (pop-up window).', 'huber' ), 
				'options'   => array(
					'group_images' => esc_html__( 'All images on page show as gallery within lightbox window', 'huber' ),
					'separate_images' => esc_html__( 'Images are not grouped', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'group_images',
			),

			array(  
				'id' => 'popup_box',
				'title' => esc_html__( 'Login/Register Popup Windows', 'huber' ),
				'desc' => esc_html__( 'Choose whether to use the login/register popup windows or standard WordPress login.', 'huber' ),
				'type' => 'button_set',
				'options'   => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				), 
				'default'   => 'enabled'						
			),

			array(  
				'id' => 'registration_gdpr',
				'title' => esc_html__( 'Registration Privacy Policy Checkbox (GDPR)', 'huber' ),
				'desc' => esc_html__( 'Add a privacy policy checkbox to the theme\'s registration form (this does not add a checkbox to the BuddyPress or other plugin registration pages).', 'huber' ),
				'type' => 'button_set',
				'options'   => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				), 
				'default'   => 'disabled',
			),
			
			array(  
				'id' => 'registration_gdpr_text',
				'title' => esc_html__( 'Registration Privacy Policy Text', 'huber' ),
				'desc' => esc_html__( 'Add your own privacy policy text next to the checkbox.', 'huber' ),
				'subtitle' => esc_html__( 'To add a link within your text use HTML tags e.g. "This is my text and this is a <a href="http://domain.com/privacy-policy">link</a>."', 'huber' ),
				'type' => 'textarea',
				'required' => array( 'registration_gdpr', '=', 'enabled' ),
			),
							
			array( 
				'id' => 'js_code',
				'type' => 'ace_editor',
				'title' => esc_html__( 'JS Code', 'huber' ),
				'subtitle' => esc_html__( 'Paste your JS code here.', 'huber' ),
				'desc' => esc_html__( 'Scripts that need to be embedded into the theme (e.g. Google Analytics).', 'huber' ),
				'mode' => 'javascript',
				'theme' => 'chrome',
				'default' => '',				
			 ),
							
		),
	
	) );
	
		
	Redux::setSection( $opt_name, array(
		'id' => 'header_options',
		'title' => esc_html__( 'Header', 'huber' ),
		'desc' => esc_html__( 'Options for the header.', 'huber' ),
		'icon' => 'el-icon-website',
		'fields' => array(								 

			array( 
				'id' => 'header_layout',
				'title' => esc_html__( 'Layout', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'The layout for the header.', 'huber' ),
				'options' => array( 
					'gp-header-wide' => esc_html__( 'Wide', 'huber' ),
					'gp-header-boxed' => esc_html__( 'Boxed', 'huber' ),
				),
				'default' => 'gp-header-boxed',
			),
								 
			array(  
				'id' => 'fixed_header',
				'title' => esc_html__( 'Fixed Header', 'huber' ),
				'type' => 'radio',
				'desc' => esc_html__( 'The header stays at the top of the screen as you scroll down the page.', 'huber' ),
				'options' => array(
					'gp-fixed-header-all' => esc_html__( 'Show on all devices', 'huber' ),
					'gp-fixed-header-desktop' => esc_html__( 'Only show on desktop devices', 'huber' ),
					'gp-relative-header' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'gp-fixed-header-desktop',
			),
			
			array(
				'id' => 'desktop_header_height',
				'type' => 'dimensions',
				'units' => 'px',
				'title' => esc_html__( 'Desktop Header Height', 'huber' ),
				'desc' => esc_html__( 'The height of the header on larger devices.', 'huber' ),
				'width' => false,
				'default'           => array(
					'height'    => '80px',
				)
			),

			array(
				'id' => 'desktop_scrolling_header_height',
				'required' => array( 'fixed_header', '!=', 'gp-relative-header' ),
				'type' => 'dimensions',
				'units' => 'px',
				'title' => esc_html__( 'Desktop Scrolling Header Height', 'huber' ),
				'desc' => esc_html__( 'The height of the header on larger devices when scrolling.', 'huber' ),
				'width' => false,
				'default'           => array(
					'height'    => '50px',
				)
			),
			
			array(
				'id' => 'mobile_header_height',
				'type' => 'dimensions',
				'units' => 'px',
				'title' => esc_html__( 'Mobile Header Height', 'huber' ),
				'desc' => esc_html__( 'The height of the header on mobile and smaller tablet devices.', 'huber' ),
				'width' => false,
				'default'           => array(
					'height'    => '50px',
				)
			),
			 				
			array( 
				'id' => 'desktop_logo',
				'title' => esc_html__( 'Desktop Logo', 'huber' ),						
				'type' => 'media',
				'desc' => esc_html__( 'The image that is displayed in the header on larger devices.', 'huber' ),
				'default'  => array(
					'url' => get_template_directory_uri() . '/lib/images/logo.png',
				),
			 ),
			 
			array(
				'id' => 'desktop_logo_dimensions',
				'type' => 'dimensions',
				'units' => 'px',
				'title' => esc_html__( 'Desktop Logo Dimensions', 'huber' ),
				'desc' => esc_html__( 'The width and height of the logo on larger devices.', 'huber' ),
				'subtitle' => esc_html__( 'Set to half the original logo dimensions for retina displays.', 'huber' ),
				'default'           => array(
					'width'     => '217px',
					'height'    => '32px',
				)
			),

			array( 
				'id' => 'desktop_scrolling_logo',
				'required' => array( 'fixed_header', '!=', 'gp-relative-header' ),
				'title' => esc_html__( 'Desktop Scrolling Logo', 'huber' ),			
				'type' => 'media',
				'desc' => esc_html__( 'The image that is displayed in the header on larger devices when scrolling.', 'huber' ),
				'default'  => array(
					'url' => get_template_directory_uri() . '/lib/images/logo.png',
				),
				
			 ),
			 
			array(
				'id' => 'desktop_scrolling_logo_dimensions',
				'required' => array( 'fixed_header', '!=', 'gp-relative-header' ),
				'type' => 'dimensions',
				'units' => 'px',
				'title' => esc_html__( 'Desktop Scrolling Logo Dimensions', 'huber' ),
				'desc' => esc_html__( 'The width and height of the logo on larger devices.', 'huber' ),
				'subtitle' => esc_html__( 'Set to half the original logo dimensions for retina displays.', 'huber' ),
				'default'           => array(
					'width'     => '217px',
					'height'    => '32px',
				)
			),
			
			array( 
				'id' => 'mobile_logo',
				'title' => esc_html__( 'Mobile Logo', 'huber' ),						
				'type' => 'media',
				'desc' => esc_html__( 'The image that is displayed in the header on mobile and smaller tablet devices.', 'huber' ),
				'default'  => array(
					'url' => get_template_directory_uri() . '/lib/images/logo.png',
				),
			 ),

			array(
				'id' => 'mobile_logo_dimensions',
				'type' => 'dimensions',
				'units' => 'px',
				'title' => esc_html__( 'Mobile Logo Dimensions', 'huber' ),
				'desc' => esc_html__( 'The width and height of the logo on mobile and smaller tablet devices.', 'huber' ),
				'subtitle' => esc_html__( 'Set to half the original logo dimensions for retina displays.', 'huber' ),
				'default'           => array(
					'width'     => '133px', 
					'height'    => '20px',
				)
			),

			array( 
				'id' => 'text_logo',
				'title' => esc_html__( 'Text Logo', 'huber' ),
				'subtitle' => esc_html__( 'Adding a text logo will remove any image logos.', 'huber' ),				
				'type' => 'text',
				'desc' => esc_html__( 'Use a text logo.', 'huber' ),
				'default'  => '',
			),

			array(  
				'id' => 'cart_button',
				'title' => esc_html__( 'Cart Button', 'huber' ),
				'desc' => esc_html__( 'Choose when the cart button is shown in the header.', 'huber' ),
				'type' => 'radio',
				'options' => array(
					'gp-cart-button-all' => esc_html__( 'Show on all devices', 'huber' ),
					'gp-cart-button-desktop' => esc_html__( 'Only show on desktop devices', 'huber' ),
					'gp-cart-button-mobile' => esc_html__( 'Only show on mobile devices', 'huber' ),
					'gp-cart-button-disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'gp-cart-button-all',
			),
			
			array(  
				'id' => 'search_button',
				'title' => esc_html__( 'Search Button', 'huber' ),
				'desc' => esc_html__( 'Choose when the search button is shown in the header.', 'huber' ),
				'type' => 'radio',
				'options' => array(
					'gp-search-button-all' => esc_html__( 'Show on all devices', 'huber' ),
					'gp-search-button-desktop' => esc_html__( 'Only show on desktop devices', 'huber' ),
					'gp-search-button-mobile' => esc_html__( 'Only show on mobile devices', 'huber' ),
					'gp-search-button-disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'gp-search-button-all',
			),

			array(  
				'id' => 'social_nav',
				'title' => esc_html__( 'Social Navigation', 'huber' ),
				'desc' => esc_html__( 'Choose when the social navigation is shown in the header.', 'huber' ),
				'type' => 'radio',
				'options' => array(
					'gp-social-nav-all' => esc_html__( 'Show on all devices', 'huber' ),
					'gp-social-nav-desktop' => esc_html__( 'Only show on desktop devices', 'huber' ),
					'gp-social-nav-mobile' => esc_html__( 'Only show on mobile devices', 'huber' ),
					'gp-social-nav-disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'gp-social-nav-desktop',
			),
												 
			array(  
				'id' => 'profile_nav',
				'title' => esc_html__( 'Profile Navigation', 'huber' ),
				'desc' => esc_html__( 'Choose when the profile navigation is shown in the header.', 'huber' ),
				'type' => 'radio',
				'options' => array(
					'gp-profile-nav-all' => esc_html__( 'Show on all devices', 'huber' ),
					'gp-profile-nav-desktop' => esc_html__( 'Only show on desktop devices', 'huber' ),
					'gp-profile-nav-mobile' => esc_html__( 'Only show on mobile devices', 'huber' ),
					'gp-profile-nav-disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'gp-profile-nav-all',
			),	
			
			array(  
				'id' => 'top_header',
				'title' => esc_html__( 'Top Header', 'huber' ),
				'type' => 'radio',
				'desc' => esc_html__( 'Display a top header above the main header.', 'huber' ),	
				'options' => array(
					'gp-top-header-all' => esc_html__( 'Show on all devices', 'huber' ),
					'gp-top-header-desktop' => esc_html__( 'Only show on desktop devices', 'huber' ),
					'gp-top-header-mobile' => esc_html__( 'Only show on mobile devices', 'huber' ),
					'gp-top-header-disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'gp-top-header-disabled',
			),			
																								
		),
			
	) );
	

	Redux::setSection( $opt_name, array(
		'id' => 'footer_options',
		'title' => esc_html__( 'Footer', 'huber' ),
		'desc' => esc_html__( 'Options for the footer.', 'huber' ),
		'icon' => 'el-icon-photo',
		'fields' => array(

			array( 
				'id' => 'footer_image',
				'title' => esc_html__( 'Footer Image', 'huber' ),						
				'type' => 'media',
				'desc' => esc_html__( 'The image that is displayed just above the footer.', 'huber' ),
				'default'  => array(
					'url' => get_template_directory_uri() . '/lib/images/logo.png',
				),
			 ),
			 		
			array(
				'id' => 'footer_image_dimensions',
				'type' => 'dimensions',
				'units' => 'px',
				'title' => esc_html__( 'Footer Image Dimensions', 'huber' ),
				'desc' => esc_html__( 'The width and height of the footer image.', 'huber' ),
				'subtitle' => esc_html__( 'Set to half the original footer image dimensions for retina displays.', 'huber' ),
				'default'           => array(
					'width'     => '217px',
					'height'    => '32px',			
				)
			),
									
			array(
				'id' => 'footer_image_spacing',
				'type' => 'spacing',
				'output' => array( '#gp-footer-image img' ),
				'mode' => 'margin',
				'units' => 'px',
				'title' => esc_html__( 'Footer Image Spacing', 'huber' ),
				'desc' => esc_html__( 'The spacing around the footer image.', 'huber' ),
				'default'       => array(
					'margin-top'    => '0', 
					'margin-right'  => '0', 
					'margin-bottom' => '-1px', 
					'margin-left'   => '0',
				)
			),
									
			array( 
				'id' => 'copyright_text',
				'title' => esc_html__( 'Copyright Text', 'huber' ),
				'desc' => esc_html__( 'Add copyright text to the footer.', 'huber' ),
				'type' => 'textarea',
			),
							
		),
		
	) );
		

	Redux::setSection( $opt_name, array(
		'id' => 'post_options',
		'title' => esc_html__( 'Posts', 'huber' ),
		'desc' => esc_html__( 'Global options for all posts (some options can be overridden on individual posts).', 'huber' ),
		'icon' => 'el-icon-pencil',
		'fields' => array(
			
			array( 
				'id' => 'post_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'Choose the type of page header you want to display.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-standard-page-header',
			),
			
			array( 
				'id' => 'post_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '500px', 
				)		
			),
														
			array( 
				'id' => 'post_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),					
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-right-sidebar',
			),
			
			array(
				'id'      => 'post_left_sidebar',
				'type'    => 'select',
				'required' => array( 'post_layout', 'equals', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'post_right_sidebar',
				'type'    => 'select',
				'required' => array( 'post_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-right-sidebar',
			),

			array(  
				'id' => 'post_image',
				'title' => esc_html__( 'Featured Image', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether to display the featured image.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
							
			array(
				'id'        => 'post_meta',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'huber' ),
				'desc' => esc_html__( 'Add post meta data to the page.', 'huber' ),
				'options'   => array(
					'release_date' => esc_html__( 'Release Date', 'huber' ),
					'author' => esc_html__( 'Author Name', 'huber' ),
					'date' => esc_html__( 'Post Date', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'followers' => esc_html__( 'Followers', 'huber' ),
					'cats' => esc_html__( 'Categories', 'huber' ),
					'tags' => esc_html__( 'Post Tags', 'huber' ),
					'post_nav' => esc_html__( 'Post Navigation', 'huber' ),
				),
				'default'   => array(
					'release_date' => '0',
					'author' => '1',
					'date' => '1',
					'comment_count' => '1',
					'views' => '1',
					'likes' => '1',
					'followers' => '0',
					'cats' => '0',
					'tags' => '1',
					'post_nav' => '1',
					'share_icons' => '1',
				)
			),
			
			array(  
				'id' => 'post_related_hubs',
				'title' => esc_html__( 'Related Hubs', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to show hubs that this post is associated with.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
			
			array(
				'id'        => 'post_related_hubs_title',
				'type'      => 'text',
				'required'  => array( 'post_related_hubs', '=', 'enabled' ),
				'title'     => esc_html__( 'Related Hubs Title', 'huber' ),
				'desc' => esc_html__( 'The title for the related hubs panel.', 'huber' ),
				'default'   => esc_html__( 'Related Games', 'huber' ),
			),
			
			array(  
				'id' => 'post_top_post_content',
				'title' => esc_html__( 'Top Post Content', 'huber' ),
				'desc' => esc_html__( 'Add code that will appear at the top of the post e.g. social icons.', 'huber' ),
				'type' => 'textarea',
				'default' => ''
			),

			array(  
				'id' => 'post_voting',
				'title' => esc_html__( 'Vote Up/Down', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a vote up/down panel to the page.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
			
			array(
				'id'        => 'post_voting_title',
				'type'      => 'text',
				'required'  => array( 'post_voting', '=', 'enabled' ),
				'title'     => esc_html__( 'Vote Up/Down Title', 'huber' ),
				'desc' => esc_html__( 'The title for the vote up/down panel.', 'huber' ),
				'default'   => esc_html__( 'Have your say!', 'huber' ),
			),
																   
			array(  
				'id' => 'post_author_info',
				'title' => esc_html__( 'Author Info Panel', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add an author info panel to the page.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),

			array(  
				'id' => 'post_related_items',
				'title' => esc_html__( 'Related Items', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a related items section to the page.', 'huber' ), 
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
						
		),			
	) );
	

	Redux::setSection( $opt_name, array(
		'id' => 'post_category_options',
		'title' => esc_html__( 'Post Categories', 'huber' ),
		'desc' => esc_html__( 'Global options for all post categories (some options can be overridden on individual post categories or by using the Blog page template).', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-folder-open',
		'fields' => array(	

			array( 
				'id' => 'cat_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The page header on the page.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-first-post-page-header' => esc_html__( 'First Post', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-standard-page-header',
			),

			array( 
				'id' => 'cat_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '500px', 
				)		
			 ),
			 										
			array( 
				'id' => 'cat_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-right-sidebar',
			),
			
			array(
				'id'      => 'cat_left_sidebar',
				'type'    => 'select',
				'required' => array( 'cat_layout', '=', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'cat_right_sidebar',
				'type'    => 'select',
				'required' => array( 'cat_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-right-sidebar',
			),
			
			array( 
				'id' => 'cat_format',
				'title' => esc_html__( 'Format', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The format to display the items in.', 'huber' ),
				'options' => array(
					'gp-blog-list' => esc_html__( 'List', 'huber' ),
					'gp-blog-columns-1' => esc_html__( '1 Column', 'huber' ),
					'gp-blog-columns-2' => esc_html__( '2 Columns', 'huber' ),
					'gp-blog-columns-3' => esc_html__( '3 Columns', 'huber' ),
					'gp-blog-columns-4' => esc_html__( '4 Columns', 'huber' ),
					'gp-blog-columns-5' => esc_html__( '5 Columns', 'huber' ),
					'gp-blog-columns-6' => esc_html__( '6 Columns', 'huber' ),
					'gp-blog-masonry' => esc_html__( 'Masonry', 'huber' ),
				),
				'default' => 'gp-blog-list',
			),

			array(  
				'id' => 'cat_orderby',
				'title' => esc_html__( 'Order By', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The criteria which the items are ordered by.', 'huber' ),
				'options' => array(
					'newest' => esc_html__( 'Newest', 'huber' ),
					'oldest' => esc_html__( 'Oldest', 'huber' ),
					'title_az' => esc_html__( 'Title (A-Z)', 'huber' ),
					'title_za' => esc_html__( 'Title (Z-A)', 'huber' ),
					'comment_count' => esc_html__( 'Most Comments', 'huber' ),
					'views' => esc_html__( 'Most Views', 'huber' ),
					'likes' => esc_html__( 'Most Likes', 'huber' ),
					'menu_order' => esc_html__( 'Menu Order', 'huber' ),
					'rand' => esc_html__( 'Random', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default' => 'newest',
			),
			
			array(
				'id'       => 'cat_per_page',
				'type'     => 'spinner',
				'title'    => esc_html__( 'Items Per Page', 'huber' ),
				'desc' => esc_html__( 'The number of items on each page.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 9,
			),
			
			array(
				'id'       => 'cat_standard_post_image_size',
				'title'    => esc_html__( 'Standard Post Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'cat_hub_image_size',
				'title'    => esc_html__( 'Hub Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'cat_review_image_size',
				'title'    => esc_html__( 'Review Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'cat_preview_image_size',
				'title'    => esc_html__( 'Preview Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
							
			array( 
				'id' => 'cat_content_display',
				'title' => esc_html__( 'Content Display', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'The amount of content displayed.', 'huber' ),
				'options' => array(
					'excerpt' => esc_html__( 'Excerpt', 'huber' ),
					'full_content' => esc_html__( 'Full Content', 'huber' ),
				),
				'default' => 'excerpt',
			),
		
			array( 
				'id' => 'cat_excerpt_length',
				'title' => esc_html__( 'Excerpt Length', 'huber' ),
				'required'  => array( 'cat_content_display', '=', 'excerpt' ),
				'type' => 'spinner',
				'desc' => esc_html__( 'The number of characters in excerpts.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => '200',
			),

			array(
				'id'        => 'cat_meta',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'huber' ),
				'desc' => esc_html__( 'Select the meta data you want to display.', 'huber' ), 
				'options'   => array(
					'release_date' => esc_html__( 'Release Date', 'huber' ),
					'author' => esc_html__( 'Author Name', 'huber' ),
					'date' => esc_html__( 'Post Date', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'followers' => esc_html__( 'Followers', 'huber' ),
					'cats' => esc_html__( 'Categories', 'huber' ),
					'tags' => esc_html__( 'Post Tags', 'huber' ),
					'hub_fields' => esc_html__( 'Hub Fields', 'huber' ),
					'site_rating' => esc_html__( 'Site Rating', 'huber' ),
					'user_rating' => esc_html__( 'User Rating', 'huber' ),
				),
				'default'   => array(
					'release_date' => '1',
					'author' => '0',
					'date' => '0', 
					'comment_count' => '0',
					'views' => '0',
					'likes' => '0',
					'followers' => '0',
					'cats' => '0',
					'tags' => '0',
					'hub_fields' => '1',
					'site_rating' => '1',
					'user_rating' => '0',
				)
			),
							
			array(
				'id'        => 'cat_filters',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Filters (Sorting)', 'huber' ),
				'desc' => esc_html__( 'Choose what options to display in the frontend dropdown filter menu (disabled if load more button enabled).', 'huber' ), 
				'options'   => array(
					'date' => esc_html__( 'Date', 'huber' ),
					'title' => esc_html__( 'Title', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default'   => array(
					'date' => '0',
					'title' => '0',
					'comment_count' => '0',
					'views' => '0',
					'likes' => '0',
					'release_date' => '0',
					'release_date_asc' => '0',
					'site_rating' => '0',
					'user_rating' => '0',
				),
			),
										  
			array(  
				'id' => 'cat_read_more_link',
				'title' => esc_html__( 'Read More Link', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a read more link below the content.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),

			array(  
				'id' => 'cat_pagination',
				'title' => esc_html__( 'Pagination', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'Add pagination numbers or load more button (filters are disabled if using load more button).', 'huber' ),
				'options' => array(
					'load-more' => esc_html__( 'Load More Button', 'huber' ),
					'page-numbers' => esc_html__( 'Page Numbers', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'page-numbers',
			),
			
		),						   
	) );


	Redux::setSection( $opt_name, array(
		'id' => 'search_results_options',
		'title' => esc_html__( 'Search Results', 'huber' ),
		'desc' => esc_html__( 'Global options for search results.', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-search',
		'fields' => array(	

			array( 
				'id' => 'search_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The page header on the page.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-standard-page-header',
			),

			array(
				'id' => 'search_page_header_bg', 
				'title' => esc_html__( 'Page Header Background', 'huber' ),
				'type'      => 'media',			
				'required' => array( 'search_page_header', '!=', 'gp-standard-page-header' ),
				'desc' => esc_html__( 'The background of the page header.', 'huber' ),
				'default' => '',
			),
			
			array( 
				'id' => 'search_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '500px', 
				)		
			 ),
			 															
			array( 
				'id' => 'search_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-right-sidebar',
			),
			
			array(
				'id'      => 'search_left_sidebar',
				'type'    => 'select',
				'required' => array( 'search_layout', '=', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'search_right_sidebar',
				'type'    => 'select',
				'required' => array( 'search_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-right-sidebar',
			),
			
			array( 
				'id' => 'search_format',
				'title' => esc_html__( 'Format', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The format to display the items in.', 'huber' ),
				'options' => array(
					'gp-blog-list' => esc_html__( 'List', 'huber' ),
					'gp-blog-columns-1' => esc_html__( '1 Column', 'huber' ),
					'gp-blog-columns-2' => esc_html__( '2 Columns', 'huber' ),
					'gp-blog-columns-3' => esc_html__( '3 Columns', 'huber' ),
					'gp-blog-columns-4' => esc_html__( '4 Columns', 'huber' ),
					'gp-blog-columns-5' => esc_html__( '5 Columns', 'huber' ),
					'gp-blog-columns-6' => esc_html__( '6 Columns', 'huber' ),
					'gp-blog-masonry' => esc_html__( 'Masonry', 'huber' ),
				),
				'default' => 'gp-blog-columns-2',
			),

			array(  
				'id' => 'search_post_types',
				'title' => esc_html__( 'Post Types', 'huber' ),
				'type' => 'select',
				'multi' => true,
				'data' => 'post_type',
				'desc' => esc_html__( 'Select the post types you want to show in search results.', 'huber' ),
				'default' => 'post',
			),
			
			array(  
				'id' => 'search_templates',
				'title' => esc_html__( 'Templates', 'huber' ),
				'type' => 'select',
				'multi' => true,
				'desc' => esc_html__( 'Further narrow down what template types you want to show in search results.', 'huber' ),
				'options' => array(
					'gp-standard-post' => esc_html__( 'Standard Posts', 'huber' ),
					'gp-hub-post' => esc_html__( 'Hubs', 'huber' ),
					'gp-review-post' => esc_html__( 'Reviews', 'huber' ),
					'gp-user-review-post' => esc_html__( 'User Reviews', 'huber' ),
					'gp-preview-post' => esc_html__( 'Previews', 'huber' ),
				),
				'default' => array( 'gp-standard-post', 'gp-hub-post', 'gp-review-post', 'gp-preview-post' ),
			),
			
			array(  
				'id' => 'search_orderby',
				'title' => esc_html__( 'Order By', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The criteria which the items are ordered by.', 'huber' ),
				'options' => array(
					'newest' => esc_html__( 'Newest', 'huber' ),
					'oldest' => esc_html__( 'Oldest', 'huber' ),
					'title_az' => esc_html__( 'Title (A-Z)', 'huber' ),
					'title_za' => esc_html__( 'Title (Z-A)', 'huber' ),
					'comment_count' => esc_html__( 'Most Comments', 'huber' ),
					'views' => esc_html__( 'Most Views', 'huber' ),
					'likes' => esc_html__( 'Most Likes', 'huber' ),
					'menu_order' => esc_html__( 'Menu Order', 'huber' ),
					'rand' => esc_html__( 'Random', 'huber' ),
					'release_date' => esc_html__( 'Release Date', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
					'relevance' => esc_html__( 'Relevance', 'huber' ),
				),
				'default' => 'relevance',
			),
			
			array(
				'id'       => 'search_per_page',
				'type'     => 'spinner',
				'title'    => esc_html__( 'Items Per Page', 'huber' ),
				'desc' => esc_html__( 'The number of items on each page.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 8,
			),
			
			array(
				'id'       => 'search_standard_post_image_size',
				'title'    => esc_html__( 'Standard Post Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'search_hub_image_size',
				'title'    => esc_html__( 'Hub Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'search_review_image_size',
				'title'    => esc_html__( 'Review Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'search_preview_image_size',
				'title'    => esc_html__( 'Preview Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
	
			array( 
				'id' => 'search_content_display',
				'title' => esc_html__( 'Content Display', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'The amount of content displayed.', 'huber' ),
				'options' => array(
					'excerpt' => esc_html__( 'Excerpt', 'huber' ),
					'full_content' => esc_html__( 'Full Content', 'huber' ),
				),
				'default' => 'excerpt',
			),
		
			array( 
				'id' => 'search_excerpt_length',
				'title' => esc_html__( 'Excerpt Length', 'huber' ),
				'required'  => array( 'search_content_display', '=', 'excerpt' ),
				'type' => 'spinner',
				'desc' => esc_html__( 'The number of characters in excerpts.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => '0',
			),

			array(
				'id'        => 'search_meta',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'huber' ),
				'desc' => esc_html__( 'Select the meta data you want to display.', 'huber' ), 
				'options'   => array(
					'release_date' => esc_html__( 'Release Date', 'huber' ),
					'author' => esc_html__( 'Author Name', 'huber' ),
					'date' => esc_html__( 'Post Date', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'followers' => esc_html__( 'Followers', 'huber' ),
					'cats' => esc_html__( 'Categories', 'huber' ),
					'tags' => esc_html__( 'Post Tags', 'huber' ),
					'hub_fields' => esc_html__( 'Hub Fields', 'huber' ),
					'site_rating' => esc_html__( 'Site Rating', 'huber' ),
					'user_rating' => esc_html__( 'User Rating', 'huber' ),
				),
				'default'   => array(
					'release_date' => '1',
					'author' => '0',
					'date' => '0', 
					'comment_count' => '0',
					'views' => '0',
					'likes' => '0',
					'followers' => '0',
					'cats' => '0',
					'tags' => '0',
					'hub_fields' => '1',
					'site_rating' => '1',
					'user_rating' => '0',
				)
			),
						
			array(
				'id'        => 'search_filters',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Filters (Sorting)', 'huber' ),
				'desc' => esc_html__( 'Choose what options to display in the frontend dropdown filter menu (disabled if load more button enabled).', 'huber' ), 
				'options'   => array(
					'relevance' => esc_html__( 'Relevance', 'huber' ),
					'date' => esc_html__( 'Date', 'huber' ),
					'title' => esc_html__( 'Title', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default'   => array(
					'relevance' => '0',
					'date' => '0',
					'title' => '0',
					'comment_count' => '0',
					'views' => '0',
					'likes' => '0',
					'release_date' => '0',
					'release_date_asc' => '0',
					'site_rating' => '0',
					'user_rating' => '0',
				)
			),
			
			array(  
				'id' => 'search_filters_templates',
				'title' => esc_html__( 'Templates', 'huber' ),
				'type' => 'select',
				'multi' => true,
				'desc' => esc_html__( 'Select the template types you want to add as frontend filters.', 'huber' ),
				'options' => array(
					'gp-standard-post' => esc_html__( 'Standard Posts', 'huber' ),
					'gp-hub-post' => esc_html__( 'Hubs', 'huber' ),
					'gp-review-post' => esc_html__( 'Reviews', 'huber' ),
					'gp-user-review-post' => esc_html__( 'User Reviews', 'huber' ),
					'gp-preview-post' => esc_html__( 'Previews', 'huber' ),
				),
				'default' => array( 'gp-standard-post', 'gp-hub-post', 'gp-review-post', 'gp-user-review-post', 'gp-preview-post' ),
			),
													   
			array(  
				'id' => 'search_read_more_link',
				'title' => esc_html__( 'Read More Link', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a read more link below the content.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),
			
			array(  
				'id' => 'search_pagination',
				'title' => esc_html__( 'Pagination', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'Add pagination numbers or load more button (filters are disabled if using load more button).', 'huber' ),
				'options' => array(
					'load-more' => esc_html__( 'Load More Button', 'huber' ),
					'page-numbers' => esc_html__( 'Page Numbers', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'page-numbers',
			),
			
		),						   
	) );
	

	Redux::setSection( $opt_name, array(
		'id' => 'author_posts_options',
		'title' => esc_html__( 'Author Posts', 'huber' ),
		'desc' => esc_html__( 'Global options for author posts.', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-user',
		'fields' => array(	

			array( 
				'id' => 'author_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The page header on the page.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-standard-page-header',
			),

			array(
				'id' => 'author_page_header_bg', 
				'title' => esc_html__( 'Page Header Background', 'huber' ),
				'type'      => 'media',			
				'required' => array( 'author_page_header', '!=', 'gp-standard-page-header' ),
				'desc' => esc_html__( 'The background of the page header.', 'huber' ),
				'default' => '',
			),
			
			array( 
				'id' => 'author_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '500px', 
				)		
			 ),
			 															
			array( 
				'id' => 'author_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-right-sidebar',
			),
			
			array(
				'id'      => 'author_left_sidebar',
				'type'    => 'select',
				'required' => array( 'author_layout', '=', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'author_right_sidebar',
				'type'    => 'select',
				'required' => array( 'author_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-right-sidebar',
			),
			
			array( 
				'id' => 'author_format',
				'title' => esc_html__( 'Format', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The format to display the items in.', 'huber' ),
				'options' => array(
					'gp-blog-list' => esc_html__( 'List', 'huber' ),
					'gp-blog-columns-1' => esc_html__( '1 Column', 'huber' ),
					'gp-blog-columns-2' => esc_html__( '2 Columns', 'huber' ),
					'gp-blog-columns-3' => esc_html__( '3 Columns', 'huber' ),
					'gp-blog-columns-4' => esc_html__( '4 Columns', 'huber' ),
					'gp-blog-columns-5' => esc_html__( '5 Columns', 'huber' ),
					'gp-blog-columns-6' => esc_html__( '6 Columns', 'huber' ),
					'gp-blog-masonry' => esc_html__( 'Masonry', 'huber' ),
				),
				'default' => 'gp-blog-columns-2',
			),

			array(  
				'id' => 'author_post_types',
				'title' => esc_html__( 'Post Types', 'huber' ),
				'type' => 'select',
				'multi' => true,
				'data' => 'post_type',
				'desc' => esc_html__( 'Select the post types you want to show in author posts.', 'huber' ),
				'default' => 'post',
			),
			
			array(  
				'id' => 'author_templates',
				'title' => esc_html__( 'Templates', 'huber' ),
				'type' => 'select',
				'multi' => true,
				'desc' => esc_html__( 'Further narrow down what template types you want to show in author posts.', 'huber' ),
				'options' => array(
					'gp-standard-post' => esc_html__( 'Standard Posts', 'huber' ),
					'gp-hub-post' => esc_html__( 'Hubs', 'huber' ),
					'gp-review-post' => esc_html__( 'Reviews', 'huber' ),
					'gp-user-review-post' => esc_html__( 'User Reviews', 'huber' ),
					'gp-preview-post' => esc_html__( 'Previews', 'huber' ),
				),
				'default' => array( 'gp-standard-post', 'gp-hub-post', 'gp-review-post', 'gp-preview-post' ),
			),
			
			array(  
				'id' => 'author_orderby',
				'title' => esc_html__( 'Order By', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The criteria which the items are ordered by.', 'huber' ),
				'options' => array(
					'newest' => esc_html__( 'Newest', 'huber' ),
					'oldest' => esc_html__( 'Oldest', 'huber' ),
					'title_az' => esc_html__( 'Title (A-Z)', 'huber' ),
					'title_za' => esc_html__( 'Title (Z-A)', 'huber' ),
					'comment_count' => esc_html__( 'Most Comments', 'huber' ),
					'views' => esc_html__( 'Most Views', 'huber' ),
					'likes' => esc_html__( 'Most Likes', 'huber' ),
					'menu_order' => esc_html__( 'Menu Order', 'huber' ),
					'rand' => esc_html__( 'Random', 'huber' ),
					'release_date' => esc_html__( 'Release Date', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default' => 'newest',
			),
			
			array(
				'id'       => 'author_per_page',
				'type'     => 'spinner',
				'title'    => esc_html__( 'Items Per Page', 'huber' ),
				'desc' => esc_html__( 'The number of items on each page.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 8,
			),
			
			array(
				'id'       => 'author_standard_post_image_size',
				'title'    => esc_html__( 'Standard Post Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'author_hub_image_size',
				'title'    => esc_html__( 'Hub Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'author_review_image_size',
				'title'    => esc_html__( 'Review Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'author_preview_image_size',
				'title'    => esc_html__( 'Preview Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
	
			array( 
				'id' => 'author_content_display',
				'title' => esc_html__( 'Content Display', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'The amount of content displayed.', 'huber' ),
				'options' => array(
					'excerpt' => esc_html__( 'Excerpt', 'huber' ),
					'full_content' => esc_html__( 'Full Content', 'huber' ),
				),
				'default' => 'excerpt',
			),
		
			array( 
				'id' => 'author_excerpt_length',
				'title' => esc_html__( 'Excerpt Length', 'huber' ),
				'required'  => array( 'author_content_display', '=', 'excerpt' ),
				'type' => 'spinner',
				'desc' => esc_html__( 'The number of characters in excerpts.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => '0',
			),

			array(
				'id'        => 'author_meta',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'huber' ),
				'desc' => esc_html__( 'Select the meta data you want to display.', 'huber' ), 
				'options'   => array(
					'release_date' => esc_html__( 'Release Date', 'huber' ),
					'author' => esc_html__( 'Author Name', 'huber' ),
					'date' => esc_html__( 'Post Date', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'followers' => esc_html__( 'Followers', 'huber' ),
					'cats' => esc_html__( 'Categories', 'huber' ),
					'tags' => esc_html__( 'Post Tags', 'huber' ),
					'hub_fields' => esc_html__( 'Hub Fields', 'huber' ),
					'site_rating' => esc_html__( 'Site Rating', 'huber' ),
					'user_rating' => esc_html__( 'User Rating', 'huber' ),
				),
				'default'   => array(
					'release_date' => '1',
					'author' => '0',
					'date' => '0', 
					'comment_count' => '0',
					'views' => '0',
					'likes' => '0',
					'followers' => '0',
					'cats' => '0',
					'tags' => '0',
					'hub_fields' => '1',
					'site_rating' => '1',
					'user_rating' => '0',
				)
			),
						
			array(
				'id'        => 'author_filters',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Filters (Sorting)', 'huber' ),
				'desc' => esc_html__( 'Choose what options to display in the frontend dropdown filter menu (disabled if load more button enabled).', 'huber' ), 
				'options'   => array(
					'date' => esc_html__( 'Date', 'huber' ),
					'title' => esc_html__( 'Title', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default'   => array(
					'date' => '0',
					'title' => '0',
					'comment_count' => '0',
					'views' => '0',
					'likes' => '0',
					'release_date' => '0',
					'release_date_asc' => '0',
					'site_rating' => '0',
					'user_rating' => '0',
				)
			),
													   
			array(  
				'id' => 'author_read_more_link',
				'title' => esc_html__( 'Read More Link', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a read more link below the content.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),
			
			array(  
				'id' => 'author_pagination',
				'title' => esc_html__( 'Pagination', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'Add pagination numbers or load more button (filters are disabled if using load more button).', 'huber' ),
				'options' => array(
					'load-more' => esc_html__( 'Load More Button', 'huber' ),
					'page-numbers' => esc_html__( 'Page Numbers', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'page-numbers',
			),
			
		),						   
	) );	
		
										
	Redux::setSection( $opt_name, array(
		'id' => 'page_options',
		'title' => esc_html__( 'Pages', 'huber' ),
		'desc' => esc_html__( 'Global options for all pages (some options can be overridden on individual pages).', 'huber' ),
		'icon' => 'el-icon-file',
		'fields' => array(

			array( 
				'id' => 'page_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The page header on the page.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-standard-page-header',
			),
			
			array( 
				'id' => 'page_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '500px', 
				)		
			),
													
			array( 
				'id' => 'page_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),					
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-right-sidebar',
			),

			array(
				'id'      => 'page_left_sidebar',
				'type'    => 'select',
				'required' => array( 'page_layout', '=', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'page_right_sidebar',
				'type'    => 'select',
				'required' => array( 'page_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-right-sidebar',
			),

			array(  
				'id' => 'page_image',
				'title' => esc_html__( 'Featured Image', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether to display the featured image.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
			
			array(  
				'id' => 'page_voting',
				'title' => esc_html__( 'Vote Up/Down', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a vote up/down panel to the page.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),
			
			array(
				'id'        => 'page_voting_title',
				'type'      => 'text',
				'required'  => array( 'page_voting', '=', 'enabled' ),
				'title'     => esc_html__( 'Vote Up/Down Title', 'huber' ),
				'desc' => esc_html__( 'The title for the vote up/down panel.', 'huber' ),
				'default'   => esc_html__( 'Have your say!', 'huber' ),
			),
			
			array(  
				'id' => 'page_author_info',
				'title' => esc_html__( 'Author Info Panel', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add an author info panel to the page.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),

		),
	) );
	

	Redux::setSection( $opt_name, array(
		'id' => 'hub_options',
		'title' => esc_html__( 'Hubs', 'huber' ),
		'desc' => esc_html__( 'General hub and review options.', 'huber' ),
		'icon' => 'el-icon-globe',
		'fields' => array(),
	) );
	
	Redux::setSection( $opt_name, array(
		'id' => 'review_options',
		'title' => esc_html__( 'General Hub/Review', 'huber' ),
		'desc' => esc_html__( 'General hub and review options.', 'huber' ),
		'icon' => 'el-icon-star',
		'subsection' => true,
		'fields' => array(

			array( 
				'id' => 'global_custom_tabs',
				'title' => esc_html__( 'Custom Endpoints And Tab Titles', 'huber' ),
				'type' => 'multi_text',
				'subtitle'  => esc_html__( 'After adding your endpoints, go to', 'huber' ) . ' <a href="' . admin_url( 'options-permalink.php' ) . '">' . esc_html__( 'Settings -> Permalinks', 'huber' ) . '</a> ' . esc_html__( 'and click Save Changes.', 'huber' ),
				'desc' => esc_html__( 'Add the endpoint and tab title for each custom tab e.g. endpoint:Tab Title. The endpoint will be shown in the URL e.g. http://domain.com/hub-name/endpoint. For more information click ', 'huber' ) . '<a href="https://ghostpool.ticksy.com/article/14366/" target="_blank">' . esc_html__( 'here', 'huber' ) . '</a>.',
				'add_text' => esc_html__( 'Add New', 'huber' ),
				'default' => '',
			),
			
			array(  
				'id' => 'hub_tab_order',
				'title' => esc_html__( 'Hub Tab Order', 'huber' ),
				'desc' => esc_html__( 'Enter the tabs in the order you want them to appear, add each one on a new line.', 'huber' ),
				'subtitle' => esc_html__( 'Available tabs: ', 'huber' ) . ' <code>%HUB%</code> <code>%REVIEWS%</code> <code>%PREVIEWS%</code> <code>%NEWS%</code> <code>%IMAGES%</code> <code>%VIDEOS%</code> <code>%FORUMS%</code> <code>%POST_SUBMISSION%</code> <code>%LOCAL_TAB_*%</code> <code>%GLOBAL_TAB_**%</code>' . '<br/>' . esc_html__( '* is the custom post/page ID - LOCAL_TAB_ will only show on hubs where this post/page is associated with that hub', 'huber' ) . '<br/>' . esc_html__( '** is the custom endpoint slug - GLOBAL_TAB_ will show on all hubs', 'huber' ),
				'type' => 'textarea',
				'default' => '
%HUB%
%REVIEWS%
%PREVIEWS%
%NEWS%
%IMAGES%
%VIDEOS%
%FORUMS%',
			),
			
			array(
				'id' => 'hub_tab_count',
				'title' => esc_html__( 'Hub Tab Count', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Checks if hubs have relevant posts before showing tabs e.g. only shows Reviews tab if hub has associated reviews. Disable this on larger sites to reduce database queries.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
				
			array( 
				'id' => 'hub_fields',
				'title' => esc_html__( 'Hub Fields', 'huber' ),
				'type' => 'multi_text',
				'subtitle'  => esc_html__( 'After adding/editing the hub fields, go to', 'huber' ) . ' <a href="' . admin_url( 'options-permalink.php' ) . '">' . esc_html__( 'Settings -> Permalinks', 'huber' ) . '</a> ' . esc_html__( 'and click Save Changes. Do NOT use any of the reserved terms listed', 'huber' ) . ' <a href="https://codex.wordpress.org/Reserved_Terms" target="_blank">' . esc_html__( 'here', 'huber' ) . '</a>.',
				'desc' => esc_html__( 'Add hub fields that can be displayed on your hub pages.', 'huber' ),
				'validate' => 'unique_slug',
				'add_text' => esc_html__( 'Add New', 'huber' ),
				'default' => array(
					0 => esc_html__( 'Genre', 'huber' ),
					1 => esc_html__( 'Rating', 'huber' ),
					2 => esc_html__( 'Developed By', 'huber' ),
					3 => esc_html__( 'Publisher', 'huber' ),
				),
			),
						
			array(
				'id' => 'hub_field_links',
				'title' => esc_html__( 'Hub Field Links', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether to disable the links to the archive pages for hub fields.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),

			array(
				'id' => 'hub_header_associated_content',
				'title' => esc_html__( 'Hub Header On Associated Content', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to display hub header on associated posts, reviews and previews.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),
			
			array(
				'id' => 'hub_tab_associated_content',
				'title' => esc_html__( 'Hub Tabs On Associated Content', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to display hub tabs on associated posts, reviews and previews.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),
			
			array(
				'id'       => 'release_date_format',
				'type'     => 'text',
				'title'    => esc_html__( 'Release Date Format', 'huber' ),
				'subtitle' => esc_html__( 'For all date formats ', 'huber' ) . '<a href="https://codex.wordpress.org/Formatting_Date_and_Time" target="_blank">' . esc_html__( 'click here', 'huber' ) . '</a>.',
				'desc' => esc_html__( 'The release date format.', 'huber' ),
				'default' => 'F j, Y',
			),
						
			array(
				'id'       => 'release_date_text',
				'type'     => 'text',
				'title'    => esc_html__( 'Release Date Text', 'huber' ),
				'desc' => esc_html__( 'The text displayed next to the release date.', 'huber' ),
				'default' => esc_html__( 'Released', 'huber' ),
			),
			
			array(
				'id'       => 'upcoming_date_text',
				'type'     => 'text',
				'title'    => esc_html__( 'Upcoming Date Text', 'huber' ),
				'desc' => esc_html__( 'The text displayed next to the upcoming date.', 'huber' ),
				'default' => esc_html__( 'Coming', 'huber' ),
			),

			array(
				'id'       => 'hub_header_fields',
				'type'     => 'select',
				'multi' => true,
				'title'    => esc_html__( 'Include Hub Header Fields', 'huber' ),
				'data' => 'taxonomies',
				'args' => array( 'object_type' => array( 'post', 'page' ) ),
				'desc' => esc_html__( 'Select the hub fields you want to include in the hub header.', 'huber' ),
				'default' => '',
			),
												
			array(
				'id' => 'visitor_voting',
				'title' => esc_html__( 'Visitor Voting', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether to allow visitors to rate items.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
						
			array(  
				'id' => 'rating_number',
				'title' => esc_html__( 'Rating Number', 'huber' ),
				'type' => 'spinner',
				'desc' => esc_html__( 'The maximum number users can vote up to.', 'huber' ),						
				'min' => 1,
				'max' => 10,
				'default' => 10,
			),
											
			array( 
				'id' => 'site_rating_criteria',
				'title' => esc_html__( 'Rating Criteria', 'huber' ),
				'subtitle' => esc_html__( 'Can overwrite this on individual pages.', 'huber' ),
				'desc' => esc_html__( 'Add multiple rating criteria to your site rating.', 'huber' ),
				'type' => 'multi_text',
				'add_text' => esc_html__( 'Add New', 'huber' ),
				'default' => array(
					0 => esc_html__( 'Gameplay', 'huber' ),
					1 => esc_html__( 'Graphics', 'huber' ),
					2 => esc_html__( 'Audio', 'huber' ),
					3 => esc_html__( 'Longevity', 'huber' ),
				),
			),
						   
			array(
				'id' => 'site_rating_text_1',
				'title' => esc_html__( 'Rating 1 Text', 'huber' ),
				'type' => 'text',
				'desc' => esc_html__( 'The text used to describe a site rating of 1.', 'huber' ),
				'default' => esc_html__( 'Horrendous', 'huber' ),
			),

			array(
				'id' => 'site_rating_text_2',
				'title' => esc_html__( 'Rating 2 Text', 'huber' ),
				'desc' => esc_html__( 'The text used to describe a site rating of 2.', 'huber' ),
				'type' => 'text',
				'default' => esc_html__( 'Awful', 'huber' ),
			),

			array(
				'id' => 'site_rating_text_3',
				'title' => esc_html__( 'Rating 3 Text', 'huber' ),
				'desc' => esc_html__( 'The text used to describe a site rating of 3.', 'huber' ),
				'type' => 'text',
				'default' => esc_html__( 'Bad', 'huber' ),
			),
			
			array(
				'id' => 'site_rating_text_4',
				'title' => esc_html__( 'Rating 4 Text', 'huber' ),
				'desc' => esc_html__( 'The text used to describe a site rating of 4.', 'huber' ),
				'type' => 'text',
				'default' => esc_html__( 'Poor', 'huber' ),
			),
			
			array(
				'id' => 'site_rating_text_5',
				'title' => esc_html__( 'Rating 5 Text', 'huber' ),
				'desc' => esc_html__( 'The text used to describe a site rating of 5.', 'huber' ),
				'type' => 'text',
				'default' => esc_html__( 'Average', 'huber' ),
			),
			
			array(
				'id' => 'site_rating_text_6',
				'title' => esc_html__( 'Rating 6 Text', 'huber' ),
				'desc' => esc_html__( 'The text used to describe a site rating of 6.', 'huber' ),
				'type' => 'text',
				'default' => esc_html__( 'Fair', 'huber' ),
			),
			array(
				'id' => 'site_rating_text_7',
				'title' => esc_html__( 'Rating 7 Text', 'huber' ),
				'desc' => esc_html__( 'The text used to describe a site rating of 7.', 'huber' ),
				'type' => 'text',
				'default' => esc_html__( 'Good', 'huber' ),
			),
			array(
				'id' => 'site_rating_text_8',
				'title' => esc_html__( 'Rating 8 Text', 'huber' ),
				'desc' => esc_html__( 'The text used to describe a site rating of 8.', 'huber' ),
				'type' => 'text',
				'default' => esc_html__( 'Great', 'huber' ),
			),
			array(
				'id' => 'site_rating_text_9',
				'title' => esc_html__( 'Rating 9 Text', 'huber' ),
				'desc' => esc_html__( 'The text used to describe a site rating of 9.', 'huber' ),
				'type' => 'text',
				'default' => esc_html__( 'Amazing', 'huber' ),
			),
			array(
				'id' => 'site_rating_text_10',
				'title' => esc_html__( 'Rating 10 Text', 'huber' ),
				'desc' => esc_html__( 'The text used to describe a site rating of 10.', 'huber' ),
				'type' => 'text',
				'default' => esc_html__( 'Perfect', 'huber' ),
			),			

			array(
				'id'        => 'rating_color_1',
				'type'      => 'color',
				'title'     => esc_html__( 'Rating Color (1-2.9)', 'huber' ),
				'transparent' => false,
				'output'    => array( 
					'background-color' => '.gp-rating-color-1',
				),                        
				'default' => '#20dddb',
			),

			array(
				'id'        => 'rating_color_2',
				'type'      => 'color',
				'title'     => esc_html__( 'Rating Color (3-4.9)', 'huber' ),
				'transparent' => false,
				'output'    => array( 
					'background-color' => '.gp-rating-color-2',
				),                        
				'default' => '#20dd7d',
			),

			array(
				'id'        => 'rating_color_3',
				'type'      => 'color',
				'title'     => esc_html__( 'Rating Color (5-6.9)', 'huber' ),
				'transparent' => false,
				'output'    => array( 
					'background-color' => '.gp-rating-color-3',
				),                        
				'default' => '#fab43b',
			),
			
			array(
				'id'        => 'rating_color_4',
				'type'      => 'color',
				'title'     => esc_html__( 'Rating Color (7-8.9)', 'huber' ),
				'transparent' => false,
				'output'    => array( 
					'background-color' => '.gp-rating-color-4',
				),                        
				'default' => '#fe7449',
			),											

			array(
				'id'        => 'rating_color_5',
				'type'      => 'color',
				'title'     => esc_html__( 'Rating Color (9-10)', 'huber' ),
				'transparent' => false,
				'output'    => array( 
					'background-color' => '.gp-rating-color-5',
				),                        
				'default' => '#fe4a49',
			),
			
			array(
				'id' => 'rating_unrated_image', 
				'title' => esc_html__( 'Rating Unrated Image', 'huber' ),
				'type'      => 'background',
				'desc' => esc_html__( 'The images used before a rating has been given.', 'huber' ),				
				'output'    => array( '.gp-rating-slider-wrapper .gp-rating-unrated' ),
				'preview' => false,
				'preview_media' => true,
				'background-size' => false,
				'background-color' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'transparent' => false,
				'default'   => array(
					'background-image' => get_template_directory_uri() . '/lib/images/user-rating-slider-unrated.png',
				),	
			),

			array(
				'id' => 'rating_hover_image', 
				'title' => esc_html__( 'Rating Hover Image', 'huber' ),
				'type'      => 'background',
				'desc' => esc_html__( 'The images shown when hovering over the rating.', 'huber' ),				
				'output'    => array( '.gp-rating-slider-wrapper .gp-rating-hover' ),
				'preview' => false,
				'preview_media' => true,
				'background-size' => false,
				'background-color' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'transparent' => false,
				'default'   => array(
					'background-image' => get_template_directory_uri() . '/lib/images/user-rating-slider-hover.png',
				),	
			),

			array(
				'id' => 'rating_rated_image', 
				'title' => esc_html__( 'Rating Rated Image', 'huber' ),
				'type'      => 'background',
				'desc' => esc_html__( 'The images shown when a rating has been given.', 'huber' ),				
				'output'    => array( '.gp-rating-slider-wrapper .gp-rating-rated' ),
				'preview' => false,
				'preview_media' => true,
				'background-size' => false,
				'background-color' => false,
				'background-repeat' => false,
				'background-attachment' => false,
				'background-position' => false,
				'transparent' => false,
				'default'   => array(
					'background-image' => get_template_directory_uri() . '/lib/images/user-rating-slider-rated.png',
				),	
			),
											
		),
	) );
	
	Redux::setSection( $opt_name, array(
		'id' => 'hub_template_options',
		'title' => esc_html__( 'Hub Template', 'huber' ),
		'desc' => esc_html__( 'General options for post/pages using the Hub template option.', 'huber' ),
		'icon' => 'el-icon-globe',
		'subsection' => true,
		'fields' => array(
		
			array(  
				'id' => 'hub_tabs',
				'title' => esc_html__( 'Hub Tabs', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add hub tabs to hub pages.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),

			array( 
				'id' => 'hub_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'Choose the type of page header you want to display.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-fullwidth-page-header',
			),
													
			array( 
				'id' => 'hub_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '400px', 
				)		
			),
											
			array( 
				'id' => 'hub_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),					
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-right-sidebar',
			),

			array(
				'id'      => 'hub_left_sidebar',
				'type'    => 'select',
				'required' => array( 'hub_layout', '=', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'hub_right_sidebar',
				'type'    => 'select',
				'required' => array( 'hub_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-hub-sidebar',
			),
																		
		),

	) );

	Redux::setSection( $opt_name, array(
		'id' => 'review_template_options',
		'title' => esc_html__( 'Review Template', 'huber' ),
		'desc' => esc_html__( 'General options for post/pages using the Review template option.', 'huber' ),
		'icon' => 'el-icon-star',
		'subsection' => true,
		'fields' => array(
				
			array( 
				'id' => 'review_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'Choose the type of page header you want to display.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-fullwidth-page-header',
			),
			
			array(  
				'id' => 'review_hub_header_content',
				'title' => esc_html__( 'Hub Header Content', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to show the hub header content.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),		
			
			array( 
				'id' => 'review_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '500px', 
				)		
			),
														
			array( 
				'id' => 'review_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),					
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-no-sidebar',
			),
			
			array(
				'id'      => 'review_left_sidebar',
				'type'    => 'select',
				'required' => array( 'review_layout', 'equals', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'review_right_sidebar',
				'type'    => 'select',
				'required' => array( 'review_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-review-sidebar',
			),

			array(
				'id'      => 'review_comments_sidebar',
				'type'    => 'select',
				'required' => array( 'review_layout', '=', array( 'gp-no-sidebar', 'gp-fullwidth' ) ),
				'title'   => esc_html__( 'Comments Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-review-sidebar',
			),


			array(  
				'id' => 'review_image',
				'title' => esc_html__( 'Featured Image', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether to display the featured image.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),
										
			array(
				'id'        => 'review_meta',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'huber' ),
				'desc' => esc_html__( 'Add post meta data to the page.', 'huber' ),
				'options'   => array(
					'release_date' => esc_html__( 'Release Date', 'huber' ),
					'author' => esc_html__( 'Author Name', 'huber' ),
					'date' => esc_html__( 'Post Date', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'followers' => esc_html__( 'Followers', 'huber' ),
					'cats' => esc_html__( 'Categories', 'huber' ),
					'tags' => esc_html__( 'Post Tags', 'huber' ),
					'post_nav' => esc_html__( 'Post Navigation', 'huber' ),
				),
				'default'   => array(
					'release_date' => '0',
					'author' => '1',
					'date' => '1',
					'comment_count' => '0',
					'views' => '0',
					'likes' => '0',
					'followers' => '0',
					'cats' => '0',
					'tags' => '0',
					'post_nav' => '0',
					'share_icons' => '1',
				)
			),
			
			array(  
				'id' => 'review_related_hubs',
				'title' => esc_html__( 'Related Hubs', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to show hubs that this post is associated with.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
			
			array(
				'id'        => 'review_related_hubs_title',
				'type'      => 'text',
				'required'  => array( 'review_related_hubs', '=', 'enabled' ),
				'title'     => esc_html__( 'Related Hubs Title', 'huber' ),
				'desc' => esc_html__( 'The title for the related hubs panel.', 'huber' ),
				'default'   => esc_html__( 'Related Games', 'huber' ),
			),
			
			array(  
				'id' => 'review_top_post_content',
				'title' => esc_html__( 'Top Post Content', 'huber' ),
				'desc' => esc_html__( 'Add code that will appear at the top of the post e.g. social icons.', 'huber' ),
				'type' => 'textarea',
				'default' => ''
			),

			array(  
				'id' => 'review_voting',
				'title' => esc_html__( 'Vote Up/Down', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a vote up/down panel to the page.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
			
			array(
				'id'        => 'review_voting_title',
				'type'      => 'text',
				'required'  => array( 'review_voting', '=', 'enabled' ),
				'title'     => esc_html__( 'Vote Up/Down Title', 'huber' ),
				'desc' => esc_html__( 'The title for the vote up/down panel.', 'huber' ),
				'default'   => esc_html__( 'Have your say!', 'huber' ),
			),
																   
			array(  
				'id' => 'review_author_info',
				'title' => esc_html__( 'Author Info Panel', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add an author info panel to the page.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),

			array(  
				'id' => 'review_related_items',
				'title' => esc_html__( 'Related Items', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a related items section to the page.', 'huber' ), 
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
					
			array(  
				'id' => 'review_results_position',
				'title' => esc_html__( 'Review Results Position', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose the position of the review results which contain the good/bad points and site rating.', 'huber' ),
				'options' => array(
					'top' => esc_html__( 'Top', 'huber' ),
					'bottom' => esc_html__( 'Bottom', 'huber' ),
				),
				'default' => 'bottom',
			),
											
		),
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'associated_posts_options',
		'title' => esc_html__( 'Associated Posts', 'huber' ),
		'desc' => esc_html__( 'Global options for all posts associated with hubs.', 'huber' ),
		'icon' => 'el-icon-pencil',
		'subsection' => true,
		'fields' => array(
			
			array( 
				'id' => 'associated_posts_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'Choose the type of page header you want to display.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-standard-page-header',
			),
			
			array( 
				'id' => 'associated_posts_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '500px', 
				)		
			),
														
			array( 
				'id' => 'associated_posts_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),					
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-right-sidebar',
			),
			
			array(
				'id'      => 'associated_posts_left_sidebar',
				'type'    => 'select',
				'required' => array( 'associated_posts_layout', 'equals', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'associated_posts_right_sidebar',
				'type'    => 'select',
				'required' => array( 'associated_posts_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-right-sidebar',
			),

			array(  
				'id' => 'associated_posts_image',
				'title' => esc_html__( 'Featured Image', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether to display the featured image.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
							
			array(
				'id'        => 'associated_posts_meta',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'huber' ),
				'desc' => esc_html__( 'Add post meta data to the page.', 'huber' ),
				'options'   => array(
					'author' => esc_html__( 'Author Name', 'huber' ),
					'date' => esc_html__( 'Post Date', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'followers' => esc_html__( 'Followers', 'huber' ),
					'cats' => esc_html__( 'Categories', 'huber' ),
					'tags' => esc_html__( 'Post Tags', 'huber' ),
					'post_nav' => esc_html__( 'Post Navigation', 'huber' ),
				),
				'default'   => array(
					'release_date' => '0',
					'author' => '1',
					'date' => '1',
					'comment_count' => '1',
					'views' => '1',
					'likes' => '1',
					'followers' => '0',
					'cats' => '0',
					'tags' => '1',
					'post_nav' => '1',
					'share_icons' => '1',
				)
			),
			
			array(  
				'id' => 'associated_posts_related_hubs',
				'title' => esc_html__( 'Related Hubs', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to show hubs that this post is associated with.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
			
			array(
				'id'        => 'associated_posts_related_hubs_title',
				'type'      => 'text',
				'required'  => array( 'associated_posts_related_hubs', '=', 'enabled' ),
				'title'     => esc_html__( 'Related Hubs Title', 'huber' ),
				'desc' => esc_html__( 'The title for the related hubs panel.', 'huber' ),
				'default'   => esc_html__( 'Related Games', 'huber' ),
			),
			
			array(  
				'id' => 'associated_posts_top_post_content',
				'title' => esc_html__( 'Top Post Content', 'huber' ),
				'desc' => esc_html__( 'Add code that will appear at the top of the post e.g. social icons.', 'huber' ),
				'type' => 'textarea',
				'default' => ''
			),

			array(  
				'id' => 'associated_posts_voting',
				'title' => esc_html__( 'Vote Up/Down', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a vote up/down panel to the page.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
			
			array(
				'id'        => 'associated_posts_voting_title',
				'type'      => 'text',
				'required'  => array( 'associated_posts_voting', '=', 'enabled' ),
				'title'     => esc_html__( 'Vote Up/Down Title', 'huber' ),
				'desc' => esc_html__( 'The title for the vote up/down panel.', 'huber' ),
				'default'   => esc_html__( 'Have your say!', 'huber' ),
			),
																   
			array(  
				'id' => 'associated_posts_author_info',
				'title' => esc_html__( 'Author Info Panel', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add an author info panel to the page.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),

			array(  
				'id' => 'associated_posts_related_items',
				'title' => esc_html__( 'Related Items', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a related items section to the page.', 'huber' ), 
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
						
		),			
	) );
	
	Redux::setSection( $opt_name, array(
		'id' => 'user_review_template_options',
		'title' => esc_html__( 'User Review Template', 'huber' ),
		'desc' => esc_html__( 'Global options for all user reviews.', 'huber' ),
		'icon' => 'el-icon-star',
		'subsection' => true,
		'fields' => array(
			
			array( 
				'id' => 'user_review_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'Choose the type of page header you want to display.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-standard-page-header',
			),
			
			array( 
				'id' => 'user_review_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '500px', 
				)		
			),
														
			array( 
				'id' => 'user_review_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),					
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-right-sidebar',
			),
			
			array(
				'id'      => 'user_review_left_sidebar',
				'type'    => 'select',
				'required' => array( 'user_review_layout', 'equals', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'user_review_right_sidebar',
				'type'    => 'select',
				'required' => array( 'user_review_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-right-sidebar',
			),

			array(  
				'id' => 'user_review_image',
				'title' => esc_html__( 'Featured Image', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether to display the featured image.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
							
			array(
				'id'        => 'user_review_meta',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'huber' ),
				'desc' => esc_html__( 'Add post meta data to the page.', 'huber' ),
				'options'   => array(
					'author' => esc_html__( 'Author Name', 'huber' ),
					'date' => esc_html__( 'Post Date', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'followers' => esc_html__( 'Followers', 'huber' ),
					'cats' => esc_html__( 'Categories', 'huber' ),
					'tags' => esc_html__( 'Post Tags', 'huber' ),
					'post_nav' => esc_html__( 'Post Navigation', 'huber' ),
				),
				'default'   => array(
					'release_date' => '0',
					'author' => '1',
					'date' => '1',
					'comment_count' => '1',
					'views' => '1',
					'likes' => '1',
					'followers' => '0',
					'cats' => '0',
					'tags' => '1',
					'post_nav' => '1',
					'share_icons' => '1',
				)
			),
			
			array(  
				'id' => 'user_review_related_hubs',
				'title' => esc_html__( 'Related Hubs', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to show hubs that this post is associated with.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
			
			array(
				'id'        => 'user_review_related_hubs_title',
				'type'      => 'text',
				'required'  => array( 'user_review_related_hubs', '=', 'enabled' ),
				'title'     => esc_html__( 'Related Hubs Title', 'huber' ),
				'desc' => esc_html__( 'The title for the related hubs panel.', 'huber' ),
				'default'   => esc_html__( 'Related Games', 'huber' ),
			),
			
			array(  
				'id' => 'user_review_top_post_content',
				'title' => esc_html__( 'Top Post Content', 'huber' ),
				'desc' => esc_html__( 'Add code that will appear at the top of the post e.g. social icons.', 'huber' ),
				'type' => 'textarea',
				'default' => ''
			),

			array(  
				'id' => 'user_review_voting',
				'title' => esc_html__( 'Vote Up/Down', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a vote up/down panel to the page.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
			
			array(
				'id'        => 'user_review_voting_title',
				'type'      => 'text',
				'required'  => array( 'user_review_voting', '=', 'enabled' ),
				'title'     => esc_html__( 'Vote Up/Down Title', 'huber' ),
				'desc' => esc_html__( 'The title for the vote up/down panel.', 'huber' ),
				'default'   => esc_html__( 'Have your say!', 'huber' ),
			),
																   
			array(  
				'id' => 'user_review_author_info',
				'title' => esc_html__( 'Author Info Panel', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add an author info panel to the page.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),

			array(  
				'id' => 'user_review_related_items',
				'title' => esc_html__( 'Related Items', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a related items section to the page.', 'huber' ), 
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
						
		),			
	) );
	
	Redux::setSection( $opt_name, array(
		'id' => 'preview_template_options',
		'title' => esc_html__( 'Preview Template', 'huber' ),
		'desc' => esc_html__( 'General options for post/pages using the Preview template option.', 'huber' ),
		'icon' => 'el-icon-eye-open',
		'subsection' => true,
		'fields' => array(
						
			array( 
				'id' => 'preview_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'Choose the type of page header you want to display.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-fullwidth-page-header',
			),
			
			array(  
				'id' => 'preview_hub_header_content',
				'title' => esc_html__( 'Hub Header Content', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to show the hub header content.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),
						
			array( 
				'id' => 'preview_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '500px', 
				)		
			),
														
			array( 
				'id' => 'preview_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),					
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-no-sidebar',
			),
			
			array(
				'id'      => 'preview_left_sidebar',
				'type'    => 'select',
				'required' => array( 'preview_layout', 'equals', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'preview_right_sidebar',
				'type'    => 'select',
				'required' => array( 'preview_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-review-sidebar',
			),

			array(
				'id'      => 'preview_comments_sidebar',
				'type'    => 'select',
				'required' => array( 'preview_layout', '=', array( 'gp-no-sidebar', 'gp-fullwidth' ) ),
				'title'   => esc_html__( 'Comments Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-review-sidebar',
			),


			array(  
				'id' => 'preview_image',
				'title' => esc_html__( 'Featured Image', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether to display the featured image.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),
										
			array(
				'id'        => 'preview_meta',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'huber' ),
				'desc' => esc_html__( 'Add post meta data to the page.', 'huber' ),
				'options'   => array(
					'release_date' => esc_html__( 'Release Date', 'huber' ),
					'author' => esc_html__( 'Author Name', 'huber' ),
					'date' => esc_html__( 'Post Date', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'followers' => esc_html__( 'Followers', 'huber' ),
					'cats' => esc_html__( 'Categories', 'huber' ),
					'tags' => esc_html__( 'Post Tags', 'huber' ),
					'post_nav' => esc_html__( 'Post Navigation', 'huber' ),
				),
				'default'   => array(
					'release_date' => '0',
					'author' => '1',
					'date' => '1',
					'comment_count' => '0',
					'views' => '0',
					'likes' => '0',
					'followers' => '0',
					'cats' => '0',
					'tags' => '0',
					'post_nav' => '0',
					'share_icons' => '1',
				)
			),
			
			array(  
				'id' => 'preview_related_hubs',
				'title' => esc_html__( 'Related Hubs', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to show hubs that this post is associated with.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
			
			array(
				'id'        => 'preview_related_hubs_title',
				'type'      => 'text',
				'required'  => array( 'preview_related_hubs', '=', 'enabled' ),
				'title'     => esc_html__( 'Related Hubs Title', 'huber' ),
				'desc' => esc_html__( 'The title for the related hubs panel.', 'huber' ),
				'default'   => esc_html__( 'Related Games', 'huber' ),
			),
			
			array(  
				'id' => 'preview_top_post_content',
				'title' => esc_html__( 'Top Post Content', 'huber' ),
				'desc' => esc_html__( 'Add code that will appear at the top of the post e.g. social icons.', 'huber' ),
				'type' => 'textarea',
				'default' => ''
			),

			array(  
				'id' => 'preview_voting',
				'title' => esc_html__( 'Vote Up/Down', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a vote up/down panel to the page.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
			
			array(
				'id'        => 'preview_voting_title',
				'type'      => 'text',
				'required'  => array( 'preview_voting', '=', 'enabled' ),
				'title'     => esc_html__( 'Vote Up/Down Title', 'huber' ),
				'desc' => esc_html__( 'The title for the vote up/down panel.', 'huber' ),
				'default'   => esc_html__( 'Have your say!', 'huber' ),
			),
																   
			array(  
				'id' => 'preview_author_info',
				'title' => esc_html__( 'Author Info Panel', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add an author info panel to the page.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),

			array(  
				'id' => 'preview_related_items',
				'title' => esc_html__( 'Related Items', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a related items section to the page.', 'huber' ), 
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
					
			array(  
				'id' => 'preview_results_position',
				'title' => esc_html__( 'Preview Results Position', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose the position of the preview results which contain the good/bad points and site rating.', 'huber' ),
				'options' => array(
					'top' => esc_html__( 'Top', 'huber' ),
					'bottom' => esc_html__( 'Bottom', 'huber' ),
				),
				'default' => 'bottom',
			),
														
		),
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'hub_tab_options',
		'title' => esc_html__( 'Hub Tab', 'huber' ),
		'icon' => 'el-icon-pencil',
		'subsection' => true,
		'fields' => array(	
			
			array(  
				'id' => 'hub_tab',
				'title' => esc_html__( 'Hub Tab Title', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to enable the hub tab title.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' )
				),
				'default' => 'enabled',
			),		
			
			array(
				'id'       => 'hub_tab_title',
				'required'  => array( 'hub_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Tab Title', 'huber' ),
				'subtitle' => esc_html__( 'Leave this empty to show the name of the hub page.', 'huber' ),
				'desc' => esc_html__( 'The home hub tab title.', 'huber' ),
				'default' => '',
			),

			array(
				'id'       => 'hub_tab_page_title',
				'type'     => 'text',
				'title'    => esc_html__( 'Page Title', 'huber' ),
				'desc' => esc_html__( 'The hub page title.', 'huber' ),
				'default' => esc_html__( 'Latest News', 'huber' ),
			),
				
			array(  
				'id' => 'hub_tab_posts',
				'title' => esc_html__( 'Display Associated Posts', 'huber' ),
				'subtitle' => esc_html__( 'You can also add content to each hub page text area to add your own custom content.', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to display all the posts (news, videos, previews and reviews) associated with the hub page.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' )
				),
				'default' => 'enabled',
			),
						
			array( 
				'id' => 'hub_tab_format',
				'required'  => array( 'hub_tab_posts', '=', 'enabled' ),
				'title' => esc_html__( 'Format', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The format to display the items in.', 'huber' ),
				'options' => array(
					'gp-blog-list' => esc_html__( 'List', 'huber' ),
					'gp-blog-columns-1' => esc_html__( '1 Column', 'huber' ),
					'gp-blog-columns-2' => esc_html__( '2 Columns', 'huber' ),
					'gp-blog-columns-3' => esc_html__( '3 Columns', 'huber' ),
					'gp-blog-columns-4' => esc_html__( '4 Columns', 'huber' ),
					'gp-blog-columns-5' => esc_html__( '5 Columns', 'huber' ),
					'gp-blog-columns-6' => esc_html__( '6 Columns', 'huber' ),
					'gp-blog-masonry' => esc_html__( 'Masonry', 'huber' ),
				),
				'default' => 'gp-blog-list',
			),

			array(  
				'id' => 'hub_tab_orderby',
				'required'  => array( 'hub_tab_posts', '=', 'enabled' ),
				'title' => esc_html__( 'Order By', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The criteria which the items are ordered by.', 'huber' ),
				'options' => array(
					'newest' => esc_html__( 'Newest', 'huber' ),
					'oldest' => esc_html__( 'Oldest', 'huber' ),
					'title_az' => esc_html__( 'Title (A-Z)', 'huber' ),
					'title_za' => esc_html__( 'Title (Z-A)', 'huber' ),
					'comment_count' => esc_html__( 'Most Comments', 'huber' ),
					'views' => esc_html__( 'Most Views', 'huber' ),
					'likes' => esc_html__( 'Most Likes', 'huber' ),
					'menu_order' => esc_html__( 'Menu Order', 'huber' ),
					'rand' => esc_html__( 'Random', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default' => 'newest',
			),
			
			array(
				'id'       => 'hub_tab_per_page',
				'required'  => array( 'hub_tab_posts', '=', 'enabled' ),
				'type'     => 'spinner',
				'title'    => esc_html__( 'Items Per Page', 'huber' ),
				'desc' => esc_html__( 'The number of items on each page.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 9,
			),
			
			array(
				'id'       => 'hub_tab_standard_post_image_size',
				'title'    => esc_html__( 'Standard Post Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'hub_tab_hub_image_size',
				'title'    => esc_html__( 'Hub Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'hub_tab_review_image_size',
				'title'    => esc_html__( 'Review Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'hub_tab_preview_image_size',
				'title'    => esc_html__( 'Preview Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
	
			array( 
				'id' => 'hub_tab_content_display',
				'required'  => array( 'hub_tab_posts', '=', 'enabled' ),
				'title' => esc_html__( 'Content Display', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'The amount of content displayed.', 'huber' ),
				'options' => array(
					'excerpt' => esc_html__( 'Excerpt', 'huber' ),
					'full_content' => esc_html__( 'Full Content', 'huber' ),
				),
				'default' => 'excerpt',
			),
		
			array( 
				'id' => 'hub_tab_excerpt_length',
				'required'  => array( array( 'hub_tab_content_display', '=', 'excerpt' ), array( 'hub_tab_posts', '=', 'enabled' ) ),
				'title' => esc_html__( 'Excerpt Length', 'huber' ),
				'type' => 'spinner',
				'desc' => esc_html__( 'The number of characters in excerpts.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => '200',
			),

			array(
				'id'        => 'hub_tab_meta',
				'required'  => array( 'hub_tab_posts', '=', 'enabled' ),
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'huber' ),
				'desc' => esc_html__( 'Select the meta data you want to display.', 'huber' ), 
				'options'   => array(
					'release_date' => esc_html__( 'Release Date', 'huber' ),
					'author' => esc_html__( 'Author Name', 'huber' ),
					'date' => esc_html__( 'Post Date', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'followers' => esc_html__( 'Followers', 'huber' ),
					'cats' => esc_html__( 'Categories', 'huber' ),
					'tags' => esc_html__( 'Post Tags', 'huber' ),
					'hub_fields' => esc_html__( 'Hub Fields', 'huber' ),
					'site_rating' => esc_html__( 'Site Rating', 'huber' ),
					'user_rating' => esc_html__( 'User Rating', 'huber' ),
				),
				'default'   => array(
					'release_date' => '0',
					'author' => '1',
					'date' => '1', 
					'comment_count' => '1',
					'views' => '0',
					'likes' => '0',
					'followers' => '0',
					'cats' => '0',
					'tags' => '0',
					'hub_fields' => '0',
					'site_rating' => '1',
					'user_rating' => '0',
				)
			),
											
			array(
				'id'        => 'hub_tab_filters',
				'required'  => array( 'hub_tab_posts', '=', 'enabled' ),
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Filters (Sorting)', 'huber' ),
				'desc' => esc_html__( 'Choose what options to display in the frontend dropdown filter menu (disabled if load more button enabled).', 'huber' ), 
				'options'   => array(
					'date' => esc_html__( 'Date', 'huber' ),
					'title' => esc_html__( 'Title', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default'   => array(
					'date' => '0',
					'title' => '0',
					'comment_count' => '0',
					'views' => '0',
					'likes' => '0',
					'release_date' => '0',
					'release_date_asc' => '0',
					'site_rating' => '0',
					'user_rating' => '0',
				),
			),
							  
			array(  
				'id' => 'hub_tab_read_more_link',
				'required'  => array( 'hub_tab_posts', '=', 'enabled' ),
				'title' => esc_html__( 'Read More Link', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a read more link below the content.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),		
								
		),
	) );
		
	Redux::setSection( $opt_name, array(
		'id' => 'reviews_tab_options',
		'title' => esc_html__( 'Reviews Tab', 'huber' ),
		'icon' => 'el-icon-star',
		'subsection' => true,
		'fields' => array(
		
			array(  
				'id' => 'reviews_tab',
				'title' => esc_html__( 'Reviews Tab', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to enable the reviews tab.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' )
				),
				'default' => 'enabled',
			),		
			
			array(
				'id'       => 'reviews_tab_title',
				'required'  => array( 'reviews_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Tab Title', 'huber' ),
				'desc' => esc_html__( 'The reviews tab title.', 'huber' ),
				'default' => esc_html__( 'Reviews', 'huber' ),
			),
			
			array(
				'id'       => 'reviews_tab_parameter',
				'required'  => array( 'reviews_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Tab URL Endpoint', 'huber' ),
				'subtitle'  => esc_html__( 'After editing the endpoint, go to', 'huber' ) . ' <a href="' . admin_url( 'options-permalink.php' ) . '">' . esc_html__( 'Settings -> Permalinks', 'huber' ) . '</a> ' . esc_html__( 'and click Save Changes.', 'huber' ),
				'desc' => esc_html__( 'The endpoint shown in the URL for this tab e.g. http://domain.com/hub-name/', 'huber' ) . '<strong>' . esc_html__( 'reviews', 'huber' ) . '</strong>',
				'default' => 'reviews',
			),
			
			array(
				'id'       => 'reviews_tab_page_title',
				'required'  => array( 'reviews_tab', '=', 'enabled'  ),
				'type'     => 'text',
				'title'    => esc_html__( 'Reviews Page Title', 'huber' ),
				'desc' => esc_html__( 'The reviews page title.', 'huber' ),
				'default' => esc_html__( 'Reviews', 'huber' ),
			),

			array(
				'id'       => 'user_reviews_tab_page_title',
				'required'  => array( 'reviews_tab', '=', 'enabled'  ),
				'type'     => 'text',
				'title'    => esc_html__( 'User Reviews Page Title', 'huber' ),
				'desc' => esc_html__( 'The user reviews page title.', 'huber' ),
				'default' => esc_html__( 'User Reviews', 'huber' ),
			),
						
			array( 
				'id' => 'reviews_tab_format',
				'required'  => array( 'reviews_tab', '=', 'enabled'  ),
				'title' => esc_html__( 'Format', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The format to display the items in.', 'huber' ),
				'options' => array(
					'gp-blog-list' => esc_html__( 'List', 'huber' ),
					'gp-blog-columns-1' => esc_html__( '1 Column', 'huber' ),
					'gp-blog-columns-2' => esc_html__( '2 Columns', 'huber' ),
					'gp-blog-columns-3' => esc_html__( '3 Columns', 'huber' ),
					'gp-blog-columns-4' => esc_html__( '4 Columns', 'huber' ),
					'gp-blog-columns-5' => esc_html__( '5 Columns', 'huber' ),
					'gp-blog-columns-6' => esc_html__( '6 Columns', 'huber' ),
					'gp-blog-masonry' => esc_html__( 'Masonry', 'huber' ),
				),
				'default' => 'gp-blog-list',
			),

			array(  
				'id' => 'reviews_tab_orderby',
				'required'  => array( 'reviews_tab', '=', 'enabled'  ),
				'title' => esc_html__( 'Order By', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The criteria which the items are ordered by.', 'huber' ),
				'options' => array(
					'newest' => esc_html__( 'Newest', 'huber' ),
					'oldest' => esc_html__( 'Oldest', 'huber' ),
					'title_az' => esc_html__( 'Title (A-Z)', 'huber' ),
					'title_za' => esc_html__( 'Title (Z-A)', 'huber' ),
					'comment_count' => esc_html__( 'Most Comments', 'huber' ),
					'views' => esc_html__( 'Most Views', 'huber' ),
					'likes' => esc_html__( 'Most Likes', 'huber' ),
					'menu_order' => esc_html__( 'Menu Order', 'huber' ),
					'rand' => esc_html__( 'Random', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default' => 'newest',
			),
			
			array(
				'id'       => 'reviews_tab_per_page',
				'required'  => array( 'reviews_tab', '=', 'enabled'  ),
				'type'     => 'spinner',
				'title'    => esc_html__( 'Items Per Page', 'huber' ),
				'desc' => esc_html__( 'The number of items on each page.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 9,
			),
			
			array(
				'id'       => 'reviews_tab_standard_post_image_size',
				'title'    => esc_html__( 'Standard Post Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'reviews_tab_hub_image_size',
				'title'    => esc_html__( 'Hub Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'reviews_tab_review_image_size',
				'title'    => esc_html__( 'Review Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'reviews_tab_preview_image_size',
				'title'    => esc_html__( 'Preview Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
	
			array( 
				'id' => 'reviews_tab_content_display',
				'required'  => array( 'reviews_tab', '=', 'enabled'  ),
				'title' => esc_html__( 'Content Display', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'The amount of content displayed.', 'huber' ),
				'options' => array(
					'excerpt' => esc_html__( 'Excerpt', 'huber' ),
					'full_content' => esc_html__( 'Full Content', 'huber' ),
				),
				'default' => 'excerpt',
			),
		
			array( 
				'id' => 'reviews_tab_excerpt_length',
				'required'  => array( array( 'reviews_tab_content_display', '=', 'excerpt' ), array( 'reviews_tab', '=', 'enabled' ) ),
				'title' => esc_html__( 'Excerpt Length', 'huber' ),
				'type' => 'spinner',
				'desc' => esc_html__( 'The number of characters in excerpts.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => '200',
			),

			array(
				'id'        => 'reviews_tab_meta',
				'required'  => array( 'reviews_tab', '=', 'enabled'  ),
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'huber' ),
				'desc' => esc_html__( 'Select the meta data you want to display.', 'huber' ), 
				'options'   => array(
					'release_date' => esc_html__( 'Release Date', 'huber' ),
					'author' => esc_html__( 'Author Name', 'huber' ),
					'date' => esc_html__( 'Post Date', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'followers' => esc_html__( 'Followers', 'huber' ),
					'cats' => esc_html__( 'Categories', 'huber' ),
					'tags' => esc_html__( 'Post Tags', 'huber' ),
					'hub_fields' => esc_html__( 'Hub Fields', 'huber' ),
					'site_rating' => esc_html__( 'Site Rating', 'huber' ),
					'user_rating' => esc_html__( 'User Rating', 'huber' ),
				),
				'default'   => array(
					'release_date' => '0',
					'author' => '1',
					'date' => '1', 
					'comment_count' => '1',
					'views' => '0',
					'likes' => '0',
					'followers' => '0',
					'cats' => '0',
					'tags' => '0',
					'hub_fields' => '0',
					'site_rating' => '1',
					'user_rating' => '0',
				)
			),
											
			array(
				'id'        => 'reviews_tab_filters',
				'required'  => array( 'reviews_tab', '=', 'enabled' ),
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Filters (Sorting)', 'huber' ),
				'desc' => esc_html__( 'Choose what options to display in the frontend dropdown filter menu (disabled if load more button enabled).', 'huber' ), 
				'options'   => array(
					'date' => esc_html__( 'Date', 'huber' ),
					'title' => esc_html__( 'Title', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default'   => array(
					'date' => '0',
					'title' => '0',
					'comment_count' => '0',
					'views' => '0',
					'likes' => '0',
					'release_date' => '0',
					'release_date_asc' => '0',
					'site_rating' => '0',
					'user_rating' => '0',
				),
			),
							  
			array(  
				'id' => 'reviews_tab_read_more_link',
				'required'  => array( 'reviews_tab', '=', 'enabled'  ),
				'title' => esc_html__( 'Read More Link', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a read more link below the content.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),		
								
		),
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'previews_tab_options',
		'title' => esc_html__( 'Previews Tab', 'huber' ),
		'icon' => 'el-icon-eye-open',
		'subsection' => true,
		'fields' => array(
		
			array(  
				'id' => 'previews_tab',
				'title' => esc_html__( 'Previews Tab', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to enable the previews tab.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' )
				),
				'default' => 'enabled',
			),		
			
			array(
				'id'       => 'previews_tab_title',
				'required'  => array( 'previews_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Tab Title', 'huber' ),
				'desc' => esc_html__( 'The previews tab title.', 'huber' ),
				'default' => esc_html__( 'Previews', 'huber' ),
			),
			
			array(
				'id'       => 'previews_tab_parameter',
				'required'  => array( 'previews_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Tab URL Endpoint', 'huber' ),
				'subtitle'  => esc_html__( 'After editing the endpoint, go to', 'huber' ) . ' <a href="' . admin_url( 'options-permalink.php' ) . '">' . esc_html__( 'Settings -> Permalinks', 'huber' ) . '</a> ' . esc_html__( 'and click Save Changes.', 'huber' ),
				'desc' => esc_html__( 'The endpoint shown in the URL for this tab e.g. http://domain.com/hub-name/', 'huber' ) . '<strong>' . esc_html__( 'previews', 'huber' ) . '</strong>',
				'default' => 'previews',
			),
			
			array(
				'id'       => 'previews_tab_page_title',
				'required'  => array( 'previews_tab', '=', 'enabled'  ),
				'type'     => 'text',
				'title'    => esc_html__( 'Page Title', 'huber' ),
				'desc' => esc_html__( 'The previews page title.', 'huber' ),
				'default' => esc_html__( 'Previews', 'huber' ),
			),
						
			array( 
				'id' => 'previews_tab_format',
				'required'  => array( 'previews_tab', '=', 'enabled'  ),
				'title' => esc_html__( 'Format', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The format to display the items in.', 'huber' ),
				'options' => array(
					'gp-blog-list' => esc_html__( 'List', 'huber' ),
					'gp-blog-columns-1' => esc_html__( '1 Column', 'huber' ),
					'gp-blog-columns-2' => esc_html__( '2 Columns', 'huber' ),
					'gp-blog-columns-3' => esc_html__( '3 Columns', 'huber' ),
					'gp-blog-columns-4' => esc_html__( '4 Columns', 'huber' ),
					'gp-blog-columns-5' => esc_html__( '5 Columns', 'huber' ),
					'gp-blog-columns-6' => esc_html__( '6 Columns', 'huber' ),
					'gp-blog-masonry' => esc_html__( 'Masonry', 'huber' ),
				),
				'default' => 'gp-blog-list',
			),

			array(  
				'id' => 'previews_tab_orderby',
				'required'  => array( 'previews_tab', '=', 'enabled'  ),
				'title' => esc_html__( 'Order By', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The criteria which the items are ordered by.', 'huber' ),
				'options' => array(
					'newest' => esc_html__( 'Newest', 'huber' ),
					'oldest' => esc_html__( 'Oldest', 'huber' ),
					'title_az' => esc_html__( 'Title (A-Z)', 'huber' ),
					'title_za' => esc_html__( 'Title (Z-A)', 'huber' ),
					'comment_count' => esc_html__( 'Most Comments', 'huber' ),
					'views' => esc_html__( 'Most Views', 'huber' ),
					'likes' => esc_html__( 'Most Likes', 'huber' ),
					'menu_order' => esc_html__( 'Menu Order', 'huber' ),
					'rand' => esc_html__( 'Random', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default' => 'newest',
			),
			
			array(
				'id'       => 'previews_tab_per_page',
				'required'  => array( 'previews_tab', '=', 'enabled'  ),
				'type'     => 'spinner',
				'title'    => esc_html__( 'Items Per Page', 'huber' ),
				'desc' => esc_html__( 'The number of items on each page.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 9,
			),
			
			array(
				'id'       => 'previews_tab_standard_post_image_size',
				'title'    => esc_html__( 'Standard Post Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'previews_tab_hub_image_size',
				'title'    => esc_html__( 'Hub Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'previews_tab_review_image_size',
				'title'    => esc_html__( 'Review Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'previews_tab_preview_image_size',
				'title'    => esc_html__( 'Preview Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
			
			array( 
				'id' => 'previews_tab_content_display',
				'required'  => array( 'previews_tab', '=', 'enabled'  ),
				'title' => esc_html__( 'Content Display', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'The amount of content displayed.', 'huber' ),
				'options' => array(
					'excerpt' => esc_html__( 'Excerpt', 'huber' ),
					'full_content' => esc_html__( 'Full Content', 'huber' ),
				),
				'default' => 'excerpt',
			),
		
			array( 
				'id' => 'previews_tab_excerpt_length',
				'required'  => array( array( 'previews_tab_content_display', '=', 'excerpt' ), array( 'previews_tab', '=', 'enabled' ) ),
				'title' => esc_html__( 'Excerpt Length', 'huber' ),
				'type' => 'spinner',
				'desc' => esc_html__( 'The number of characters in excerpts.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => '200',
			),

			array(
				'id'        => 'previews_tab_meta',
				'required'  => array( 'previews_tab', '=', 'enabled'  ),
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'huber' ),
				'desc' => esc_html__( 'Select the meta data you want to display.', 'huber' ), 
				'options'   => array(
					'release_date' => esc_html__( 'Release Date', 'huber' ),
					'author' => esc_html__( 'Author Name', 'huber' ),
					'date' => esc_html__( 'Post Date', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'followers' => esc_html__( 'Followers', 'huber' ),
					'cats' => esc_html__( 'Categories', 'huber' ),
					'tags' => esc_html__( 'Post Tags', 'huber' ),
					'hub_fields' => esc_html__( 'Hub Fields', 'huber' ),
					'site_rating' => esc_html__( 'Site Rating', 'huber' ),
					'user_rating' => esc_html__( 'User Rating', 'huber' ),
				),
				'default'   => array(
					'release_date' => '0',
					'author' => '1',
					'date' => '1', 
					'comment_count' => '1',
					'views' => '0',
					'likes' => '0',
					'followers' => '0',
					'cats' => '0',
					'tags' => '0',
					'hub_fields' => '0',
					'site_rating' => '1',
					'user_rating' => '0',
				)
			),
											
			array(
				'id'        => 'previews_tab_filters',
				'required'  => array( 'previews_tab', '=', 'enabled' ),
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Filters (Sorting)', 'huber' ),
				'desc' => esc_html__( 'Choose what options to display in the frontend dropdown filter menu (disabled if load more button enabled).', 'huber' ), 
				'options'   => array(
					'date' => esc_html__( 'Date', 'huber' ),
					'title' => esc_html__( 'Title', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default'   => array(
					'date' => '0',
					'title' => '0',
					'comment_count' => '0',
					'views' => '0',
					'likes' => '0',
					'release_date' => '0',
					'release_date_asc' => '0',
					'site_rating' => '0',
					'user_rating' => '0',
				),
			),
							  
			array(  
				'id' => 'previews_tab_read_more_link',
				'required'  => array( 'previews_tab', '=', 'enabled'  ),
				'title' => esc_html__( 'Read More Link', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a read more link below the content.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),		
								
		),
	) );
														
	Redux::setSection( $opt_name, array(
		'id' => 'news_tab_options',
		'title' => esc_html__( 'News Tab', 'huber' ),
		'icon' => 'el-icon-pencil',
		'subsection' => true,
		'fields' => array(
		
			array(  
				'id' => 'news_tab',
				'title' => esc_html__( 'News Tab', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to enable the news page.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' )
				),
				'default' => 'enabled',
			),		
			
			array(
				'id'       => 'news_tab_title',
				'required'  => array( 'news_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Tab Title', 'huber' ),
				'desc' => esc_html__( 'The news tab title.', 'huber' ),
				'default' => esc_html__( 'News', 'huber' ),
			),

			array(
				'id'       => 'news_tab_page_title',
				'required'  => array( 'news_tab', '=', 'enabled'  ),
				'type'     => 'text',
				'title'    => esc_html__( 'Page Title', 'huber' ),
				'desc' => esc_html__( 'The news page title.', 'huber' ),
				'default' => esc_html__( 'News', 'huber' ),
			),
			
			array(
				'id'       => 'news_tab_parameter',
				'required'  => array( 'news_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Tab URL Endpoint', 'huber' ),
				'subtitle'  => esc_html__( 'After editing the endpoint, go to', 'huber' ) . ' <a href="' . admin_url( 'options-permalink.php' ) . '">' . esc_html__( 'Settings -> Permalinks', 'huber' ) . '</a> ' . esc_html__( 'and click Save Changes.', 'huber' ),
				'desc' => esc_html__( 'The endpoint shown in the URL for this tab e.g. http://domain.com/hub-name/', 'huber' ) . '<strong>' . esc_html__( 'news', 'huber' ) . '</strong>',
				'default' => 'news',
			),
			
			array( 
				'id' => 'news_tab_format',
				'required'  => array( 'news_tab', '=', 'enabled'  ),
				'title' => esc_html__( 'Format', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The format to display the items in.', 'huber' ),
				'options' => array(
					'gp-blog-list' => esc_html__( 'List', 'huber' ),
					'gp-blog-columns-1' => esc_html__( '1 Column', 'huber' ),
					'gp-blog-columns-2' => esc_html__( '2 Columns', 'huber' ),
					'gp-blog-columns-3' => esc_html__( '3 Columns', 'huber' ),
					'gp-blog-columns-4' => esc_html__( '4 Columns', 'huber' ),
					'gp-blog-columns-5' => esc_html__( '5 Columns', 'huber' ),
					'gp-blog-columns-6' => esc_html__( '6 Columns', 'huber' ),
					'gp-blog-masonry' => esc_html__( 'Masonry', 'huber' ),
				),
				'default' => 'gp-blog-list',
			),

			array(  
				'id' => 'news_tab_orderby',
				'required'  => array( 'news_tab', '=', 'enabled'  ),
				'title' => esc_html__( 'Order By', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The criteria which the items are ordered by.', 'huber' ),
				'options' => array(
					'newest' => esc_html__( 'Newest', 'huber' ),
					'oldest' => esc_html__( 'Oldest', 'huber' ),
					'title_az' => esc_html__( 'Title (A-Z)', 'huber' ),
					'title_za' => esc_html__( 'Title (Z-A)', 'huber' ),
					'comment_count' => esc_html__( 'Most Comments', 'huber' ),
					'views' => esc_html__( 'Most Views', 'huber' ),
					'likes' => esc_html__( 'Most Likes', 'huber' ),
					'menu_order' => esc_html__( 'Menu Order', 'huber' ),
					'rand' => esc_html__( 'Random', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default' => 'newest',
			),
			
			array(
				'id'       => 'news_tab_per_page',
				'required'  => array( 'news_tab', '=', 'enabled'  ),
				'type'     => 'spinner',
				'title'    => esc_html__( 'Items Per Page', 'huber' ),
				'desc' => esc_html__( 'The number of items on each page.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 9,
			),
			
			array(
				'id'       => 'news_tab_standard_post_image_size',
				'title'    => esc_html__( 'Standard Post Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'news_tab_hub_image_size',
				'title'    => esc_html__( 'Hub Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'news_tab_review_image_size',
				'title'    => esc_html__( 'Review Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'news_tab_preview_image_size',
				'title'    => esc_html__( 'Preview Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
	
			array( 
				'id' => 'news_tab_content_display',
				'required'  => array( 'news_tab', '=', 'enabled'  ),
				'title' => esc_html__( 'Content Display', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'The amount of content displayed.', 'huber' ),
				'options' => array(
					'excerpt' => esc_html__( 'Excerpt', 'huber' ),
					'full_content' => esc_html__( 'Full Content', 'huber' ),
				),
				'default' => 'excerpt',
			),
		
			array( 
				'id' => 'news_tab_excerpt_length',
				'required'  => array( array( 'news_tab_content_display', '=', 'excerpt' ), array( 'news_tab', '=', 'enabled' ) ),
				'title' => esc_html__( 'Excerpt Length', 'huber' ),
				'type' => 'spinner',
				'desc' => esc_html__( 'The number of characters in excerpts.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => '200',
			),

			array(
				'id'        => 'news_tab_meta',
				'required'  => array( 'news_tab', '=', 'enabled'  ),
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'huber' ),
				'desc' => esc_html__( 'Select the meta data you want to display.', 'huber' ), 
				'options'   => array(
					'release_date' => esc_html__( 'Release Date', 'huber' ),
					'author' => esc_html__( 'Author Name', 'huber' ),
					'date' => esc_html__( 'Post Date', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'followers' => esc_html__( 'Followers', 'huber' ),
					'cats' => esc_html__( 'Categories', 'huber' ),
					'tags' => esc_html__( 'Post Tags', 'huber' ),
					'hub_fields' => esc_html__( 'Hub Fields', 'huber' ),
					'site_rating' => esc_html__( 'Site Rating', 'huber' ),
					'user_rating' => esc_html__( 'User Rating', 'huber' ),
				),
				'default'   => array(
					'release_date' => '0',
					'author' => '1',
					'date' => '1', 
					'comment_count' => '1',
					'views' => '0',
					'likes' => '0',
					'followers' => '0',
					'cats' => '0',
					'tags' => '0',
					'hub_fields' => '0',
					'site_rating' => '1',
					'user_rating' => '0',
				)
			),
											
			array(
				'id'        => 'news_tab_filters',
				'required'  => array( 'news_tab', '=', 'enabled' ),
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Filters (Sorting)', 'huber' ),
				'desc' => esc_html__( 'Choose what options to display in the frontend dropdown filter menu (disabled if load more button enabled).', 'huber' ), 
				'options'   => array(
					'date' => esc_html__( 'Date', 'huber' ),
					'title' => esc_html__( 'Title', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default'   => array(
					'date' => '0',
					'title' => '0',
					'comment_count' => '0',
					'views' => '0',
					'likes' => '0',
					'release_date' => '0',
					'release_date_asc' => '0',
					'site_rating' => '0',
					'user_rating' => '0',
				),
			),
							  
			array(  
				'id' => 'news_tab_read_more_link',
				'required'  => array( 'news_tab', '=', 'enabled'  ),
				'title' => esc_html__( 'Read More Link', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a read more link below the content.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),		
								
		),
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'images_tab_options',
		'title' => esc_html__( 'Images Tab', 'huber' ),
		'icon' => 'el-icon-picture',
		'subsection' => true,
		'fields' => array(
		
			array(  
				'id' => 'images_tab',
				'title' => esc_html__( 'Images Tab', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to enable the images tab.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' )
				),
				'default' => 'enabled',
			),		
			
			array(
				'id'       => 'images_tab_title',
				'required'  => array( 'images_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Tab Title', 'huber' ),
				'desc' => esc_html__( 'The images tab title.', 'huber' ),
				'default' => esc_html__( 'Images', 'huber' ),
			),

			array(
				'id'       => 'images_tab_page_title',
				'required'  => array( 'images_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Page Title', 'huber' ),
				'desc' => esc_html__( 'The images page title.', 'huber' ),
				'default' => esc_html__( 'Images', 'huber' ),
			),
			
			array(
				'id'       => 'images_tab_parameter',
				'required'  => array( 'images_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Tab URL Endpoint', 'huber' ),
				'subtitle'  => esc_html__( 'After editing the endpoint, go to', 'huber' ) . ' <a href="' . admin_url( 'options-permalink.php' ) . '">' . esc_html__( 'Settings -> Permalinks', 'huber' ) . '</a> ' . esc_html__( 'and click Save Changes.', 'huber' ),
				'desc' => esc_html__( 'The endpoint shown in the URL for this tab e.g. http://domain.com/hub-name/', 'huber' ) . '<strong>' . esc_html__( 'images', 'huber' ) . '</strong>',
				'default' => 'images',
			),
								
		),
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'videos_tab_options',
		'title' => esc_html__( 'Videos Tab', 'huber' ),
		'icon' => 'el-icon-video',
		'subsection' => true,
		'fields' => array(
		
			array(  
				'id' => 'videos_tab',
				'title' => esc_html__( 'Videos Tab', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to enable the videos tab.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' )
				),
				'default' => 'enabled',
			),		
			
			array(
				'id'       => 'videos_tab_title',
				'required'  => array( 'videos_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Tab Title', 'huber' ),
				'desc' => esc_html__( 'The videos tab title.', 'huber' ),
				'default' => esc_html__( 'Videos', 'huber' ),
			),

			array(
				'id'       => 'videos_tab_page_title',
				'required'  => array( 'videos_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Page Title', 'huber' ),
				'desc' => esc_html__( 'The videos page title.', 'huber' ),
				'default' => esc_html__( 'Videos', 'huber' ),
			),
			
			array(
				'id'       => 'videos_tab_parameter',
				'required'  => array( 'videos_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Tab URL Endpoint', 'huber' ),
				'subtitle'  => esc_html__( 'After editing the endpoint, go to', 'huber' ) . ' <a href="' . admin_url( 'options-permalink.php' ) . '">' . esc_html__( 'Settings -> Permalinks', 'huber' ) . '</a> ' . esc_html__( 'and click Save Changes.', 'huber' ),
				'desc' => esc_html__( 'The endpoint shown in the URL for this tab e.g. http://domain.com/hub-name/', 'huber' ) . '<strong>' . esc_html__( 'videos', 'huber' ) . '</strong>',
				'default' => 'videos',
			),

			array( 
				'id' => 'videos_tab_format',
				'required'  => array( 'videos_tab', '=', 'enabled' ),
				'title' => esc_html__( 'Format', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The format to display the items in.', 'huber' ),
				'options' => array(
					'gp-blog-list' => esc_html__( 'List', 'huber' ),
					'gp-blog-columns-1' => esc_html__( '1 Column', 'huber' ),
					'gp-blog-columns-2' => esc_html__( '2 Columns', 'huber' ),
					'gp-blog-columns-3' => esc_html__( '3 Columns', 'huber' ),
					'gp-blog-columns-4' => esc_html__( '4 Columns', 'huber' ),
					'gp-blog-columns-5' => esc_html__( '5 Columns', 'huber' ),
					'gp-blog-columns-6' => esc_html__( '6 Columns', 'huber' ),
					'gp-blog-masonry' => esc_html__( 'Masonry', 'huber' ),
				),
				'default' => 'gp-blog-columns-3',
			),

			array(  
				'id' => 'videos_tab_orderby',
				'required'  => array( 'videos_tab', '=', 'enabled' ),
				'title' => esc_html__( 'Order By', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The criteria which the items are ordered by.', 'huber' ),
				'options' => array(
					'newest' => esc_html__( 'Newest', 'huber' ),
					'oldest' => esc_html__( 'Oldest', 'huber' ),
					'title_az' => esc_html__( 'Title (A-Z)', 'huber' ),
					'title_za' => esc_html__( 'Title (Z-A)', 'huber' ),
					'comment_count' => esc_html__( 'Most Comments', 'huber' ),
					'views' => esc_html__( 'Most Views', 'huber' ),
					'likes' => esc_html__( 'Most Likes', 'huber' ),
					'menu_order' => esc_html__( 'Menu Order', 'huber' ),
					'rand' => esc_html__( 'Random', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default' => 'newest',
			),
			
			array(
				'id'       => 'videos_tab_per_page',
				'required'  => array( 'videos_tab', '=', 'enabled' ),
				'type'     => 'spinner',
				'title'    => esc_html__( 'Items Per Page', 'huber' ),
				'desc' => esc_html__( 'The number of items on each page.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 9,
			),
			
			array(
				'id'       => 'videos_tab_standard_post_image_size',
				'title'    => esc_html__( 'Standard Post Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'videos_tab_hub_image_size',
				'title'    => esc_html__( 'Hub Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'videos_tab_review_image_size',
				'title'    => esc_html__( 'Review Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
		
			array(
				'id'       => 'videos_tab_preview_image_size',
				'title'    => esc_html__( 'Preview Image Size', 'huber' ),
				'type'     => 'select',
				'data' => 'custom_image_size',
				'desc' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '" target="_blank">'. esc_html__( 'here', 'huber' ) . '</a>.',
				'default' => 'default',
			),
	
			array( 
				'id' => 'videos_tab_content_display',
				'required'  => array( 'videos_tab', '=', 'enabled' ),
				'title' => esc_html__( 'Content Display', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'The amount of content displayed.', 'huber' ),
				'options' => array(
					'excerpt' => esc_html__( 'Excerpt', 'huber' ),
					'full_content' => esc_html__( 'Full Content', 'huber' ),
				),
				'default' => 'excerpt',
			),
		
			array( 
				'id' => 'videos_tab_excerpt_length',
				'required'  => array( array( 'videos_tab_content_display', '=', 'excerpt' ), array( 'videos_tab', '=', 'enabled' ) ),
				'title' => esc_html__( 'Excerpt Length', 'huber' ),
				'type' => 'spinner',
				'desc' => esc_html__( 'The number of characters in excerpts.', 'huber' ),
				'min' => 0,
				'max' => 999999,
				'default' => '200',
			),

			array(
				'id'        => 'videos_tab_meta',
				'required'  => array( 'videos_tab', '=', 'enabled' ),
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'huber' ),
				'desc' => esc_html__( 'Select the meta data you want to display.', 'huber' ), 
				'options'   => array(
					'release_date' => esc_html__( 'Release Date', 'huber' ),
					'author' => esc_html__( 'Author Name', 'huber' ),
					'date' => esc_html__( 'Post Date', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'followers' => esc_html__( 'Followers', 'huber' ),
					'cats' => esc_html__( 'Categories', 'huber' ),
					'tags' => esc_html__( 'Post Tags', 'huber' ),
					'hub_fields' => esc_html__( 'Hub Fields', 'huber' ),
					'site_rating' => esc_html__( 'Site Rating', 'huber' ),
					'user_rating' => esc_html__( 'User Rating', 'huber' ),
				),
				'default'   => array(
					'release_date' => '0',
					'author' => '0',
					'date' => '1', 
					'comment_count' => '0',
					'views' => '0',
					'likes' => '0',
					'followers' => '0',
					'cats' => '0',
					'tags' => '0',
					'hub_fields' => '0',
					'site_rating' => '1',
					'user_rating' => '0',
				)
			),
											
			array(
				'id'        => 'videos_tab_filters',
				'required'  => array( 'videos_tab', '=', 'enabled' ),
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Filters (Sorting)', 'huber' ),
				'desc' => esc_html__( 'Choose what options to display in the frontend dropdown filter menu (disabled if load more button enabled).', 'huber' ), 
				'options'   => array(
					'date' => esc_html__( 'Date', 'huber' ),
					'title' => esc_html__( 'Title', 'huber' ),
					'comment_count' => esc_html__( 'Comment Count', 'huber' ),
					'views' => esc_html__( 'Views', 'huber' ),
					'likes' => esc_html__( 'Likes', 'huber' ),
					'release_date' => esc_html__( 'Latest Releases', 'huber' ),
					'release_date_asc' => esc_html__( 'Oldest Releases', 'huber' ),
					'site_rating' => esc_html__( 'Top Site Rated', 'huber' ),
					'user_rating' => esc_html__( 'Top User Rated', 'huber' ),
				),
				'default'   => array(
					'date' => '0',
					'title' => '0',
					'comment_count' => '0',
					'views' => '0',
					'likes' => '0',
					'release_date' => '0',
					'release_date_asc' => '0',
					'site_rating' => '0',
					'user_rating' => '0',
				),
			),
							  
			array(  
				'id' => 'videos_tab_read_more_link',
				'required'  => array( 'videos_tab', '=', 'enabled' ),
				'title' => esc_html__( 'Read More Link', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Add a read more link below the content.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),		
								
		),
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'forums_tab_options',
		'title' => esc_html__( 'Forums Tab', 'huber' ),
		'icon' => 'el-icon-comment-alt',
		'subsection' => true,
		'fields' => array(
		
			array(  
				'id' => 'forums_tab',
				'title' => esc_html__( 'Forums Tab', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to enable the forums tab.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' )
				),
				'default' => 'enabled',
			),		
			
			array(
				'id'       => 'forums_tab_title',
				'required'  => array( 'forums_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Tab Title', 'huber' ),
				'desc' => esc_html__( 'The forums tab title.', 'huber' ),
				'default' => esc_html__( 'Forums', 'huber' ),
			),

			array(
				'id'       => 'forums_tab_page_title',
				'required'  => array( 'forums_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Page Title', 'huber' ),
				'desc' => esc_html__( 'The forums page title.', 'huber' ),
				'default' => esc_html__( 'Forums', 'huber' ),
			),
			
			array(
				'id'       => 'forums_tab_parameter',
				'required'  => array( 'forums_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Tab URL Endpoint', 'huber' ),
				'subtitle'  => esc_html__( 'After editing the endpoint, go to', 'huber' ) . ' <a href="' . admin_url( 'options-permalink.php' ) . '">' . esc_html__( 'Settings -> Permalinks', 'huber' ) . '</a> ' . esc_html__( 'and click Save Changes.', 'huber' ),
				'desc' => esc_html__( 'The endpoint shown in the URL for this tab e.g. http://domain.com/hub-name/', 'huber' ) . '<strong>' . esc_html__( 'forums', 'huber' ) . '</strong>',
				'default' => 'forums',
			),
								
		),
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'post_submission_options',
		'title' => esc_html__( 'Post Submission', 'huber' ),
		'icon' => 'el-icon-envelope',
		'subsection' => true,
		'fields' => array(
		
			array( 
				'id' => 'post_submission_page',
				'title' => esc_html__( 'Post Submission Page', 'huber' ),
				'desc' => esc_html__( 'Select the page you want to use for your post list, post submission, editing and previews.', 'huber' ),
				'type' => 'select',
				'multi' => false,
				'data' => 'page',
				'default' => '',
			),
		
			array(  
				'id' => 'post_submission_tab',
				'title' => esc_html__( 'Post Submission Tab', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to enable the post submission tab.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' )
				),
				'default' => 'disabled',
			),	
			
			array(
				'id'       => 'post_submission_tab_title',
				'required'  => array( 'post_submission_tab', '=', 'enabled' ),
				'type'     => 'text',
				'title'    => esc_html__( 'Tab Title', 'huber' ),
				'desc' => esc_html__( 'The post submission tab title.', 'huber' ),
				'default' => esc_html__( 'Write A Review', 'huber' ),
			),

			array(
				'id'       => 'post_submission_page_title',
				'type'     => 'text',
				'title'    => esc_html__( 'Post Submission Page Title', 'huber' ),
				'desc' => esc_html__( 'The post submission page title.', 'huber' ),
				'default' => esc_html__( 'Write A Review', 'huber' ),
			),

			array(
				'id'       => 'post_edit_page_title',
				'type'     => 'text',
				'title'    => esc_html__( 'Post Edit Page Title', 'huber' ),
				'desc' => esc_html__( 'The post edit page title.', 'huber' ),
				'default' => esc_html__( 'Edit My Review', 'huber' ),
			),

			array(
				'id'       => 'post_preview_page_title',
				'type'     => 'text',
				'title'    => esc_html__( 'Post Preview Page Title', 'huber' ),
				'desc' => esc_html__( 'The post preview page title.', 'huber' ),
				'default' => esc_html__( 'Post Preview', 'huber' ),
			),
								
			array( 
				'id' => 'post_submission_visitors',
				'title' => esc_html__( 'Vistors Can Post', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether visitors can submit posts without logging in.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),	
			
			array( 
				'id' => 'post_submission_status',
				'title' => esc_html__( 'Submitting Posts', 'huber' ),
				'type' => 'radio',
				'desc' => esc_html__( 'Choose how users can submit their posts.', 'huber' ),
				'options' => array(
					'pending' => esc_html__( 'Posts need to be approved before showing up on the site', 'huber' ),
					'approved' => esc_html__( 'Posts are approved automatically', 'huber' ),
				),
				'default' => 'pending',
			),
			
			array( 
				'id' => 'post_editing_status',
				'title' => esc_html__( 'Editing Posts', 'huber' ),
				'type' => 'radio',
				'desc' => esc_html__( 'Choose how users can edit their posts.', 'huber' ),
				'options' => array(
					'approved' => esc_html__( 'Once a user edits a post it is approved automatically', 'huber' ),
					'pending' => esc_html__( 'Once a user edits a post it needs to be approved again', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'approved',
			),
			
			array( 
				'id' => 'post_deleting',
				'title' => esc_html__( 'Deleting Posts', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether users can delete posts.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
			
			array( 
				'id' => 'post_submission_email_notification',
				'title' => esc_html__( 'Email Notifications', 'huber' ),
				'subtitle' => esc_html__( 'You will only be emailed if posts need to be approved before they are submitted or edited.', 'huber' ),
				'type' => 'radio',
				'desc' => esc_html__( 'Choose how you receive email notifications when a user submits or edits a post.', 'huber' ),
				'options' => array(
					'email_always' => esc_html__( 'Email me whenever a user submits or edits a post', 'huber' ),
					'email_submission' => esc_html__( 'Email me only when a user submits a post', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'email_always',
			),

			/*array(
				'id' => 'post_submission_add_to_user_average',
				'title' => esc_html__( 'Add Rating To User Average', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose to add the rating from the user review to the user average score.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),*/
			
			array(
				'id' => 'post_submission_toc_url', 
				'title' => esc_html__( 'Terms of condition URL', 'huber' ),
				'type'      => 'text',	
				'validate'  => 'url',
				'desc' => esc_html__( 'The terms of condition page URL.', 'huber' ),
				'default' => '',
			),	

			array( 
				'id' => 'post_submission_categories',
				'title' => esc_html__( 'Post Categories', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether to allow users to select post categories.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),	

			array(
				'id'       => 'post_submission_parent_category',
				'required' => array( 'post_submission_categories', '=', 'enabled' ),
				'type'     => 'select',
				'multi' => true,
				'title'    => esc_html__( 'Categories', 'huber' ),
				'data' => 'terms',
				'args' => array( 'taxonomies' => 'category', 'hide_empty' => false ),
				'desc' => esc_html__( 'Select the category you want to display - only the sub categories of this category will be displayed.', 'huber' ),
				'default' => '',
			),
						
			array( 
				'id' => 'post_submission_formats',
				'title' => esc_html__( 'Post Formats', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Choose whether to allow users to select the post format.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'disabled',
			),	

			array(  
				'id' => 'post_submission_gdpr',
				'title' => esc_html__( 'Privacy Policy Checkbox (GDPR)', 'huber' ),
				'desc' => esc_html__( 'Add a privacy policy checkbox to the post submission form.', 'huber' ),
				'type' => 'button_set',
				'options'   => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				), 
				'default'   => 'disabled',
			),
			
			array(  
				'id' => 'post_submission_gdpr_text',
				'title' => esc_html__( 'Privacy Policy Text', 'huber' ),
				'desc' => esc_html__( 'Add your own privacy policy text next to the checkbox.', 'huber' ),
				'subtitle' => esc_html__( 'To add a link within your text use HTML tags e.g. "This is my text and this is a <a href="http://domain.com/privacy-policy">link</a>."', 'huber' ),
				'type' => 'textarea',
				'required' => array( 'post_submission_gdpr', '=', 'enabled' ),
			),
					
		),
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'following_options',
		'title' => esc_html__( 'Following Page', 'huber' ),
		'icon' => 'el-icon-plus',
		'subsection' => true,
		'fields' => array(
				
			array( 
				'id' => 'following_items',
				'title' => esc_html__( 'Following Items', 'huber' ),
				'type' => 'radio',
				'desc' => esc_html__( 'Choose who can follow items on your site.', 'huber' ),
				'options' => array(
					'both' => esc_html__( 'Members and visitors can follow items', 'huber' ),
					'members' => esc_html__( 'Only members can follow items', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'both',
			),	
				
			array( 
				'id' => 'following_page',
				'required' => array( 'following_items', '!=', 'disabled' ),
				'title' => esc_html__( 'Following Page', 'huber' ),
				'desc' => esc_html__( 'Select the page you want to use for showing followed items.', 'huber' ),
				'type' => 'select',
				'multi' => false,
				'data' => 'page',
				'default' => '',
			),

			array( 
				'id' => 'following_items_post_types',
				'required' => array( 'following_items', '!=', 'disabled' ),
				'title' => esc_html__( 'Following Post Types', 'huber' ),
				'desc' => esc_html__( 'Choose what post types to display for the latest items for each hub.', 'huber' ),
				'type' => 'select',
				'multi' => true,
				'data' => 'post_types',
				'default' => array( 'post', 'page' ),
			),
			
			array( 
				'id' => 'following_items_modified',
				'required' => array( 'following_items', '!=', 'disabled' ),
				'title' => esc_html__( 'Include Modified Items', 'huber' ),
				'type' => 'button_set',
				'desc' => esc_html__( 'Display modified items for the latest items for each hub.', 'huber' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'huber' ),
					'disabled' => esc_html__( 'Disabled', 'huber' ),
				),
				'default' => 'enabled',
			),
			
			array( 
				'id' => 'following_items_per_page',
				'required' => array( 'following_items', '!=', 'disabled' ),
				'title' => esc_html__( 'Items Per Page', 'huber' ),
				'type'     => 'spinner',
				'desc' => esc_html__( 'The number of items to display for the latest items for each hub.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 5,
			),

			array( 
				'id' => 'following_items_days_ago',
				'required' => array( 'following_items', '!=', 'disabled' ),
				'title' => esc_html__( 'Number Of Days', 'huber' ),
				'type'     => 'spinner',
				'desc' => esc_html__( 'The number of days before am item is no longer displayed for the latest items for each hub.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 31,
			),				
			
		),
	) );
	
								
	Redux::setSection( $opt_name, array(
		'id' => 'buddypress_options',
		'title' => esc_html__( 'BuddyPress', 'huber' ),
		'desc' => esc_html__( 'Global options for all BuddyPress pages.', 'huber' ),
		'icon' => 'el-icon-user',
		'fields' => array(),
	) );	

	Redux::setSection( $opt_name, array(
		'id' => 'bp_general_options',
		'title' => esc_html__( 'General', 'huber' ),
		'desc' => esc_html__( 'Global options for all BuddyPress pages (some options can be overridden for different BuddyPress sections below).', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-user',
		'fields' => array(

			array( 
				'id' => 'bp_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The page header on the page.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-standard-page-header',
			),

			array(
				'id' => 'bp_page_header_bg', 
				'title' => esc_html__( 'Page Header Background', 'huber' ),
				'type'      => 'media',			
				'required' => array( 'bp_page_header', '!=', 'gp-standard-page-header' ),
				'desc' => esc_html__( 'The background of the page header.', 'huber' ),
				'default' => '',
			),

			array( 
				'id' => 'bp_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '300px', 
				)		
			),
		
			array( 
				'id' => 'bp_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),					
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-no-sidebar',
			),

			array(
				'id'      => 'bp_left_sidebar',
				'type'    => 'select',
				'required' => array( 'bp_layout', '=', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'bp_right_sidebar',
				'type'    => 'select',
				'required' => array( 'bp_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-right-sidebar',
			),
	
		),
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'bp_activity_options',
		'title' => esc_html__( 'Activity Page', 'huber' ),
		'desc' => esc_html__( 'Global options for the BuddyPress activity page.', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-user',
		'fields' => array(

			array( 
				'id' => 'bp_activity_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The page header on the page.', 'huber' ),
				'options' => array(
					'default' => esc_html__( 'Default', 'huber' ),
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'default',
			),

			array(
				'id' => 'bp_activity_page_header_bg', 
				'title' => esc_html__( 'Page Header Background', 'huber' ),
				'type'      => 'media',			
				'desc' => esc_html__( 'The background of the page header.', 'huber' ),
				'default' => '',
			),

			array( 
				'id' => 'bp_activity_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '', 
				)		
			),
										
			array( 
				'id' => 'bp_activity_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'default' => array( 'title' => esc_html__( 'Default', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/default.png' ),
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'default',
			),

			array(
				'id'       => 'bp_activity_left_sidebar',
				'type'     => 'select',
				'title'    => esc_html__( 'Left Sidebar', 'huber' ),
				'desc'     => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'     => 'custom_sidebars_default',
				'default'  => 'default',
			),

			array(
				'id'       => 'bp_activity_right_sidebar',
				'type'     => 'select',
				'title'    => esc_html__( 'Right Sidebar', 'huber' ),
				'desc'     => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'     => 'custom_sidebars_default',
				'default'  => 'default',
			),

		),
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'bp_members_options',
		'title' => esc_html__( 'Members Page', 'huber' ),
		'desc' => esc_html__( 'Global options for the BuddyPress members page.', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-user',
		'fields' => array(

			array( 
				'id' => 'bp_members_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The page header on the page.', 'huber' ),
				'options' => array(
					'default' => esc_html__( 'Default', 'huber' ),
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'default',
			),

			array(
				'id' => 'bp_members_page_header_bg', 
				'title' => esc_html__( 'Page Header Background', 'huber' ),
				'type'      => 'media',			
				'desc' => esc_html__( 'The background of the page header.', 'huber' ),
				'default' => '',
			),

			array( 
				'id' => 'bp_members_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '', 
				)		
			),
										
			array( 
				'id' => 'bp_members_layout',
				'title' => esc_html__( 'Directory Page Layout', 'huber' ),
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'default' => array( 'title' => esc_html__( 'Default', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/default.png' ),
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'default',
			),

			array( 
				'id' => 'bp_profile_layout',
				'title' => esc_html__( 'Profile Page Layout', 'huber' ),
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'default' => array( 'title' => esc_html__( 'Default', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/default.png' ),
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'default',
			),
			
			array(
				'id'      => 'bp_members_left_sidebar',
				'type'    => 'select',
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'     => 'custom_sidebars_default',
				'default'  => 'default',
			),

			array(
				'id'      => 'bp_members_right_sidebar',
				'type'    => 'select',
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'     => 'custom_sidebars_default',
				'default'  => 'default',
			),

		),
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'bp_groups_options',
		'title' => esc_html__( 'Groups Page', 'huber' ),
		'desc' => esc_html__( 'Global options for the BuddyPress group page.', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-user',
		'fields' => array(

			array( 
				'id' => 'bp_groups_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The page header on the page.', 'huber' ),
				'options' => array(
					'default' => esc_html__( 'Default', 'huber' ),
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'default',
			),

			array(
				'id' => 'bp_groups_page_header_bg', 
				'title' => esc_html__( 'Page Header Background', 'huber' ),
				'type'      => 'media',			
				'desc' => esc_html__( 'The background of the page header.', 'huber' ),
				'default' => '',
			),

			array( 
				'id' => 'bp_groups_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '', 
				)		
			),
										
			array( 
				'id' => 'bp_groups_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'default' => array( 'title' => esc_html__( 'Default', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/default.png' ),
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'default',
			),

			array(
				'id'      => 'bp_groups_left_sidebar',
				'type'    => 'select',
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'     => 'custom_sidebars_default',
				'default'  => 'default',
			),

			array(
				'id'      => 'bp_groups_right_sidebar',
				'type'    => 'select',
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'     => 'custom_sidebars_default',
				'default'  => 'default',
			),

		),
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'bp_register_options',
		'title' => esc_html__( 'Registration Page', 'huber' ),
		'desc' => esc_html__( 'Global options for the BuddyPress registration page.', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-user',
		'fields' => array(

			array( 
				'id' => 'bp_register_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The page header on the page.', 'huber' ),
				'options' => array(
					'default' => esc_html__( 'Default', 'huber' ),
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'default',
			),

			array(
				'id' => 'bp_register_page_header_bg', 
				'title' => esc_html__( 'Page Header Background', 'huber' ),
				'type'      => 'media',			
				'desc' => esc_html__( 'The background of the page header.', 'huber' ),
				'default' => '',
			),

			array( 
				'id' => 'bp_register_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '', 
				)		
			),
										
			array( 
				'id' => 'bp_register_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'default' => array( 'title' => esc_html__( 'Default', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/default.png' ),
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'default',
			),

			array(
				'id'      => 'bp_register_left_sidebar',
				'type'    => 'select',
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'     => 'custom_sidebars_default',
				'default'  => 'default',
			),

			array(
				'id'      => 'bp_register_right_sidebar',
				'type'    => 'select',
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'     => 'custom_sidebars_default',
				'default'  => 'default',
			),

		)
	) );
		
	
	Redux::setSection( $opt_name, array(
		'id' => 'bbpress_options',
		'title' => esc_html__( 'bbPress', 'huber' ),
		'desc' => esc_html__( 'Global options for all bbPress pages.', 'huber' ),
		'icon' => 'el-icon-comment-alt',
		'fields' => array(
			
			array( 
				'id' => 'bbpress_page_header',
				'title' => esc_html__( 'Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The page header on the page.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-standard-page-header',
			),

			array( 
				'id' => 'bbpress_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '500px', 
				)		
			),

			array(
				'id' => 'bbpress_page_header_bg', 
				'title' => esc_html__( 'Page Header Background', 'huber' ),
				'type'      => 'media',			
				'required' => array( 'bbpress_page_header', '!=', 'gp-standard-page-header' ),
				'desc' => esc_html__( 'The background of the page header.', 'huber' ),
				'default' => '',
			),
						
			array(						
				'id' => 'bbpress_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),					
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-no-sidebar',
			),
			
			array(
				'id'      => 'bbpress_left_sidebar',
				'type'    => 'select',
				'required' => array( 'bbpress_layout', '=', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'bbpress_right_sidebar',
				'type'    => 'select',
				'required' => array( 'bbpress_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-right-sidebar',
			),

		),	
	
	) );
	

	Redux::setSection( $opt_name, array(
		'id' => 'wc_options',
		'title' => esc_html__( 'WooCommerce', 'huber' ),
		'desc' => esc_html__( 'Global options for all WooCommerce pages (some options can be overridden on individual product pages).', 'huber' ),
		'icon' => 'el-icon-shopping-cart',
		'fields' => array(),
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'wc_shop_options',
		'title' => esc_html__( 'Shop Page', 'huber' ),
		'desc' => esc_html__( 'Global options for the main WooCommerce shop page.', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-shopping-cart',
		'fields' => array(	

			array( 
				'id' => 'wc_shop_page_header',
				'title' => esc_html__( 'Shop Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The shop page header on the page.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-standard-page-header',
			),

			array(
				'id' => 'wc_shop_page_header_bg', 
				'title' => esc_html__( 'Page Header Background', 'huber' ),
				'type'      => 'media',			
				'required' => array( 'wc_shop_page_header', '!=', 'gp-standard-page-header' ),
				'desc' => esc_html__( 'The background of the page header.', 'huber' ),
				'default' => '',
			),
			
			array( 
				'id' => 'wc_shop_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '500px', 
				)		
			 ),
											
			array( 
				'id' => 'wc_shop_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-no-sidebar',
			),
	
			array(
				'id'      => 'wc_shop_left_sidebar',
				'type'    => 'select',
				'required' => array( 'wc_shop_layout', '=', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'wc_shop_right_sidebar',
				'type'    => 'select',
				'required' => array( 'wc_shop_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-right-sidebar',
			),

			array(
				'id'       => 'wc_shop_per_page',
				'type'     => 'spinner',
				'title'    => esc_html__( 'Items Per Page', 'huber' ),
				'desc' => esc_html__( 'The number of items on each page.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 12,
			),
						
		),
	) );	

	Redux::setSection( $opt_name, array(
		'id' => 'wc_product_cat_options',
		'title' => esc_html__( 'Product Categories/Tags', 'huber' ),
		'desc' => esc_html__( 'Global options for all product categories and tags (some options can be overridden on individual product categories and tags).', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-shopping-cart',
		'fields' => array(	

			array( 
				'id' => 'wc_product_cat_page_header',
				'title' => esc_html__( 'Shop Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The shop page header on the page.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-first-post-page-header' => esc_html__( 'First Post', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-standard-page-header',
			),

			array( 
				'id' => 'wc_product_cat_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '500px', 
				)		
			 ),
											
			array( 
				'id' => 'wc_product_cat_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-no-sidebar',
			),
	
			array(
				'id'      => 'wc_product_cat_left_sidebar',
				'type'    => 'select',
				'required' => array( 'wc_product_cat_layout', '=', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'wc_product_cat_right_sidebar',
				'type'    => 'select',
				'required' => array( 'wc_product_cat_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-right-sidebar',
			),

			array(
				'id'       => 'wc_product_cat_per_page',
				'type'     => 'spinner',
				'title'    => esc_html__( 'Items Per Page', 'huber' ),
				'desc' => esc_html__( 'The number of items on each page.', 'huber' ),
				'min' => 1,
				'max' => 999999,
				'default' => 12,
			),

		),			
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'wc_product_options',
		'title' => esc_html__( 'Product Pages', 'huber' ),
		'desc' => esc_html__( 'Global options for all product pages (some options can be overridden on individual product pages).', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-shopping-cart',
		'fields' => array(	

			array( 
				'id' => 'wc_product_page_header',
				'title' => esc_html__( 'Shop Page Header', 'huber' ),
				'type' => 'select',
				'desc' => esc_html__( 'The shop page header on the page.', 'huber' ),
				'options' => array(
					'gp-standard-page-header' => esc_html__( 'Standard', 'huber' ),
					'gp-first-post-page-header' => esc_html__( 'First Post', 'huber' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'huber' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'huber' ),
				),
				'default' => 'gp-standard-page-header',
			),

			array( 
				'id' => 'wc_product_page_header_height',
				'title' => esc_html__( 'Page Header Height', 'huber' ),
				'units' => 'px',
				'type' => 'spacing',
				'mode' => 'padding',
				'desc' => esc_html__( 'The height of the page header in pixels.', 'huber' ),
				'top' => false,
				'right' => false,
				'left' => false,
				'default'       => array(
					'padding-bottom'    => '500px', 
				)		
			 ),
										
			array( 
				'id' => 'wc_product_layout',
				'title' => esc_html__( 'Page Layout', 'huber' ),
				'type' => 'image_select',
				'desc' => esc_html__( 'The layout of the page.', 'huber' ),
				'options' => array(
					'gp-left-sidebar' => array( 'title' => esc_html__( 'Left Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png' ),
					'gp-right-sidebar' => array( 'title' => esc_html__( 'Right Sidebar', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png' ),
					'gp-both-sidebars' => array( 'title' => esc_html__( 'Both Sidebars', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/both-sidebars.png' ),
					'gp-no-sidebar' => array( 'title' => esc_html__( 'No Sidebar', 'huber' ), 'img' => get_template_directory_uri() . '/lib/framework/images/no-sidebar.png' ),
					'gp-fullwidth' => array( 'title' => esc_html__( 'Full Width', 'huber' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png' ),
				),	
				'default' => 'gp-no-sidebar',
			),

			array(
				'id'      => 'wc_product_left_sidebar',
				'type'    => 'select',
				'required' => array( 'wc_product_layout', '=', array( 'gp-left-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Left Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-left-sidebar',
			),

			array(
				'id'      => 'wc_product_right_sidebar',
				'type'    => 'select',
				'required' => array( 'wc_product_layout', '=', array( 'gp-right-sidebar', 'gp-both-sidebars' ) ),
				'title'   => esc_html__( 'Right Sidebar', 'huber' ),
				'desc' => esc_html__( 'The sidebar to display.', 'huber' ),
				'data'    => 'custom_sidebars',
				'default' => 'gp-right-sidebar',
			),
		
		),
	) );


	Redux::setSection( $opt_name, array(
		'id' => 'styling_options',
		'title'     => esc_html__( 'Styling', 'huber' ),
		'desc' => esc_html__( 'Style your theme.', 'huber' ),
		'icon' => 'el-icon-brush',
		'fields'    => array(
		
			array( 
				'title' => esc_html__( 'Custom Stylesheet', 'huber' ),
				'subtitle' => wp_kses( __( 'Use relative URL to your custom stylesheet e.g. <strong>lib/css/custom-style.css</strong>', 'huber' ), array( 'strong' => array() ) ),
				'desc' => esc_html__( 'Load a custom stylesheet to add your own CSS code.', 'huber' ),
				'id' => 'custom_stylesheet',
				'type' => 'text',
				'default' => '',
			),

			array(
				'id'        => 'custom_css',
				'type'      => 'ace_editor',
				'title'     => esc_html__( 'CSS Code', 'huber' ),
				'subtitle'  => esc_html__( 'Add your CSS code here - this CSS will not be lost if you update the theme.', 'huber' ),
				'mode'      => 'css',
				'theme'     => 'monokai',
				'options'   => array( 'minLines' => 50 ),
				'default' => '',
			),
			
		),
	) );
				
	Redux::setSection( $opt_name, array(
		'id' => 'styling-general',
		'title'     => esc_html__( 'General', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-cogs',
		'fields'    => array(
	
			array(
				'id'        => 'page_bg',
				'type'      => 'background',
				'title'     => esc_html__( 'Page Background', 'huber' ),
				'desc'  => esc_html__( 'The overall page background.', 'huber' ),
				'output'    => array( 'body' ),
				'preview' => false,
				'transparent' => false,
				'default'   => array(
					'background-color' => '#fff',
				),
			),

			array(
				'id'        => 'content_wrapper_bg',
				'type'      => 'background',
				'title'     => esc_html__( 'Content Background', 'huber' ),
				'desc'  => esc_html__( 'The content background.', 'huber' ),
				'output'    => array( '#gp-content-wrapper', '#gp-content', '#gp-hub-tabs .gp-container' ),
				'preview' => false,
				'default'   => array(
					'background-color' => '#fff',
				),
			),

			array(
				'id'       => 'content_wrapper_margin',
				'type'     => 'spacing',
				'title'    => esc_html__( 'Content Margin', 'huber' ),
				'desc' => esc_html__( 'When using the "Full Width Page Header" you can choose to move the page content over the header by setting a negative margin.', 'huber' ),
				'mode' => 'margin',
				'output' => array( '.gp-fullwidth-page-header:not(.gp-has-hub-header) #gp-content-wrapper' ),
				'bottom' => false,
				'right' => false,
				'left' => false,
				'units' => 'px',
				'default' => array(
					'margin-top' => '-100px',
				),	
			),
									
			array(
				'id'        => 'general_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'General Typography', 'huber' ),
				'desc'  => esc_html__( 'The general typography.', 'huber' ),
				'output'    => array( 'body' ),
				'google'    => true,
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => true,
				'letter-spacing' => true,
				'default'   => array(
					'font-size'   => '16px',
					'line-height' => '32px',
					'font-family' => 'Open Sans',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets'     => 'latin',
					'color'       => '#000',
					'letter-spacing' => '0',
					'text-transform' => 'none',
				),
			),
																															
			array(
				'id'        => 'general_link_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'General Link Colors', 'huber' ),
				'desc'  => esc_html__( 'The general link colors.', 'huber' ),
				'output'    => array( 'a' ),
				'default'   => array(
					'regular'  => '#fe4a49',
					'hover'    => '#000',
					'active'   => false,
				),
			),
			
			array(
				'id'        => 'h1_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'H1 Typography', 'huber' ),
				'desc'  => esc_html__( 'The H1 typography.', 'huber' ),
				'output'    => array( 'h1' ),
				'google'    => true,
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => true,
				'letter-spacing' => true,
				'default'   => array(
					'font-size'   => '48px',
					'line-height' => '52px',
					'font-family' => 'Unica One',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets'     => 'latin',
					'letter-spacing' => '-1.5px',
					'color' 	  => '#000',
					'text-transform' => 'uppercase',
				),
			),

			array(
				'id'        => 'h2_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'H2 Typography', 'huber' ),
				'desc'  => esc_html__( 'The H2 typography.', 'huber' ),
				'output'    => array( 'h2' ),
				'google'    => true,
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => true,
				'letter-spacing' => true,
				'default'   => array(
					'font-size'   => '36px',
					'line-height' => '40px',
					'font-family' => 'Unica One',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets'     => 'latin',
					'letter-spacing' => '-1.5px',
					'color' 	  => '#000',
					'text-transform' => 'uppercase',
				),
			),

			array(
				'id'        => 'h3_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'H3 Typography', 'huber' ),
				'desc'  => esc_html__( 'The H3 typography.', 'huber' ),
				'output'    => array( 'h3' ),
				'google'    => true,
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => true,
				'letter-spacing' => true,
				'default'   => array(
					'font-size'   => '24px',
					'line-height' => '28px',
					'font-family' => 'Unica One',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets'     => 'latin',
					'letter-spacing' => '-1.5px',
					'color' 	  => '#000',
					'text-transform' => 'uppercase',
				),
			),

			array(
				'id'        => 'h4_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'H4 Typography', 'huber' ),
				'desc'  => esc_html__( 'The H4 typography.', 'huber' ),
				'output'    => array( 'h4' ),
				'google'    => true,
				'text-align' => false,
				'font-backup' => true,
				'letter-spacing' => true,
				'text-transform' => true,
				'letter-spacing' => true,				
				'default'   => array(
					'font-size'   => '20px',
					'line-height' => '24px',
					'font-family' => 'Unica One',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets'     => 'latin',
					'letter-spacing' => '-1.5px',
					'color' 	  => '#000',
					'text-transform' => 'uppercase',
				),
			),

			array(
				'id'        => 'h5_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'H5 Typography', 'huber' ),
				'desc'  => esc_html__( 'The H5 typography.', 'huber' ),
				'output'    => array( 'h5' ),
				'google'    => true,
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => true,
				'letter-spacing' => true,
				'default'   => array(
					'font-size'   => '14px',
					'line-height' => '18px',
					'font-family' => 'Unica One',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets'     => 'latin',
					'letter-spacing' => '0',
					'color' 	  => '#000',
					'text-transform' => 'uppercase',
				),
			),

			array(
				'id'        => 'h6_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'H6 Typography', 'huber' ),
				'desc'  => esc_html__( 'The H6 typography.', 'huber' ),
				'output'    => array( 'h6' ),
				'google'    => true,
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => true,
				'letter-spacing' => true,
				'default'   => array(
					'font-size'   => '12px',
					'line-height' => '16px',
					'font-family' => 'Unica One',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets'     => 'latin',
					'letter-spacing' => '0',
					'color' 	  => '#000',
					'text-transform' => 'uppercase',
				),
			),


			array(
				'id'        => 'other_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'Other Typography', 'huber' ),
				'desc'  => esc_html__( 'Other areas of the theme using this typography.', 'huber' ),
				'output'    => array( '#gp-copyright-text', '.gp-rating-text', '.gp-rating-avg-text', '.gp-average-rating-score', '.gp-site-rating-criteria-text', '.gp-site-rating-selection', '#gp-hub-fields', '#gp-hub-cats', '#gp-author-written-by', '#gp-author-name', '.gp-affiliates-box-post-title', '.gp-affiliates-name', '.gp-affiliates-price', '#gp-hub-tabs-mobile-nav-button', '.gp-average-rating-text', '.gp-total-votes', '.gp-your-rating-title', '.gp-your-rating-text', '.gp-rating-box-date', '.gp-hub-field', '#gp-good-title', '#gp-bad-title', '.gp-last-updated-title', '.gp-rating-score', '#gp-summary-title', '.gp-sign-in-to-rate' ),
				'google'    => true,
				'font-backup' => true,
				'text-align' => false,
				'text-transform' => true,
				'letter-spacing' => false,
				'font-size'   => false,
				'line-height' => false,
				'font-weight' => false,
				'font-style' => false,
				'subsets'     => false,
				'letter-spacing' => false,
				'color' 	  => false,
				'default'   => array(
					'font-family' => 'Unica One',
					'font-backup' => 'Arial, Helvetica, sans-serif',	
					'text-transform' => 'uppercase',
				),
			),
						
			array(
				'id'        => 'caption_bg',
				'type'      => 'color_rgba',
				'title'     => esc_html__( 'Caption Background', 'huber' ),
				'desc'  => esc_html__( 'The caption background color used in the homepage featured box, hub header and first post header.', 'huber' ),
				'output' => array( 'background-color' => '.gp-featured-caption, .gp-first-post-caption' ),
				'default'   => array(
					'color' => '#3e6a91',
					'alpha' => '0.4',
				),
			),

			array(
				'id'        => 'caption_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Caption Text Color', 'huber' ),
				'desc'  => esc_html__( 'The caption text color used in the homepage featured box, hub header and first post header.', 'huber' ),
				'transparent' => false,
				'output' => array( 'color' => '.gp-featured-caption-title, .gp-featured-caption-text, #gp-hub-fields, .gp-first-post-caption-title a, .gp-first-post-caption-title a:hover, .gp-first-post-caption-inner .gp-loop-meta, .gp-first-post-caption-inner .gp-loop-meta a' ),
				'default' => '#fff',
			),
																																		
			array(
				'id'        => 'caption_link_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Caption Link Colors', 'huber' ),
				'desc'  => esc_html__( 'The caption link colors used in the homepage featured box, hub header and first post header.', 'huber' ),
				'output'    => array( '.gp-featured-caption a' ),
				'default'   => array(
					'regular'  => '#ffd85c',
					'hover'    => '#fff',
					'active'   => false,
				),
			),

			array(
				'id'        => 'divider_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Divider Color', 'huber' ),
				'desc'  => esc_html__( 'The colours of dividers used thorughout the theme.', 'huber' ),
				'output' => array( 
					'border-color' => '.gp-hub-sub-header, .gp-blog-list .gp-section-loop-inner section, .gp-blog-vertical section, #gp-top-of-post, #gp-hub-tabs li, #buddypress ul.item-list, #buddypress ul.item-list li, .gp-theme #buddypress div.item-list-tabs ul li, .gp-login-or-left-line, .gp-login-or-right-line, .gp-sidebar,.gp-theme .widget.buddypress #friends-list li,.gp-theme .widget.buddypress #groups-list li,.gp-theme .widget.buddypress #members-list li',
					'background-color' => '.error404 .gp-search, #gp-new-search'
				),
				'default'   => '#eee',
			),
																																						
		),
	) );
	
	Redux::setSection( $opt_name, array(
		'id' => 'styling-header',
		'title'     => esc_html__( 'Header', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-website',
		'fields'    => array(                                          

			array(
				'id'        => 'top_header_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Top Header Background', 'huber' ),
				'desc'  => esc_html__( 'The top header background.', 'huber' ),
				'output'    => array( 'background-color' => '#gp-top-header' ),
				'default'    => '#000',
			),
			
			array(
				'id'        => 'top_header_link_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Top Header Link Colors', 'huber' ),
				'desc'  => esc_html__( 'The top header link colors.', 'huber' ),
				'output'    => array( '#gp-top-nav > ul > li > a' ),
				'default'   => array(
					'regular'   => '#fff',
					'hover'     => '#fff',
					'active' 	=> false,
				),
			),

			array(
				'id'        => 'text_logo_typography',
				'required' => array( 'text_logo', '!=', '' ),
				'type'      => 'typography',
				'title'     => esc_html__( 'Text Logo Typography', 'huber' ),
				'desc'  => esc_html__( 'The text logo typography.', 'huber' ),
				'output'    => array( '#gp-text-logo' ),
				'google'    => true,
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => true,
				'letter-spacing' => true,
				'default'   => array(
					'font-size'   => '48px',
					'line-height' => '50px',
					'font-family' => 'Unica One',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets'     => 'latin',
					'color'       => '#fff',
					'letter-spacing' => '-1.5px',
					'text-transform' => 'uppercase',
				),
			),
															
			array(
				'id'        => 'main_header_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Main Header Background', 'huber' ),
				'desc'  => esc_html__( 'The main header background.', 'huber' ),
				'output'    => array( 'background-color' => '#gp-main-header' ),
				'default'   => '#fe4a49',
			),

			array(
				'id'        => 'main_header_scrolling_bg',
				'type'      => 'color_rgba',
				'title'     => esc_html__( 'Scrolling Main Header Background', 'huber' ),
				'desc'  => esc_html__( 'The main header background when scrolling.', 'huber' ),
				'output' => array( 'background-color' => '.gp-desktop-scrolling #gp-main-header' ),
				'default'   => array(
					'color' => '#fe4a49',
					'alpha' => '1',
				),
			),

			array(
				'id'        => 'main_header_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'Main Header Typography', 'huber' ),
				'desc'  => esc_html__( 'The main header typography (desktop and profile navigation menus).', 'huber' ),
				'output'    => array( '#gp-desktop-nav > ul > li', '#gp-profile-nav > ul > li', '#gp-mobile-nav li' ),
				'text-align' => false,
				'font-style' => false,
				'text-transform' => true,
				'font-backup' => true,
				'letter-spacing' => true,
				'line-height' => false,
				'color' => false,
				'default'   => array(
					'font-size'     => '20px',
					'font-weight' => '400',
					'subsets'     => 'latin',
					'text-transform' => 'uppercase',
					'letter-spacing' => '-1.5px',
					'font-family' => 'Unica One',
					'font-backup' => 'Arial, Helvetica, sans-serif',
				),
			),
			
			array(
				'id'        => 'main_header_link_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Main Header Link Colors', 'huber' ),
				'desc'  => esc_html__( 'The main header link colors (desktop and profile navigation menus).', 'huber' ),
				'output'    => array( '.gp-nav .menu li a' ),
				'default'   => array(
					'regular'   => '#fff',
					'hover'     => '#fed766',
					'active' 	=> false,
				),
			),

			array(
				'id'        => 'dropdown_menu_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Dropdown Menu Background', 'huber' ),
				'desc'  => esc_html__( 'The dropdown menu background color.', 'huber' ),
				'transparent' => false,
				'output'    => array( 
					'background-color' => '.gp-nav .sub-menu, .gp-nav .menu li .gp-menu-tabs li.gp-selected, #gp-mobile-nav',
					'color' => '.gp-nav .sub-menu:before, .gp-nav .menu > li.menu-item-has-children:hover > a:before, .gp-nav .menu > li.gp-tab-content-menu:hover > a:before, .gp-nav .menu > li.gp-content-menu:hover > a:before',
				),
				'default' => '#00a3e7',
			),

			array(
				'id'        => 'dropdown_menu_nav_header_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Dropdown Menu Header Color', 'huber' ),
				'desc'  => esc_html__( 'The dropdown menu header navigation color.', 'huber' ),
				'transparent' => false,
				'output'    => array(
					'color' => '.gp-nav .gp-megamenu > .sub-menu > li > .gp-menu-header',
				),
				'default' => '#fed766',
			),
						
			array(
				'id'        => 'dropdown_menu_link_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Dropodown Menu Link Colors', 'huber' ),
				'desc'  => esc_html__( 'The dropdown menu navigation link colors.', 'huber' ),
				'output'    => array( '.gp-nav .sub-menu li a', '#gp-mobile-nav .menu li a', '.gp-mobile-dropdown-icon', '#gp-mobile-nav li a' ),
				'default'   => array(
					'regular'   => '#fff',
					'hover'     => '#fed766',
					'active' 	=> false,
				),
			),

			array(
				'id'        => 'header_buttons_link_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Search/Social Button Colors', 'huber' ),
				'desc'  => esc_html__( 'The mobile navigation, search and social button colors.', 'huber' ),
				'output'    => array( '#gp-cart-button', '#gp-search-button', '#gp-social-nav > ul > li > a.fa, .gp-profile-link-icon' ),
				'default'   => array(
					'regular'   => '#fff',
					'hover'     => '#fff',
					'active' 	=> false,
				),
			),
	
			array(
				'id'        => 'mobile_nav_button_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Mobile Navigation Button Color', 'huber' ),		
				'transparent' => false,
				'output'    => array( 
					'background' => '.gp-open-nav #gp-nav-button-icon, .gp-open-nav #gp-nav-button-icon:before, .gp-open-nav #gp-nav-button-icon:after',
					'color' => '.gp-close-nav #gp-nav-button-icon:before',
				),
				'default' => '#fff',
			),
						
			array(
				'id'        => 'search_box',
				'type'      => 'color',
				'title'     => esc_html__( 'Search Box Background', 'huber' ),
				'desc'  => esc_html__( 'The search box background color.', 'huber' ),
				'output'    => array( 
					'background' => '#gp-search-box',
					'color' => '#gp-search-box:before',
				),                        
				'default' => '#00a3e7',
			),

			array(
				'id'        => 'notifications_counter',
				'type'      => 'color',
				'title'     => esc_html__( 'Notifications Counter Background', 'huber' ),
				'desc'  => esc_html__( 'The notifications counter background color.', 'huber' ),
				'output'    => array( 'background' => '.gp-nav .menu li a.gp-notification-counter, #gp-cart-counter' ),                        
				'default' => '#3e6a91',
			),

		)
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'styling-posts',
		'title'     => esc_html__( 'Posts', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-pencil',
		'fields'    => array(      
		                                    
			array(
				'id'        => 'post_title_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'Title Typography', 'huber' ),
				'desc'  => esc_html__( 'The title typography.', 'huber' ),
				'output'    => array( '.gp-entry-title.gp-single-title' ),
				'google'    => true,
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => true,
				'letter-spacing' => true,
				'default'   => array(
					'font-size'   => '60px',
					'line-height' => '60px',
					'color' => '#000',                           
					'font-family' => 'Unica One',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets'     => 'latin',
					'letter-spacing' => '-4.5px',
				),
			),
			
			array(
				'id'        => 'post_title_mobile_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'Mobile Title Typography', 'huber' ),
				'desc'  => esc_html__( 'The title typography on mobile devices.', 'huber' ),
				'google'    => false,
				'text-align' => false,
				'font-weight' => false,
				'letter-spacing' => true,
				'font-family' => false,
				'font-style' => false,
				'color' => false,
				'default'   => array(
					'font-size'   => '40px',
					'line-height' => '42px',
					'letter-spacing' => '-2.5px',
				),
			),
	
			array(
				'id'        => 'post_subtitle_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'Subtitle Typography', 'huber' ),
				'desc'  => esc_html__( 'The subtitle typography.', 'huber' ),
				'output'    => array( '.gp-subtitle' ),
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => true,
				'letter-spacing' => true,
				'default'   => array(
					'font-size'   => '22px',
					'line-height' => '32px',
					'color' => '#999',                           
					'font-family' => 'Open Sans',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '300',
					'subsets'     => 'latin',
					'letter-spacing' => '0',
				),
			),
			
			array(
				'id'        => 'post_subtitle_mobile_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'Mobile Subtitle Typography', 'huber' ),
				'desc'  => esc_html__( 'The subtitle typography on mobile devices.', 'huber' ),
				'google'    => false,
				'text-align' => false,
				'font-weight' => false,
				'letter-spacing' => true,
				'font-family' => false,
				'font-style' => false,
				'color' => false,
				'default'   => array(
					'font-size'   => '20px',
					'line-height' => '30px',
					'letter-spacing' => '0',
				),
			),

			array(
				'id'        => 'post_sub_header_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'Sub Header Typography', 'huber' ),
				'desc'  => esc_html__( 'The sub header typography used for the related posts section, comments section, hub pages etc.', 'huber' ),
				'output'    => array( '.gp-related-wrapper > h3', '#comments h3', '.gp-hub-sub-header' ),
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => true,
				'letter-spacing' => true,
				'default'   => array(
					'font-size'   => '30px',
					'line-height' => '30px',
					'color' => '#3e6a91',                           
					'font-family' => 'Unica One',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets'     => 'latin',
					'letter-spacing' => '-1.5px',
				),
			),
									
			array(
				'id'        => 'post_meta_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Post Meta Text Color', 'huber' ),
				'desc'  => esc_html__( 'The post meta text color.', 'huber' ),
				'transparent' => false,
				'output'    => array( '.gp-entry-meta', '.gp-entry-meta a', '.gp-entry-tags' ),
				'default'   => '#999',
			),
									
			array(
				'id'        => 'author_info_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Author Info Background', 'huber' ),
				'desc'      => esc_html__( 'The author info background color.', 'huber' ),
				'output'    => array( 'background-color' => '#gp-author-info' ),
				'default'   => '#f8f8f8',
			),
			
			array(
				'id'        => 'author_info_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Author Info Text Color', 'huber' ),
				'desc'  => esc_html__( 'The author info text color.', 'huber' ),
				'transparent' => false,
				'output'    => array( '#gp-author-info' ),
				'default' => '#000',
			),	
					
			array(
				'id'        => 'author_info_link_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Author Info Link Colors', 'huber' ),
				'desc'  => esc_html__( 'The author info link colors.', 'huber' ),
				'output'    => array( '#gp-author-info a' ),
				'default'   => array(
					'regular'     => '#3e6a91',
					'hover'       => '#000',
					'active'      => false,
				),
			),
																											 
			array(
				'id'        => 'blockquote_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Blockquote Background', 'huber' ),
				'desc'      => esc_html__( 'The blockquote background.', 'huber' ),
				'output'    => array( 'background-color' => 'blockquote' ),
				'default'   => '#fe4a49',
			),
			
			array(
				'id'        => 'blockquote_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Blockquote Text Color', 'huber' ),
				'desc'  => esc_html__( 'The blockquote text color.', 'huber' ),
				'transparent' => false,
				'output'    => array( 'blockquote', 'blockquote a' ),
				'default' => '#fff',
			),

			array(
				'id'        => 'post_tooltip_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Tooltip Color', 'huber' ),
				'desc'  => esc_html__( 'The tooltip color uaed in the related hubs panel.', 'huber' ),
				'transparent' => false,
				'output'    => array( 
					'background-color' => '.gp-tooltip',
					'border-top-color' => '.gp-tooltip::after',
				),
				'default'   => '#fe4a49',
			),
			
			array(
				'id'        => 'vote_up_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Vote Up Button Background', 'huber' ),
				'desc'      => esc_html__( 'The vote up background color.', 'huber' ),
				'output'    => array( 'background-color' => '.gp-voting-container .gp-voting-up' ),
				'default'   => '#38b6bb',
			),

			array(
				'id'        => 'vote_down_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Vote Down Button Background', 'huber' ),
				'desc'      => esc_html__( 'The vote down button background color.', 'huber' ),
				'output'    => array( 'background-color' => '.gp-voting-container .gp-voting-down' ),
				'default'   => '#fe4a49',
			),

			array(
				'id'        => 'vote_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Vote Button Text Color', 'huber' ),
				'desc'  => esc_html__( 'The vote button text color.', 'huber' ),
				'transparent' => false,
				'output'    => array( '.gp-voting-container .gp-voting-up, .gp-voting-container .gp-voting-down' ),
				'default' => '#fff',
			),
																					
		)

	) );

	Redux::setSection( $opt_name, array(
		'id' => 'styling-pages',
		'title'     => esc_html__( 'Pages', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-file',
		'fields'    => array(
		    
			array(
				'id'        => 'page_title_text_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Page Title Background', 'huber' ),
				'desc'  => esc_html__( 'The page title background.', 'huber' ),
				'output'    => array( 'background-color' => '#gp-page-title' ),        
				'default'   => '#000',
			),
					                                    
			array(
				'id'        => 'page_title_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'Page Title Typography', 'huber' ),
				'desc'  => esc_html__( 'The page title typography.', 'huber' ),
				'output'    => array( '#gp-page-title h1' ),
				'google'    => true,
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => true,
				'letter-spacing' => true,
				'default'   => array(
					'font-size'   => '36px',
					'line-height' => '36px',
					'color' 	  => '#fff',                           
					'font-family' => 'Unica One',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets'     => 'latin',
					'letter-spacing' => '-1.5px',
					'text-transform' => 'uppercase',
				),
			),

			array(
				'id'        => 'page_subtitle_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'Subtitle Typography', 'huber' ),
				'desc'  => esc_html__( 'The subtitle typography.', 'huber' ),
				'output'    => array( '#gp-page-title-subtitle' ),
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => true,
				'letter-spacing' => true,
				'default'   => array(
					'font-size'   => '16px',
					'line-height' => '24px',
					'color' => '#fff',                           
					'font-family' => 'Open Sans',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets'     => 'latin',
					'letter-spacing' => '-0.5px',
					'text-transform' => 'none',
				),
			),
				
			array(
				'id'        => 'page_subtitle_link_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Subtitle Link Colors', 'huber' ),
				'desc'  => esc_html__( 'The subtitle link colors.', 'huber' ),
				'output'    => array( '#gp-page-title-subtitle a' ),
				'default'   => array(
					'regular'       => '#fe4a49',
					'hover'       => '#fff',
					'active'       => false,
				),
			),
									
		)
			
	) );
								  
	Redux::setSection( $opt_name, array(
		'id' => 'styling-categories',
		'title'     => esc_html__( 'Categories', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-folder-open',
		'fields'    => array(

			array(
				'id'        => 'cat_post_title_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'Post Title Typography', 'huber' ),
				'desc'  => esc_html__( 'The post title typography.', 'huber' ),
				'output'    => array( '.gp-loop-title' ),
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => true,
				'letter-spacing' => true,
				'font-size'   => false,
				'line-height' => false,
				'color' => '#000',
				'default'   => array(                           
					'font-family' => 'Open Sans',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '600',
					'subsets'     => 'latin',
					'letter-spacing' => '0',
					'text-transform' => 'none',
				),
			),
				
			array(
				'id'        => 'cat_post_title_link_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Post Title Link Colors', 'huber' ),
				'desc'  => esc_html__( 'The post title link colors.', 'huber' ),
				'output'    => array( '.gp-loop-title a' ),
				'default'   => array(
					'regular'       => '#000',
					'hover'       => '#fe4a49',
					'active'       => false,
				),
			),

			array(
				'id'        => 'cat_post_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Post Text Color', 'huber' ),
				'desc'  => esc_html__( 'The post text color.', 'huber' ),
				'output'    => array( '.gp-loop-text' ),
				'transparent' => false,
				'default' => '#000',
			),
			
			array(
				'id'        => 'cat_meta_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Post Meta Color', 'huber' ),
				'desc'  => esc_html__( 'The post meta color.', 'huber' ),
				'output'    => array( '.gp-loop-meta, .gp-loop-meta a, #gp-breadcrumbs, #gp-breadcrumbs a, div.bbp-breadcrumb, div.bbp-breadcrumb a, .gp-comment-meta time' ),
				'transparent' => false,
				'default' => '#999',
			),

			array(
				'id'        => 'cat_masonry_post_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Masonry Background', 'huber' ),
				'desc'  => esc_html__( 'The masonry background.', 'huber' ),
				'output'    => array( 'background-color' => '.gp-blog-masonry section' ), 
				'default'   => '#eee',
			),
																
		),
	
	) );      

	Redux::setSection( $opt_name, array(
		'id' => 'styling-hubs-reviews',
		'title'     => esc_html__( 'Hubs/Reviews', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-globe',
		'fields'    => array(  

			array(
				'id'        => 'hub_cats_link_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Hub Categories Link Colors', 'huber' ),
				'desc'  => esc_html__( 'The hub categories link colors used in the hub header.', 'huber' ),
				'output'    => array( '#gp-hub-cats a' ),
				'default'   => array(
					'regular'  => '#ffd85c',
					'hover'    => '#fff',
					'active'   => false,
				),
			),
			
			array(
				'id'        => 'hub_fields_link_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Hub Fields Link Colors', 'huber' ),
				'desc'  => esc_html__( 'The hub fields link colors used in the hub header.', 'huber' ),
				'output'    => array( '#gp-hub-fields a' ),
				'default'   => array(
					'regular'  => '#fff',
					'hover'    => '#ffd85c',
					'active'   => false,
				),
			),
					
			array(
				'id'        => 'hub_tab_link',
				'type'      => 'color',
				'title'     => esc_html__( 'Hub Tab Link Color', 'huber' ),
				'desc'  => esc_html__( 'The hub tab link color.', 'huber' ),
				'output'    => array( 'color' => '#gp-hub-tabs li a' ), 
				'transparent' => false,
				'default'   => '#000',
			),

			array(
				'id'        => 'hub_tab_link_selected',
				'type'      => 'color',
				'title'     => esc_html__( 'Hub Tab Link Selected/Hover Color', 'huber' ),
				'desc'  => esc_html__( 'The hub tab link selected/hover color.', 'huber' ),
				'output'    => array( 'color' => '#gp-hub-tabs li a:hover, #gp-hub-tabs li a.gp-selected' ), 
				'transparent' => false,
				'default'   => '#38b6bb',
			),
						
			array(
				'id'        => 'review_summary_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Summary Background', 'huber' ),
				'desc'  => esc_html__( 'The summary background.', 'huber' ),
				'output'    => array( 'background-color' => '#gp-summary' ), 
				'default'   => '#191e1d',
			),

			array(
				'id'        => 'review_summary_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Summary Text Color', 'huber' ),
				'desc'  => esc_html__( 'The summary text color.', 'huber' ),
				'transparent' => false,
				'output'    => array( 'color' => '#gp-summary-title, #gp-summary' ), 
				'default'   => '#fff',
			),
						
		),	
								
	) );  
				
	Redux::setSection( $opt_name, array(
		'id' => 'styling-widgets-elements',
		'title'     => esc_html__( 'Widgets/Elements', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-cog',
		'fields'    => array(
		
			array(
				'id'        => 'widget_title_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Widget Title Colors', 'huber' ),
				'desc'  => esc_html__( 'The widget title colors.', 'huber' ),
				'output'    => array( '.widgettitle', '.widgettitle a' ),
				'default'   => array(
					'regular' => '#3e6a91',
					'hover'   => '#3e6a91',
					'active'  => false,
				),
			),

			array(
				'id'        => 'widgets_trending_counter_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Ranking Counter Background', 'huber' ),
				'desc'  => esc_html__( 'Ranking counter background color.', 'huber' ),
				'output'    => array( 
					'background-color' => '.gp-ranking-counter',
				),
				'transparent' => false,
				'default' => '#3e6a91',
			),

			array(
				'id'        => 'ranking_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Ranking Text Color', 'huber' ),
				'desc'  => esc_html__( 'The ranking text color.', 'huber' ),
				'transparent' => false,
				'output'    => array( '.gp-ranking-counter' ),
				'default' => '#fff',
			),

			array(
				'id'        => 'rating_box_details_backgorund',
				'type'      => 'color',
				'title'     => esc_html__( 'Rating Box Details Background', 'huber' ),
				'desc'  => esc_html__( 'The rating box details background.', 'huber' ),
				'transparent' => false,
				'output'    => array( 'background-color' => '.gp-rating-box-details' ), 
				'default'   => '#3e6a91',
			),

			array(
				'id'        => 'rating_box_average_rating_backgorund',
				'type'      => 'color',
				'title'     => esc_html__( 'Rating Box Average Rating Background', 'huber' ),
				'desc'  => esc_html__( 'The rating box average rating background.', 'huber' ),
				'transparent' => false,
				'output'    => array( 'background-color' => '.gp-rating-box-average-rating' ), 
				'default'   => '#191e1d',
			),

			array(
				'id'        => 'rating_box_your_rating_backgorund',
				'type'      => 'color_rgba',
				'title'     => esc_html__( 'Rating Box Your Rating Background', 'huber' ),
				'desc'  => esc_html__( 'The rating box your rating background.', 'huber' ),
				'transparent' => false,
				'output'    => array( 'background-color' => '.gp-your-rating' ), 
				'default'   => array(
					'color' => '#3e6a91',
					'alpha' => '0.8',
				),	
			),

			array(
				'id'        => 'rating_box_hub_field_backgorund',
				'type'      => 'color',
				'title'     => esc_html__( 'Rating Box Hub Fields Background', 'huber' ),
				'desc'  => esc_html__( 'The rating box hub fields background.', 'huber' ),
				'transparent' => false,
				'output'    => array( 'background-color' => '.gp-hub-fields' ), 
				'default'   => '#2a4a68',
			),	

			array(
				'id'        => 'rating_box_primary_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Rating Box Primary Text Color', 'huber' ),
				'desc'  => esc_html__( 'The rating box primary text color.', 'huber' ),
				'transparent' => false,
				'output'    => array( 'color' => '.gp-rating-box-widget, .gp-rating-box-title a' ), 
				'default'   => '#fff',
			),		

			array(
				'id'        => 'rating_box_secondary_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Rating Box Secondary Text Color', 'huber' ),
				'desc'  => esc_html__( 'The rating box secondary text color.', 'huber' ),
				'transparent' => false,
				'output'    => array( 'color' => '.gp-rating-box-date, .gp-total-votes, .gp-your-rating-text, .gp-hub-field-list a, .gp-hub-field-list a:hover' ), 
				'default'   => '#fed766',
			),			
																															
		),
	
	) );      
		
			
	Redux::setSection( $opt_name, array(
		'id' => 'styling-fields-buttons',
		'title'     => esc_html__( 'Fields & Buttons', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-check',
		'fields'    => array(
						
			array(
				'id'        => 'input_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Input Background', 'huber' ),
				'desc'  => esc_html__( 'The input background.', 'huber' ),
				'output'    => array( 'background-color' => 'input, textarea, .gp-theme #buddypress div.activity-comments form .ac-textarea, #buddypress form#whats-new-form textarea' ),
				'default'   => '#fff',
			),

			array(
				'id'        => 'input_border',
				'type'      => 'border',
				'title'     => esc_html__( 'Input Border', 'huber' ),
				'desc'  => esc_html__( 'The input border color.', 'huber' ),
				'output'    => array( 'input', 'textarea, .gp-theme #buddypress div.activity-comments form .ac-textarea, #buddypress form#whats-new-form textarea' ),  
				'default'   => array(
					'border-color' => '#ccc',
					'border-width' => '1px',
					'border-style' => 'solid',
				),
			),
											
			array(
				'id'        => 'input_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Input Text Color', 'huber' ),
				'desc'  => esc_html__( 'The input text color.', 'huber' ),
				'output'    => array( 'input, textarea, .gp-theme #buddypress div.activity-comments form .ac-textarea, #buddypress div.activity-comments form textarea, #buddypress form#whats-new-form textarea' ),
				'transparent' => false,
				'default' => '#000',
			),

						
			array(
				'id'        => 'select_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Selection Menu Background', 'huber' ),
				'desc'  => esc_html__( 'The selection background.', 'huber' ),
				'output'    => array( 'background-color' => 'select' ),   
				'transparent' => false,
				'default'   => '#fafafa',
			),

			array(
				'id'        => 'select_border_color',
				'type'      => 'border',
				'title'     => esc_html__( 'Selection Menu Border Color', 'huber' ),
				'desc'  => esc_html__( 'The selection border color.', 'huber' ),
				'output'    => array( 'select' ),  
				'default'   => array(
					'border-color' => '#eee',
					'border-width' => '5px',
					'border-style' => 'solid',
				),
			),
								
			array(
				'id'        => 'select_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Selection Menu Text Color', 'huber' ),
				'desc'  => esc_html__( 'The selection text color.', 'huber' ),
				'output'    => array( 'select' ),
				'transparent' => false,
				'default' => '#3e6a91',
			),
						
			array(
				'id'        => 'button_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Button Background', 'huber' ),
				'desc'  => esc_html__( 'The button background.', 'huber' ),
				'output'    => array( 'background-color' => 'input[type="button"], input[type="submit"], input[type="reset"], button, .button, .gp-theme #buddypress .comment-reply-link, .gp-theme #buddypress .generic-button a, .gp-theme #buddypress a.button, .gp-theme #buddypress button, .gp-theme #buddypress input[type=button], .gp-theme #buddypress input[type=reset], .gp-theme #buddypress input[type=submit], .gp-theme #buddypress ul.button-nav li a, a.bp-title-button, .gp-theme #buddypress div.activity-meta a, .gp-theme #buddypress #reply-title small a, .gp-theme #buddypress a.bp-primary-action, .gp-theme #buddypress a.bp-secondary-action, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, #add_payment_method .wc-proceed-to-checkout a.checkout-button, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button, .woocommerce-checkout .wc-proceed-to-checkout a.checkout-button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce div.product form.cart .button' ),    
				'transparent' => false,   
				'default' => '#38b6bb',
			),
			
			 array(
				'id'        => 'button_bg_hover',
				'type'      => 'color',
				'title'     => esc_html__( 'Button Background Hover Color', 'huber' ),
				'desc'  => esc_html__( 'The button background hover color.', 'huber' ),
				'output'    => array( 'background-color' => 'input[type="button"]:hover, input[type="submit"]:hover, input[type="reset"]:hover, button:hover, .button:hover, .gp-theme #buddypress .comment-reply-link:hover, .gp-theme #buddypress a.button:focus, .gp-theme #buddypress a.button:hover, .gp-theme #buddypress button:hover, .gp-theme #buddypress div.generic-button a:hover, .gp-theme #buddypress input[type=button]:hover, .gp-theme #buddypress input[type=reset]:hover, .gp-theme #buddypress input[type=submit]:hover, .gp-theme #buddypress ul.button-nav li a:hover, .gp-theme #buddypress ul.button-nav li.current a, .gp-theme #buddypress div.activity-meta a:hover, .gp-theme #buddypress #reply-title small a:hover, .gp-theme #buddypress a.bp-primary-action:hover, .gp-theme #buddypress a.bp-secondary-action:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, #add_payment_method .wc-proceed-to-checkout a.checkout-button:hover, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button:hover, .woocommerce-checkout .wc-proceed-to-checkout a.checkout-button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce div.product form.cart .button:hover' ),    
				'transparent' => false,   
				'default' => '#38b6bb',
			),
											
			array(
				'id'        => 'button_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'Button Typography', 'huber' ),
				'desc'  => esc_html__( 'The button typography.', 'huber' ),
				'output'    => array( 'input[type="button"]', 'input[type="submit"]', 'input[type="reset"]', 'button', '.button',  'input[type="button"]:hover', 'input[type="submit"]:hover', 'input[type="reset"]:hover', 'button:hover', '.button:hover', '.gp-theme #buddypress .comment-reply-link', '.gp-theme #buddypress .generic-button a', '.gp-theme #buddypress a.button', '.gp-theme #buddypress button', '.gp-theme #buddypress input[type=button]', '.gp-theme #buddypress input[type=reset]', '.gp-theme #buddypress input[type=submit]', '.gp-theme #buddypress ul.button-nav li a', 'a.bp-title-button, .gp-theme #buddypress div.activity-meta a, .gp-theme #buddypress #reply-title small a, .gp-theme #buddypress a.bp-primary-action, .gp-theme #buddypress a.bp-secondary-action', '.gp-theme #buddypress .comment-reply-link:hover', '.gp-theme #buddypress a.button:focus', '.gp-theme #buddypress a.button:hover', '.gp-theme #buddypress button:hover', '.gp-theme #buddypress div.generic-button a:hover', '.gp-theme #buddypress input[type=button]:hover', '.gp-theme #buddypress input[type=reset]:hover', '.gp-theme #buddypress input[type=submit]:hover', '.gp-theme #buddypress ul.button-nav li a:hover', '.gp-theme #buddypress ul.button-nav li.current a, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, #add_payment_method .wc-proceed-to-checkout a.checkout-button, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button, .woocommerce-checkout .wc-proceed-to-checkout a.checkout-button, #add_payment_method .wc-proceed-to-checkout a.checkout-button:hover, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button:hover, .woocommerce-checkout .wc-proceed-to-checkout a.checkout-button:hover, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce div.product form.cart .button, .woocommerce div.product form.cart .button:hover .woocommerce #respond input#submit.alt.disabled, 
.woocommerce #respond input#submit.alt.disabled:hover, 
.woocommerce #respond input#submit.alt:disabled,
.woocommerce #respond input#submit.alt:disabled:hover,
.woocommerce #respond input#submit.alt:disabled[disabled],
.woocommerce #respond input#submit.alt:disabled[disabled]:hover,
.woocommerce input.button:disabled,
.woocommerce input.button:disabled:hover, 
.woocommerce input.button:disabled[disabled],
.woocommerce input.button:disabled[disabled]:hover,
.woocommerce a.button.alt.disabled,
.woocommerce a.button.alt.disabled:hover,
.woocommerce a.button.alt:disabled,
.woocommerce a.button.alt:disabled:hover,
.woocommerce a.button.alt:disabled[disabled],
.woocommerce a.button.alt:disabled[disabled]:hover,
.woocommerce button.button.alt.disabled,
.woocommerce button.button.alt.disabled:hover,
.woocommerce button.button.alt:disabled,
.woocommerce button.button.alt:disabled:hover,
.woocommerce button.button.alt:disabled[disabled],
.woocommerce button.button.alt:disabled[disabled]:hover,
.woocommerce input.button.alt.disabled,
.woocommerce input.button.alt.disabled:hover,
.woocommerce input.button.alt:disabled,
.woocommerce input.button.alt:disabled:hover,
.woocommerce input.button.alt:disabled[disabled],
.woocommerce input.button.alt:disabled[disabled]:hover' ),
				'google'    => true,
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => false,
				'letter-spacing' => false,
				'font-size'   => false,
				'line-height' => false,
				'subsets' => false,
				'font-weight' => false,
				'font-style' => false,
				'default'   => array(
					'font-family' => 'Unica One',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'color' => '#fff',
				),	
			),
				
		)		
	) );

	Redux::setSection( $opt_name, array(
		'id' => 'styling-footer',
		'title'     => esc_html__( 'Footer', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-photo',
		'fields'    => array(

			array(
				'id'        => 'copyright_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Copyright Background', 'huber' ),
				'desc'  => esc_html__( 'The copyright background.', 'huber' ),
				'output'    => array( 'background-color' => '#gp-footer, #gp-copyright' ),
				'default'    => '#000',
			),
														
			array(
				'id'        => 'footer_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Footer Widget Background', 'huber' ),
				'desc'  => esc_html__( 'The footer widgets background.', 'huber' ),
				'output'    => array( 'background-color' => '#gp-footer-widgets' ),
				'default' => '#FE4A47',
			),

			array(
				'id'        => 'footer_border',
				'type'      => 'border',
				'title'     => esc_html__( 'Footer Border', 'huber' ),
				'desc'  => esc_html__( 'The footer border diving the copyright section and footer widgets.', 'huber' ),
				'output'    => array( '#gp-copyright' ),
				'all' => false,
				'right' => true,
				'default'   => array(
					'border-color' => '#fed766',
					'border-right' => '10px',
					'border-style' => 'solid',
				),
			),
												
			array(
				'id'        => 'copyright_text_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Copyright Text Color', 'huber' ),
				'desc'  => esc_html__( 'The copyright text color.', 'huber' ),
				'output'    => array( '#gp-copyright-text', '#gp-copyright-text a' ),
				'default'   => array(
					'regular' => '#999',
					'hover'   => '#999',
					'active'  => false,
				),
			),

			array(
				'id'        => 'footer_nav_colors',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Copyright Navigation Colors', 'huber' ),
				'desc'  => esc_html__( 'The copyright navigation colors.', 'huber' ),
				'output'    => array( '#gp-footer-nav .menu > li > a' ),
				'default'   => array(
					'regular' => '#fff',
					'hover'   => '#fed766',
					'active'  => false,
				),
			),
																		  
			array(
				'id'        => 'footer_widget_title_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Footer Widget Title Colors', 'huber' ),
				'desc'  => esc_html__( 'The footer widget title colors.', 'huber' ),
				'output'    => array( '.gp-footer-widget .widgettitle', '.gp-footer-widget .widgettitle a' ),
				'default'   => array(
					'regular' => '#fff',
					'hover'   => '#fff',
					'active'  => false,
				),
			),

			array(
				'id'        => 'footer_widget_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Footer Widget Text Color', 'huber' ),
				'desc'  => esc_html__( 'The widget text color.', 'huber' ),
				'output'    => array( '.gp-footer-widget' ),
				'transparent' => false,
				'default' => '#fff',
			),
			
			array(
				'id'        => 'footer_widget_link_colors',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Footer Widget Link Colors', 'huber' ),
				'desc'  => esc_html__( 'The footer widget link colors.', 'huber' ),
				'output'    => array( '.gp-footer-widget a' ),
				'default'   => array(
					'regular' => '#fed766',
					'hover'   => '#fff',
					'active'  => false,
				),
			),

			array(
				'id'        => 'footer_widget_list_link_colors',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Footer Widget List Link Colors', 'huber' ),
				'desc'  => esc_html__( 'The footer widget list link colors.', 'huber' ),
				'output'    => array( '.gp-footer-widget ul li a', '.gp-footer-widget .gp-loop-title a' ),
				'default'   => array(
					'regular' => '#fff',
					'hover'   => '#fed766',
					'active'  => false,
				),
			),
																																							
			array(
				'id'        => 'back_to_top_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Back To Top Background', 'huber' ),
				'desc'      => esc_html__( 'The back to top button background.', 'huber' ),
				'output'    => array( 'background-color' => '#gp-to-top' ),
				'default'   => '#3e6a91',
			),
											
			array(
				'id'        => 'back_to_top_icon_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Back To Top Icon Color', 'huber' ),
				'desc'      => esc_html__( 'The back to top icon color.', 'huber' ),
				'output'    => array( '#gp-to-top' ),
				'transparent' => false,
				'default'   => '#fff',
			),
																																	 
		)
	) );                

	Redux::setSection( $opt_name, array(
		'id' => 'styling-buddypress',
		'title'     => esc_html__( 'BuddyPress', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-user',
		'fields'    => array(

			array(
				'id'        => 'bp_nav_link',
				'type'      => 'color',
				'title'     => esc_html__( 'Navigation Link Color', 'huber' ),
				'desc'  => esc_html__( 'The navigation link color.', 'huber' ),
				'output'    => array( 
					'color' => '.gp-theme #buddypress div.item-list-tabs ul li a, .gp-theme #buddypress div.item-list-tabs ul li span',
					'background-color' => '.gp-theme #buddypress div.item-list-tabs ul li a span',
				),
				'transparent' => false,
				'default' => '#000',
			),

			array(
				'id'        => 'bp_nav_link_hover',
				'type'      => 'color',
				'title'     => esc_html__( 'Navigation Link Hover Color', 'huber' ),
				'desc'  => esc_html__( 'The navigation link hover colors.', 'huber' ),
				'output'    => array( 
					'color' => '.gp-theme #buddypress div.item-list-tabs ul li a:hover, .gp-theme #buddypress div.item-list-tabs ul li.current a, .gp-theme #buddypress div.item-list-tabs ul li.selected a',
					'background-color' => '.gp-theme #buddypress div.item-list-tabs ul li a:hover span, .gp-theme #buddypress div.item-list-tabs ul li.current a span, .gp-theme #buddypress div.item-list-tabs ul li.selected a span',
				),
				'transparent' => false,
				'default'   => '#38b6bb',
			),
			
			array(
				'id'        => 'bp_sub_nav_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Sub Navigation Background', 'huber' ),
				'desc'  => esc_html__( 'The sub navigation background color.', 'huber' ),
				'output'    => array( 'background-color' => '.gp-theme #buddypress div.item-list-tabs#subnav' ),   	
				'default'   => '#f8f8f8',
			),
																																				 
		)
	) ); 
	      
 	Redux::setSection( $opt_name, array(
		'id' => 'styling-bbpress',
		'title'     => esc_html__( 'bbPress', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-comment-alt',
		'fields'    => array(

			array(
				'id'        => 'bbpress_forum_cat_header_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Forum Category Header Background', 'huber' ),
				'desc'  => esc_html__( 'The forum category header background.', 'huber' ),
				'output'    => array( 'background-color' => '.gp-theme #bbpress-forums .gp-forum-home.bbp-forums .bbp-has-subforums .bbp-forum-info > .bbp-forum-title, .gp-theme #bbpress-forums .bbp-topics .bbp-header, .gp-theme #bbpress-forums .bbp-replies .bbp-header, .gp-theme #bbpress-forums .bbp-search-results .bbp-header' ),
				'default' => '#000',
			),

			array(
				'id'        => 'bbpress_forum_cat_header_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Forum Category Header Text Color', 'huber' ),
				'desc'  => esc_html__( 'The forum category header text color.', 'huber' ),
				'output'    => array( '.gp-theme #bbpress-forums .gp-forum-home.bbp-forums .bbp-has-subforums .bbp-forum-info > .bbp-forum-title, .gp-theme #bbpress-forums .bbp-topics .bbp-header, .gp-theme #bbpress-forums .bbp-replies .bbp-header, .gp-theme #bbpress-forums .bbp-search-results .bbp-header' ),
				'transparent' => false,
				'default'   => '#fff',
			),
									
			array(
				'id'        => 'bbpress_forum_row_bg_1',
				'type'      => 'color',
				'title'     => esc_html__( 'Forum Row Background 1', 'huber' ),
				'desc'  	=> esc_html__( 'The forum row background.', 'huber' ),
				'output'    => array( 'background-color' => '#bbpress-forums .bbp-forums-list li.odd-forum-row, #bbpress-forums div.odd, #bbpress-forums ul.odd' ),
				'default'	 => '#fbfbfb',
			),

			array(
				'id'        => 'bbpress_forum_row_bg_2',
				'type'      => 'color',
				'title'     => esc_html__( 'Forum Row Background 2', 'huber' ),
				'desc'  => esc_html__( 'The forum row background.', 'huber' ),
				'output'    => array( 'background-color' => '#bbpress-forums .bbp-forums-list li.even-forum-row, #bbpress-forums div.even, #bbpress-forums ul.even' ),
				'default'   => '#fff',
			),
													
			array(
				'id'        => 'bbpress_forum_border',
				'type'      => 'color',
				'title'     => esc_html__( 'Forum Border Color', 'huber' ),
				'desc'  	=> esc_html__( 'The forum border color.', 'huber' ),
				'output'    => array( 'border-color' => '.gp-theme #bbpress-forums .bbp-forums-list, .gp-theme #bbpress-forums div.bbp-reply-header, .gp-theme #bbpress-forums .gp-forum-home .bbp-forums-list li.odd-forum-row, .gp-theme #bbpress-forums .gp-forum-home .bbp-forums-list li.even-forum-row, .gp-theme #bbpress-forums li.bbp-body, .gp-theme #bbpress-forums li.bbp-body ul.forum, .gp-theme #bbpress-forums li.bbp-body ul.topic, .gp-theme #bbpress-forums .bbp-topics li.bbp-body, .gp-theme #bbpress-forums .bbp-replies li.bbp-body' ),
				'default'   => '#ddd',
			),

			array(
				'id'        => 'bbpress_forum_role_bg',
				'type'      => 'color',
				'title'     => esc_html__( 'Forum Role Background', 'huber' ),
				'desc'  => esc_html__( 'The forum role background.', 'huber' ),
				'output'    => array( 'background-color' => '.gp-theme #bbpress-forums div.bbp-forum-author .bbp-author-role, .gp-theme #bbpress-forums div.bbp-topic-author .bbp-author-role, .gp-theme #bbpress-forums div.bbp-reply-author .bbp-author-role' ),
				'default'   => '#FE4A48',
			),
										
			array(
				'id'        => 'bbpress_forum_role_text_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Forum Role Text Color', 'huber' ),
				'desc'  => esc_html__( 'The forum role text color.', 'huber' ),
				'output'    => array( '.gp-theme #bbpress-forums div.bbp-forum-author .bbp-author-role, .gp-theme #bbpress-forums div.bbp-topic-author .bbp-author-role, .gp-theme #bbpress-forums div.bbp-reply-author .bbp-author-role' ),
				'transparent' => false,
				'default'   => '#fff',
			),
																																																																					 
		)
	) );       

	Redux::setSection( $opt_name, array(
		'id' => 'styling-woocommerce',
		'title'     => esc_html__( 'WooCommerce', 'huber' ),
		'subsection' => true,
		'icon' => 'el-icon-shopping-cart',
		'fields'    => array(

			array(
				'id'        => 'cart_dropdown_text',
				'type'      => 'color',
				'title'     => esc_html__( 'Cart Dropdown Text Color', 'huber' ),
				'desc'  => esc_html__( 'The cart dropdown text color.', 'huber' ),
				'output'    => array( 'color' => '#gp-cart-nav .widget_shopping_cart' ),
				'transparent' => false,
				'default'   => '#fff',
			),

			array(
				'id'        => 'cart_dropdown_link_color',
				'type'      => 'link_color',
				'title'     => esc_html__( 'Cart Dropdown Link Colors', 'huber' ),
				'desc'  => esc_html__( 'The cart dropdown link colors.', 'huber' ),
				'output'    => array( '#gp-cart-nav .widget_shopping_cart a' ),
				'default'   => array(
					'regular'  => '#fff',
					'hover'    => '#fed766',
					'active'   => false,
				),
			),
												
			array(
				'id'        => 'cart_dropdown_buttons',
				'type'      => 'color',
				'title'     => esc_html__( 'Cart Dropdown Button Background Color', 'huber' ),
				'desc'  => esc_html__( 'The cart dropdown button background color.', 'huber' ),
				'output'    => array( 'background-color' => '#gp-cart-nav .widget_shopping_cart .buttons a' ),
				'default'   => '#3e6a91',
			),

			array(
				'id'        => 'cart_dropdown_buttons_hover',
				'type'      => 'color',
				'title'     => esc_html__( 'Cart Dropdown Button Background Hover Color', 'huber' ),
				'desc'  => esc_html__( 'The cart dropdown button background hover color.', 'huber' ),
				'output'    => array( 'background-color' => '#gp-cart-nav .widget_shopping_cart .buttons a:hover' ),
				'default'   => '#000',
			),

			array(
				'id'        => 'cart_dropdown_buttons_hover',
				'type'      => 'color',
				'title'     => esc_html__( 'Cart Dropdown Button Background Hover Color', 'huber' ),
				'desc'  => esc_html__( 'The cart dropdown button background hover color.', 'huber' ),
				'output'    => array( 'background-color' => '#gp-cart-nav .widget_shopping_cart .buttons a:hover' ),
				'default'   => '#000',
			),

			array(
				'id'        => 'cart_dropdown_buttons_typography',
				'type'      => 'typography',
				'title'     => esc_html__( 'Cart Dropdown Button Typography', 'huber' ),
				'desc'  => esc_html__( 'The button typography.', 'huber' ),
				'output'    => array( '#gp-cart-nav .widget_shopping_cart .buttons a' ),
				'google'    => true,
				'text-align' => false,
				'font-backup' => true,
				'text-transform' => false,
				'letter-spacing' => false,
				'font-size'   => false,
				'line-height' => false,
				'subsets' => false,
				'font-weight' => false,
				'font-style' => false,
				'default'   => array(
					'font-family' => 'Unica One',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'color' => '#fff',
				),	
			),
													
		)		
	) );
    /*
     * <--- END SECTIONS
     */