<?php get_header();

// Get category options
$term_data = null;
if ( isset( get_queried_object()->term_id ) ) {
	$term_id = get_queried_object()->term_id;
	$term_data = get_option( "taxonomy_$term_id" );
}

// Page options
$header = ! isset( $term_data['page_header'] ) || $term_data['page_header'] == 'default' ? ghostpool_option( 'cat_page_header' ) : $term_data['page_header'];
$format = ! isset( $term_data['format'] ) || $term_data['format'] == 'default' ? ghostpool_option( 'cat_format' ) : $term_data['format'];
$image_size_standard = ghostpool_option( 'cat_standard_post_image_size' );
$image_size_hub = ghostpool_option( 'cat_hub_image_size' );
$image_size_review = ghostpool_option( 'cat_review_image_size' );
$image_size_preview = ghostpool_option( 'cat_preview_image_size' );
$content_display = ghostpool_option( 'cat_content_display' );	
$excerpt_length = ghostpool_option( 'cat_excerpt_length' );	
$meta_release_date = ghostpool_option( 'cat_meta', 'release_date' );
$meta_author = ghostpool_option( 'cat_meta', 'author' );
$meta_date = ghostpool_option( 'cat_meta', 'date' );
$meta_comment_count = ghostpool_option( 'cat_meta', 'comment_count' );
$meta_views = ghostpool_option( 'cat_meta', 'views' );
$meta_likes = ghostpool_option( 'cat_meta', 'likes' );
$meta_followers = ghostpool_option( 'cat_meta', 'followers' );
$meta_cats = ghostpool_option( 'cat_meta', 'cats' );
$meta_tags = ghostpool_option( 'cat_meta', 'tags' );
$meta_hub_fields = ghostpool_option( 'cat_meta', 'hub_fields' );
$meta_site_rating = ghostpool_option( 'cat_meta', 'site_rating' );
$meta_user_rating = ghostpool_option( 'cat_meta', 'user_rating' );
$read_more_link = ghostpool_option( 'cat_read_more_link' );

?>

<?php ghostpool_page_title( '', $header ); ?>

<?php ghostpool_page_header( 
	$post_id = '', 
	$type = $header,
	$bg = isset( $term_data['page_header_bg'] ) ? $term_data['page_header_bg'] : '',
	$height = ghostpool_option( 'cat_page_header_height', 'padding-bottom' )
); ?>

<?php if ( $header == 'gp-first-post-page-header' ) { ?>
	
	<?php get_template_part( 'lib/sections/taxonomies/first-post-cat' ); ?>
	
<?php } else { ?>

	<div id="gp-content-wrapper" class="gp-container">
	
		<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>
	
		<div id="gp-inner-container">

			<div id="gp-left-column">
	
				<div id="gp-content">
				
					<?php if ( $header == 'gp-fullwidth-page-header' OR $header == 'gp-full-page-page-header' ) { ?>
						<?php ghostpool_breadcrumbs(); ?>
						<header class="gp-entry-header">
							<h1 class="gp-entry-title">
								<?php if ( is_category() OR is_tag() OR is_tax() ) {
									single_cat_title();
								} elseif ( is_archive() ) {
									if ( ! function_exists( '_wp_render_title_tag' ) && ! function_exists( 'ghostpool_render_title' ) ) { 
										echo apply_filters( 'ghostpool_archives_title', esc_html__( 'Archives', 'huber' ) ); 
									} else { 
										echo apply_filters( 'ghostpool_archives_title', get_the_archive_title() );
									}
								} elseif ( is_front_page() ) {
									echo apply_filters( 'ghostpool_blog_title', esc_html__( 'Blog', 'huber' ) );
								} else {
									wp_title( '' );
								} ?>
							</h1>
							<?php if ( category_description() ) { ?>
								<div class="gp-subtitle"><?php echo str_replace( array( '<p>', '</p>' ), '', category_description() ); ?></div>
							<?php } ?>
						</header>
					<?php } ?>
		
					<div class="gp-blog-wrapper gp-archive-wrapper <?php echo sanitize_html_class( $format ); ?>" data-type="<?php if ( is_home() ) { ?>home<?php } else { ?>taxonomy<?php } ?>" data-format="<?php echo esc_attr( $format ); ?>" data-orderby="<?php echo esc_attr( ghostpool_option( 'cat_orderby' ) ); ?>" data-perpage="<?php echo absint( ghostpool_option( 'cat_per_page' ) ); ?>" data-offset="<?php echo esc_attr( ghostpool_option( 'cat_offset' ) ); ?>" data-imagesizestandard="<?php echo esc_attr( $image_size_standard ); ?>" data-imagesizehub="<?php echo esc_attr( $image_size_hub ); ?>" data-imagesizereview="<?php echo esc_attr( $image_size_review ); ?>" data-imagesizepreview="<?php echo esc_attr( $image_size_preview ); ?>" data-contentdisplay="<?php echo esc_attr( ghostpool_option( 'cat_content_display' ) ); ?>" data-excerptlength="<?php echo absint( ghostpool_option( 'cat_excerpt_length' ) ); ?>" data-metareleasedate="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'release_date' ) ); ?>" data-metaauthor="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'author' ) ); ?>" data-metadate="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'date' ) ); ?>" data-metacommentcount="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'comment_count' ) ); ?>" data-metaviews="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'views' ) ); ?>" data-metalikes="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'likes' ) ); ?>" data-metafollowers="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'followers' ) ); ?>" data-metacats="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'cats' ) ); ?>" data-metatags="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'tags' ) ); ?>" data-metahubfields="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'hub_fields' ) ); ?>" data-metasiterating="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'site_rating' ) ); ?>" data-metauserrating="<?php echo esc_attr( ghostpool_option( 'cat_meta', 'user_rating' ) ); ?>" data-readmorelink="<?php echo esc_attr( ghostpool_option( 'cat_read_more_link' ) ); ?>" data-pagination="<?php echo esc_attr( ghostpool_option( 'cat_pagination' ) ); ?>"<?php if ( isset( $_POST['category'] ) ) { ?> data-cats="<?php echo esc_attr( $_POST['category'] ); ?>"<?php } ?><?php if ( isset( $_GET['release_date'] ) ) { ?> data-release_date="<?php echo esc_attr( $_GET['release_date'] ); ?>"<?php } ?><?php if ( isset( $_GET['from'] ) ) { ?> data-release_date_from="<?php echo esc_attr( $_GET['from'] ); ?>"<?php } ?><?php if ( isset( $_GET['to'] ) ) { ?>  data-release_date_to="<?php echo esc_attr( $_GET['to'] ); ?>"<?php } ?>>
	
						<?php ghostpool_filter( 
							ghostpool_option( 'cat_filters' ), 
							'',
							ghostpool_option( 'cat_orderby' ),
							ghostpool_option( 'cat_pagination' )
						); ?>
											
						<div class="gp-section-loop <?php echo sanitize_html_class( ghostpool_option( 'ajax' ) ); ?>">
							
							<?php if ( have_posts() ) : ?>

								<div class="gp-section-loop-inner">			
									<?php if ( $format == 'gp-blog-masonry' ) { ?><div class="gp-gutter-size"></div><?php } ?>					
									<?php while ( have_posts() ) : the_post(); ?>
										<?php if ( function_exists( 'ghostpool_post_loop' ) ) { ghostpool_post_loop( $format, $image_size_standard, $image_size_hub, $image_size_review, $image_size_preview, $content_display, $excerpt_length, $meta_release_date, $meta_author, $meta_date, $meta_comment_count, $meta_views, $meta_likes, $meta_followers, $meta_cats, $meta_tags, $meta_hub_fields, $meta_site_rating, $meta_user_rating, $read_more_link ); } ?>
									<?php endwhile; ?>
								</div>
														
								<?php echo ghostpool_pagination( $wp_query->max_num_pages, ghostpool_option( 'cat_pagination' ) ); ?>
						
							<?php else : ?>

								<strong class="gp-no-items-found"><?php esc_html_e( 'No items found.', 'huber' ); ?></strong>

							<?php endif; ?>

						</div>
											
					</div>

				</div>

				<?php get_sidebar( 'left' ); ?>

			</div>
	
			<?php get_sidebar( 'right' ); ?>
			
		</div>

		<?php do_action( 'ghostpool_end_content_wrapper' ); ?>
			
		<div class="gp-clear"></div>

	</div>

<?php } ?>

<?php get_footer(); ?>