<?php
/*
Template Name: Homepage
*/
get_header(); ?>
		
<?php if ( have_posts() ) : while ( have_posts() ) : the_post();

	$post_id = get_the_ID();

	$page_header_height = redux_post_meta( 'ghostpool_huber', $post_id, 'page_header_height' );

	ghostpool_page_header( 
		$post_id = $post_id, 
		$type = redux_post_meta( 'ghostpool_huber', $post_id, 'page_header' ) == 'default' ? ghostpool_option( 'page_header' ) : redux_post_meta( 'ghostpool_huber', $post_id, 'page_header' ),  
		$bg = redux_post_meta( 'ghostpool_huber', $post_id, 'page_header_bg' ),
		$height = $page_header_height && $page_header_height['padding-bottom'] != '' ? $page_header_height['padding-bottom'] : ghostpool_option( 'page_header_height', 'padding-bottom' )
	);
	
	if ( get_post_meta( $post_id, 'featured_box', true ) == 'enabled' ) {
	
		// Set offset value to null if equal to 0
		$offset = get_post_meta( $post_id, 'featured_box_offset', true ) != '0' ? get_post_meta( $post_id, 'featured_box_offset', true ) : '';
		
		// Post counter
		global $gp_counter, $post_id; $gp_counter = 1;
					
		$args = array(
			'post_status'         => 'publish',
			'post_type'           => get_post_meta( $post_id, 'featured_box_post_types', true ),
			'post__in'            => get_post_meta( $post_id, 'featured_box_page_ids', true ),
			ghostpool_cats( get_post_meta( $post_id, 'featured_box_cats', true ), 'param' ) => ghostpool_cats( get_post_meta( $post_id, 'featured_box_cats', true ), 'variables' ),
			'orderby' 		      => ghostpool_orderby( get_post_meta( $post_id, 'featured_box_orderby', true ), 'orderby' ),
			'order' 		      => ghostpool_orderby( get_post_meta( $post_id, 'featured_box_orderby', true ), 'order' ),
			'offset' 		      => $offset,
			'meta_key' 		      => ghostpool_orderby( get_post_meta( $post_id, 'featured_box_orderby', true ), 'meta_key' ),	
			'meta_query' 		  => ghostpool_orderby( get_post_meta( $post_id, 'featured_box_orderby', true ), get_post_meta( $post_id, 'featured_box_release_date_from', true ), get_post_meta( $post_id, 'featured_box_release_date_to', true ), 'meta_query' ),
			'posts_per_page'      => 3, 
			'paged'			      => 1,
			'no_found_rows'		  => true,
			'ignore_sticky_posts' => apply_filters( 'ghostpool_featured_box_sticky_posts', '1' ),
		);
		$gp_query = new WP_Query( $args ); if ( $gp_query->have_posts() ) : ?>

			<div id="gp-featured-box" class="<?php echo sanitize_html_class( get_post_meta( $post_id, 'featured_box_format', true ) ); ?> <?php echo sanitize_html_class( get_post_meta( $post_id, 'featured_box_size', true ) ); ?>">	
			
				<div id="gp-featured-box-posts">	
		
					<?php while ( $gp_query->have_posts() ) : $gp_query->the_post(); ?>
		
						<?php if ( ( $gp_counter % 3 == 1 ) OR ( get_post_meta( $post_id, 'featured_box_format', true ) == 'gp-featured-box-2' && $gp_counter % 3 == 2 ) ) { ?>
						
							<div class="gp-featured-large">
								<?php get_template_part( 'lib/sections/home/featured-box-post' ); ?>
							</div>
							
						<?php } elseif ( get_post_meta( $post_id, 'featured_box_format', true ) == 'gp-featured-box-3' && $gp_counter % 3 == 2 ) { ?>		
						
							<div class="gp-featured-right">
						
								<div class="gp-featured-small">
									<?php get_template_part( 'lib/sections/home/featured-box-post' ); ?>
								</div>
								
							<?php if ( ( $gp_query->current_post + 1 ) == ( $gp_query->post_count ) ) { ?>
								</div>
							<?php } ?>

						<?php } elseif ( get_post_meta( $post_id, 'featured_box_format', true ) == 'gp-featured-box-3' && $gp_counter % 3 == 0 ) { ?>
								
								<div class="gp-featured-small">
									<?php get_template_part( 'lib/sections/home/featured-box-post' ); ?>
								</div>
							
							</div>
												
						<?php } ?>
					
					<?php $gp_counter++; endwhile; ?>	
					
				</div>	
				
				<?php
				
				$bg = get_post_meta( $post_id, 'featured_box_bg', true );
				if ( isset( $bg['id'] ) && $bg['id'] > 0 ) {
					$id = $bg['id'];
				} else {
					$id = '';
				}
	
				if ( $id > 0 ) {
					$bg_image = wp_get_attachment_image_src( $id, apply_filters( 'ghostpool_page_header_image_size', 'ghostpool-page-header-image' ) );
					$bg_image = isset( $bg_image[0] ) ? $bg_image[0] : '';
				} else {
					$bg_image = '';
				}

				if ( $bg_image ) {
					$bg_css = 'background-image: url(' . esc_url( $bg_image ) . ');';
				} else {
					$bg_css = '';
				} 
	
				?>

				<?php if ( get_post_meta( $post_id, 'featured_box_size', true ) != 'gp-featured-box-boxed' ) { ?>
					<div class="gp-standard-bg"<?php if ( $bg_css ) { ?> style="<?php echo esc_attr( $bg_css ); ?>"<?php } ?>></div>
				<?php } ?>
				
			</div>
															
		<?php else : ?>

			<strong class="gp-no-items-found"><?php esc_html_e( 'No items found.', 'huber' ); ?></strong>

		<?php endif; wp_reset_postdata(); ?>
	
	<?php } ?>

	<?php if ( get_post_meta( $post_id, 'homepage_content_header', true ) ) { ?>
		
		<div id="gp-content-header"<?php if ( get_post_meta( $post_id, 'homepage_content_header_format', true ) == 'fixed' ) { ?>  class="gp-container"<?php } ?>>
			<?php echo do_shortcode( get_post_meta( $post_id, 'homepage_content_header', true ) ); ?>
		</div>
		
	<?php } ?>
				
	<div id="gp-content-wrapper" class="gp-container">
	
		<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>

		<div id="gp-featured-posts">
			<?php if ( get_post_meta( $post_id, 'featured_posts', true ) == 'enabled' ) {
	
				// Implode array of page ids
				if ( get_post_meta( $post_id, 'featured_posts_page_ids', true ) ) {
					$page_ids = implode( ',', get_post_meta( $post_id, 'featured_posts_page_ids', true ) );
				} else {
					$page_ids = '';
				} 
	
				// Implode array of post types
				if ( get_post_meta( $post_id, 'featured_posts_post_types', true ) ) {
					$post_types = implode( ',', get_post_meta( $post_id, 'featured_posts_post_types', true ) );
				} else {
					$post_types = 'post'; // If no post type is set fallback to default
				}
				
				// Site and user ratings
				if ( get_post_meta( $post_id, 'featured_posts_site_rating', true ) == 'enabled' ) {
					$meta_site_rating = '1';
				} else {
					$meta_site_rating = '0';
				}	
				if ( get_post_meta( $post_id, 'featured_posts_user_rating', true ) == 'enabled' ) {
					$meta_user_rating = '1';
				} else {
					$meta_user_rating = '0';
				}
				
				// Set offset value to null if equal to 0
				$offset = get_post_meta( $post_id, 'featured_posts_offset', true ) != '0' ? get_post_meta( $post_id, 'featured_posts_offset', true ) : '';
					
				?>
	
				<?php echo do_shortcode( '[blog 
				widget_title="' . esc_attr( get_post_meta( $post_id, 'featured_posts_title', true ) ) . '"
				cats="' . ghostpool_cats( get_post_meta( $post_id, 'featured_posts_cats', true ), 'variables' ) . '" 
				page_ids="' . esc_attr( $page_ids ) . '" 
				post_types="' . esc_attr( $post_types  ). '" 
				format="' . get_post_meta( $post_id, 'featured_posts_format', true ) . '" 
				orderby="' . get_post_meta( $post_id, 'featured_posts_orderby', true ) . '"
				per_page="' . get_post_meta( $post_id, 'featured_posts_per_page', true ) . '"
				offset="' . $offset . '"
				excerpt_length="0"
				meta_site_rating="' . $meta_site_rating . '"
				meta_user_rating="' . $meta_user_rating . '"
				pagination="disabled"
				]' ); ?>
	
			<?php } ?>
		</div>
							
		<div id="gp-inner-container">

			<div id="gp-left-column">
		
				<div id="gp-content">
								
					<?php the_content(); ?>	
					
					<?php if ( get_post_meta( $post_id, 'latest_news', true ) == 'enabled' ) {
	
						// Implode array of page ids
						if ( get_post_meta( $post_id, 'latest_news_page_ids', true ) ) {
							$page_ids = implode( ',', get_post_meta( $post_id, 'latest_news_page_ids', true ) );
						} else {
							$page_ids = '';
						} 
	
						// Implode array of post types
						if ( get_post_meta( $post_id, 'latest_news_post_types', true ) ) {
							$post_types = implode( ',', get_post_meta( $post_id, 'latest_news_post_types', true ) );
						} else {
							$post_types = 'post'; // If no post type is set fallback to default
						}
						
						// Set offset value to null if equal to 0
						$offset = get_post_meta( $post_id, 'latest_news_offset', true ) != '0' ? get_post_meta( $post_id, 'latest_news_offset', true ) : '';
					
						echo do_shortcode( '[blog 
						widget_title="' . esc_attr( get_post_meta( $post_id, 'latest_news_title', true ) ) . '"
						cats="' . ghostpool_cats( get_post_meta( $post_id, 'latest_news_cats', true ), 'variables' ) . '" 
						page_ids="' . esc_attr( $page_ids ) . '" 
						post_types="' . esc_attr( $post_types ) . '" 
						format="' . get_post_meta( $post_id, 'latest_news_format', true ) . '" 
						orderby="' . get_post_meta( $post_id, 'latest_news_orderby', true ) . '"
						per_page="' . get_post_meta( $post_id, 'latest_news_per_page', true ) . '"
						image_size_standard="' . get_post_meta( $post_id, 'latest_news_standard_post_image_size', true ) . '"
						image_size_hub="' . get_post_meta( $post_id, 'latest_news_hub_image_size', true ) . '"
						image_size_review="' . get_post_meta( $post_id, 'latest_news_review_image_size', true ) . '"
						image_size_preview="' . get_post_meta( $post_id, 'latest_news_preview_image_size', true ) . '"
						offset="' . $offset . '"
						excerpt_length="' . get_post_meta( $post_id, 'latest_news_excerpt_length', true ) . '"
						meta_date="1"
						meta_comment_count="1"
						pagination="' . get_post_meta( $post_id, 'latest_news_pagination', true ) . '"
						]' ); 
						
					} ?>
				
				</div>
			
				<?php get_sidebar( 'left' ); ?>
		
			</div>
				
			<?php get_sidebar( 'right' ); ?>
			
		</div>	

		<?php do_action( 'ghostpool_end_content_wrapper' ); ?>
				
		<div class="gp-clear"></div>
			
	</div>
	
<?php endwhile; endif; ?>
	
<?php get_footer(); ?>