<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11" />
<?php if ( is_singular() && pings_open( get_queried_object() ) ) { ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php } ?>
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<?php if ( ! is_page_template( 'blank-page-template.php' ) ) { ?>

	<div id="gp-site-wrapper">
							
		<div id="gp-page-wrapper">
		
			<header id="gp-headers-container">

				<?php if ( ghostpool_option( 'top_header' ) != 'gp-top-header-disabled' ) { ?>
					<header id="gp-top-header" class="<?php echo sanitize_html_class( ghostpool_option( 'header_layout' ) ); ?><?php if ( ghostpool_option( 'theme_layout' ) == 'gp-boxed-layout' ) { ?> gp-container<?php } ?>">
						<?php if ( ghostpool_option( 'header_layout' ) == 'gp-header-boxed' ) { ?><div class="gp-container"><?php } ?>
							<?php if ( has_nav_menu( 'gp-top-nav' ) ) { ?>	
								<nav id="gp-top-nav" class="gp-nav">
									<?php wp_nav_menu( array( 'theme_location' => 'gp-top-nav', 'sort_column' => 'menu_order', 'container' => 'ul', 'fallback_cb' => 'null', 'walker' => new Ghostpool_Custom_Menu ) ); ?>		
								</nav>
							<?php } ?>
						<?php if ( ghostpool_option( 'header_layout' ) == 'gp-header-boxed' ) { ?></div><?php } ?>
					</header>
				<?php } ?>

				<header id="gp-main-header" class="<?php echo sanitize_html_class( ghostpool_option( 'header_layout' ) ); ?><?php if ( ghostpool_option( 'theme_layout' ) == 'gp-boxed-layout' ) { ?> gp-container<?php } ?>">
			
					<div class="gp-container">
				
						<div id="gp-header-left">
			
							<<?php if ( is_front_page() && ! is_home() ) { ?>h1<?php } else { ?>div<?php } ?> id="gp-logo">
						
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php bloginfo( 'name' ); ?>">
									<?php if ( ghostpool_option( 'text_logo' ) ) { ?>
										<span id="gp-text-logo"><?php echo esc_attr( ghostpool_option( 'text_logo' ) ); ?></span>
									<?php } else { ?>
										<?php if ( ghostpool_option( 'desktop_logo', 'url' ) ) { ?>
											<img src="<?php echo esc_url( ghostpool_option( 'desktop_logo', 'url', get_template_directory_uri() . '/lib/images/logo.png' ) ); ?>" alt="<?php bloginfo( 'name' ); ?>" width="<?php echo absint( ghostpool_option( 'desktop_logo_dimensions', 'width', 217 ) ); ?>" height="<?php echo absint( ghostpool_option( 'desktop_logo_dimensions', 'height', 32 ) ); ?>" class="gp-desktop-logo" />
										<?php } ?>
										<?php if ( ghostpool_option( 'desktop_scrolling_logo', 'url' ) ) { ?>
											<img src="<?php echo esc_url( ghostpool_option( 'desktop_scrolling_logo', 'url', get_template_directory_uri() . '/lib/images/logo.png' ) ); ?>" alt="<?php bloginfo( 'name' ); ?>" width="<?php echo absint( ghostpool_option( 'desktop_scrolling_logo_dimensions', 'width', 217 ) ); ?>" height="<?php echo absint( ghostpool_option( 'desktop_scrolling_logo_dimensions', 'height', 32 ) ); ?>" class="gp-scrolling-logo" />
										<?php } ?>
										<?php if ( ghostpool_option( 'mobile_logo', 'url' ) ) { ?>
											<img src="<?php echo esc_url( ghostpool_option( 'mobile_logo', 'url', get_template_directory_uri() . '/lib/images/logo.png' ) ); ?>" alt="<?php bloginfo( 'name' ); ?>" width="<?php echo absint( ghostpool_option( 'mobile_logo_dimensions', 'width', 133 ) ); ?>" height="<?php echo absint( ghostpool_option( 'mobile_logo_dimensions', 'height', 20 ) ); ?>" class="gp-mobile-logo" />
										<?php } ?>
									<?php } ?>
								</a>		
						
							</<?php if ( is_front_page() && ! is_home() ) { ?>h1<?php } else { ?>div<?php } ?>>
	
						</div>

						<?php if ( has_nav_menu( 'gp-desktop-nav' ) ) { ?>	
							<nav id="gp-desktop-nav" class="gp-nav">
								<?php wp_nav_menu( array( 'theme_location' => 'gp-desktop-nav', 'sort_column' => 'menu_order', 'container' => 'ul', 'fallback_cb' => 'null', 'walker' => new Ghostpool_Custom_Menu ) ); ?>		
							</nav>					
						<?php } ?>
					
						<div id="gp-header-right">
						
							<?php if ( function_exists( 'is_woocommerce' ) && ghostpool_option( 'cart_button' ) != 'gp-cart-disabled' ) { echo ghostpool_dropdown_cart(); } ?>
			
							<?php if ( ghostpool_option( 'search_button' ) != 'gp-search-button-disabled' ) { ?>
								<a id="gp-search-button"></a>
							<?php } ?>
						
							<?php if ( has_nav_menu( 'gp-social-nav' ) && ghostpool_option( 'social_nav' ) != 'gp-social-nav-disabled' ) { ?>	
								<nav id="gp-social-nav" class="gp-nav">
									<?php wp_nav_menu( array( 'theme_location' => 'gp-social-nav', 'sort_column' => 'menu_order', 'container' => 'ul', 'fallback_cb' => 'null', 'walker' => new Ghostpool_Custom_Menu ) ); ?>		
								</nav>
							<?php } ?>
						
							<?php if ( has_nav_menu( 'gp-profile-nav' ) && ghostpool_option( 'profile_nav' ) != 'gp-profile-nav-disabled' ) { ?>	
								<nav id="gp-profile-nav" class="gp-nav">
									<?php wp_nav_menu( array( 'theme_location' => 'gp-profile-nav', 'sort_column' => 'menu_order', 'container' => 'ul', 'fallback_cb' => 'null', 'walker' => new Ghostpool_Custom_Menu ) ); ?>		
								</nav>
							<?php } ?>
						
							<?php if ( has_nav_menu( 'gp-mobile-nav' ) ) { ?>
								<div id="gp-mobile-nav-button" class="gp-open-nav"><div id="gp-nav-button-icon"></div></div>
							<?php } ?>

						</div>

						<div class="gp-clear"></div>
					
					</div>
					
					<?php if ( ghostpool_option( 'search_button' ) != 'gp-search-button-disabled' ) { ?>
						<div id="gp-search-box-wrapper" class="gp-container">
							<div id="gp-search-box">				
								<?php get_search_form(); ?>
							</div>
						</div>
					<?php } ?>
							
				</header>
			
			</header>
						
			<div id="gp-fixed-header-padding"></div>
							
			<?php if ( has_nav_menu( 'gp-mobile-nav' ) ) { ?>		
				<nav id="gp-mobile-nav">
					<?php wp_nav_menu( array( 'theme_location' => 'gp-mobile-nav', 'sort_column' => 'menu_order', 'container' => 'ul', 'fallback_cb' => 'null', 'walker' => new Ghostpool_Custom_Menu ) ); ?>
				</nav>
			<?php } ?>
			
<?php } ?>