<?php get_header();

// Page options
$format = ghostpool_option( 'author_format' );
$image_size_standard = ghostpool_option( 'author_standard_post_image_size' );
$image_size_hub = ghostpool_option( 'author_hub_image_size' );
$image_size_review = ghostpool_option( 'author_review_image_size' );
$image_size_preview = ghostpool_option( 'author_preview_image_size' );
$content_display = ghostpool_option( 'author_content_display' );
$excerpt_length = ghostpool_option( 'author_excerpt_length' );	
$meta_release_date = ghostpool_option( 'author_meta', 'release_date' );
$meta_author = ghostpool_option( 'author_meta', 'author' );
$meta_date = ghostpool_option( 'author_meta', 'date' );
$meta_comment_count = ghostpool_option( 'author_meta', 'comment_count' );
$meta_views = ghostpool_option( 'author_meta', 'views' );
$meta_likes = ghostpool_option( 'author_meta', 'likes' );
$meta_followers = ghostpool_option( 'author_meta', 'followers' );
$meta_cats = ghostpool_option( 'author_meta', 'cats' );
$meta_tags = ghostpool_option( 'author_meta', 'tags' );
$meta_hub_fields = ghostpool_option( 'author_meta', 'hub_fields' );
$meta_site_rating = ghostpool_option( 'author_meta', 'site_rating' );
$meta_user_rating = ghostpool_option( 'author_meta', 'user_rating' );
$read_more_link = ghostpool_option( 'author_read_more_link' );

if ( ! is_array( ghostpool_option( 'author_post_types' ) ) ) {
	$post_types = array( ghostpool_option( 'author_post_types' ) );
} else {
	$post_types = ghostpool_option( 'author_post_types' );
}

if ( ! is_array( ghostpool_option( 'author_templates' ) ) ) {
	$templates = array( ghostpool_option( 'author_templates' ) );
} else {
	$templates = ghostpool_option( 'author_templates' );
}

?>

<?php ghostpool_page_title( '', ghostpool_option( 'author_page_header' ) ); ?>

<?php ghostpool_page_header( 
	$post_id = '', 
	$type = ghostpool_option( 'author_page_header' ),
	$bg = ghostpool_option( 'author_page_header_bg' ),
	$height = ghostpool_option( 'author_page_header_height', 'padding-bottom' )
); ?>

<div id="gp-content-wrapper" class="gp-container">

	<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>
		
	<div id="gp-inner-container">

		<div id="gp-left-column">

			<div id="gp-content">

				<?php if ( ghostpool_option( 'author_page_header' ) == 'gp-fullwidth-page-header' OR ghostpool_option( 'author_page_header' ) == 'gp-full-page-page-header' ) { ?>
					<?php ghostpool_breadcrumbs(); ?>
					<header class="gp-entry-header">		
						<h1 class="gp-entry-title">
							<?php esc_html_e( 'Author', 'huber' ); ?>
						</h1>
					</header>
				<?php } ?>
				
				<div class="gp-blog-wrapper gp-archive-wrapper <?php echo sanitize_html_class( ghostpool_option( 'author_format' ) ); ?>" data-type="author" data-format="<?php echo esc_attr( ghostpool_option( 'author_format' ) ); ?>" data-posttypes="<?php echo esc_attr( implode( ',', $post_types ) ); ?>" data-templates="<?php echo esc_attr( implode( ',', $templates ) ); ?>" data-orderby="<?php echo esc_attr( ghostpool_option( 'author_orderby' ) ); ?>" data-perpage="<?php echo absint( ghostpool_option( 'author_per_page' ) ); ?>" data-offset="<?php echo esc_attr( ghostpool_option( 'author_offset' ) ); ?>" data-imagesizestandard="<?php echo esc_attr( $image_size_standard ); ?>" data-imagesizehub="<?php echo esc_attr( $image_size_hub ); ?>" data-imagesizereview="<?php echo esc_attr( $image_size_review ); ?>" data-imagesizepreview="<?php echo esc_attr( $image_size_preview ); ?>" data-contentdisplay="<?php echo esc_attr( ghostpool_option( 'author_content_display' ) ); ?>" data-excerptlength="<?php echo absint( ghostpool_option( 'author_excerpt_length' ) ); ?>" data-metareleasedate="<?php echo esc_attr( ghostpool_option( 'author_meta', 'release_date' ) ); ?>" data-metaauthor="<?php echo esc_attr( ghostpool_option( 'author_meta', 'author' ) ); ?>" data-metadate="<?php echo esc_attr( ghostpool_option( 'author_meta', 'date' ) ); ?>" data-metacommentcount="<?php echo esc_attr( ghostpool_option( 'author_meta', 'comment_count' ) ); ?>" data-metaviews="<?php echo esc_attr( ghostpool_option( 'author_meta', 'views' ) ); ?>" data-metalikes="<?php echo esc_attr( ghostpool_option( 'author_meta', 'likes' ) ); ?>" data-metafollowers="<?php echo esc_attr( ghostpool_option( 'author_meta', 'followers' ) ); ?>" data-metacats="<?php echo esc_attr( ghostpool_option( 'author_meta', 'cats' ) ); ?>" data-metatags="<?php echo esc_attr( ghostpool_option( 'author_meta', 'tags' ) ); ?>" data-metahubfields="<?php echo esc_attr( ghostpool_option( 'author_meta', 'hub_fields' ) ); ?>" data-metasiterating="<?php echo esc_attr( ghostpool_option( 'author_meta', 'site_rating' ) ); ?>" data-metauserrating="<?php echo esc_attr( ghostpool_option( 'author_meta', 'user_rating' ) ); ?>" data-readmorelink="<?php echo esc_attr( ghostpool_option( 'author_read_more_link' ) ); ?>" data-pagination="<?php echo esc_attr( ghostpool_option( 'author_pagination' ) ); ?>">
					
					<?php ghostpool_filter( 
						ghostpool_option( 'author_filters' ),
						'',
						ghostpool_option( 'author_orderby' ),
						ghostpool_option( 'author_pagination' )
					); ?>
			
					<div class="gp-section-loop <?php echo sanitize_html_class( ghostpool_option( 'ajax' ) ); ?>">

						<?php if ( have_posts() ) : ?>
						
							<div class="gp-section-loop-inner">							
								<?php if ( $format == 'gp-blog-masonry' ) { ?><div class="gp-gutter-size"></div><?php } ?>							
								<?php while ( have_posts() ) : the_post(); ?>
									<?php if ( function_exists( 'ghostpool_post_loop' ) ) { ghostpool_post_loop( $format, $image_size_standard, $image_size_hub, $image_size_review, $image_size_preview, $content_display, $excerpt_length, $meta_release_date, $meta_author, $meta_date, $meta_comment_count, $meta_views, $meta_likes, $meta_followers, $meta_cats, $meta_tags, $meta_hub_fields, $meta_site_rating, $meta_user_rating, $read_more_link ); } ?>
								<?php endwhile; ?>
							</div>

							<?php echo ghostpool_pagination( $wp_query->max_num_pages, ghostpool_option( 'author_pagination' ) ); ?>

						<?php else : ?>

							<strong class="gp-no-items-found"><?php esc_html_e( 'No items found.', 'huber' ); ?></strong>

						<?php endif; ?>
					
					</div>
	
				</div>			

			</div>

			<?php get_sidebar( 'left' ); ?>

		</div>
	
		<?php get_sidebar( 'right' ); ?>
	
	</div>

	<?php do_action( 'ghostpool_end_content_wrapper' ); ?>
			
	<div class="gp-clear"></div>

</div>

<?php get_footer(); ?>