<?php
/*
Plugin Name: WP All Import - Homey Reviews Add-On
Plugin URI: http://www.wpallimport.com/
Description: Supporting imports into the Homey theme.
Version: 1.0.0
Author: Favethemes
*/

include "rapid-addon.php";

$homey_review_addon = new RapidAddon( 'Homey Reviews Add-On', 'homey_addon' );


$homey_review_addon->disable_default_images();

$prefix = 'homey_';

$homey_review_addon->add_field( $prefix.'rating', 'Rating', 'text', null, 'example: 2' );

$homey_review_addon->add_field( $prefix.'where_to_display', 'Where to display', 'radio', array(
    'experience_detail_page' => 'Experiences',
    'listing_detail_page' => 'Listings'
) );

$homey_review_addon->add_field( 'reservation_experience_id', 'Experience Title', 'text', null, '' );
$homey_review_addon->add_field( 'reservation_listing_id', 'Listing Title', 'text', null, '' );

$homey_review_addon->set_import_function( 'homey_review_addon_import' );

$homey_review_addon->admin_notice();
/* Check dependent plugins */
$homey_review_addon->admin_notice( 'Homey Add-on requires WP All Import <a href="http://www.wpallimport.com/order-now/?utm_source=free-plugin&utm_medium=dot-org&utm_campaign=homey" target="_blank">Pro</a> or <a href="http://wordpress.org/plugins/wp-all-import" target="_blank">Free</a>, and the <a href="https://themeforest.net/item/homey-booking-wordpress-theme/23338013">Homey</a> theme.',
    array('themes' => array("Homey"))
);

$homey_review_addon->run( array(
    "themes"     => array("Homey"),
    "post_types" => array("homey_review")
) );

function homey_review_addon_import( $post_id, $data, $import_options, $article ) {

    global $homey_review_addon;
    $prefix = 'homey_';

    // all fields except for slider and image fields
    $fields = array(
        $prefix.'rating',
        $prefix.'where_to_display',
    );

    // update everything in fields arrays
    foreach ( $fields as $field ) {

        if ( empty( $article['ID'] ) or $homey_review_addon->can_update_meta( $field, $import_options ) ) {

            if ( strlen( $data[$field] ) == 0 ) {
                delete_post_meta( $post_id, $field );
            } else {
                update_post_meta( $post_id, $field, $data[$field] );
            }
        }
    }



    // update review experience
    $experience_title = 'reservation_experience_id';
    $post_type = 'experience';

    if ( empty( $article['ID'] ) or $homey_review_addon->can_update_meta( $experience_title, $import_options ) ) {

        $post = get_page_by_title( $data[$experience_title], 'OBJECT', $post_type );

        if ( !empty($post) ) {

            update_post_meta( $post_id, $experience_title, $post->ID );

        } 
    }

    // update review listings
    $listing_title = 'reservation_listing_id';
    $post_type = 'listing';

    if ( empty( $article['ID'] ) or $homey_review_addon->can_update_meta( $listing_title, $import_options ) ) {

        $post = get_page_by_title( $data[$listing_title], 'OBJECT', $post_type );

        if ( !empty($post) ) {

            update_post_meta( $post_id, $listing_title, $post->ID );

        } 
    }
    
}
