<?php
/*-----------------------------------------------------------------------------------*/
/*	Add Metaboxes
/*-----------------------------------------------------------------------------------*/

add_action('load-post.php', 'homey_meta_boxes_setup');
add_action('load-post-new.php', 'homey_meta_boxes_setup');

/* Meta box setup function. */
if (!function_exists('homey_meta_boxes_setup')) :
    function homey_meta_boxes_setup()
    {
        global $typenow;

        if ($typenow == 'homey_reservation') {
            add_action('add_meta_boxes', 'homey_add_reservation_meta');
            add_action('save_post', 'homey_save_page_metaboxes', 10, 2);

        } elseif ($typenow == 'page') {
            add_action('add_meta_boxes', 'homey_load_page_metaboxes');
            add_action('save_post', 'homey_save_page_metaboxes', 10, 2);
        }

    }
endif;


if (!function_exists('homey_add_reservation_meta')) :
    function homey_add_reservation_meta()
    {
        add_meta_box('homey-reservation-meta', esc_html__('Reservation', 'homey'), 'homey_reservation_meta', 'homey_reservation', 'normal', 'high');
    }
endif;

if (!function_exists('homey_load_page_metaboxes')) :
    function homey_load_page_metaboxes()
    {
        add_meta_box('homey-page-metaboxes', esc_html__('Page Sidebar', 'homey'), 'homey_page_metaboxes', 'page', 'side', 'high');
    }
endif;

/*-----------------------------------------------------------------------------------*/
/*  Page sidebar metaboxes
/*-----------------------------------------------------------------------------------*/

if (!function_exists('homey_reservation_meta')) {

    function homey_reservation_meta($object, $box)
    {
        $homey_local = homey_get_localization();
        $homey_prefix = 'homey_';
        $reservationID = $object->ID;

        if (count(get_post_meta($reservationID)) > 0) {
            $post = get_post($reservationID);

            $res_meta = get_post_meta($reservationID, 'reservation_meta', true);
            $is_hourly = get_post_meta($reservationID, 'is_hourly', true);

            $reservation_status = get_post_meta($reservationID, 'reservation_status', true);
            $upfront_payment = get_post_meta($reservationID, 'reservation_upfront', true);
            $upfront_payment = homey_formatted_price($upfront_payment);
            $payment_link = homey_get_template_link_2('template/dashboard-payment.php');

            if ($is_hourly == 'yes') {
                $check_in_date = $res_meta['check_in_date'];
                $start_hour = $res_meta['start_hour'];
                $end_hour = $res_meta['end_hour'];
                if ($res_meta['no_of_hours'] > 1) {
                    $hour_label = esc_html__('Hours', 'homey');
                } else {
                    $hour_label = esc_html__('Hour', 'homey');
                }
            } else {
                $check_in = get_post_meta($reservationID, 'reservation_checkin_date', true);
                $check_out = get_post_meta($reservationID, 'reservation_checkout_date', true);
            }


            $guests = get_post_meta($reservationID, 'reservation_guests', true);
            $listing_id = get_post_meta($reservationID, 'reservation_listing_id', true);
            $pets = get_post_meta($listing_id, $homey_prefix . 'pets', true);

            $booking_type = homey_booking_type_by_id($listing_id);

            $renter_msg = isset($res_meta['renter_msg']) ? $res_meta['renter_msg'] : '';

            $renter_id = get_post_meta($reservationID, 'listing_renter', true);
            $renter_info = homey_get_author_by_id('60', '60', 'reserve-detail-avatar img-circle', $renter_id);

            $owner_id = get_post_meta($reservationID, 'listing_owner', true);
            $owner_info = homey_get_author_by_id('60', '60', 'reserve-detail-avatar img-circle', $owner_id);

            $guests_label = $homey_local['guest_label'];
            if ($guests > 1) {
                $guests_label = $homey_local['guests_label'];
            }
            ?>

            <div class="wrap">
                <table class="wp-list-table widefat fixed striped">
                    <tr>
                        <td class="manage-column">
                            <strong><?php echo esc_attr($homey_local['date_label']); ?>:</strong>
                        </td>
                        <td>
                            <?php echo esc_attr(get_the_date(get_option('date_format'), $reservationID)); ?>
                            <br>
                            <?php echo esc_attr(get_the_date(get_option('time_format'), $reservationID)); ?>
                        </td>
                    </tr>
                    <tr>
                        <td class="manage-column">
                            <strong><?php esc_html_e('From', 'homey'); ?>:</strong>
                        </td>
                        <td>
                            <?php $renter_phone = get_user_meta($renter_id, 'phone', true);
                            $renter_phone_tel_tag = '<a title="'.esc_html__('Click to call', 'homey').'" href="tel:'.$renter_phone.'">'.$renter_phone.'</a>';
                            ?>
                            <?php echo esc_attr($renter_info['name']) . ' ' . $renter_phone_tel_tag; ?>
                        </td>
                    </tr>
                    <tr>
                        <td class="manage-column">
                            <strong><?php esc_html_e('Listing', 'homey'); ?>:</strong>
                        </td>
                        <td>
                            <?php echo get_the_title($listing_id); ?>
                        </td>
                    </tr>
                </table>
            </div>


            <div class="wrap">
                <h4><?php esc_html_e('Details', 'homey'); ?></h4>
                <table class="wp-list-table widefat fixed striped">
                    <tr>
                        <td class="manage-column">
                            <strong><?php echo esc_attr($homey_local['check_In']); ?>:</strong>
                        </td>
                        <td>
                            <?php
                            if ($is_hourly == 'yes') {
                                echo esc_attr($check_in_date) . ' ' . esc_html__('at', 'homey-core') . ' ' . date('g:i a', strtotime($start_hour));
                            } else {
                                echo esc_attr($check_in);
                            }
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td class="manage-column">
                            <strong><?php echo esc_attr($homey_local['check_Out']); ?>:</strong>
                        </td>
                        <td>
                            <?php
                            if ($is_hourly == 'yes') {
                                echo esc_attr($check_in_date) . ' ' . esc_html__('at', 'homey-core') . ' ' . date('g:i a', strtotime($end_hour));
                            } else {
                                echo esc_attr($check_out);
                            }
                            ?>
                        </td>
                    </tr>

                    <?php if ($is_hourly == 'yes') { ?>
                        <tr>
                            <td class="manage-column">
                                <strong><?php echo esc_attr($hour_label); ?>:</strong>
                            </td>
                            <td>
                                <?php echo esc_attr($res_meta['no_of_hours']); ?>
                            </td>
                        </tr>
                    <?php } else { ?>

                        <?php if ($booking_type == 'per_week') {
                            $no_of_weeks = isset($res_meta['total_weeks_count']) ? $res_meta['total_weeks_count'] : 0;
                            ?>

                            <tr>
                                <td class="manage-column">
                                    <strong><?php echo esc_html__('Weeks', 'homey'); ?>:</strong>
                                </td>
                                <td>
                                    <?php echo esc_attr($no_of_weeks); ?>
                                </td>
                            </tr>

                        <?php } else { ?>
                            <tr>
                                <td class="manage-column">
                                    <strong><?php echo esc_attr($homey_local['nights_label']); ?>:</strong>
                                </td>
                                <td>
                                    <?php echo esc_attr(isset($res_meta['no_of_days']) ? $res_meta['no_of_days'] : ''); ?>
                                </td>
                            </tr>
                        <?php } ?>
                    <?php } ?>
                    <tr>
                        <td class="manage-column">
                            <strong><?php echo esc_attr($guests_label); ?>:</strong>
                        </td>
                        <td>
                            <?php echo esc_attr($guests); ?>
                        </td>
                    </tr>
                    <?php if (!empty($res_meta['additional_guests'])) { ?>
                        <tr>
                            <td class="manage-column">
                                <strong><?php echo esc_attr($homey_local['addinal_guest_text']); ?>:</strong>
                            </td>
                            <td>
                                <?php echo esc_attr($res_meta['additional_guests']); ?>
                            </td>
                        </tr>
                    <?php } ?>
                    <!-- <tr>
                        <td class="manage-column">
                            <strong>Children:</strong>
                        </td>
                        <td>
                            0
                        </td>
                    </tr> -->
                </table>
            </div>

            <?php if (!empty($renter_msg)) { ?>
                <div class="wrap">
                    <h4><?php esc_html_e('Notes', 'homey'); ?></h4>
                    <table class="wp-list-table widefat fixed striped">
                        <tr>
                            <td>
                                <?php echo esc_attr($renter_msg); ?>
                            </td>
                        </tr>
                    </table>
                </div>
            <?php } ?>

            <div class="wrap">
                <h4><?php echo esc_attr($homey_local['payment_label']); ?></h4>
                <table class="wp-list-table widefat fixed striped">
                    <?php
                    if (count(get_post_meta($reservationID)) > 0) {
                        if ($is_hourly == 'yes') {
                            echo homey_calculate_hourly_reservation_cost_admin($reservationID);
                        } else {
                            echo homey_calculate_reservation_cost_admin($reservationID);
                        }
                    } else {
                        echo '<h1>Reservation New</h1>';
                    }
                    ?>
                </table>
            </div>
            <?php
        } else {// new post as this does not contain any meta
            homey_reservation_meta_new_post($object, $box);
        }
    }
}

if (!function_exists('homey_reservation_meta_new_post')) {

    function homey_reservation_meta_new_post($object, $box)
    {
        $homey_local = homey_get_localization();
        $homey_prefix = 'homey_';
        $reservationID = $object->ID;

        $post = get_post($reservationID);

        $res_meta = $is_hourly = $reservation_status = $upfront_payment = null;
        $payment_link = homey_get_template_link_2('template/dashboard-payment.php');

        $check_in = current_time('Y-m-d');

        $current_date_time = new DateTime(current_time('Y-m-d'));
        $current_date_time->modify('+1 day');
        $check_out = $current_date_time->format('Y-m-d');

        $guests = 1;
        $listing_id = 0;
        $pets = 0;

        $booking_type = homey_booking_type_by_id($listing_id);

        $renter_msg = '';

        $renter_id = $owner_id = 0;
        $renter_info = $owner_info = '';

        $guests_label = $homey_local['guest_label'];
        $renter_name = isset($renter_info['name']) ? $renter_info['name'] : 'n-a';

        $error = get_transient('homey_metabox_error');
        if ($error) {
            echo '<div class="error"><p>' . $error . '</p></div>';
            delete_transient('homey_metabox_error');
        }
        ?>
        <form method="post">
            <?php wp_nonce_field('save_homey_reservation_meta_box_data', 'homey_reservation_meta_box_nonce'); ?>
            <div class="wrap">
                <table class="wp-list-table widefat fixed striped">
                    <tr>
                        <td class="manage-column">
                            <strong><?php echo esc_attr($homey_local['date_label']); ?>:</strong>
                        </td>
                        <td>
                            <?php echo esc_attr(get_the_date(get_option('date_format'), $reservationID)); ?>
                            <br>
                            <?php echo esc_attr(get_the_date(get_option('time_format'), $reservationID)); ?>
                        </td>
                    </tr>
                    <tr>
                        <td class="manage-column">
                            <strong><?php esc_html_e('Reservation Type', 'homey'); ?>:</strong>
                        </td>
                        <td>
                            <?php
                            $reservation_types = [
                                'instant_booking' => esc_html__('Instant Book', 'homey'),
                                'request_booking' => esc_html__('Request to book', 'homey'),
                            ];
                            $output = '<select name="reservation_type_dropdown" id="reservation_type_dropdown">';
                            $output .= '<option value="">' . esc_html__("Select Reservation Type", "homey") . '</option>';

                            foreach ($reservation_types as $key => $reservation_type) {
                                $selected = ($key == 'instant_booking') ? 'selected="selected"' : '';

                                $output .= '<option value="' . esc_attr($key) . '" ' . $selected . '>' . esc_html($reservation_type) . '</option>';
                            }

                            $output .= '</select>';
                            echo $output;
                            ?>
                        </td>
                    </tr>

                    <tr>
                        <td class="manage-column">
                            <strong><?php esc_html_e('From', 'homey'); ?>:</strong>
                        </td>
                        <td>
                            <?php echo homey_get_all_users_select($renter_id); ?>
                        </td>
                    </tr>
                    <tr>
                        <td class="manage-column">
                            <strong><?php esc_html_e('Listing', 'homey'); ?>:</strong>
                        </td>
                        <td>
                            <?php echo homey_get_all_listings_select($listing_id); ?>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="wrap">
                <h4><?php esc_html_e('Details', 'homey'); ?></h4>
                <table class="wp-list-table widefat fixed striped">
                    <tr>
                        <td class="manage-column">
                            <strong><?php echo esc_attr($homey_local['check_In']); ?>:</strong>
                        </td>
                        <td>
                            <?php
                            if ($is_hourly == 'yes') {
                                echo esc_attr($check_in) . ' ' . esc_html__('at', 'homey-core') . ' ' . date('g:i a', strtotime($start_hour));
                            } else {
                                echo '<input type="date" name="checkin_date" value="' . $check_in . '" />';
                            }
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td class="manage-column">
                            <strong><?php echo esc_attr($homey_local['check_Out']); ?>:</strong>
                        </td>
                        <td>
                            <?php
                            if ($is_hourly == 'yes') {
                                echo esc_attr($check_out) . ' ' . esc_html__('at', 'homey-core') . ' ' . date('g:i a', strtotime($end_hour));
                            } else {
                                echo '<input type="date" name="checkout_date" value="' . $check_out . '" />';
                            }
                            ?>
                        </td>
                    </tr>

                    <?php if ($is_hourly == 'yes') { ?>
                        <tr>
                            <td class="manage-column">
                                <strong><?php echo esc_attr($hour_label); ?>:</strong>
                            </td>
                            <td>1</td>
                        </tr>
                    <?php } else { ?>

                        <?php if ($booking_type == 'per_week') {
                            ?>
                            <tr>
                                <td class="manage-column">
                                    <strong><?php echo esc_html__('Weeks', 'homey'); ?>:</strong>
                                </td>
                                <td>1</td>
                            </tr>

                        <?php } else { ?>
                            <tr>
                                <td class="manage-column">
                                    <strong><?php echo esc_attr($homey_local['nights_label']); ?>:</strong>
                                </td>
                                <td>1</td>
                            </tr>
                        <?php } ?>
                    <?php } ?>
                    <tr>
                        <td class="manage-column">
                            <strong><?php echo esc_attr($guests_label); ?>:</strong>
                        </td>
                        <td><input type="number" name="guests" value="<?php echo esc_attr($guests); ?>"/>';
                        </td>
                    </tr>
                    <?php if (!empty($res_meta['additional_guests'])) { ?>
                        <tr>
                            <td class="manage-column">
                                <strong><?php echo esc_attr($homey_local['addinal_guest_text']); ?>:</strong>
                            </td>
                            <td>
                                <?php echo esc_attr($res_meta['additional_guests']); ?>
                            </td>
                        </tr>
                    <?php } ?>
                    <!-- <tr>
                        <td class="manage-column">
                            <strong>Children:</strong>
                        </td>
                        <td>
                            0
                        </td>
                    </tr> -->
                </table>
            </div>

            <?php if (!empty($renter_msg)) { ?>
                <div class="wrap">
                    <h4><?php esc_html_e('Notes', 'homey'); ?></h4>
                    <table class="wp-list-table widefat fixed striped">
                        <tr>
                            <td>
                                <?php echo esc_attr($renter_msg); ?>
                            </td>
                        </tr>
                    </table>
                </div>
            <?php } ?>
        </form>
    <?php }
}

// Save the meta box data

/*-----------------------------------------------------------------------------------*/
/*  Page sidebar metaboxes
/*-----------------------------------------------------------------------------------*/

if (!function_exists('homey_page_metaboxes')):

    function homey_page_metaboxes($object, $box)
    {
        global $wp_registered_sidebars;

        $homey_meta = homey_get_sidebar_meta($object->ID);
        wp_nonce_field(plugin_basename(__FILE__), 'homey_page_nonce');

        $sidebar = $homey_meta['homey_sidebar'];
        $sidebar_position = $homey_meta['sidebar_position'];
        $selected_sidebar = $homey_meta['selected_sidebar'];
        ?>
        <div class="homey_meta_control custom_sidebar_js">
            <p><?php esc_html_e('Show Sidebar?', 'homey'); ?></p>
            <select id="homey_page_sidebar" name="homey[homey_sidebar]" class="homey-dropdown widefat">
                <option value="no" <?php selected($sidebar, 'no'); ?>><?php esc_html_e('No', 'homey'); ?></option>
                <option value="yes" <?php selected($sidebar, 'yes'); ?>><?php esc_html_e('Yes', 'homey'); ?></option>
            </select>
        </div>

        <div class="homeythemes_meta_control homey_selected_sidebar" style="display: none;">
            <p><?php esc_html_e('Sidebar Position', 'homey'); ?></p>
            <select name="homey[sidebar_position]" class="homey-dropdown widefat">
                <option value="right" <?php selected($sidebar_position, 'right'); ?>><?php esc_html_e('Right', 'homey'); ?></option>
                <option value="left" <?php selected($sidebar_position, 'left'); ?>><?php esc_html_e('Left', 'homey'); ?></option>
            </select>
        </div>

        <div class="homeythemes_meta_control homey_selected_sidebar" style="display: none;">
            <p><?php esc_html_e('Select Sidebar', 'homey'); ?></p>
            <select name="homey[selected_sidebar]" class="homey-dropdown widefat">
                <option value=""><?php echo esc_html__('Default', 'homey'); ?></option>
                <?php
                foreach ($wp_registered_sidebars as $sidebar) { ?>
                    <option value="<?php echo esc_attr($sidebar['id']); ?>" <?php selected($selected_sidebar, $sidebar['id']); ?>><?php echo esc_attr($sidebar['name']); ?></option>
                    <?php
                }
                ?>
            </select>
        </div>

        <?php
    }

endif; // end   homey_page_metaboxes

/*-----------------------------------------------------------------------------------*/
/* Save sidebar page Meta
/*-----------------------------------------------------------------------------------*/
if (!function_exists('homey_save_page_metaboxes')) :
    function homey_save_page_metaboxes($post_id, $post)
    {
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
            return;

        if ($post->post_type == 'homey_reservation' && isset($_POST['user_ID'])) {
            $post_type = get_post_type_object($post->post_type);
            if (!current_user_can($post_type->cap->edit_post, $post_id))
                return $post_id;

            $homey_meta = array();
            $renter_id = $_POST['user_dropdown'];
            $reservation_type = $_POST['reservation_type_dropdown'];
            $listing_id = $_POST['posts_dropdown'];
            $checkin_date = $_POST['checkin_date'];
            $checkout_date = $_POST['checkout_date'];
            $guests = $_POST['guests'];
            homey_admin_user_add_reservation($post_id, $listing_id, $renter_id, $checkin_date, $checkout_date, $guests, $reservation_type);

        }

        if ($post->post_type == 'page' && isset($_POST['homey'])) {
            $post_type = get_post_type_object($post->post_type);
            if (!current_user_can($post_type->cap->edit_post, $post_id))
                return $post_id;

            $homey_meta = array();

            $homey_meta['homey_sidebar'] = isset($_POST['homey']['homey_sidebar']) ? $_POST['homey']['homey_sidebar'] : 'no';

            $homey_meta['sidebar_position'] = isset($_POST['homey']['sidebar_position']) ? $_POST['homey']['sidebar_position'] : 'right';

            $homey_meta['selected_sidebar'] = isset($_POST['homey']['selected_sidebar']) ? $_POST['homey']['selected_sidebar'] : 'default-sidebar';

            update_post_meta($post_id, '_homey_sidebar_meta', $homey_meta);

        }
    }
endif;

if (!function_exists('homey_admin_user_add_reservation')) {
    function homey_admin_user_add_reservation($reservation_id, $listing_id, $userID, $check_in_date, $check_out_date, $guests, $reservation_type)
    {
        $admin_email = get_option('new_admin_email');
        $admin_email = empty($admin_email) ? get_option('admin_email') : $admin_email;

        $local = homey_get_localization();
        $allowded_html = array();
        $reservation_meta = array();

        $listing_owner_id = get_post_field('post_author', $listing_id);
        $extra_options = isset($_POST['extra_options']) ? $_POST['extra_options'] : '';
        $title = $local['reservation_text'] . ' ' . esc_html__('by admin', 'homey');

        $booking_type = homey_booking_type_by_id($listing_id);

        $owner = homey_usermeta($listing_owner_id);
        $owner_email = $owner['email'];

        if (!is_user_logged_in() || $userID === 0) {
            set_transient('homey_metabox_error', $local['login_for_reservation'], 60); // Transient expires in 60 seconds
            return false;

        }

        $booking_hide_fields = homey_option('booking_hide_fields');
        if (empty($guests) && $booking_hide_fields['guests'] != 1) {
            set_transient('homey_metabox_error', $local['choose_guests'], 60); // Transient expires in 60 seconds
            return false;
        }

        if ($booking_type == "per_day_date" && strtotime($check_out_date) < strtotime($check_in_date)) {
            set_transient('homey_metabox_error', $local['ins_book_proceed'], 60); // Transient expires in 60 seconds
        }

        if ($booking_type != "per_day_date" && strtotime($check_out_date) <= strtotime($check_in_date)) {
            set_transient('homey_metabox_error', $local['dates_not_available'], 60); // Transient expires in 60 seconds
            return false;
        }

        $check_availability = check_booking_availability($check_in_date, $check_out_date, $listing_id, $guests);

        $is_available = $check_availability['success'];
        $check_message = $check_availability['message'];

        if ($is_available) {
            if ($booking_type == 'per_week') {
                $prices_array = homey_get_weekly_prices($check_in_date, $check_out_date, $listing_id, $guests, $extra_options);

                $price_per_week = $prices_array['price_per_week'];
                $weeks_total_price = $prices_array['weeks_total_price'];
                $total_weeks_count = $prices_array['total_weeks_count'];

                $reservation_meta['price_per_week'] = $price_per_week;
                $reservation_meta['weeks_total_price'] = $weeks_total_price;
                $reservation_meta['total_weeks_count'] = $total_weeks_count;
                $reservation_meta['reservation_listing_type'] = 'per_week';

            } else if ($booking_type == 'per_month') {
                $prices_array = homey_get_monthly_prices($check_in_date, $check_out_date, $listing_id, $guests, $extra_options);

                $price_per_month = $prices_array['price_per_month'];
                $months_total_price = $prices_array['months_total_price'];
                $total_months_count = $prices_array['total_months_count'];

                $reservation_meta['price_per_month'] = $price_per_month;
                $reservation_meta['months_total_price'] = $months_total_price;
                $reservation_meta['total_months_count'] = $total_months_count;
                $reservation_meta['reservation_listing_type'] = 'per_month';

            } else if ($booking_type == 'per_day_date') {

                $prices_array = homey_get_day_date_prices($check_in_date, $check_out_date, $listing_id, $guests, $extra_options);
                $price_per_night = $prices_array['price_per_day_date'];
                $nights_total_price = $prices_array['nights_total_price'];

                $reservation_meta['price_per_day_date'] = $price_per_night;
                $reservation_meta['price_per_night'] = $price_per_night;
                $reservation_meta['days_total_price'] = $nights_total_price;
                $reservation_meta['reservation_listing_type'] = 'per_day_date';
            } else {

                $prices_array = homey_get_prices($check_in_date, $check_out_date, $listing_id, $guests, $extra_options);
                $price_per_night = $prices_array['price_per_night'];
                $nights_total_price = $prices_array['nights_total_price'];

                $reservation_meta['price_per_night'] = $price_per_night;
                $reservation_meta['nights_total_price'] = $nights_total_price;
                $reservation_meta['reservation_listing_type'] = 'per_night';
            }

            $reservation_meta['no_of_days'] = $prices_array['days_count'] = $booking_type == 'per_day_date' ? $prices_array['days_count'] : $prices_array['days_count'];
            $reservation_meta['additional_guests'] = $prices_array['additional_guests'];

            $upfront_payment = $prices_array['upfront_payment'];
            $balance = $prices_array['balance'];
            $total_price = $prices_array['total_price'];
            $cleaning_fee = $prices_array['cleaning_fee'];
            $city_fee = $prices_array['city_fee'];
            $services_fee = $prices_array['services_fee'];
            $days_count = $prices_array['days_count'];
            $period_days = isset($prices_array['period_days']) ? $prices_array['period_days'] : 1;
            $taxes = $prices_array['taxes'];
            $taxes_percent = $prices_array['taxes_percent'];
            $security_deposit = $prices_array['security_deposit'];
            $additional_guests = $prices_array['additional_guests'];
            $additional_guests_price = $prices_array['additional_guests_price'];
            $additional_guests_total_price = $prices_array['additional_guests_total_price'];
            $booking_has_weekend = isset($prices_array['booking_has_weekend']) ? $prices_array['booking_has_weekend'] : 0;
            $booking_has_custom_pricing = isset($prices_array['booking_has_custom_pricing']) ? $prices_array['booking_has_custom_pricing'] : 0;

            $reservation_meta['check_in_date'] = $check_in_date;
            $reservation_meta['check_out_date'] = $check_out_date;
            $reservation_meta['guests'] = $guests;
            $reservation_meta['listing_id'] = $listing_id;
            $reservation_meta['upfront'] = $upfront_payment;
            $reservation_meta['balance'] = $balance;
            $reservation_meta['total'] = $total_price;

            $reservation_meta['cleaning_fee'] = $cleaning_fee;
            $reservation_meta['city_fee'] = $city_fee;
            $reservation_meta['services_fee'] = $services_fee;
            $reservation_meta['period_days'] = $period_days;
            $reservation_meta['taxes'] = $taxes;
            $reservation_meta['taxes_percent'] = $taxes_percent;
            $reservation_meta['security_deposit'] = $security_deposit;
            $reservation_meta['additional_guests_price'] = $additional_guests_price;
            $reservation_meta['additional_guests_total_price'] = $additional_guests_total_price;
            $reservation_meta['booking_has_weekend'] = $booking_has_weekend;
            $reservation_meta['booking_has_custom_pricing'] = $booking_has_custom_pricing;

            global $wpdb;
            $wpdb->update(
                $wpdb->posts,
                array(
                    'post_title' => $title . ' ' . $reservation_id
                ),
                array(
                    'ID' => $reservation_id
                )
            );

            update_post_meta($reservation_id, 'reservation_listing_id', $listing_id);
            update_post_meta($reservation_id, 'listing_owner', $listing_owner_id);
            update_post_meta($reservation_id, 'listing_renter', $userID);
            update_post_meta($reservation_id, 'reservation_checkin_date', $check_in_date);
            update_post_meta($reservation_id, 'reservation_checkout_date', $check_out_date);
            update_post_meta($reservation_id, 'reservation_guests', $guests);
            update_post_meta($reservation_id, 'reservation_meta', $reservation_meta);
            update_post_meta($reservation_id, 'reservation_status', 'under_review');
            update_post_meta($reservation_id, 'is_hourly', 'no');
            update_post_meta($reservation_id, 'extra_options', $extra_options);
            update_post_meta($reservation_id, 'reservation_upfront', $upfront_payment);
            update_post_meta($reservation_id, 'reservation_balance', $balance);
            update_post_meta($reservation_id, 'reservation_total', $total_price);

            if ($reservation_type == 'instant_booking') {
                //Book dates
                $booked_days_array = homey_make_days_booked($listing_id, $reservation_id);
                update_post_meta($listing_id, 'reservation_dates', $booked_days_array);
                set_transient('homey_metabox_error', $local['reserve_period_success'], 60); // Transient expires in 60 seconds
            } else {
                if ($booking_type == 'per_day_date') {
                    $pending_dates_array = homey_get_booking_pending_date_days($listing_id);
                } else {
                    $pending_dates_array = homey_get_booking_pending_days($listing_id);
                }
                update_post_meta($listing_id, 'reservation_pending_dates', $pending_dates_array);
                set_transient('homey_metabox_error', $local['request_sent'], 60); // Transient expires in 60 seconds
            }

            $user_info = get_userdata($userID);
            $renter_email = '';
            if ($user_info) {
                $renter_email = $user_info->user_email;
            }

            $email_args = array(
                'reservation_detail_url' => reservation_detail_link($reservation_id),
                'check_in_date' => $check_in_date,
                'check_out_date' => $check_out_date,
                'guests' => $guests,
                'adult_guest' => 'n-a',
                'child_guest' => 'n-a',
                'total_price' => $total_price,
                'renter_email' => $renter_email
            );

            if ($owner_email != $admin_email) {
                homey_email_composer($owner_email, 'new_reservation_by_admin', $email_args);
            }

            homey_email_composer($admin_email, 'new_reservation_by_admin', $email_args);

            $reservation_page = homey_get_template_link_dash('template/dashboard-reservations2.php');
            $reservation_detail_link = add_query_arg('reservation_detail', $reservation_id, $reservation_page);

            $user_info = get_userdata($userID);
            $renter_email = '';
            if ($user_info) {
                $renter_email = $user_info->user_email;
            }

            $email_args = array(
                'reservation_detail_url' => $reservation_detail_link,
                'check_in_date' => $check_in_date,
                'check_out_date' => $check_out_date,
                'guests' => $guests,
                'adult_guest' => 'n-a',
                'child_guest' => 'n-a',
                'total_price' => $total_price,
                'renter_email' => $renter_email
            );

            homey_email_composer($renter_email, 'new_reservation_sent_by_admin', $email_args);
        } else { // end $check_availability
            set_transient('homey_metabox_error', $check_message, 60); // Transient expires in 60 seconds
        }

    }
}