<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Homey_Exp_Reservation_Post_Type {
    /**
     * Initialize custom post type
     *
     * @access public
     * @return void
     */
    public static function init() {
        add_action( 'init', array( __CLASS__, 'definition' ) );

        add_action('admin_init', array( __CLASS__, 'mark_exp_paid_manually' ));
        add_action('wp_trash_post', array( __CLASS__, 'homey_delete_exp_clear_db_on_trash'), 10);
        add_action('untrash_post', array( __CLASS__, 'homey_restore_exp_reservation'), 11);

        add_filter( 'manage_edit-homey_e_reservation_columns', array( __CLASS__, 'custom_experience_columns' ) );
        add_action( 'manage_pages_custom_column', array( __CLASS__, 'custom_experience_columns_manage' ) );
    }

    /**
     * Custom post type definition
     *
     * @access public
     * @return void
     */
    public static function definition() {
        $labels = array(
            'name' => __( 'Experience Reservations','homey-core'),
            'singular_name' => __( 'Reservation','homey-core' ),
            'add_new' => __('Add New','homey-core'),
            'add_new_item' => __('Add New','homey-core'),
            'edit_item' => __('Edit Reservation','homey-core'),
            'new_item' => __('New Reservation','homey-core'),
            'view_item' => __('View Reservation','homey-core'),
            'search_items' => __('Search Reservation','homey-core'),
            'not_found' =>  __('No Reservation found','homey-core'),
            'not_found_in_trash' => __('No Reservation found in Trash','homey-core'),
            'parent_item_colon' => ''
          );

        $labels = apply_filters( 'homey_exp_reservation_post_type_labels', $labels );

        $args = array(
            'labels' => $labels,
            'public' => false,
            'show_in_menu'        => false,
            'show_in_admin_bar'   => true,
            'publicly_queryable' => false,
            'show_ui' => true,
            'query_var' => true,
            'has_archive' => true,
            'capability_type' => 'post',
            'map_meta_cap'    => true,
            'hierarchical' => true,
            'menu_icon' => 'dashicons-location',
            'menu_position' => 22,
            'can_export' => true,
            'show_in_rest'       => true,
            'rest_base'          => 'exp_reservations',
            'rest_controller_class' => 'WP_REST_Posts_Controller',
            'supports' => array('title','revisions','author'),

             // The rewrite handles the URL structure.
            'rewrite' => array(
                  'slug'       => 'homey_e_reservation',
                  'with_front' => false,
                  'pages'      => true,
                  'feeds'      => true,
                  'ep_mask'    => EP_PERMALINK,
            ),
        );

        $args = apply_filters( 'homey_exp_reservation_post_type_args', $args );

        register_post_type('homey_e_reservation',$args);
    }

    public static function mark_exp_paid_manually() {
        if (!empty($_GET['mark-paid']) && wp_verify_nonce($_REQUEST['_wpnonce'], 'mark-paid') && current_user_can('publish_post', $_GET['mark-paid'])) {
            global $current_user;
            $current_user = wp_get_current_user();
            $userID       = $current_user->ID;
            $date = date( 'Y-m-d G:i:s', current_time( 'timestamp', 0 ));

            $reservation_id = absint($_GET['mark-paid']);
            update_post_meta($reservation_id, 'reservation_status', 'booked');

            // Emails
            $experience_owner = get_post_meta($reservation_id, 'experience_owner', true);
            $experience_renter = get_post_meta($reservation_id, 'experience_renter', true);

            $renter = homey_usermeta($experience_renter);
            $renter_email = $renter['email'];

            $owner = homey_usermeta($experience_owner);
            $owner_email = $owner['email'];

            $email_args = array('reservation_detail_url' => reservation_detail_link($reservation_id) );
            homey_email_composer( $renter_email, 'booked_reservation', $email_args );
            homey_email_composer( $owner_email, 'admin_booked_reservation', $email_args );

            //zahid generate invoice on off site payment
            homey_exp_generate_invoice( 'reservation','one_time', $reservation_id, $date, $userID, 0, 0, '', 'Self' , 1);

            wp_redirect(remove_query_arg('mark-paid', add_query_arg('mark-paid', $reservation_id, admin_url('edit.php?post_type=homey_reservation'))));
            exit;
        }
    }


    /**
     * Delete booked and pending dates on trash
     *
     * @access public
     * @return void
     */
    public static function homey_delete_exp_clear_db_on_trash( $postid ){

        global $post_type;
        if ( $post_type == 'homey_e_reservation' ) {
           
            if( !current_user_can('administrator') ) {
                exit("don't have rights");
            }

            homey_delete_reservation_exp($postid);
            
        }
    }

    /**
     * Restore reservation from trash trash
     *
     * @access public
     * @return void
     */
    public static function homey_restore_exp_reservation( $postid ){
        global $post_type;   
        if ( $post_type == 'homey_e_reservation' ) {
           
            if( !current_user_can('administrator') ) {
                exit("don't have rights");
            }

            $reservation_id = $postid;
              
            $experience_id  = get_post_meta($reservation_id, 'reservation_experience_id', true);
            $is_hourly   = get_post_meta($reservation_id, 'is_hourly', true);    
            
            if($reservation_id==0 || $experience_id==0 ) {
                exit();
            }

            if($is_hourly == 'yes') { 
                $booked_days_array = homey_make_hours_booked($experience_id, $reservation_id);
                update_post_meta($experience_id, 'reservation_booked_hours', $booked_days_array);
            } else {
                $booked_days_array = homey_make_days_booked($experience_id, $reservation_id);
                update_post_meta($experience_id, 'reservation_dates', $booked_days_array);
            }
            
        }
    }

    /**
     * Custom admin columns for post type
     *
     * @access public
     * @return array
     */
    public static function custom_experience_columns() {

        $columns = array(
            "cb" => "<input type=\"checkbox\" />",
            "pic" => __( 'Pic','homey-core' ),
            "title" => __( 'ID','homey-core' ),
            'status' => __( 'Status','homey-core' ),
            //"res_date" => __('Date','homey-core'),
            "res_address" => __('Address','homey-core'),
            "check_in" => __('Check-in','homey-core'),
            "check_out" => __( 'Check-out','homey-core' ),
            "res_guests" => __( 'Guests','homey-core' ),
            "pets" => __( 'Pets','homey-core' ),
            "subtotal" => __( 'Subtotal','homey-core' ),
            "actions" => __( 'Actions','homey-core' ),
            "date" => __('Date','homey-core'),
        );

        $columns = apply_filters( 'houzez_custom_post_experience_columns', $columns );

        return $columns;
        
    }

    /**
     * Custom admin columns implementation
     *
     * @access public
     * @param string $column
     * @return array
     */
    public static function custom_experience_columns_manage( $column ) {
        global $post, $post_type;

        if($post_type != 'homey_e_reservation'){
            return '';
        }

        $prefix = 'homey_';
        $local = homey_get_localization();
        $experience_id = get_post_meta(get_the_ID(), 'reservation_experience_id', true);
        $status = get_post_meta(get_the_ID(), 'reservation_status', true);
        $is_hourly = get_post_meta(get_the_ID(), 'is_hourly', true);

        if($is_hourly == 'yes') {
            $item_meta = get_post_meta(get_the_ID(), 'reservation_meta', true);
        }

        switch ($column)
        {
            case 'pic':
                $experience_author = homey_get_author('40', '40', 'img-circle media-object avatar');
                if(!empty($experience_author['photo'])) {
                    echo $experience_author['photo'];
                } else {
                    echo '-';
                }
                break;
            case 'title':
                echo $post->ID. ' >>> test <<< ';
                break;

            case 'status':
                homey_e_reservation_label($status);
                break;
            case 'res_address':
                $experience_address    = get_post_meta( $experience_id, $prefix.'experience_address', true );
                echo $experience_address;
                break;
            case 'check_in':

                if($is_hourly == 'yes') {
                    echo homey_format_date_simple(esc_attr($item_meta['check_in_date'])).'<br/>';
                    echo esc_html__('at', 'homey-core').' ';
                    echo date('g:i a',strtotime($item_meta['start_hour']));
                } else {
                    $check_in = get_post_meta(get_the_ID(), 'reservation_checkin_date', true);
                    esc_attr_e(homey_format_date_simple($check_in));
                }
                break;
            case 'check_out':

                if($is_hourly == 'yes') {
                    echo homey_format_date_simple(esc_attr($item_meta['check_in_date'])).'<br/>';
                    echo esc_html__('at', 'homey-core').' ';
                    echo date('g:i a',strtotime($item_meta['end_hour']));
                } else {
                    $check_out = get_post_meta(get_the_ID(), 'reservation_checkout_date', true);
                    esc_attr_e(homey_format_date_simple($check_out));
                }
                break;
            case 'res_guests':
                $guests = get_post_meta(get_the_ID(), 'reservation_guests', true);
                echo $guests; 
                break;
            case 'pets':
                $pets   = get_post_meta($experience_id, $prefix.'pets', true);
                if($pets != 1) {
                    echo $local['text_no'];
                } else {
                    echo $local['text_yes'];
                }
                break;
            case 'subtotal':
                $deposit = get_post_meta(get_the_ID(), 'reservation_upfront', true);
                echo homey_formatted_price($deposit);
                break;
            
            case 'actions':
                echo '<div class="actions">';
                $admin_actions = apply_filters( 'post_row_actions', array(), $post );

                $user = wp_get_current_user();

                if( ($status == 'under_review' || $status == 'available') && current_user_can('administrator')) {
    
                    if ( in_array( $post->post_status, array( 'publish' ) ) && !homey_is_renter() ) {
                        $admin_actions['mark-paid']   = array(
                            'action'  => 'mark-paid',
                            'name'    => __( 'Mark Paid', 'homey-core' ),
                            'url'     =>  wp_nonce_url( add_query_arg( 'mark-paid', $post->ID ), 'mark-paid' )
                        );
                    }
                }

                if ( $post->post_status !== 'trash' ) {
                    
                    if ( current_user_can( 'edit_post', $post->ID ) ) {
                        $admin_actions['edit']   = array(
                            'action'  => 'edit',
                            'name'    => __( 'View Detail', 'homey-core' ),
                            'url'     => get_edit_post_link( $post->ID )
                        );
                    }
                    
                }


                $admin_actions = apply_filters( 'homey_experience_admin_actions', $admin_actions, $post );

                foreach ( $admin_actions as $action ) {
                    if ( is_array( $action ) ) {
                        printf( '<a class="button button-icon tips icon-%1$s" href="%2$s" data-tip="%3$s">%4$s</a>', $action['action'], esc_url( $action['url'] ), esc_attr( $action['name'] ), esc_html( $action['name'] ) );
                    } else {
                        //echo str_replace( 'class="', 'class="button ', $action );
                    }
                }

                echo '</div>';

                break;

        }
    }


}
