<?php

/**
 * SETTINGS TAB
 **/
$ipanel_hind_tabs[] = array(
	'name' => esc_html__('Main Settings', 'hind'),
	'id' => 'main_settings'
);

$ipanel_hind_option[] = array(
	"type" => "StartTab",
	"id" => "main_settings"
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Enable Site Preloader", 'hind'),
	"id" => "enable_preloader",
	"std" => false,
	"desc" => esc_html__("Show animated site preloader before site content will be loaded", 'hind'),
	"type" => "checkbox",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Upload Site Preloader image", 'hind'),
	"id" => "preloader_image",
	"field_options" => array(
		"std" => get_template_directory_uri().'/img/preloader.gif'
	),
	"desc" => esc_html__("Upload your site preloader image (Animated GIF recommended). Leave blank to use theme default CSS3 preloader.", 'hind'),
	"type" => "qup",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Preloader image width (px)", 'hind'),
	"id" => "preloader_width",
	"std" => "100",
	"desc" => esc_html__("Default: 100. Upload retina preloader (2x size) and input your regular preloader image width here. For example if your retina preloader image have 400px width put 200 value here. If you does not use retina preloader input regular image width here (your preloader image width).", 'hind'),
	"type" => "text",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Enable Parallax effects for pages backgrounds and parallax blocks", 'hind'),
	"id" => "enable_parallax",
	"std" => true,
	"desc" => esc_html__("You can turn on/off parallax effects for scrolling here", 'hind'),
	"type" => "checkbox",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Enable theme CSS3 animations", 'hind'),
	"id" => "enable_theme_animations",
	"std" => true,
	"desc" => esc_html__("Enable colors and background colors fade effects", 'hind'),
	"type" => "checkbox",
);
$ipanel_hind_option[] = array(
	"type" => "htmlpage",
	"name" => wp_kses_post(__('<div class="ipanel-label">
	    <label>Favicon</label>
	  </div><div class="ipanel-input">
	    You can upload your website favicon (site icon) in <a href="customize.php" target="_blank">WordPress Customizer</a> (in "Site Identity" section at the left sidebar).<br/><br/><br/>
	  </div>', 'hind'))
);

$ipanel_hind_option[] = array(
	"type" => "EndTab"
);
/**
 * Header TAB
 **/
$ipanel_hind_tabs[] = array(
	'name' => esc_html__('Header', 'hind'),
	'id' => 'header_settings'
);

$ipanel_hind_option[] = array(
	"type" => "StartTab",
	"id" => "header_settings"
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Header layout", 'hind'),
	"type" => "StartSection",
	"field_options" => array(
		"show" => true // Set true to show items by default.
	)
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Header height in pixels", 'hind'),
	"id" => "header_height",
	"std" => "145",
	"desc" => esc_html__("Default: 145", 'hind'),
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Fullwidth Header", 'hind'),
	"id" => "header_fullwidth",
	"std" => true,
	"desc" => "",
	"type" => "checkbox",
);
$ipanel_hind_option[] = array(
	"type" => "htmlpage",
	"name" => wp_kses_post(__('<div class="ipanel-label">
	    <label>Logo upload</label>
	  </div><div class="ipanel-input">
	    You can upload your website logo in <a href="customize.php" target="_blank">WordPress Customizer</a> (in "Header Image" section at the left sidebar).<br/><br/><br/>
	  </div>', 'hind'))
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Logo width (px)", 'hind'),
	"id" => "logo_width",
	"std" => "114",
	"desc" => esc_html__("Default: 114. Upload retina logo (2x size) and input your regular logo width here. For example if your retina logo have 400px width put 200 value here. If you does not use retina logo input regular logo width here (your logo image width).", 'hind'),
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Sticky/Fixed header", 'hind'),
	"id" => "enable_sticky_header",
	"std" => false,
	"desc" => esc_html__("Header will be fixed to top if enabled", 'hind'),
	"type" => "checkbox",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Enable Fullscreen search (Add search button to header)", 'hind'),
	"id" => "enable_fullscreen_search",
	"std" => true,
	"desc" => esc_html__("Fullscreen Search can be opened by search button near header social icons.", 'hind'),
	"type" => "checkbox",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Enable right side offcanvas floating sidebar menu", 'hind'),
	"id" => "enable_offcanvas_sidebar",
	"std" => false,
	"desc" => esc_html__("Sidebar can be opened by toggle button near header social icons. You can add widgets to this sidebar in 'Offcanvas Right sidebar' in Appearance > Widgets.", 'hind'),
	"type" => "checkbox",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("MainMenu position", 'hind'),
	"id" => "header_menu_layout",
	"options" => array(
		'menu_below_header' => array(
			"image" => HIND_IPANEL_URI . 'option-images/menu_in_header_1.png',
			"label" => esc_html__('MainMenu below Header', 'hind')
		),
		'menu_in_header' => array(
			"image" => HIND_IPANEL_URI . 'option-images/menu_in_header_2.png',
			"label" => esc_html__('MainMenu in Header Center', 'hind')
		),
	),
	"std" => "menu_in_header",
	"desc" => "",
	"type" => "image",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("MainMenu color scheme", 'hind'),
	"id" => "header_menu_color_scheme",
	"std" => "menu_light",
	"options" => array(
		"menu_light" => esc_html__("Light menu", 'hind'),
		"menu_dark" => esc_html__("Dark menu", 'hind'),
	),
	"desc" => esc_html__("This option will change menu background if MainMenu located below header", 'hind'),
	"type" => "select",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("MainMenu horizontal align", 'hind'),
	"id" => "header_menu_align",
	"std" => "menu_left",
	"options" => array(
		"menu_left" => esc_html__("Left", 'hind'),
		"menu_center" => esc_html__("Center", 'hind'),
	),
	"desc" => esc_html__("This option will change menu align if MainMenu located below header", 'hind'),
	"type" => "select",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Header Logo position", 'hind'),
	"id" => "header_logo_position",
	"options" => array(
		'left' => array(
			"image" => HIND_IPANEL_URI . 'option-images/header_logo_position_1.png',
			"label" => esc_html__('Left', 'hind')
		),
		'center' => array(
			"image" => HIND_IPANEL_URI . 'option-images/header_logo_position_2.png',
			"label" => esc_html__('Center', 'hind')
		),
	),
	"std" => "left",
	"desc" => "",
	"type" => "image",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Header info text", 'hind'),
	"id" => "header_info_2_editor",
	"std" => '<strong>Hind Photography WordPress theme</strong>',
	"desc" => esc_html__("Available only with 'Menu below header' menu layout type. Does not available with 'Centered logo' option. Displayed in header after search. ", 'hind'),
	"field_options" => array(
		'media_buttons' => false
	),
	"type" => "wp_editor",
);
$ipanel_hind_option[] = array(
		"type" => "EndSection"
);
$ipanel_hind_option[] = array(

	"name" => esc_html__("Social icons", 'hind'),
	"type" => "StartSection",
	"field_options" => array(
		"show" => true // Set true to show items by default.
	)
);
$ipanel_hind_option[] = array(
	"type" => "info",
	"name" => esc_html__("Leave URL fields blank to hide this social icons", 'hind'),
	"field_options" => array(
		"style" => 'alert'
	)
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Facebook Page url", 'hind'),
	"id" => "facebook",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Vkontakte page url", 'hind'),
	"id" => "vk",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Twitter Page url", 'hind'),
	"id" => "twitter",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Google+ Page url", 'hind'),
	"id" => "google-plus",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Behance", 'hind'),
	"id" => "behance",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("LinkedIn Page url", 'hind'),
	"id" => "linkedin",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Dribbble Page url", 'hind'),
	"id" => "dribbble",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Instagram Page url", 'hind'),
	"id" => "instagram",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Tumblr page url", 'hind'),
	"id" => "tumblr",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Pinterest page url", 'hind'),
	"id" => "pinterest",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Vimeo page url", 'hind'),
	"id" => "vimeo-square",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("YouTube page url", 'hind'),
	"id" => "youtube",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Skype url", 'hind'),
	"id" => "skype",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Houzz url", 'hind'),
	"id" => "houzz",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Flickr url", 'hind'),
	"id" => "flickr",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Odnoklassniki url", 'hind'),
	"id" => "odnoklassniki",
	"std" => "",
	"desc" => "",
	"type" => "text",
);
$ipanel_hind_option[] = array(
		"type" => "EndSection"
);
$ipanel_hind_option[] = array(
	"type" => "EndTab"
);
/**
 * FOOTER TAB
 **/
$ipanel_hind_tabs[] = array(
	'name' => esc_html__('Footer', 'hind'),
	'id' => 'footer_settings'
);

$ipanel_hind_option[] = array(
	"type" => "StartTab",
	"id" => "footer_settings"
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Show 'Footer 4 column sidebar #1' only on homepage", 'hind'),
	"id" => "footer_sidebar_1_homepage_only",
	"std" => true,
	"desc" => "",
	"type" => "checkbox",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Footer Left text (Copyright)", 'hind'),
	"id" => "footer_copyright_editor",
	"std" => "<h6>Copyright</h6><p>Powered by <a href='http://themeforest.net/user/dedalx/' target='_blank'>Hind - Premium Wordpress Theme</a></p>",
	"desc" => "",
	"field_options" => array(
		'media_buttons' => true
	),
	"type" => "wp_editor",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Footer Center text (Follow us)", 'hind'),
	"id" => "footer_follow_editor",
	"std" => "<h6>Follow</h6><a href='#'>Facebook</a> / <a href='#'>Twitter</a> / <a href='#'>Dribbble</a>",
	"desc" => "",
	"field_options" => array(
		'media_buttons' => true
	),
	"type" => "wp_editor",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Footer Right text (Contact us)", 'hind'),
	"id" => "footer_contact_editor",
	"std" => "<h6>Contact</h6><a href='#'>Email</a> / +1 917 558 5303",
	"desc" => "",
	"field_options" => array(
		'media_buttons' => true
	),
	"type" => "wp_editor",
);

$ipanel_hind_option[] = array(
	"type" => "EndTab"
);
/**
 * MEGAMENU TAB
 **/
$ipanel_hind_tabs[] = array(
	'name' => esc_html__('MegaMenu', 'hind'),
	'id' => 'megamenu_settings'
);

$ipanel_hind_option[] = array(
	"type" => "StartTab",
	"id" => "megamenu_settings"
);
$ipanel_hind_option[] = array(
	"type" => "info",
	"name" => wp_kses_post(__("You can manage your theme menus <a href='nav-menus.php'>here</a>.", 'hind')),
	"field_options" => array(
		"style" => 'alert'
	)
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Enable Mega Menu", 'hind'),
	"id" => "megamenu_enable",
	"std" => false,
	"desc" => "",
	"type" => "checkbox",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Number of megamenu sidebars", 'hind'),
	"id" => "megamenu_sidebars_count",
	"std" => "1",
	"desc" => esc_html__("You can use megamenu sidebars to show widgets in your megamenus. Increase this option value to add more new sidebars.", 'hind'),
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"type" => "EndTab"
);
/**
 * SIDEBARS TAB
 **/
$ipanel_hind_tabs[] = array(
	'name' => esc_html__('Sidebars', 'hind'),
	'id' => 'sidebar_settings'
);

$ipanel_hind_option[] = array(
	"type" => "StartTab",
	"id" => "sidebar_settings"
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Pages sidebar position", 'hind'),
	"id" => "page_sidebar_position",
	"options" => array(
		'left' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_1.png',
			"label" => esc_html__('Left', 'hind')
		),
		'right' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_2.png',
			"label" => esc_html__('Right', 'hind')
		),
		'disable' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_3.png',
			"label" => esc_html__('Disable sidebar', 'hind')
		),
	),
	"std" => "disable",
	"desc" => "",
	"type" => "image",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Blog page sidebar position", 'hind'),
	"id" => "blog_sidebar_position",
	"options" => array(
		'left' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_1.png',
			"label" => esc_html__('Left', 'hind')
		),
		'right' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_2.png',
			"label" => esc_html__('Right', 'hind')
		),
		'disable' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_3.png',
			"label" => esc_html__('Disable sidebar', 'hind')
		),
	),
	"std" => "disable",
	"desc" => "",
	"type" => "image",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Blog Archive page sidebar position", 'hind'),
	"id" => "archive_sidebar_position",
	"options" => array(
		'left' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_1.png',
			"label" => esc_html__('Left', 'hind')
		),
		'right' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_2.png',
			"label" => esc_html__('Right', 'hind')
		),
		'disable' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_3.png',
			"label" => esc_html__('Disable sidebar', 'hind')
		),
	),
	"std" => "right",
	"desc" => "",
	"type" => "image",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Blog Search page sidebar position", 'hind'),
	"id" => "search_sidebar_position",
	"options" => array(
		'left' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_1.png',
			"label" => esc_html__('Left', 'hind')
		),
		'right' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_2.png',
			"label" => esc_html__('Right', 'hind')
		),
		'disable' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_3.png',
			"label" => esc_html__('Disable sidebar', 'hind')
		),
	),
	"std" => "right",
	"desc" => "",
	"type" => "image",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Blog post sidebar position", 'hind'),
	"id" => "post_sidebar_position",
	"options" => array(
		'left' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_1.png',
			"label" => esc_html__('Left', 'hind')
		),
		'right' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_2.png',
			"label" => esc_html__('Right', 'hind')
		),
		'disable' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_3.png',
			"label" => esc_html__('Disable sidebar', 'hind')
		),
	),
	"std" => "disable",
	"desc" => "",
	"type" => "image",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Portfolio item page sidebar position", 'hind'),
	"id" => "portfolio_sidebar_position",
	"options" => array(
		'left' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_1.png',
			"label" => esc_html__('Left', 'hind')
		),
		'right' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_2.png',
			"label" => esc_html__('Right', 'hind')
		),
		'disable' => array(
			"image" => HIND_IPANEL_URI . 'option-images/sidebar_position_3.png',
			"label" => esc_html__('Disable sidebar', 'hind')
		),
	),
	"std" => "disable",
	"desc" => "",
	"type" => "image",
);

$ipanel_hind_option[] = array(
	"type" => "EndTab"
);
/**
 * BLOG TAB
 **/
$ipanel_hind_tabs[] = array(
	'name' => esc_html__('Blog', 'hind'),
	'id' => 'blog_settings'
);
$ipanel_hind_option[] = array(
	"type" => "StartTab",
	"id" => "blog_settings"
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Post excerpt length (words)", 'hind'),
	"id" => "post_excerpt_legth",
	"std" => "18",
	"desc" => esc_html__("Used by WordPress for post shortening. Default: 18", 'hind'),
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Show author info and avatar after single blog post", 'hind'),
	"id" => "blog_enable_author_info",
	"std" => true,
	"desc" => "",
	"type" => "checkbox",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Show prev/next posts navigation links on single post page", 'hind'),
	"id" => "blog_post_navigation",
	"std" => true,
	"desc" => "",
	"type" => "checkbox",
);
$ipanel_hind_option[] = array(
	"type" => "EndTab"
);

/**
 * PORTFOLIO TAB
 **/
$ipanel_hind_tabs[] = array(
	'name' => esc_html__('Portfolio', 'hind'),
	'id' => 'portfolio_settings'
);
$ipanel_hind_option[] = array(
	"type" => "StartTab",
	"id" => "portfolio_settings"
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Display portfolio item images slider prev/next navigation buttons", 'hind'),
	"id" => "portfolio_show_slider_navigation",
	"std" => true,
	"desc" => "",
	"type" => "checkbox",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Display portfolio item images slider pagination buttons", 'hind'),
	"id" => "portfolio_show_slider_pagination",
	"std" => false,
	"desc" => "",
	"type" => "checkbox",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Portfolio item images slider autoplay", 'hind'),
	"id" => "portfolio_slider_autoplay",
	"std" => true,
	"desc" => "",
	"type" => "checkbox",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Show related works on portfolio items page", 'hind'),
	"id" => "portfolio_related_works",
	"std" => true,
	"desc" => esc_html__("This will show works from the same categories", 'hind'),
	"type" => "checkbox",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Portfolio related items per row", 'hind'),
	"id" => "portfolio_related_items_columns",
	"std" => "3",
	"options" => array(
		"3" => "3",
		"4" => "4",
		"5" => "5"
	),
	"desc" => "",
	"type" => "select",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Portfolio item page related works limit", 'hind'),
	"id" => "portfolio_related_limit",
	"std" => "8",
	"desc" => esc_html__("Recommended values: 4, 8, 12, 16, etc", 'hind'),
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Portfolio related items hover effect", 'hind'),
	"id" => "portfolio_posts_item_hover_effect",
	"std" => "fade",
	"options" => array(
		"0" => esc_html__("Text from left, Zoom+Rotate, Theme Color Overlay", 'hind'),
		"1" => esc_html__("Text from left, Zoom+Rotate, Transparent Overlay", 'hind'),
		"2" => esc_html__("Text from left, Zoom, Transparent Overlay", 'hind'),
		"3" => esc_html__("Text from bottom, Zoom, Transparent Overlay", 'hind'),
		"4" => esc_html__("Text from bottom, Transparent Overlay", 'hind'),
		"5" => esc_html__("Text fly-in, Transparent Overlay", 'hind'),
		"6" => esc_html__("Text style, Large text (No images)", 'hind'),
		"7" => esc_html__("Text style, Large text (Image on hover)", 'hind'),
	),
	"desc" => "",
	"type" => "select",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Portfolio related items grid sort animation effect 1", 'hind'),
	"id" => "portfolio_posts_animation_1",
	"std" => "fade",
	"options" => array(
		"fade" => esc_html__("Fade", 'hind'),
		"scale" => esc_html__("Scale", 'hind'),
		"translateX" => esc_html__("TranslateX", 'hind'),
		"translateY" => esc_html__("TranslateY", 'hind'),
		"translateZ" => esc_html__("TranslateZ", 'hind'),
		"rotateX" => esc_html__("RotateX", 'hind'),
		"rotateY" => esc_html__("RotateY", 'hind'),
		"rotateZ" => esc_html__("RotateZ", 'hind'),
		"stagger" => esc_html__("Stagger", 'hind')
	),
	"desc" => "",
	"type" => "select",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Portfolio related items grid sort animation effect 2", 'hind'),
	"id" => "portfolio_posts_animation_2",
	"std" => "scale",
	"options" => array(
		"fade" => esc_html__("Fade", 'hind'),
		"scale" => esc_html__("Scale", 'hind'),
		"translateX" => esc_html__("TranslateX", 'hind'),
		"translateY" => esc_html__("TranslateY", 'hind'),
		"translateZ" => esc_html__("TranslateZ", 'hind'),
		"rotateX" => esc_html__("RotateX", 'hind'),
		"rotateY" => esc_html__("RotateY", 'hind'),
		"rotateZ" => esc_html__("RotateZ", 'hind'),
		"stagger" => esc_html__("Stagger", 'hind')
	),
	"desc" => "",
	"type" => "select",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Show prev/next portfolio items navigation on single portfolio item page", 'hind'),
	"id" => "portfolio_show_item_navigation",
	"std" => true,
	"desc" => "",
	"type" => "checkbox",
);

$ipanel_hind_option[] = array(
	"type" => "EndTab"
);

/**
 * FONTS TAB
 **/

$ipanel_hind_tabs[] = array(
	'name' => esc_html__('Fonts', 'hind'),
	'id' => 'font_settings'
);

$ipanel_hind_option[] = array(
	"type" => "StartTab",
	"id" => "font_settings"
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Headers font", 'hind'),
	"id" => "header_font",
	"desc" => esc_html__("Font used in headers. Default: Lato", 'hind'),
	"options" => array(
		"font-sizes" => array(
			" " => esc_html__("Font Size", 'hind'),
			'11' => '11px',
			'12' => '12px',
			'13' => '13px',
			'14' => '14px',
			'15' => '15px',
			'16' => '16px',
			'17' => '17px',
			'18' => '18px',
			'19' => '19px',
			'20' => '20px',
			'21' => '21px',
			'22' => '22px',
			'23' => '23px',
			'24' => '24px',
			'25' => '25px',
			'26' => '26px',
			'27' => '27px',
			'28' => '28px',
			'29' => '29px',
			'30' => '30px',
			'31' => '31px',
			'32' => '32px',
			'33' => '33px',
			'34' => '34px',
			'35' => '35px',
			'36' => '36px',
			'37' => '37px',
			'38' => '38px',
			'39' => '39px',
			'40' => '40px',
			'41' => '41px',
			'42' => '42px',
			'43' => '43px',
			'44' => '44px',
			'45' => '45px',
			'46' => '46px',
			'47' => '47px',
			'48' => '48px',
			'49' => '49px',
			'50' => '50px'
		),
		"color" => false,
		"font-families" => iPanel::getGoogleFonts(),
		"font-styles" => false
	),
	"std" => array(
		"font-size" => '35',
		"font-family" => 'Lato'
	),
	"type" => "typography"
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Headers font parameters for Google Font", 'hind'),
	"id" => "header_font_options",
	"std" => "300,300italic,400,400italic,700,700italic",
	"desc" => esc_html__("You can specify additional Google Fonts paramaters here, for example fonts styles to load. Default: 300,300italic,400,400italic,700,700italic", 'hind'),
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Body font", 'hind'),
	"id" => "body_font",
	"desc" => esc_html__("Font used in text elements. Default: Lato", 'hind'),
	"options" => array(
		"font-sizes" => array(
			" " => esc_html__("Font Size", 'hind'),
			'11' => '11px',
			'12' => '12px',
			'13' => '13px',
			'14' => '14px',
			'15' => '15px',
			'16' => '16px',
			'17' => '17px',
			'18' => '18px',
			'19' => '19px',
			'20' => '20px',
			'21' => '21px',
			'22' => '22px',
			'23' => '23px',
			'24' => '24px',
			'25' => '25px',
			'26' => '26px',
			'27' => '27px'
		),
		"color" => false,
		"font-families" => iPanel::getGoogleFonts(),
		"font-styles" => false
	),
	"std" => array(
		"font-size" => '16',
		"font-family" => 'Lato'
	),
	"type" => "typography"
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Body font parameters for Google Font", 'hind'),
	"id" => "body_font_options",
	"std" => "300,300italic,400,400italic,700,700italic",
	"desc" => esc_html__("You can specify additional Google Fonts paramaters here, for example fonts styles to load. Default: 300,300italic,400,400italic,700,700italic", 'hind'),
	"type" => "text",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Additional font", 'hind'),
	"id" => "additional_font",
	"desc" => esc_html__("Font used some special decorated theme elements. Default: Herr Von Muellerhoff", 'hind'),
	"options" => array(
		"font-sizes" => array(
			" " => esc_html__("Font Size", 'hind'),
			'11' => '11px',
			'12' => '12px',
			'13' => '13px',
			'14' => '14px',
			'15' => '15px',
			'16' => '16px',
			'17' => '17px',
			'18' => '18px',
			'19' => '19px',
			'20' => '20px',
			'21' => '21px',
			'22' => '22px',
			'23' => '23px',
			'24' => '24px',
			'25' => '25px',
			'26' => '26px',
			'27' => '27px',
			'28' => '28px',
			'29' => '29px',
			'30' => '30px',
			'31' => '31px',
			'32' => '32px',
			'33' => '33px',
			'34' => '34px',
			'35' => '35px',
			'36' => '36px',
			'37' => '37px',
			'38' => '38px',
			'39' => '39px',
			'40' => '40px',
			'41' => '41px',
			'42' => '42px',
			'43' => '43px',
			'44' => '44px',
			'45' => '45px',
			'46' => '46px',
			'47' => '47px',
			'48' => '48px',
			'49' => '49px',
			'50' => '50px'
		),
		"color" => false,
		"font-families" => iPanel::getGoogleFonts(),
		"font-styles" => false
	),
	"std" => array(
		"font-size" => '48',
		"font-family" => 'Herr Von Muellerhoff'
	),
	"type" => "typography"
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Enable Additional font", 'hind'),
	"id" => "additional_font_enable",
	"std" => false,
	"desc" => esc_html__("Uncheck if you don't want to use Additional font. This will speed up your site.", 'hind'),
	"type" => "checkbox",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Disable ALL Google Fonts on site", 'hind'),
	"id" => "font_google_disable",
	"std" => false,
	"desc" => esc_html__("Use this if you want extra site speed or want to have regular fonts. Arial font will be used with this option.", 'hind'),
	"type" => "checkbox",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Regular font (apply if you disabled Google Fonts below)", 'hind'),
	"id" => "font_regular",
	"std" => "Arial",
	"options" => array(
		"Arial" => "Arial",
		"Tahoma" => "Tahoma",
		"Times New Roman" => "Times New Roman",
		"Verdana" => "Verdana",
		"Helvetica" => "Helvetica",
		"Georgia" => "Georgia",
		"Courier New" => "Courier New"
	),
	"desc" => esc_html__("Use this option if you disabled ALL Google Fonts.", 'hind'),
	"type" => "select",
);
$ipanel_hind_option[] = array(
	"type" => "EndTab"
);

/**
 * COLORS TAB
 **/

$ipanel_hind_tabs[] = array(
	'name' => esc_html__('Colors & Skins', 'hind'),
	'id' => 'color_settings'
);

$ipanel_hind_option[] = array(
	"type" => "StartTab",
	"id" => "color_settings",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Predefined color skins", 'hind'),
	"id" => "color_skin_name",
	"std" => "none",
	"options" => array(
		"none" => esc_html__("Use colors specified below", 'hind'),
		"default" => esc_html__("Hind (Default)", 'hind'),
		"defaultlight" => esc_html__("Hind + Light Submenus", 'hind'),
		"green" => esc_html__("Green Grass", 'hind'),
		"blue" => esc_html__("Cloudy blue", 'hind'),
		"red" => esc_html__("Sakura", 'hind'),
		"blackandwhite" => esc_html__("Greyscale", 'hind'),
		"orange" => esc_html__("Orange Juice", 'hind'),
		"fencer" => esc_html__("Fencer", 'hind'),
		"perfectum" => esc_html__("Perfectum", 'hind'),
		"simplegreat" => esc_html__("SimpleGreat", 'hind')
	),
	"desc" => esc_html__("Select one of predefined skins", 'hind'),
	"type" => "select",
);
$ipanel_hind_option[] = array(
	"name" => esc_html__("Body background color", 'hind'),
	"id" => "theme_body_color",
	"std" => "#ffffff",
	"desc" => esc_html__("Used in many theme places, default: #ffffff", 'hind'),
	"field_options" => array(
		//'desc_in_tooltip' => true
	),
	"type" => "color",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Body text color", 'hind'),
	"id" => "theme_text_color",
	"std" => "#4c4d4f",
	"desc" => esc_html__("Used in many theme places, default: #4c4d4f", 'hind'),
	"field_options" => array(
		//'desc_in_tooltip' => true
	),
	"type" => "color",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Theme Main color", 'hind'),
	"id" => "theme_main_color",
	"std" => "#1151D3",
	"desc" => esc_html__("Used in many theme places, links, buttons, tabs color, default: #1151D3", 'hind'),
	"field_options" => array(
		//'desc_in_tooltip' => true
	),
	"type" => "color",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Header background color", 'hind'),
	"id" => "theme_header_bg_color",
	"std" => "#ffffff",
	"desc" => esc_html__("Default: #ffffff", 'hind'),
	"field_options" => array(
		//'desc_in_tooltip' => true
	),
	"type" => "color",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Main menu background color", 'hind'),
	"id" => "theme_main_menu_bg_color",
	"std" => "#EEEEEE",
	"desc" => esc_html__("This background will be used for menu below header position. Default: #EEEEEE", 'hind'),
	"field_options" => array(
		//'desc_in_tooltip' => true
	),
	"type" => "color",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Dark Main menu background color", 'hind'),
	"id" => "theme_main_menu_dark_bg_color",
	"std" => "#262626",
	"desc" => esc_html__("This background will be used for Dark menu below header position. Default: #262626", 'hind'),
	"field_options" => array(
		//'desc_in_tooltip' => true
	),
	"type" => "color",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Main menu submenu background color", 'hind'),
	"id" => "theme_main_menu_submenu_bg_color",
	"std" => "#262626",
	"desc" => esc_html__("Default: #262626", 'hind'),
	"field_options" => array(
		//'desc_in_tooltip' => true
	),
	"type" => "color",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Main menu submenu link color", 'hind'),
	"id" => "theme_main_menu_submenu_link_color",
	"std" => "#FFFFFF",
	"desc" => esc_html__("Default: #FFFFFF", 'hind'),
	"field_options" => array(
		//'desc_in_tooltip' => true
	),
	"type" => "color",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Footer sidebar background color", 'hind'),
	"id" => "theme_footer_sidebar_bg_color",
	"std" => "#262626",
	"desc" => esc_html__("Default: #262626", 'hind'),
	"field_options" => array(
		//'desc_in_tooltip' => true
	),
	"type" => "color",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Footer background color", 'hind'),
	"id" => "theme_footer_bg_color",
	"std" => "#F4F4F4",
	"desc" => esc_html__("Default: #EEEEEE", 'hind'),
	"field_options" => array(
		//'desc_in_tooltip' => true
	),
	"type" => "color",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Pages title color", 'hind'),
	"id" => "theme_title_color",
	"std" => "#000000",
	"desc" => esc_html__("Default: #000000", 'hind'),
	"field_options" => array(
		//'desc_in_tooltip' => true
	),
	"type" => "color",
);

$ipanel_hind_option[] = array(
	"type" => "EndTab"
);

/**
 * CUSTOM CODE TAB
 **/

$ipanel_hind_tabs[] = array(
	'name' => esc_html__('Custom code', 'hind'),
	'id' => 'custom_code'
);

$ipanel_hind_option[] = array(
	"type" => "StartTab",
	"id" => "custom_code",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Custom JavaScript code", 'hind'),
	"id" => "custom_js_code",
	"std" => '',
	"field_options" => array(
		"language" => "javascript",
		"line_numbers" => true,
		"autoCloseBrackets" => true,
		"autoCloseTags" => true
	),
	"desc" => esc_html__("This code will run in header", 'hind'),
	"type" => "textarea",
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Custom CSS styles", 'hind'),
	"id" => "custom_css_code",
	"std" => '',
	"field_options" => array(
		"language" => "json",
		"line_numbers" => true,
		"autoCloseBrackets" => true,
		"autoCloseTags" => true
	),
	"desc" => esc_html__("This CSS code will be included in header", 'hind'),
	"type" => "textarea",
);

$ipanel_hind_option[] = array(
	"type" => "EndTab"
);

/**
 * DOCUMENTATION TAB
 **/

$ipanel_hind_tabs[] = array(
	'name' => esc_html__('Documentation', 'hind'),
	'id' => 'documentation'
);

$ipanel_hind_option[] = array(
	"type" => "StartTab",
	"id" => "documentation"
);

function get_plugin_version_number($plugin_name) {
        // If get_plugins() isn't available, require it
	if ( ! function_exists( 'get_plugins' ) )
		require_once( ABSPATH . 'wp-admin/includes/plugin.php' );

        // Create the plugins folder and file variables
	$plugin_folder = get_plugins( '/' . $plugin_name );
	$plugin_file = $plugin_name.'.php';

	// If the plugin version number is set, return it
	if ( isset( $plugin_folder[$plugin_file]['Version'] ) ) {
		return $plugin_folder[$plugin_file]['Version'];

	} else {
	// Otherwise return null
		return 'Plugin not installed';
	}
}

$ipanel_hind_option[] = array(
	"type" => "htmlpage",
	"name" => '<div class="documentation-icon"><img src="'.esc_url(HIND_IPANEL_URI). 'assets/img/documentation-icon.png" alt="Documentation"/></div><p>We recommend you to read <a href="http://magniumthemes.com/go/hind-docs/" target="_blank">Theme Documentation</a> before you will start using our theme to building your website. It covers all steps for site configuration, demo content import, theme features usage and more.</p>
<p>If you have face any problems with our theme feel free to use our <a href="http://support.magniumthemes.com/" target="_blank">Support System</a> to contact us and get help for free.</p>
<a class="button button-primary" href="http://magniumthemes.com/go/hind-docs/" target="_blank">Theme Documentation</a>
<a class="button button-primary" href="http://support.magniumthemes.com/" target="_blank">Support System</a><h3>Technical information (paste it to your support ticket):</h3><textarea style="width: 500px; height: 160px;font-size: 12px;">Theme Version: '.wp_get_theme()->get( 'Version' ).'
Theme Addons version: '.get_plugin_version_number('hind-theme-addons').'
WordPress Version: '.get_bloginfo( 'version' ).'
WooCommerce Version: '.get_plugin_version_number('woocommerce').'
WPBakery Page Builder: '.get_plugin_version_number('js_composer').'</textarea>'
);

$ipanel_hind_option[] = array(
	"type" => "EndTab"
);

/**
 * EXPORT TAB
 **/

$ipanel_hind_tabs[] = array(
	'name' => esc_html__('Export', 'hind'),
	'id' => 'export_settings'
);

$ipanel_hind_option[] = array(
	"type" => "StartTab",
	"id" => "export_settings"
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Export with Download Possibility", 'hind'),
	"type" => "export",
	"desc" => esc_html__("Export theme admin panel settings to file.", 'hind')
);

$ipanel_hind_option[] = array(
	"type" => "EndTab"
);

/**
 * IMPORT TAB
 **/

$ipanel_hind_tabs[] = array(
	'name' => esc_html__('Import', 'hind'),
	'id' => 'import_settings'
);

$ipanel_hind_option[] = array(
	"type" => "StartTab",
	"id" => "import_settings"
);

$ipanel_hind_option[] = array(
	"name" => esc_html__("Import", 'hind'),
	"type" => "import",
	"desc" => esc_html__("Select theme options import file or paste options string to import your settings from Export.", 'hind')
);

$ipanel_hind_option[] = array(
	"type" => "EndTab"
);

/**
 * CONFIGURATION
 **/

$ipanel_configs = array(
	'ID'=> 'HIND_PANEL',
	'menu'=>
		array(
			'submenu' => false,
			'page_title' => esc_html__('Hind Control Panel', 'hind'),
			'menu_title' => esc_html__('Hind Theme Control Panel ', 'hind'),
			'capability' => 'manage_options',
			'menu_slug' => 'manage_theme_options',
			'icon_url' => HIND_IPANEL_URI . 'assets/img/panel-icon.png',
			'position' => 59
		),
	'rtl' => ( function_exists('is_rtl') && is_rtl() ),
	'tabs' => $ipanel_hind_tabs,
	'fields' => $ipanel_hind_option,
	'download_capability' => 'manage_options',
	'live_preview' => false
);

$ipanel_theme_usage = new IPANEL( $ipanel_configs );

