<?php
/**
 * Plugin recomendations
 **/
$hind_theme_options = hind_get_theme_options();

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

require_once ('class-tgm-plugin-activation.php');

add_action( 'tgmpa_register', 'hind_register_required_plugins' );

function hind_register_required_plugins() {

    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(

        array(
            'name'                  => esc_html__('Hind Visual Page Builder', 'hind'), // The plugin name
            'slug'                  => 'js_composer', // The plugin slug (typically the folder name)
            'source'                => get_stylesheet_directory() . '/inc/plugins/js_composer.zip', // The plugin source
            'required'              => true, // If false, the plugin is only 'recommended' instead of required
            'version'               => '6.9.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        ),
        array(
            'name'                  => esc_html__('Hind Theme Addons', 'hind'), // The plugin name
            'slug'                  => 'hind-theme-addons', // The plugin slug (typically the folder name)
            'source'                => get_stylesheet_directory() . '/inc/plugins/hind-theme-addons.zip', // The plugin source
            'required'              => true, // If false, the plugin is only 'recommended' instead of required
            'version'               => '2.3.2', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented

        ),
        array(
            'name'                  => esc_html__('Hind Custom Metaboxes', 'hind'), // The plugin name
            'slug'                  => 'cmb2', // The plugin slug (typically the folder name)
            'required'              => true, // If false, the plugin is only 'recommended' instead of required
        ),
        array(
            'name'                  => esc_html__('Revolution Slider', 'hind'), // The plugin name
            'slug'                  => 'revslider', // The plugin slug (typically the folder name)
            'source'                => get_stylesheet_directory() . '/inc/plugins/revslider.zip', // The plugin source
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
            'version'               => '6.5.24', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        ),
        array(
            'name'                  => esc_html__('WordPress LightBox', 'hind'), // The plugin name
            'slug'                  => 'responsive-lightbox', // The plugin slug (typically the folder name)
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
        ),
        array(
            'name'                  => esc_html__('Contact Form 7', 'hind'), // The plugin name
            'slug'                  => 'contact-form-7', // The plugin slug (typically the folder name)
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
        ),
        array(
            'name'                  => esc_html__('Regenerate Thumbnails', 'hind'), // The plugin name
            'slug'                  => 'regenerate-thumbnails', // The plugin slug (typically the folder name)
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
        ),
        array(
            'name'                  => esc_html__('Simple WP Retina', 'hind'), // The plugin name
            'slug'                  => 'simple-wp-retina', // The plugin slug (typically the folder name)
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
        ),
        array(
            'name'                  => esc_html__('Hind Translation Manager', 'hind'), // The plugin name
            'slug'                  => 'loco-translate', // The plugin slug (typically the folder name)
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
        )

    );

    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
        'domain'            => 'hind',           // Text domain - likely want to be the same as your theme.
        'default_path'      => '',                          // Default absolute path to pre-packaged plugins
        'menu'              => 'install-required-plugins',  // Menu slug
        'has_notices'       => true,                        // Show admin notices or not
        'dismissable'  => true,
        'is_automatic'      => false,                       // Automatically activate plugins after installation or not
        'message'           => '',                          // Message to output right before the plugins table
    );

    tgmpa( $plugins, $config );

}

/* Sidebars */

function hind_sidebars_init() {
    $hind_theme_options = hind_get_theme_options();

    register_sidebar(
      array(
        'name' => esc_html__( 'Left/Right sidebar', 'hind' ),
        'id' => 'main-sidebar',
        'description' => esc_html__( 'Widgets in this area will be shown in the left or right site column.', 'hind' )
      )
    );

    register_sidebar(
      array(
        'name' => esc_html__( 'Offcanvas Right sidebar', 'hind' ),
        'id' => 'offcanvas-sidebar',
        'description' => esc_html__( 'Widgets in this area will be shown in the right floating offcanvas menu sidebar that can be opened by toggle button in header. You can enable this sidebar in theme control panel.', 'hind' )
      )
    );

    register_sidebar(
      array(
        'name' => esc_html__( 'Footer 4 column sidebar #1', 'hind' ),
        'id' => 'footer-sidebar',
        'description' => esc_html__( 'Widgets in this area will be shown in site footer in 4 column.', 'hind' )
      )
    );

    register_sidebar(
      array(
        'name' => esc_html__( 'Footer 4 column sidebar #2', 'hind' ),
        'id' => 'footer-sidebar-2',
        'description' => esc_html__( 'Widgets in this area will be shown in site footer in 4 column after Footer sidebar #1.', 'hind' )
      )
    );

    if(isset($hind_theme_options['megamenu_sidebars_count']) && ($hind_theme_options['megamenu_sidebars_count'] > 0)) {
        for ($i = 1; $i <= $hind_theme_options['megamenu_sidebars_count']; $i++) {
            register_sidebar(
              array(
                'name' => esc_html__( 'MegaMenu sidebar #', 'hind' ).$i,
                'id' => 'megamenu_sidebar_'.$i,
                'description' => esc_html__( 'You can use this sidebar to display widgets inside megamenu items in menus.', 'hind' )
              )
            );
        }
    }
}

add_action( 'widgets_init', 'hind_sidebars_init' );

// Customisation Menu Links
class hind_description_walker extends Walker_Nav_Menu{
      function start_el(&$output, $item, $depth = 0, $args = Array(), $current_object_id = 0 ){
           global $wp_query;
           $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
           $class_names = $value = '';
           $classes = empty( $item->classes ) ? array() : (array) $item->classes;
           $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );

           $add_class = '';

           $post = get_post($item->object_id);

               $class_names = ' class="'.$add_class.' '. esc_attr( $class_names ) . '"';
               $output .= $indent . '<li id="menu-item-'. $item->ID . '"' . $value . $class_names .'>';
               $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
               $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
               $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';

                    $attributes .= ! empty( $item->url )        ? ' href="'   . esc_url( $item->url        ) .'"' : '';

                if (is_object($args)) {
                    $item_output = $args->before;
                    $item_output .= '<a'. $attributes .'>';
                    $item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID );
                    $item_output .= $args->link_after;
                    $item_output .= '</a>';
                    $item_output .= $args->after;
                    $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );

                }
     }
}

function hind_google_fonts_url() {

    $hind_theme_options = hind_get_theme_options();

    $font_url = '';
    $font_header = '';
    $font_body = '';
    $font_additional = '';

    // Demo settings
    if ( defined('DEMO_MODE') && isset($_GET['header_font']) ) {
      $hind_theme_options['header_font']['font-family'] = $_GET['header_font'];
    }
    if ( defined('DEMO_MODE') && isset($_GET['body_font']) ) {
      $hind_theme_options['body_font']['font-family'] = $_GET['body_font'];
    }
    if ( defined('DEMO_MODE') && isset($_GET['additional_font']) ) {
      $hind_theme_options['additional_font']['font-family'] = $_GET['additional_font'];
    }

    if(!isset($hind_theme_options['font_google_disable']) || $hind_theme_options['font_google_disable'] == false) {

        // Header font
        if(isset($hind_theme_options['header_font'])) {
            $font_header = $hind_theme_options['header_font']['font-family'];

            if(isset($hind_theme_options['header_font_options'])) {
                $font_header = $font_header.':'.$hind_theme_options['header_font_options'];
            }
        }
        // Body font
        if(isset($hind_theme_options['body_font'])) {
            $font_body = '|'.$hind_theme_options['body_font']['font-family'];

            if(isset($hind_theme_options['body_font_options'])) {
                $font_body = $font_body.':'.$hind_theme_options['body_font_options'];
            }
        }
        // Additional font
        if(isset($hind_theme_options['additional_font_enable']) && $hind_theme_options['additional_font_enable']) {
            if(isset($hind_theme_options['additional_font'])) {
                $font_additional = '|'.$hind_theme_options['additional_font']['font-family'].'|';
            }
        }

        // Build Google Fonts request
        $font_url = add_query_arg( 'family', urlencode( $font_header.$font_body.$font_additional ), "//fonts.googleapis.com/css" );

    }

    return $font_url;
}

// Custom layout functions
function hind_header_left_show() {
    ?>
    <a class="logo-link" href="<?php echo esc_url(site_url()); ?>"><img src="<?php echo esc_url(get_header_image()); ?>" alt="<?php bloginfo('name'); ?>" class="regular-logo"><img src="<?php if ( get_theme_mod( 'hind_header_transparent_logo' ) ) { echo esc_url( get_theme_mod( 'hind_header_transparent_logo' )); } else { echo esc_url(get_header_image()); }  ?>" alt="<?php bloginfo('name'); ?>" class="light-logo"></a>
    <?php
}

function hind_menu_below_header_show() {
    $hind_theme_options = hind_get_theme_options();

    // Demo settings
    if ( defined('DEMO_MODE') && isset($_GET['header_menu_layout']) ) {
      $hind_theme_options['header_menu_layout'] = esc_html($_GET['header_menu_layout']);
    }
    if ( defined('DEMO_MODE') && isset($_GET['header_menu_color_scheme']) ) {
      $hind_theme_options['header_menu_color_scheme'] = esc_html($_GET['header_menu_color_scheme']);
    }
    if ( defined('DEMO_MODE') && isset($_GET['header_menu_align']) ) {
      $hind_theme_options['header_menu_align'] = esc_html($_GET['header_menu_align']);
    }

    // MainMenu Below header position
    if((isset($hind_theme_options['header_menu_layout'])) && ($hind_theme_options['header_menu_layout'] == 'menu_below_header')):
    ?>
    <?php
    if((isset($hind_theme_options['header_menu_color_scheme'])) && ($hind_theme_options['header_menu_color_scheme'] == 'menu_dark')) {
        $menu_add_class = ' mainmenu-dark';
    } else {
        $menu_add_class = '';
    }

    if((isset($hind_theme_options['header_menu_align'])) && ($hind_theme_options['header_menu_align'] == 'menu_center')) {
        $menu_add_class .= ' menu-center';
    }
    ?>
    <div class="mainmenu-belowheader<?php echo esc_attr($menu_add_class); ?>">
    <?php
    // Main Menu

    $menu = wp_nav_menu(
        array (
            'theme_location'  => 'primary',
            'echo' => FALSE,
            'fallback_cb' => '__return_false'
        )
    );

    if (!empty($menu)):
    ?>
      <?php if(isset($hind_theme_options['megamenu_enable']) && $hind_theme_options['megamenu_enable']) {
        $add_class = " mgt-mega-menu";
      }
      ?>
        <div id="navbar" class="navbar navbar-default clearfix<?php echo esc_attr($add_class);?>">
          <div class="navbar-inner">
              <div class="container">

              <div class="navbar-toggle" data-toggle="collapse" data-target=".collapse">
                <?php _e( 'Menu', 'hind' ); ?>
              </div>

              <?php
              if(isset($hind_theme_options['megamenu_enable']) && $hind_theme_options['megamenu_enable']) {
                wp_nav_menu(array(
                  'theme_location'  => 'primary',
                  'container_class' => 'navbar-collapse collapse',
                  'menu_class'      => 'nav',
                  'walker'          => new rc_scm_walker
                  ));
              } else {
                 wp_nav_menu(array(
                  'theme_location'  => 'primary',
                  'container_class' => 'navbar-collapse collapse',
                  'menu_class'      => 'nav',
                  'walker'          => new hind_description_walker
                  ));
              }

              ?>
              </div>
          </div>
        </div>
      <?php endif; ?>

    </div>
    <?php
    endif;
    // MainMenu Below header position END
}

function hind_header_center_show() {
  $hind_theme_options = hind_get_theme_options();

    // Demo settings
    if ( defined('DEMO_MODE') && isset($_GET['header_menu_layout']) ) {
      $hind_theme_options['header_menu_layout'] = $_GET['header_menu_layout'];
    }

  if((isset($hind_theme_options['header_info_2_editor'])) && (isset($hind_theme_options['header_menu_layout'])) && ($hind_theme_options['header_info_2_editor'] <> '') && ($hind_theme_options['header_menu_layout'] == 'menu_below_header')){
    echo '<div class="header-info-2-text">'.wp_kses_post($hind_theme_options['header_info_2_editor']).'</div>';
  }

  // MainMenu in Header position
  if((isset($hind_theme_options['header_menu_layout'])) && ($hind_theme_options['header_menu_layout'] == 'menu_in_header')):
  ?>
    <?php
    // Main Menu

    $menu = wp_nav_menu(
        array (
            'theme_location'  => 'primary',
            'echo' => FALSE,
            'fallback_cb' => '__return_false'
        )
    );

    if (!empty($menu)):
    ?>
    <?php
    // Demo settings
    if(isset($_GET['hide_top_menu'])) {
        $hide_top_menu = true;
    } else {
        $hide_top_menu = false;
    }


    if(isset($hind_theme_options['megamenu_enable']) && $hind_theme_options['megamenu_enable']) {
        $add_class = " mgt-mega-menu";
    } else {
        $add_class = "";
    }
    ?>
        <div id="navbar" class="navbar navbar-default clearfix<?php echo esc_attr($add_class); ?>">
          <div class="navbar-inner">

              <div class="navbar-toggle" data-toggle="collapse" data-target=".collapse">
                <?php _e( 'Menu', 'hind' ); ?>
              </div>

              <?php
                if(isset($hind_theme_options['megamenu_enable']) && $hind_theme_options['megamenu_enable']) {
                    wp_nav_menu(array(
                      'theme_location'  => 'primary',
                      'container_class' => 'navbar-collapse collapse',
                      'menu_class'      => 'nav',
                      'walker'          => new rc_scm_walker
                      ));
                } else {
                     wp_nav_menu(array(
                      'theme_location'  => 'primary',
                      'container_class' => 'navbar-collapse collapse',
                      'menu_class'      => 'nav',
                      'walker'          => new hind_description_walker
                      ));
                }
              ?>

          </div>
        </div>

    <?php endif; ?>
  <?php
  endif;
  // MainMenu in Header position END

}

function hind_header_right_show() {
    $hind_theme_options = hind_get_theme_options();

    // Demo settings
    if ( defined('DEMO_MODE') && isset($_GET['enable_offcanvas_sidebar']) ) {
      $hind_theme_options['enable_offcanvas_sidebar'] = $_GET['enable_offcanvas_sidebar'];
    }

    ?>
    <ul class="header-nav">
        <?php

            $social_services_arr = Array("facebook", "vk","twitter", "google-plus", "behance", "linkedin", "dribbble", "instagram", "tumblr", "pinterest", "vimeo-square", "youtube", "skype", "houzz", "flickr", "odnoklassniki");

            $s_count = 0;

            foreach( $social_services_arr as $ss_data ){
              if(isset($hind_theme_options[$ss_data]) && (trim($hind_theme_options[$ss_data])) <> '') {
                $s_count++;
                $social_service_url = $hind_theme_options[$ss_data];
                $social_service = $ss_data;
                echo '<li><a href="'.esc_url($social_service_url).'" target="_blank" class="a-'.esc_attr($social_service).'"><i class="fa fa-'.esc_attr($social_service).'"></i></a></li>';
              }
            }

        ?>
        <?php
            if(isset($hind_theme_options['enable_fullscreen_search'])&&($hind_theme_options['enable_fullscreen_search'])):
        ?>
        <li class="search-toggle"><div id="trigger-search"><a class="search-toggle-btn"><i class="fa fa-search"></i></a></div></li>
        <?php endif; ?>
        <?php
            if(isset($hind_theme_options['enable_offcanvas_sidebar'])&&($hind_theme_options['enable_offcanvas_sidebar'])):
        ?>
        <li class="float-sidebar-toggle"><div id="st-sidebar-trigger-effects"><a class="float-sidebar-toggle-btn" data-effect="st-sidebar-effect-2"><i class="fa fa-align-left"></i></a></div></li>
        <?php endif; ?>


      </ul>
<?php
}

/* Blog post excerpt read more */
function hind_excerpt_more( $more ) {
    return '...';
}
add_filter('excerpt_more', 'hind_excerpt_more');

/* Show site preloader */
function hind_show_site_preloader() {

    $hind_theme_options = hind_get_theme_options();

    ?>
    <!-- Preloader -->
    <div class="mask">
    <?php
    if(isset($hind_theme_options['preloader_image']) && $hind_theme_options['preloader_image']['url'] <> ''):
    ?>
    <div id="preloader-image">
        <div class="preloader-image"><img src="<?php echo esc_url($hind_theme_options['preloader_image']['url']); ?>" alt="<?php esc_attr_e('Loading...', 'hind'); ?>"/></div>
    </div>
    <?php else: ?>
    <div id="preloader">
        <div class="la-line-scale la-dark">
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
        </div>
    </div>
    <?php endif; ?>

    </div>
    <!--/Preloader -->
    <?php
}

/**
 * Function for outputting a cmb2 file_list
 *
 * @param  string  $file_list_meta_key The field meta key. ('wiki_test_file_list')
 * @param  string  $img_size           Size of image to show
 */
function hind_cmb2_get_images_src( $post_id, $file_list_meta_key, $img_size = 'medium' ) {

    // Get the list of files
    $files = get_post_meta( $post_id, $file_list_meta_key, 1 );

    $attachments_image_urls_array = Array();

    foreach ( (array) $files as $attachment_id => $attachment_url ) {

        $current_attach = wp_get_attachment_image_src( $attachment_id, $img_size );

        $attachments_image_urls_array[] = $current_attach[0];

    }

    if($attachments_image_urls_array[0] == '') {
        $attachments_image_urls_array = array();
    }

    return $attachments_image_urls_array;

}

// Set revslider as theme
if(function_exists( 'set_revslider_as_theme' )){

    add_action( 'init', 'hind_setRevSlider_asTheme' );

    function hind_setRevSlider_asTheme() {
        set_revslider_as_theme();
    }
}
