<?php

	add_action( 'wp_enqueue_scripts', 'hind_enqueue_dynamic_styles', '999' );

	function hind_enqueue_dynamic_styles( ) {

        require_once(ABSPATH . 'wp-admin/includes/file.php'); // required to use WP_Filesystem()

        WP_Filesystem();

        global $wp_filesystem;

		if ( function_exists( 'is_multisite' ) && is_multisite() ){
            $cache_file_name = 'style-cache-'.wp_get_theme()->get('TextDomain').'-b' . get_current_blog_id();
        } else {
            $cache_file_name = 'style-cache-'.wp_get_theme()->get('TextDomain');
        }

        $wp_upload_dir = wp_upload_dir();

        $css_cache_file = $wp_upload_dir['basedir'].'/'.$cache_file_name.'.css';

        $css_cache_file_url = $wp_upload_dir['baseurl'].'/'.$cache_file_name.'.css';

        $ipanel_saved_date = get_option( 'ipanel_saved_date', 1 );
        $cache_saved_date = get_option( 'cache_css_saved_date', 0 );

        if( file_exists( $css_cache_file ) ) {
            $cache_status = 'exist';

            if($ipanel_saved_date > $cache_saved_date) {
                $cache_status = 'no-exist';
            }

        } else {
            $cache_status = 'no-exist';
        }

        if ( defined('DEMO_MODE') ) {
            $cache_status = 'no-exist';
        }

		if ( $cache_status == 'exist' ) {

			wp_register_style( $cache_file_name, $css_cache_file_url, $cache_saved_date);
            wp_enqueue_style( $cache_file_name );

		} else {

			$out = '';

			$generated = microtime(true);

			$out = hind_get_css();

			$out = str_replace( array( "\t", "
", "\n", "  ", "   ", ), array( "", "", " ", " ", " ", ), $out );

			$out .= '/* CSS Generator Execution Time: ' . floatval( ( microtime(true) - $generated ) ) . ' seconds */';

            // FS_CHMOD_FILE required by WordPress guideliness - https://codex.wordpress.org/Filesystem_API#Using_the_WP_Filesystem_Base_Class
            if ( defined( 'FS_CHMOD_FILE' ) ) {
                $chmod_file = FS_CHMOD_FILE;
            } else {
                $chmod_file = ( 0644 & ~ umask() );
            }

			 if ( $wp_filesystem->put_contents( $css_cache_file, $out, $chmod_file) ) {

				wp_register_style( $cache_file_name, $css_cache_file_url, $cache_saved_date);
                wp_enqueue_style( $cache_file_name );

                // Update save options date
                $option_name = 'cache_css_saved_date';

                $new_value = microtime(true) ;

                if ( get_option( $option_name ) !== false ) {

                    // The option already exists, so we just update it.
                    update_option( $option_name, $new_value );

                } else {

                    // The option hasn't been added yet. We'll add it with $autoload set to 'no'.
                    $deprecated = null;
                    $autoload = 'no';
                    add_option( $option_name, $new_value, $deprecated, $autoload );
                }
			}

		}
	}

	function hind_get_css () {
		$hind_theme_options = hind_get_theme_options();
		// ===
		ob_start();
    ?>
    <?php
    if ( defined('DEMO_MODE') && isset($_GET['header_height']) ) {
      $hind_theme_options['header_height'] = $_GET['header_height'];
    }

    if(isset($hind_theme_options['header_height']) && $hind_theme_options['header_height'] > 0) {
        $header_height = $hind_theme_options['header_height'];
    } else {
        $header_height = 120;
    }
    ?>
    header .col-md-12 {
        height: <?php echo intval($header_height); ?>px;
    }
    <?php
    // Retina logo

    ?>
    header .logo-link img {
        width: <?php if(isset($hind_theme_options['logo_width'])) { echo intval($hind_theme_options['logo_width']); } else { echo '114'; } ?>px;
    }
    #preloader-image img {
        width: <?php if(isset($hind_theme_options['preloader_width'])) { echo intval($hind_theme_options['preloader_width']); } else { echo '100'; } ?>px;
    }
    <?php if(isset($hind_theme_options['enable_parallax']) && $hind_theme_options['enable_parallax']): ?>
        .fullwidth-section.parallax,
        .parallax {
            background-attachment: fixed!important;
        }
    <?php endif; ?>

    /**
    * Custom CSS
    **/
    <?php if(isset($hind_theme_options['custom_css_code'])) {

        echo hind_wp_kses_data($hind_theme_options['custom_css_code']); // This variable contains user Custom CSS code and can't be escaped with WordPress functions

    }
    ?>

    /**
    * Theme Google Font
    **/
    <?php
        // Demo settings
        if ( defined('DEMO_MODE') && isset($_GET['header_font']) ) {
          $hind_theme_options['header_font']['font-family'] = $_GET['header_font'];
        }
        if ( defined('DEMO_MODE') && isset($_GET['body_font']) ) {
          $hind_theme_options['body_font']['font-family'] = $_GET['body_font'];
        }
        if ( defined('DEMO_MODE') && isset($_GET['additional_font']) ) {
          $hind_theme_options['additional_font']['font-family'] = $_GET['additional_font'];
        }

        if(isset($hind_theme_options['font_google_disable']) && $hind_theme_options['font_google_disable']) {

            $hind_theme_options['body_font']['font-family'] = $hind_theme_options['font_regular'];
            $hind_theme_options['header_font']['font-family'] = $hind_theme_options['font_regular'];
            $hind_theme_options['additional_font']['font-family'] = $hind_theme_options['font_regular'];
        }
    ?>
    h1, h2, h3, h4, h5, h6 {
        font-family: '<?php echo esc_attr($hind_theme_options['header_font']['font-family']); ?>';
    }
    h1 {
        font-size: <?php echo esc_attr($hind_theme_options['header_font']['font-size']); ?>px;
    }
    #jckqv,
    #jckqv *,
    #jckqv p,
    .wpml-lang #lang_sel {
        font-family: '<?php echo esc_attr($hind_theme_options['body_font']['font-family']); ?>';
    }
    body {
        font-family: '<?php echo esc_attr($hind_theme_options['body_font']['font-family']); ?>';
        font-size: <?php echo esc_attr($hind_theme_options['body_font']['font-size']); ?>px;
    }
    <?php if(isset($hind_theme_options['additional_font_enable']) && $hind_theme_options['additional_font_enable']): ?>
    .mgt-promo-block .mgt-promo-block-content strong,
    .hind-slide strong {
        font-family: '<?php echo esc_attr($hind_theme_options['additional_font']['font-family']); ?>';
    }
    <?php endif; ?>
    /**
    * Colors and color skins
    */
    <?php
    // Demo settings
    if ( defined('DEMO_MODE') && isset($_GET['color_skin_name']) ) {
      $hind_theme_options['color_skin_name'] = $_GET['color_skin_name'];
    }

    if(!isset($hind_theme_options['color_skin_name'])) {
        $color_skin_name = 'none';
    }
    else {
        $color_skin_name = $hind_theme_options['color_skin_name'];
    }
    // Use panel settings
    if($color_skin_name == 'none') {

        $theme_body_color = $hind_theme_options['theme_body_color'];
        $theme_text_color = $hind_theme_options['theme_text_color'];
        $theme_main_color = $hind_theme_options['theme_main_color'];
        $theme_header_bg_color = $hind_theme_options['theme_header_bg_color'];
        $theme_main_menu_bg_color = $hind_theme_options['theme_main_menu_bg_color'];
        $theme_main_menu_dark_bg_color = $hind_theme_options['theme_main_menu_dark_bg_color'];
        $theme_main_menu_submenu_bg_color = $hind_theme_options['theme_main_menu_submenu_bg_color'];
        $theme_main_menu_submenu_link_color = $hind_theme_options['theme_main_menu_submenu_link_color'];
        $theme_footer_sidebar_bg_color = $hind_theme_options['theme_footer_sidebar_bg_color'];
        $theme_footer_bg_color = $hind_theme_options['theme_footer_bg_color'];
        $theme_title_color = $hind_theme_options['theme_title_color'];

    }
    // Default skin
    if($color_skin_name == 'default') {
        $theme_body_color = '#FFFFFF';
        $theme_text_color = '#4c4d4f';
        $theme_main_color = '#1151D3';
        $theme_header_bg_color = '#FFFFFF';
        $theme_main_menu_bg_color = '#EEEEEE';
        $theme_main_menu_dark_bg_color = '#262626';
        $theme_main_menu_submenu_bg_color = '#262626';
        $theme_main_menu_submenu_link_color = '#ffffff';
        $theme_footer_sidebar_bg_color = '#262626';
        $theme_footer_bg_color = '#F4F4F4';
        $theme_title_color = '#000000';
    }
     // Default skin
    if($color_skin_name == 'defaultlight') {
        $theme_body_color = '#FFFFFF';
        $theme_text_color = '#4c4d4f';
        $theme_main_color = '#1151D3';
        $theme_header_bg_color = '#FFFFFF';
        $theme_main_menu_bg_color = '#EEEEEE';
        $theme_main_menu_dark_bg_color = '#262626';
        $theme_main_menu_submenu_bg_color = '#EEEEEE';
        $theme_main_menu_submenu_link_color = '#262626';
        $theme_footer_sidebar_bg_color = '#262626';
        $theme_footer_bg_color = '#F4F4F4';
        $theme_title_color = '#000000';
    }
    // Green skin
    if($color_skin_name == 'green') {
        $theme_body_color = '#FFFFFF';
        $theme_text_color = '#4c4d4f';
        $theme_main_color = '#00BC8F';
        $theme_header_bg_color = '#FFFFFF';
        $theme_main_menu_bg_color = '#EEEEEE';
        $theme_main_menu_dark_bg_color = '#262626';
        $theme_main_menu_submenu_bg_color = '#262626';
        $theme_main_menu_submenu_link_color = '#ffffff';
        $theme_footer_sidebar_bg_color = '#262626';
        $theme_footer_bg_color = '#F4F4F4';
        $theme_title_color = '#000000';
    }
    // Blue skin
    if($color_skin_name == 'blue') {

        $theme_body_color = '#FFFFFF';
        $theme_text_color = '#4c4d4f';
        $theme_main_color = '#5a7e9f';
        $theme_header_bg_color = '#FFFFFF';
        $theme_main_menu_bg_color = '#EEEEEE';
        $theme_main_menu_dark_bg_color = '#262626';
        $theme_main_menu_submenu_bg_color = '#262626';
        $theme_main_menu_submenu_link_color = '#ffffff';
        $theme_footer_sidebar_bg_color = '#262626';
        $theme_footer_bg_color = '#F4F4F4';
        $theme_title_color = '#000000';
    }
    // Red skin
    if($color_skin_name == 'red') {

        $theme_body_color = '#FFFFFF';
        $theme_text_color = '#4c4d4f';
        $theme_main_color = '#e86f75';
        $theme_header_bg_color = '#FFFFFF';
        $theme_main_menu_bg_color = '#EEEEEE';
        $theme_main_menu_dark_bg_color = '#262626';
        $theme_main_menu_submenu_bg_color = '#262626';
        $theme_main_menu_submenu_link_color = '#ffffff';
        $theme_footer_sidebar_bg_color = '#262626';
        $theme_footer_bg_color = '#F4F4F4';
        $theme_title_color = '#000000';

    }
    // Black&White skin
    if($color_skin_name == 'blackandwhite') {

        $theme_body_color = '#FFFFFF';
        $theme_text_color = '#4c4d4f';
        $theme_main_color = '#606060';
        $theme_header_bg_color = '#FFFFFF';
        $theme_main_menu_bg_color = '#EEEEEE';
        $theme_main_menu_dark_bg_color = '#262626';
        $theme_main_menu_submenu_bg_color = '#262626';
        $theme_main_menu_submenu_link_color = '#ffffff';
        $theme_footer_sidebar_bg_color = '#262626';
        $theme_footer_bg_color = '#F4F4F4';
        $theme_title_color = '#000000';

    }

    // Orange skin
    if($color_skin_name == 'orange') {

        $theme_body_color = '#FFFFFF';
        $theme_text_color = '#4c4d4f';
        $theme_main_color = '#FDAD46';
        $theme_header_bg_color = '#FFFFFF';
        $theme_main_menu_bg_color = '#EEEEEE';
        $theme_main_menu_dark_bg_color = '#262626';
        $theme_main_menu_submenu_bg_color = '#262626';
        $theme_main_menu_submenu_link_color = '#ffffff';
        $theme_footer_sidebar_bg_color = '#262626';
        $theme_footer_bg_color = '#F4F4F4';
        $theme_title_color = '#000000';

    }
    // Fencer skin
    if($color_skin_name == 'fencer') {

        $theme_body_color = '#FFFFFF';
        $theme_text_color = '#4c4d4f';
        $theme_main_color = '#26cdb3';
        $theme_header_bg_color = '#FFFFFF';
        $theme_main_menu_bg_color = '#EEEEEE';
        $theme_main_menu_dark_bg_color = '#262626';
        $theme_main_menu_submenu_bg_color = '#262626';
        $theme_main_menu_submenu_link_color = '#ffffff';
        $theme_footer_sidebar_bg_color = '#262626';
        $theme_footer_bg_color = '#F4F4F4';
        $theme_title_color = '#000000';

    }
    // Perfectum skin
    if($color_skin_name == 'perfectum') {

        $theme_body_color = '#FFFFFF';
        $theme_text_color = '#4c4d4f';
        $theme_main_color = '#F2532F';
        $theme_header_bg_color = '#FFFFFF';
        $theme_main_menu_bg_color = '#EEEEEE';
        $theme_main_menu_dark_bg_color = '#262626';
        $theme_main_menu_submenu_bg_color = '#262626';
        $theme_main_menu_submenu_link_color = '#ffffff';
        $theme_footer_sidebar_bg_color = '#262626';
        $theme_footer_bg_color = '#F4F4F4';
        $theme_title_color = '#000000';

    }
    // Simplegreat skin
    if($color_skin_name == 'simplegreat') {

        $theme_body_color = '#FFFFFF';
        $theme_text_color = '#4c4d4f';
        $theme_main_color = '#C3A36B';
        $theme_header_bg_color = '#FFFFFF';
        $theme_main_menu_bg_color = '#EEEEEE';
        $theme_main_menu_dark_bg_color = '#262626';
        $theme_main_menu_submenu_bg_color = '#262626';
        $theme_main_menu_submenu_link_color = '#ffffff';
        $theme_footer_sidebar_bg_color = '#262626';
        $theme_footer_bg_color = '#F4F4F4';
        $theme_title_color = '#000000';

    }

    ?>

    body {
        background-color: <?php echo esc_html($theme_body_color); ?>;
        color: <?php echo esc_html($theme_text_color); ?>;
    }
    .st-pusher,
    .st-sidebar-pusher {
        background-color: <?php echo esc_html($theme_body_color); ?>;
    }
    a.btn,
    .btn,
    .btn:focus,
    input[type="submit"],
    .wp-block-button a,
    .woocommerce #content input.button,
    .woocommerce #respond input#submit,
    .woocommerce a.button,
    .woocommerce button.button,
    .woocommerce input.button,
    .woocommerce-page #content input.button,
    .woocommerce-page #respond input#submit,
    .woocommerce-page a.button,
    .woocommerce-page button.button,
    .woocommerce-page input.button,
    .woocommerce a.added_to_cart,
    .woocommerce-page a.added_to_cart,
    .btn-primary:hover,
    .btn-primary:active,
    .navbar .nav > li:not(.menu-item-has-children) > a:after,
    #top-link,
    .sidebar .widget_calendar th,
    .sidebar .widget_calendar tfoot td,
    .tp-bullets.simplebullets.round .bullet:hover,
    .tp-bullets.simplebullets.round .bullet.selected,
    .tp-bullets.simplebullets.navbar .bullet:hover,
    .tp-bullets.simplebullets.navbar .bullet.selected,
    body .flex-control-paging li a.flex-active,
    body .flex-control-paging li a:hover,
    .mgt-post-list .mgt-post-icon,
    .mgt-button.mgt-style-solid-invert:hover,
    .mgt-button.mgt-style-bordered:hover,
    .mgt-button.mgt-style-grey:hover,
    .portfolio-item-block.portfolio-item-animation-0 .portfolio-item-bg,
    .portfolio-list-related .portfolio-item-block .portfolio-item-bg,
    .blog-post .more-link:after,
    .portfolio-item-block.portfolio-item-animation-6:hover .portfolio-item-bg,
    .mgt-pricing-table.featured h4.mgt-pricing-table-header,
    .navbar .navbar-toggle {
        background-color: <?php echo esc_html($theme_main_color); ?>;
    }
    a,
    a:focus,
    .page-404 h1,
    .navbar .nav > li.current_page_item > a,
    .post-social-title i,
    .post-social a:hover,
    .sidebar .widget_calendar tbody td a,
    .sidebar.footer-container .widget.widget_calendar tbody td a,
    .portfolio-filter a.view-all,
    .navbar .nav > li > a:hover,
    .blog-post .post-header-title a:hover,
    header .header-right ul.header-nav a:hover,
    .blog-post .more-link:hover,
    .mgt-counter-wrapper .mgt-counter-value,
    .wpcf7-form .wpcf7-submit:hover,
    .ninja-forms-cont input[type="submit"]:hover {
        color: <?php echo esc_html($theme_main_color); ?>;
    }
    .post-social a:hover,
    .sidebar .widget_calendar tbody td a,
    body .owl-theme .owl-controls .owl-page.active span,
    body .owl-theme .owl-controls.clickable .owl-page:hover span,
    .mgt-button.mgt-style-bordered:hover {
        border-color: <?php echo esc_html($theme_main_color); ?>;
    }
    header.main-header {
        background-color: <?php echo esc_html($theme_header_bg_color); ?>;
    }
    .mainmenu-belowheader {
        background-color: <?php echo esc_html($theme_main_menu_bg_color); ?>;
    }
    .mainmenu-belowheader.mainmenu-dark {
        background-color: <?php echo esc_html($theme_main_menu_dark_bg_color); ?>;
    }
    .nav > li .sub-menu {
        background-color: <?php echo esc_html($theme_main_menu_submenu_bg_color); ?>;
    }
    .nav .sub-menu li.menu-item > a {
        color: <?php echo esc_html($theme_main_menu_submenu_link_color); ?>;
    }
    .nav .sub-menu li.menu-item > a:hover,
    .nav .children li.menu-item > a:hover {
        color: <?php echo esc_html($theme_main_menu_submenu_link_color); ?>;
    }
    .footer-sidebar-2-wrapper {
        background-color: <?php echo esc_html($theme_footer_sidebar_bg_color); ?>;
    }
    footer {
        background-color: <?php echo esc_html($theme_footer_bg_color); ?>;
    }
    .page-item-title h1 {
        color: <?php echo esc_html($theme_title_color); ?>;
    }

    <?php

    	$out = ob_get_clean();

		$out .= ' /*' . date("Y-m-d H:i") . '*/';
		/* RETURN */
		return $out;
	}
?>
