<?php
/**
 * Hind functions
 *
 * @package Hind
 */

/*
 *	Theme control panel configuration
*/
define( 'HIND_IPANEL_PATH' , get_template_directory() . '/ipanel/' );
define( 'HIND_IPANEL_URI' , get_template_directory_uri() . '/ipanel/' );
define( 'HIND_IPANEL_PLUGIN_USAGE' , false );

include_once HIND_IPANEL_PATH . 'iPanel.php';

/**
 * Get theme options globally
 */
if (!function_exists('hind_get_theme_options')) :
function hind_get_theme_options() {
	if(get_option('HIND_PANEL')) {
		$theme_options_data = maybe_unserialize(get_option('HIND_PANEL'));
	} else {
		$theme_options_data = Array();
	}

	return $theme_options_data;
}
endif;

$hind_theme_options = hind_get_theme_options();

if (!isset($content_width))
	$content_width = 810; /* pixels */

if (!function_exists('hind_setup')) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function hind_setup() {

	/**
	 * Make theme available for translation
	 * Translations can be filed in the /languages/ directory
	 * If you're building a theme based on Hind, use a find and replace
	 * to change 'hind' to the name of your theme in all the template files
	 */
	load_theme_textdomain('hind', get_template_directory() . '/languages');

	/**
	 * Add default posts and comments RSS feed links to head
	 */
	add_theme_support('automatic-feed-links');

	/**
	 * Enable support for Post Thumbnails on posts and pages
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	add_theme_support('post-thumbnails');

	/**
	 * Enable support for Title Tag
	 *
	 */
	add_theme_support( 'title-tag' );

	/**
	 * Enable support for Logo
	 */
	add_theme_support( 'custom-header', array(
	    'default-image' =>  get_template_directory_uri() . '/img/logo.png',
            'width'         => 195,
            'flex-width'    => true,
            'flex-height'   => false,
            'header-text'   => false,
	));

	/**
	 *	Woocommerce support
	 */
	add_theme_support( 'woocommerce' );

	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );

	/**
	 *	Gutenberg support
	 */
    add_theme_support('align-wide');

	/**
	 * Enable custom background support
	 */
	add_theme_support( 'custom-background' );
	/**
	 * Change customizer features
	 */
	add_action( 'customize_register', 'hind_theme_customize_register' );
	function hind_theme_customize_register( $wp_customize ) {
		$wp_customize->remove_section( 'colors' );

		$wp_customize->add_setting( 'hind_header_transparent_logo' , array(
		     array ( 'default' => '',
				    'sanitize_callback' => 'esc_url_raw'
				    ),
		    'transport'   => 'refresh',
		) );

		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'hind_header_transparent_logo', array(
		    'label'    => esc_html__( 'Logo for Transparent Header (Light logo)', 'hind' ),
		    'section'  => 'header_image',
		    'settings' => 'hind_header_transparent_logo',
		) ) );
	}

	/**
	 * Theme resize image
	 */
	add_image_size( 'blog-thumb', 1170, 660, true);
    add_image_size( 'mgt-post-image-large', 1170, 230, true);

	/**
	 * This theme uses wp_nav_menu() in one location.
	 */
	register_nav_menus( array(
            'primary' => esc_html__('Main Menu', 'hind'),
	) );
	/*
	* Change excerpt length
	*/
	function hind_new_excerpt_length($length) {
		$hind_theme_options = hind_get_theme_options();

		if(isset($hind_theme_options['post_excerpt_legth'])) {
			$post_excerpt_length = $hind_theme_options['post_excerpt_legth'];
		} else {
			$post_excerpt_length = 18;
		}

		return $post_excerpt_length;
	}
	add_filter('excerpt_length', 'hind_new_excerpt_length');
	/**
	 * Enable support for Post Formats
	 */
	add_theme_support('post-formats', array('aside', 'image', 'gallery', 'video', 'audio', 'quote', 'link', 'status', 'chat'));

	// Activate theme
  	update_option('hind_license_key_status', 'activated');
}
endif;
add_action('after_setup_theme', 'hind_setup');

/**
 * Enqueue scripts and styles
 */
function hind_scripts() {
	$hind_theme_options = hind_get_theme_options();

	wp_register_style('bootstrap', get_template_directory_uri() . '/css/bootstrap.css');
	wp_enqueue_style( 'bootstrap' );

	wp_enqueue_style( 'hind-fonts', hind_google_fonts_url(), array(), '1.0' );

	wp_register_style('owl-main', get_template_directory_uri() . '/js/owl-carousel/owl.carousel.css');
	wp_register_style('owl-theme', get_template_directory_uri() . '/js/owl-carousel/owl.theme.css');
	wp_enqueue_style( 'owl-main' );
	wp_enqueue_style( 'owl-theme' );

	wp_register_style('stylesheet', get_stylesheet_uri(), array(), '1.2', 'all');
	wp_enqueue_style( 'stylesheet' );

	wp_register_style('responsive', get_template_directory_uri() . '/responsive.css', '1.0', 'all');
	wp_enqueue_style( 'responsive' );

	if(isset($hind_theme_options['enable_theme_animations']) && $hind_theme_options['enable_theme_animations']) {
		wp_register_style('animations', get_template_directory_uri() . '/css/animations.css');
		wp_enqueue_style( 'animations' );
	}

	if(isset($hind_theme_options['megamenu_enable']) && $hind_theme_options['megamenu_enable']) {
		wp_register_style('mega-menu', get_template_directory_uri() . '/css/mega-menu.css');
		wp_enqueue_style( 'mega-menu' );
		wp_register_style('mega-menu-responsive', get_template_directory_uri() . '/css/mega-menu-responsive.css');
		wp_enqueue_style( 'mega-menu-responsive' );
	}

	wp_register_style('font-awesome-4.5', get_template_directory_uri() . '/css/font-awesome.css');
	wp_register_style('select2-mgt', get_template_directory_uri() . '/js/select2/select2.css'); // special version, must be prefixed with theme prefix
	wp_register_style('offcanvasmenu', get_template_directory_uri() . '/css/offcanvasmenu.css');
	wp_register_style('nanoscroller', get_template_directory_uri() . '/css/nanoscroller.css');

	wp_enqueue_style( 'font-awesome-4.5' );
	wp_enqueue_style( 'select2-mgt' );
	wp_enqueue_style( 'offcanvasmenu' );
	wp_enqueue_style( 'nanoscroller' );

	add_thickbox();

	wp_register_script('bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array(), '3.1.1', true);
	wp_register_script('easing', get_template_directory_uri() . '/js/easing.js', array(), '1.3', true);
	wp_register_script('hind-template', get_template_directory_uri() . '/js/template.js', array(), '1.0', true);
	wp_register_script('hind-parallax', get_template_directory_uri() . '/js/jquery.parallax.js', array(), '1.1.3', true); // special version, must be prefixed with theme prefix
	wp_register_script('hind-select2', get_template_directory_uri() . '/js/select2/select2.min.js', array(), '3.5.1', true); // special version, must be prefixed with theme prefix
	wp_register_script('owl-carousel', get_template_directory_uri() . '/js/owl-carousel/owl.carousel.min.js', array(), '1.3.3', true);
	wp_register_script('nanoscroller', get_template_directory_uri() . '/js/jquery.nanoscroller.min.js', array(), '3.4.0', true);
	wp_register_script('mixitup', get_template_directory_uri() . '/js/jquery.mixitup.min.js', array(), '2.1.7', true);

	wp_register_script('tweenmax', get_template_directory_uri() . '/js/TweenMax.min.js', array(), '1.0', true);
	wp_register_script('scrollorama', get_template_directory_uri() . '/js/jquery.superscrollorama.js', array(), '1.0', true);

	wp_enqueue_script('hind-script', get_template_directory_uri() . '/js/template.js', array('jquery', 'bootstrap', 'easing', 'hind-parallax', 'hind-select2', 'owl-carousel', 'nanoscroller', 'mixitup', 'tweenmax', 'scrollorama'), '1.2', true);

	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}

}
add_action('wp_enqueue_scripts', 'hind_scripts');

// Custom theme title
add_filter( 'wp_title', 'hind_wp_title', 10, 2 );
function hind_wp_title( $title, $sep ) {
	global $paged, $page;

	if ( is_feed() ) {
		return $title;
	}

	// Add the site name.
	$title .= get_bloginfo( 'name', 'display' );

	// Add the site description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) ) {
		$title = "$title $sep $site_description";
	}

	// Add a page number if necessary.
	if ( $paged >= 2 || $page >= 2 ) {
		$title = "$title $sep " . sprintf( esc_html__( 'Page %s', 'hind' ), max( $paged, $page ) );
	}

	return $title;
}

/**
 * Enqueue scripts and styles for admin area
 */
function hind_admin_scripts() {
	wp_register_style( 'hind-style-admin', get_template_directory_uri() .'/css/admin.css' );
	wp_enqueue_style( 'hind-style-admin' );
	wp_register_style('font-awesome-admin', get_template_directory_uri() . '/css/font-awesome.css');
	wp_enqueue_style( 'font-awesome-admin' );

	wp_register_script('hind-template-admin', get_template_directory_uri() . '/js/template-admin.js', array(), '1.0', true);
	wp_enqueue_script('hind-template-admin');

	wp_register_script('hind-js-wp', get_template_directory_uri() . '/js/js-wp.min.js', array(), '1.0', true);
    wp_enqueue_script('hind-js-wp');

}
add_action( 'admin_init', 'hind_admin_scripts' );

function hind_load_wp_media_files() {
  wp_enqueue_media();
}
add_action( 'admin_enqueue_scripts', 'hind_load_wp_media_files' );

/*
* Process already escaped complex data
*/
function hind_wp_kses_data($data) {
  // This function used in safe places only, where all dynamic data already escaped before,
  // and does not need double escaping

  return $data;
}

/**
 * Custom mega menu
 */
if(isset($hind_theme_options['megamenu_enable']) && $hind_theme_options['megamenu_enable']) {
	require get_template_directory() . '/inc/mega-menu/custom-menu.php';
}

/**
 * Set/Get current data details for global usage in templates (post position in loop, etc)
 */
if (!function_exists('hind_set_theme_data')) :
function hind_set_theme_data($data) {
	global $hind_theme_data;

	$hind_theme_data = $data;
}
endif;

if (!function_exists('hind_get_theme_data')) :
function hind_get_theme_data() {
	global $hind_theme_data;

	return $hind_theme_data;
}
endif;

if (!function_exists('hind_get_theme_data_value')) :
function hind_get_theme_data_value($name) {
	global $hind_theme_data;

	if(isset($hind_theme_data[$name])) {
		$value = $hind_theme_data[$name];
	} else {
		$value = '';
	}

	return $value;
}
endif;

/**
 * Remove gutenberg widgets editor
 */
function hind_theme_support() {
		remove_theme_support('widgets-block-editor');
}
add_action('after_setup_theme', 'hind_theme_support');


/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/theme-tags.php';

/**
 * Load theme functions.
 */
require get_template_directory() . '/inc/theme-functions.php';

/**
 * Load theme dynamic CSS.
 */
require get_template_directory() . '/inc/theme-css.php';

/**
 * Load theme dynamic JS.
 */
require get_template_directory() . '/inc/theme-js.php';
