<?php
/**
 * @package Hind
 */
$hind_theme_options = hind_get_theme_options();

$post_sidebarposition = get_post_meta( get_the_ID(), '_post_sidebarposition_value', true );
$post_socialshare_disable = get_post_meta( get_the_ID(), '_post_socialshare_disable_value', true );
$post_notdisplaytitle = get_post_meta( $post->ID, '_post_notdisplaytitle_value', true );

$post_transparent_header = get_post_meta( $post->ID, '_post_transparent_header_value', true );

if(isset($post_transparent_header)&&($post_transparent_header)) {
	    wp_add_inline_script( 'hind-script', '(function($){$(document).ready(function() { "use strict";$("body").addClass("transparent-header"); });})(jQuery);', 'before');
}

// Demo settings
if ( defined('DEMO_MODE') && isset($_GET['post_sidebar_position']) ) {
  $hind_theme_options['post_sidebar_position'] = $_GET['post_sidebar_position'];
}

if(!isset($piemont_theme_options['post_sidebar_position'])) {
	$piemont_theme_options['post_sidebar_position'] = 'disable';
}

if(!isset($post_sidebarposition)||($post_sidebarposition == '')) {
	$post_sidebarposition = 0;
}

if($post_sidebarposition == "0") {
	$post_sidebarposition = $hind_theme_options['post_sidebar_position'];
}

$containerclass = 'container';
$add_class = '';

$post_bgcolor = get_post_meta( $post->ID, '_post_bgcolor_value', true );

$post_bgcolor_css = '';

if(isset($post_bgcolor)&&($post_bgcolor<>'')) {
  $post_bgcolor_css = 'background-color: '.$post_bgcolor;
}
else
{
  $post_bgcolor_css = '';
}

if(is_active_sidebar( 'main-sidebar' ) && ($post_sidebarposition <> 'disable') ) {
	$span_class = 'col-md-9';
}
else {
	$span_class = 'col-md-12 post-single-content';
}

?>

<div class="content-block"<?php if($post_bgcolor_css<>'') { echo ' data-style="'.esc_attr($post_bgcolor_css).'"'; }; ?>>
<?php if(!$post_notdisplaytitle): ?>
<div class="container-bg">
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <div class="page-item-title">
          <h1><?php the_title(); ?></h1>
        </div>
      </div>
    </div>
  </div>
</div>
<?php endif; ?>
<div class="post-container <?php echo esc_attr($containerclass); ?>">
	<div class="row">
<?php if ( is_active_sidebar( 'main-sidebar' ) && ( $post_sidebarposition == 'left')) : ?>
		<div class="col-md-3 main-sidebar sidebar">
		<ul id="main-sidebar">
		  <?php dynamic_sidebar( 'main-sidebar' ); ?>
		</ul>
		</div>
		<?php endif; ?>
		<div class="<?php echo esc_attr($span_class); ?>">
			<div class="blog-post blog-post-single<?php echo esc_attr($add_class); ?>">
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
							<div class="post-content-wrapper">

								<div class="post-content">

										<?php
										if ( has_post_thumbnail() ): // check if the post has a Post Thumbnail assigned to it.
										?>
										<div class="blog-post-thumb text-center">

										<?php the_post_thumbnail(); ?>

										</div>
										<?php endif; ?>

										<?php if ( is_search() ) : // Only display Excerpts for Search ?>
										<div class="entry-summary">
											<?php the_excerpt(); ?>
										</div><!-- .entry-summary -->
										<?php else : ?>
										<div class="entry-content">
											<?php the_content('<div class="more-link">'.esc_html__( 'Continue reading...', 'hind' ).'</div>' ); ?>
											<?php
												wp_link_pages( array(
													'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'hind' ),
													'after'  => '</div>',
												) );
											?>
										</div><!-- .entry-content -->


										<?php endif; ?>
									</div>

							</div>


				<div class="post-info">
				<?php if(!isset($post_socialshare_disable) || !$post_socialshare_disable): ?>
					<?php do_action('hind_social_share'); // this action called from plugin ?>
				<?php endif; ?>
				<span><?php the_time(get_option( 'date_format' ));  ?></span>

				<?php
						/* translators: used between list items, there is a space after the comma */
						$categories_list = get_the_category_list( ', ' );
						if ( $categories_list ) :
					?>

					 <span><?php esc_html_e('in','hind'); ?> <?php printf( esc_html__( '%1$s', 'hind' ), $categories_list ); ?></span>

					<?php endif; // End if categories ?>

					<?php if ( ! post_password_required() && ( comments_open() || '0' != get_comments_number() ) ) : ?>
					<span><?php comments_popup_link( esc_html__( 'Leave a comment', 'hind' ), esc_html__( '1 Comment', 'hind' ), esc_html__( '% Comments', 'hind' ) ); ?></span>
					<?php endif; ?>

					<?php edit_post_link( esc_html__( 'Edit', 'hind' ), ' <span class="edit-link">', '</span>' ); ?>
				</div>
				<?php
					/* translators: used between list items, there is a space after the comma */
					$tags_list = get_the_tag_list( '', ''  );
					if ( $tags_list ) :
				?>
				<span class="tags">
					<?php printf( esc_html__( 'Tags: %1$s', 'hind' ), $tags_list ); ?>
				</span>

				<?php endif; // End if $tags_list ?>

				</article>

			</div>

			<?php if(isset($hind_theme_options['blog_enable_author_info'])&&($hind_theme_options['blog_enable_author_info'])): ?>
				<?php if ( is_single() && get_the_author_meta( 'description' ) ) : ?>
					<?php get_template_part( 'author-bio' ); ?>
				<?php endif; ?>
			<?php endif; ?>
			<?php
			if(isset($hind_theme_options['blog_post_navigation']) && $hind_theme_options['blog_post_navigation']) {
				hind_content_nav( 'nav-below' );
			}
			?>
			<?php
				// If comments are open or we have at least one comment, load up the comment template
				if ( comments_open() || '0' != get_comments_number() )

					comments_template();
			?>

		</div>
		<?php if ( is_active_sidebar( 'main-sidebar' ) && ( $post_sidebarposition == 'right')) : ?>
		<div class="col-md-3 main-sidebar sidebar">
		<ul id="main-sidebar">
		  <?php dynamic_sidebar( 'main-sidebar' ); ?>
		</ul>
		</div>
		<?php endif; ?>
	</div>
	</div>
</div>
