<?php
/**
 * @package Hind
 */
?>
<?php

$post_classes = get_post_class();

$current_post_class = $post_classes[4];

// This post formats will display content before title
$post_classes_content_top = array('format-audio', 'format-video', 'format-gallery', 'format-status', 'format-link', 'format-quote');

?>
<div class="content-block blog-post clearfix">
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>


				<div class="post-content-wrapper">

					<?php
					if(in_array($current_post_class , $post_classes_content_top)) {
						echo '<div class="entry-content">';
						the_content('');
						echo '</div>';
					} else {
						if ( has_post_thumbnail() ):
						?>
						<div class="blog-post-thumb text-center">
							<a href="<?php the_permalink(); ?>" rel="bookmark">
							<?php the_post_thumbnail('blog-thumb'); ?>
							</a>
						</div>
						<?php
						endif;
					}
					?>
					<div class="post-content">

						<h1 class="entry-title post-header-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h1>
						<div class="post-info">

						<span><?php the_time(get_option( 'date_format' ));  ?></span>

						<?php edit_post_link( esc_html__( 'Edit', 'hind' ), ' <span class="edit-link">', '</span>' ); ?>

						</div>




						</div>

				</div>


	</article>
</div>
