<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains both current comments
 * and the comment form. The actual display of comments is
 * handled by a callback to hind_comment() which is
 * located in the inc/template-tags.php file.
 *
 * @package Hind
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() )
	return;

?>
<div id="comments" class="comments-area">

	<?php // You can start editing here -- including this comment! ?>

	<?php if ( have_comments() ) : ?>
		<h2 class="comments-title">
			<?php
				printf( _nx( '1 comment', '%1$s comments', get_comments_number(), '', 'hind' ),
				number_format_i18n( get_comments_number() ), '<span>' . the_title_attribute(array('echo' => false)) . '</span>' );
			?>
		</h2>


		<?php
			// If comments are closed and there are comments, let's leave a little note, shall we?
			if ( ! comments_open() && '0' != get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
		?>
			<div class="mgt-message-box mgt-message-box-info"><?php esc_html_e( 'Comments are closed.', 'hind' ); ?></div>
		<?php endif; ?>

		<?php
			// If comments are closed and there are comments, let's leave a little note, shall we?
			if ( comments_open() && post_type_supports( get_post_type(), 'comments' ) ) :
		?>
		<a id="blog_show_comment_form" class="btn mgt-button mgt-align-center"><?php _e('Write a comment', 'hind');?></a>
		<div class="comments-form-wrapper" id="comments-form-wrapper">
		<?php comment_form(array('comment_notes_after' => '')); ?>
		</div>
		<?php endif; ?>

		<ul class="comment-list">
			<?php
				/* Loop through and list the comments. Tell wp_list_comments()
				 * to use hind_comment() to format the comments.
				 * If you want to overload this in a child theme then you can
				 * define hind_comment() and that will be used instead.
				 * See hind_comment() in inc/template-tags.php for more.
				 */
				wp_list_comments( array( 'callback' => 'hind_comment' ) );
			?>
		</ul><!-- .comment-list -->

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
		<nav id="nav-below" class="navigation-paging">
			<div class="container-fluid">
				<div class="row-fluid">
					<div class="nav-previous col-md-2">
					<?php previous_comments_link( esc_html__( 'Older Comments', 'hind' ) ); ?>
					</div>
					<div class="col-md-8 nav-text"><?php esc_html_e("Comments navigation", 'hind'); ?></div>
					<div class="nav-next col-md-2">
					<?php next_comments_link( esc_html__( 'Newer Comments', 'hind' ) ); ?>
					</div>
				</div>
			</div>
		</nav>

		<?php endif; // check for comment navigation ?>
	<?php else: ?>
		<?php
			// If comments are closed and there are comments, let's leave a little note, shall we?
			if ( comments_open() && post_type_supports( get_post_type(), 'comments' ) ) :
		?>
		<h2 class="comments-title">
			<?php
				_e( '0 comments', 'hind' );
			?>
		</h2>
		<a id="blog_show_comment_form" class="btn mgt-button mgt-size-large mgt-align-center"><?php esc_html_e('Write a comment', 'hind');?></a>
		<div class="comments-form-wrapper" id="comments-form-wrapper">
		<?php comment_form(array('comment_notes_after' => '')); ?>
		</div>
		<?php endif; ?>

	<?php endif; // have_comments() ?>



</div><!-- #comments -->
