<?php
/**
 * Get default option by passing option id
 *
 * @param string  $option
 * @return array|mixed|false
 * @param since   2.2
 */

if ( !function_exists( 'herald_get_default_option' ) ):
	function herald_get_default_option( $option ) {


		if ( empty( $option ) ) {
			return false;
		}

		$defaults = array(
			'logo' => array( 'url' => esc_url( get_parent_theme_file_uri( '/assets/img/herald_logo.png' ) ) ),
			'logo_retina' => array( 'url' => esc_url( get_parent_theme_file_uri( '/assets/img/herald_logo@2x.png' ) ) ),
			'logo_mini' => array( 'url' => esc_url( get_parent_theme_file_uri( '/assets/img/herald_logo_mini.png' ) ) ),
			'logo_mini_retina' => array( 'url' => esc_url( get_parent_theme_file_uri( '/assets/img/herald_logo_mini@2x.png' ) ) ),
			'default_fimg' => array( 'url' => esc_url( get_parent_theme_file_uri( '/assets/img/herald_default.jpg' ) ) ),
			'header_sections' => array(
				'top' => 1,
				'middle' => 1,
				'bottom' => 1,
				'trending' => 1,
			),
			'color_header_top_bg' => '#111111',
			'color_header_top_txt' => '#aaaaaa',
			'color_header_top_acc' => '#ffffff',
			'header_top_left' => array(
				'social-menu' => 0,
				'social-menu-drop' => 0,
				'search' => 0,
				'search-drop' => 0,
				'secondary-menu-1' => 1,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'site-desc' => 0,
				'date' => 0,
				'login-form' => 0,
				'woocommerce-cart-icon' => 0,
			),
			'header_top_center' => array(
				'social-menu' => 0,
				'social-menu-drop' => 0,
				'search' => 0,
				'search-drop' => 0,
				'secondary-menu-1' => 0,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'site-desc' => 0,
				'date' => 0,
				'login-form' => 0,
				'woocommerce-cart-icon' => 0,
			),
			'header_top_right' => array(
				'social-menu' => 0,
				'social-menu-drop' => 0,
				'search' => 0,
				'search-drop' => 0,
				'secondary-menu-1' => 0,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'site-desc' => 0,
				'date' => 1,
				'login-form' => 0,
				'woocommerce-cart-icon' => 0,
			),
			'header_height' => 120,
			'color_header_middle_bg' => '#0277bd',
			'background_header_middle' => array(),
			'color_header_middle_txt' => '#ffffff',
			'color_header_middle_acc' => '#111111',
			'header_middle_left' => array(
				'logo' => 1,
				'main-menu' => 0,
				'social-menu' => 0,
				'social-menu-drop' => 0,
				'ad' => 0,
				'search' => 0,
				'search-drop' => 0,
				'secondary-menu-1' => 0,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'site-desc' => 0,
				'login-form' => 0,
				'woocommerce-cart-icon' => 0,
			),
			'header_middle_left_align' => 'hor',
			'header_middle_center' => array(
				'logo' => 0,
				'main-menu' => 0,
				'social-menu' => 0,
				'social-menu-drop' => 0,
				'ad' => 0,
				'search' => 0,
				'search-drop' => 0,
				'secondary-menu-1' => 0,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'site-desc' => 0,
				'login-form' => 0,
				'woocommerce-cart-icon' => 0,
			),
			'header_middle_center_align' => 'hor',
			'header_middle_right' => array(
				'logo' => 0,
				'main-menu' => 0,
				'social-menu' => 0,
				'social-menu-drop' => 0,
				'ad' => 1,
				'search' => 0,
				'search-drop' => 0,
				'secondary-menu-1' => 0,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'site-desc' => 0,
				'login-form' => 0,
				'woocommerce-cart-icon' => 0,
			),
			'header_middle_right_align' => 'hor',
			'color_header_bottom_bg' => '#0288d1',
			'color_header_bottom_txt' => '#ffffff',
			'color_header_bottom_acc' => '#424242',
			'header_bottom_left' => array(
				'logo-mini' => 0,
				'main-menu' => 1,
				'social-menu' => 0,
				'social-menu-drop' => 0,
				'search' => 0,
				'search-drop' => 1,
				'secondary-menu-1' => 0,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'site-desc' => 0,
				'date' => 0,
				'login-form' => 0,
				'woocommerce-cart-icon' => 0,
			),
			'header_bottom_center' => array(
				'logo-mini' => 0,
				'main-menu' => 0,
				'social-menu' => 0,
				'social-menu-drop' => 0,
				'search' => 0,
				'search-drop' => 0,
				'secondary-menu-1' => 0,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'site-desc' => 0,
				'date' => 0,
				'login-form' => 0,
				'woocommerce-cart-icon' => 0,
			),
			'header_bottom_right' => array(
				'logo-mini' => 0,
				'main-menu' => 0,
				'social-menu' => 1,
				'social-menu-drop' => 0,
				'search' => 0,
				'search-drop' => 0,
				'secondary-menu-1' => 0,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'site-desc' => 0,
				'date' => 0,
				'login-form' => 0,
				'woocommerce-cart-icon' => 0,
			),
			'color_header_trending_bg' => '#eeeeee',
			'color_header_trending_txt' => '#666666',
			'color_header_trending_acc' => '#111111',
			'trending_number' => '6',
			'trending_fimg' => true,
			'trending_slider' => false,
			'trending_slider_post' => 10,
			'trending_order' => 'date',
			'trending_cat' => array(
			),
			'trending_tag' => array(
			),
			'trending_time' => '0',
			'trending_manual' => '',
			'header_sticky' => true,
			'header_sticky_offset' => 600,
			'header_sticky_up' => false,
			'color_header_sticky_bg' => '#0288d1',
			'color_header_sticky_txt' => '#ffffff',
			'color_header_sticky_acc' => '#444444',
			'header_sticky_left' => array(
				'logo' => 0,
				'logo-mini' => 1,
				'main-menu' => 0,
				'social-menu' => 0,
				'social-menu-drop' => 0,
				'search' => 0,
				'search-drop' => 0,
				'secondary-menu-1' => 0,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'site-desc' => 0,
				'login-form' => 0,
				'woocommerce-cart-icon' => 0,
			),
			'header_sticky_center' => array(
				'logo' => 0,
				'logo-mini' => 0,
				'main-menu' => 0,
				'social-menu' => 0,
				'social-menu-drop' => 0,
				'search' => 0,
				'search-drop' => 0,
				'secondary-menu-1' => 0,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'site-desc' => 0,
				'login-form' => 0,
				'woocommerce-cart-icon' => 0,
			),
			'header_sticky_right' => array(
				'logo' => 0,
				'logo-mini' => 0,
				'main-menu' => 1,
				'social-menu' => 0,
				'social-menu-drop' => 0,
				'search' => 0,
				'search-drop' => 0,
				'secondary-menu-1' => 0,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'site-desc' => 0,
				'login-form' => 0,
				'woocommerce-cart-icon' => 0,
			),
			'header_responsive_breakpoint' => 1249,
			'header_responsive_elements' => array(
				'social-menu' => false,
				'secondary-menu-1' => false,
				'secondary-menu-2' => false,
				'secondary-menu-3' => false,
			),
			'header_responsive_actions' => array(
				'search-drop' => true,
				'login-form' => false,
				'woocommerce-cart-icon' => false,
			),
			'header_responsive_group' => false,
			'header_ad_responsive' => false,
			'mega_menu' => true,
			'mega_menu_layout' => 'i',
			'mega_menu_limit' => 4,
			'mega_menu_sub_cat' => true,
			'content_layout' => 'boxed',
			'body_background' => array(
				'background-color' => '#eeeeee',
			),
			'color_content_bg' => '#ffffff',
			'color_content_title' => '#333333',
			'color_content_txt' => '#444444',
			'color_content_acc' => '#0288d1',
			'color_content_meta' => '#999999',
			'color_footer_bg' => '#222222',
			'color_footer_txt' => '#dddddd',
			'color_footer_acc' => '#0288d1',
			'color_footer_meta' => '#aaaaaa',
			'footer_widgets' => true,
			'footer_layout' => '4_3',
			'footer_bottom' => true,
			'footer_copyright' => wp_kses_post( sprintf( __( 'Copyright &copy; {current_year}. Created by %s. Powered by %s.', 'herald' ), '<a href="https://mekshq.com" target="_blank">Meks</a>', '<a href="https://www.wordpress.org" target="_blank">WordPress</a>' ) ),
			'footer_left' => array(
				'copyright' => 1,
				'social-menu' => 0,
				'secondary-menu-1' => 0,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'date' => 0,
			),
			'footer_center' => array(
				'copyright' => 0,
				'social-menu' => 0,
				'secondary-menu-1' => 0,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'date' => 0,
			),
			'footer_right' => array(
				'copyright' => 0,
				'social-menu' => 1,
				'secondary-menu-1' => 0,
				'secondary-menu-2' => 0,
				'secondary-menu-3' => 0,
				'date' => 0,
			),
			'sidebars' => array(),
			'lay_a_cat' => true,
			'lay_a_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 1,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_a_content' => 'excerpt',
			'lay_a_excerpt_limit' => '290',
			'lay_a_rm' => true,
			'img_size_lay_a_ratio' => '16_9',
			'img_size_lay_a_custom' => '',
			'lay_a1_cat' => true,
			'lay_a1_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 1,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_a1_excerpt' => false,
			'lay_a1_excerpt_limit' => '290',
			'lay_a1_rm' => false,
			'img_size_lay_a1_ratio' => '16_9',
			'img_size_lay_a1_custom' => '',
			'lay_a2_cat' => true,
			'lay_a2_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 1,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_a2_excerpt' => true,
			'lay_a2_excerpt_limit' => '250',
			'lay_a2_rm' => false,
			'img_size_lay_a2_ratio' => '16_9',
			'img_size_lay_a2_custom' => '',
			'lay_a3_cat' => true,
			'lay_a3_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 1,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_a3_excerpt' => true,
			'lay_a3_excerpt_limit' => '250',
			'lay_a3_rm' => true,
			'img_size_lay_a3_ratio' => '16_9',
			'img_size_lay_a3_custom' => '',
			'lay_b_cat' => true,
			'lay_b_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 1,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_b_excerpt' => true,
			'lay_b_excerpt_limit' => '170',
			'lay_b_rm' => true,
			'img_size_lay_b_ratio' => '16_9',
			'img_size_lay_b_custom' => '',
			'lay_b1_cat' => true,
			'lay_b1_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 1,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_b1_excerpt' => true,
			'lay_b1_excerpt_limit' => '160',
			'lay_b1_rm' => false,
			'img_size_lay_b1_ratio' => '3_2',
			'img_size_lay_b1_custom' => '',
			'lay_c_cat' => true,
			'lay_c_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_c_excerpt' => true,
			'lay_c_excerpt_limit' => '150',
			'lay_c_rm' => false,
			'img_size_lay_c_ratio' => '16_9',
			'img_size_lay_c_custom' => '',
			'lay_c1_cat' => true,
			'lay_c1_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_c1_excerpt' => false,
			'lay_c1_excerpt_limit' => '150',
			'lay_c1_rm' => false,
			'img_size_lay_c1_ratio' => '3_2',
			'img_size_lay_c1_custom' => '',
			'lay_d_cat' => true,
			'lay_d_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'img_size_lay_d_ratio' => '16_9',
			'img_size_lay_d_custom' => '',
			'lay_d1_cat' => true,
			'lay_d1_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'img_size_lay_d1_ratio' => '3_2',
			'img_size_lay_d1_custom' => '',
			'lay_e_cat' => true,
			'lay_e_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_e_excerpt' => false,
			'lay_e_excerpt_limit' => '150',
			'lay_f_cat' => true,
			'lay_f_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_f_excerpt' => false,
			'lay_f_excerpt_limit' => '80',
			'img_size_lay_f_ratio' => '16_9',
			'img_size_lay_f_custom' => '',
			'lay_f1_cat' => true,
			'lay_f1_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_f1_excerpt' => false,
			'lay_f1_excerpt_limit' => '80',
			'img_size_lay_f1_ratio' => '3_2',
			'img_size_lay_f1_custom' => '',
			'lay_g_cat' => true,
			'lay_g_meta' => array(
				'date' => 0,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'img_size_lay_g_ratio' => '3_2',
			'img_size_lay_g_custom' => '',
			'lay_g1_cat' => true,
			'lay_g1_meta' => array(
				'date' => 0,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'img_size_lay_g1_ratio' => '4_3',
			'img_size_lay_g1_custom' => '',
			'lay_h_cat' => true,
			'lay_h_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_h_excerpt' => false,
			'lay_h_excerpt_limit' => '80',
			'lay_i_cat' => true,
			'lay_i_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'img_size_lay_i_ratio' => '16_9',
			'img_size_lay_i_custom' => '',
			'lay_i1_cat' => true,
			'lay_i1_meta' => array(
				'date' => 0,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'img_size_lay_i1_ratio' => '4_3',
			'img_size_lay_i1_custom' => '',
			'lay_j_cat' => true,
			'lay_j_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_k_title' => true,
			'lay_k_cat' => false,
			'lay_k_meta' => array(
				'date' => 0,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'img_size_lay_k_ratio' => '3_2',
			'img_size_lay_k_custom' => '',
			'lay_l_cat' => true,
			'lay_l_meta' => array(
				'date' => 0,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_fa1_cat' => true,
			'lay_fa1_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 1,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_fa1_excerpt' => true,
			'lay_fa1_excerpt_limit' => '150',
			'lay_fa1_color' => false,
			'lay_fa2_cat' => true,
			'lay_fa2_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 1,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_fa2_excerpt' => true,
			'lay_fa2_excerpt_limit' => '70',
			'lay_fa2_color' => false,
			'lay_fa3_cat' => true,
			'lay_fa3_meta' => array(
				'date' => 0,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 1,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_fa3_excerpt' => true,
			'lay_fa3_excerpt_limit' => '150',
			'lay_fa3_color' => false,
			'lay_fa4_cat' => true,
			'lay_fa4_meta' => array(
				'date' => 0,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 1,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'lay_fa4_excerpt' => true,
			'lay_fa4_excerpt_limit' => '150',
			'lay_fa4_color' => false,
			'lay_fa5_cat' => true,
			'lay_fa5_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 1,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'single_layout' => 1,
			'single_use_sidebar' => 'right',
			'single_sidebar' => 'herald_default_sidebar',
			'single_sticky_sidebar' => 'herald_default_sticky_sidebar',
			'single_cat' => true,
			'lay_single_meta' => array(
				'date' => 1,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 0,
				'author' => 0,
				'views' => 1,
				'rtime' => 1,
				'reviews' => 0,
			),
			'single_fimg' => true,
			'single_fimg_cap' => true,
			'img_size_lay_single_ratio' => 'original',
			'img_size_lay_single_custom' => '',
			'single_headline' => true,
			'single_tags' => true,
			'single_meta_bar_position' => 'left',
			'single_meta_bar_sticky' => false,
			'single_avatar' => true,
			'single_author_social_links' => array(
				'twitter' => 1,
				'facebook' => 0,
				'instagram' => 0,
			),
			'lay_single_big_meta' => array(
				'date' => 0,
				'modified_date' => 0,
				'time' => 0,
				'comments' => 1,
				'author' => 0,
				'views' => 0,
				'rtime' => 0,
				'reviews' => 0,
			),
			'single_share' => true,
			'single_meta_ad' => 'top',
			'single_author' => true,
			'single_paginated_nav_position' => 'above',
			'single_comment_form' => 'above',
			'single_infinite_scroll' => false,
			'single_sticky_bar' => true,
			'single_sticky_prevnext' => true,
			'single_prevnext_same_cat' => true,
			'single_sticky_comments' => true,
			'single_sticky_share' => true,
			'single_related' => true,
			'related_layout' => 'f1',
			'related_limit' => 3,
			'related_type' => 'cat',
			'related_order' => 'date',
			'related_time' => '0',
			'page_layout' => 1,
			'page_use_sidebar' => 'right',
			'page_sidebar' => 'herald_default_sidebar',
			'page_sticky_sidebar' => 'herald_default_sticky_sidebar',
			'page_fimg' => true,
			'page_fimg_cap' => false,
			'img_size_lay_page_ratio' => 'original',
			'img_size_lay_page_custom' => '',
			'page_comments' => true,
			'category_fa_layout' => 'none',
			'category_fa_order' => 'date',
			'category_fa_unique' => false,
			'category_sub' => true,
			'category_desc' => true,
			'category_layout' => 'b1',
			'category_ppp' => 'inherit',
			'category_ppp_num' => '8',
			'category_starter_layout' => 'none',
			'category_starter_limit' => 1,
			'category_use_sidebar' => 'right',
			'category_sidebar' => 'herald_default_sidebar',
			'category_sticky_sidebar' => 'herald_default_sticky_sidebar',
			'category_pag' => 'numeric',
			'tag_layout' => 'b1',
			'tag_ppp' => 'inherit',
			'tag_ppp_num' => '8',
			'tag_starter_layout' => 'none',
			'tag_starter_limit' => 1,
			'tag_use_sidebar' => 'right',
			'tag_sidebar' => 'herald_default_sidebar',
			'tag_sticky_sidebar' => 'herald_default_sticky_sidebar',
			'tag_pag' => 'numeric',
			'author_desc' => true,
			'author_social' => true,
			'author_layout' => 'b1',
			'author_ppp' => 'inherit',
			'author_ppp_num' => '8',
			'author_starter_layout' => 'none',
			'author_starter_limit' => 1,
			'author_use_sidebar' => 'right',
			'author_sidebar' => 'herald_default_sidebar',
			'author_sticky_sidebar' => 'herald_default_sticky_sidebar',
			'author_pag' => 'numeric',
			'search_layout' => 'b1',
			'search_ppp' => 'inherit',
			'search_ppp_num' => '8',
			'search_use_sidebar' => 'right',
			'search_sidebar' => 'herald_default_sidebar',
			'search_sticky_sidebar' => 'herald_default_sticky_sidebar',
			'search_pag' => 'numeric',
			'archive_layout' => 'b1',
			'archive_ppp' => 'inherit',
			'archive_ppp_num' => '8',
			'archive_starter_layout' => 'none',
			'archive_starter_limit' => 2,
			'archive_use_sidebar' => 'right',
			'archive_sidebar' => 'herald_default_sidebar',
			'archive_sticky_sidebar' => 'herald_default_sticky_sidebar',
			'archive_pag' => 'numeric',
			'main_font' => array(
				'google' => true,
				'font-weight' => '400',
				'font-family' => 'Open Sans',
				'subsets' => 'latin-ext',
			),
			'h_font' => array(
				'google' => true,
				'font-weight' => '700',
				'font-family' => 'Lato',
				'subsets' => 'latin-ext',
			),
			'nav_font' => array(
				'font-weight' => '600',
				'font-family' => 'Open Sans',
				'subsets' => 'latin-ext',
			),
			'font_size_p' => '16',
			'font_size_nav' => '14',
			'font_size_widget_and_module_title' => '16',
			'font_size_small' => '15',
			'font_size_h1' => '40',
			'font_size_h2' => '33',
			'font_size_h3' => '28',
			'font_size_h4' => '23',
			'font_size_h5' => '19',
			'font_size_h6' => '16',
			'font_size_h7' => '14',
			'font_size_excerpt_text' => '19',
			'font_size_meta_data_smaller' => '13',
			'font_size_meta_data_bigger' => '14',
			'uppercase' => array(
				'site-title a' => 0,
				'site-description' => 0,
				'main-navigation' => 1,
				'entry-title' => 0,
				'meta-category a' => 1,
				'herald-mod-title' => 0,
				'herald-sidebar .widget-title' => 0,
				'herald-site-footer .widget-title' => 0,
			),
			'ad_header' => '',
			'ad_below_header' => '',
			'ad_above_footer' => '',
			'ad_above_single' => '',
			'ad_below_single' => '',
			'ad_single_meta' => '',
			'ad_between_posts' => '',
			'ad_between_posts_position' => 4,
			'ad_exclude_404' => false,
			'ad_exclude_from_page' => array(),
			'rtl_mode' => false,
			'rtl_lang_skip' => '',
			'more_string' => '...',
			'smooth_scroll' => false,
			'auto_gallery_img_sizes' => true,
			'popup_img' => true,
			'on_single_img_popup' => false,
			'views_forgery' => '',
			'overlay_opacity' =>  array(
				1 => 0.5,
				2 => 0.8,
			),
			'scroll_to_top' => false,
			'image_404' => array(),
			'multibyte_rtime' => false,
			'primary_category' => false,
			'words_read_per_minute' => 200,
			'product_use_sidebar' => 'right',
			'product_sidebar' => 'herald_default_sidebar',
			'product_sticky_sidebar' => 'herald_default_sticky_sidebar',
			'product_cat_use_sidebar' => 'right',
			'product_cat_sidebar' => 'herald_default_sidebar',
			'product_cat_sticky_sidebar' => 'herald_default_sticky_sidebar',
			'forum_use_sidebar' => 'right',
			'forum_sidebar' => 'herald_default_sidebar',
			'forum_sticky_sidebar' => 'herald_default_sticky_sidebar',
			'topic_use_sidebar' => 'right',
			'topic_sidebar' => 'herald_default_sidebar',
			'topic_sticky_sidebar' => 'herald_default_sticky_sidebar',
			'bb_user_use_sidebar' => 'right',
			'bb_user_sidebar' => 'herald_default_sidebar',
			'bb_user_sticky_sidebar' => 'herald_default_sticky_sidebar',
			'enable_translate' => '1',
			'minify_css' => true,
			'minify_js' => true,
			'disable_img_sizes' => array(),
		);




		$defaults = apply_filters( 'herald_modify_default_options', $defaults );

		if ( isset( $defaults[$option] ) ) {
			return $defaults[$option];
		}

		return false;
	}
endif;

?>
